<?php
/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WPSURL\App\User\UserData;

$per_page = 15;
$offset   = ( \WPSURL\App\Utility::getCurrentPageNum() * $per_page ) - $per_page;
$order    = ( isset( $_GET['order-by'] ) && ! empty( $_GET['order-by'] ) ) ? sanitize_text_field($_GET['order-by']) : 'DESC';
$reports  = \WPSURL\App\Reports::getResults([
    'per_page' => $per_page,
    'offset' => $offset,
    'order_by' => 'created_at',
    'order' => $order,
]);
?>
<div class="wrap wpsurl-admin-wrap">
 <h1 class="wp-heading-inline"><?php _e( 'Safe Url Reports', WPSURL_TEXT_DOMAIN ) ?></h1>
 <a href="#" class="page-title-action wpsurl-empty-table wpsurl-edit-font" data-table="reports">
  <?php _e( 'Empty table', WPSURL_TEXT_DOMAIN ) ?>
 </a>
 <hr class="wp-header-end" style="margin: 7px 0;">
 <div class="wpsurl-settings wpsurl-edit-font">
  <div class="wpsurl-reports-list">
   <table class="wpsurl-reports-table wp-list-table widefat fixed striped posts">
    <thead>
    <tr>
     <th scope="col" class="manage-column"><?php _e( 'ID', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Link', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Full Name', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'User', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Email', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Content', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'created_at' ) ) ?>">
		  <?php _e( 'Date', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column"></th>
    </tr>
    </thead>
    <tbody id="the-list">
	<?php
  if ( $reports ):
	  foreach ( $reports as $report ):
      $unique_id = $report->object_id;
      $link_title = \WPSURL\App\Links::getItem($unique_id, 'title');
		  ?>
       <tr id="wpsurl-report-<?php echo esc_attr($report->object_id) ?>">
           <th>#<?php echo $unique_id ?></th>
          <th>
              <?php if(!empty($link_title)): ?>
              <a href="<?php echo \WPSURL\App\Utility::getHashLink(esc_attr($unique_id), 2) ?>" target="_blank"><?php echo $link_title ?></a>
              <?php endif; ?>
          </th>
          <th><?php echo (!empty($report->fullname)) ? $report->fullname : '' ?></th>
          <th><?php echo (!empty($report->user_id)) ? UserData::getDisplayName($report->user_id) : '' ?></th>
          <th><?php echo (!empty($report->email)) ? $report->email : '' ?></th>
          <th><?php echo nl2br($report->content) ?></th>
          <th>
                <?php
                $date = $report->created_at;
                echo \WPSURL\App\Utility::date( 'Y/m/d H:i:s', strtotime( $date ) );
                ?>
          </th>
          <th>
              <?php if($report->status == 2): ?>
                <span><?php echo esc_html__('Reviewed', WPSURL_TEXT_DOMAIN) ?></span>
              <?php else: ?>
                <a href="#" class="button report-item-action-btn" data-action="reviewed" data-id="<?php echo esc_attr($report->id) ?>"><?php echo esc_html__('Reviewed', WPSURL_TEXT_DOMAIN) ?></a>
              <?php endif; ?>
          </th>
        </tr>
	  <?php
	  endforeach;
  else:
	  echo '<tr class="no-items"><td class="colspanchange" colspan="8">';
	    _e( 'No report found', WPSURL_TEXT_DOMAIN );
	  echo '</td></tr>';
  endif;
  ?>
    </tbody>
    <tfoot>
    <tr>
     <th scope="col" class="manage-column"><?php _e( 'ID', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Link', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Full Name', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'User', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Email', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Content', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column">
        <a href="<?php echo add_query_arg( array( 'order-by' => 'created_at' ) ) ?>">
		  <?php _e( 'Date', WPSURL_TEXT_DOMAIN ) ?>
        </a>
     </th>
     <th scope="col" class="manage-column"></th>
    </tr>
    </tfoot>
   </table>
  </div>
  <div id="wpsurl-pagenavi" style="width: 100%;text-align: center;margin: 15px 0">
	  <?php \WPSURL\App\Utility::renderPagination($per_page, \WPSURL\App\Statistics::count()) ?>
  </div>
 </div>
</div>
