<?php
/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$per_page = 15;
$offset   = ( \WPSURL\App\Utility::getCurrentPageNum() * $per_page ) - $per_page;
$order    = ( isset( $_GET['order-by'] ) && ! empty( $_GET['order-by'] ) ) ? sanitize_text_field($_GET['order-by']) : 'DESC';
$reports  = \WPSURL\App\Statistics::getResults([
    'per_page' => $per_page,
    'offset' => $offset,
    'order_by' => 'last_visit',
    'order' => $order,
]);
?>
<div class="wrap wpsurl-admin-wrap">
 <h1 class="wp-heading-inline"><?php _e( 'Safe Url Statistics', WPSURL_TEXT_DOMAIN ) ?></h1>
 <a href="#" class="page-title-action wpsurl-empty-table wpsurl-edit-font" data-table="statistics">
    <?php _e( 'Empty table', WPSURL_TEXT_DOMAIN ) ?>
</a>
 <hr class="wp-header-end" style="margin: 7px 0;">
 <div class="wpsurl-settings wpsurl-edit-font">
  <div class="wpsurl-reports-list">
   <table class="wpsurl-reports-table wp-list-table widefat fixed striped posts">
    <thead>
    <tr>
     <th scope="col" class="manage-column"><?php _e( 'Country', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'IP', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Link Id', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Link', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'visit' ) ) ?>">
		  <?php _e( 'Visit', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'click' ) ) ?>">
		  <?php _e( 'Click', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'first_visit' ) ) ?>">
          <?php _e( 'First visit', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'last_visit' ) ) ?>">
          <?php _e( 'Last visit', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column"><?php _e( 'Link status', WPSURL_TEXT_DOMAIN ) ?></th>
    </tr>
    </thead>
    <tbody id="the-list">
	<?php
  $view_Chart_counts         = array();
  $click_Chart_counts        = array();
  $report_Chart_dates        = array();
  $report_Chart_dates_jalali = array();
  if ( $reports ):
	  foreach ( $reports as $report ):
          $link_id = $report->object_id;
          $link = \WPSURL\App\Links::get($link_id);
		  $status = \WPSURL\App\Links::getStatus($link_id);
		  if ( $link || in_array( $status, array( 'active', 'inactive' ) ) ) {
			  $view_Chart_counts[]         .= $report->visit;
			  $click_Chart_counts[]        .= $report->click;
			  $report_Chart_dates[]        .= date( 'm/d', strtotime( $report->first_visit ) ) . ' ' . $link_id;
			  $report_Chart_dates_jalali[] .= \WPSURL\App\Utility::date('m/d', strtotime( $report->first_visit )) . ' ' . $link_id;
		  }
		  ?>
       <tr id="wpsurl-report-<?php echo esc_attr($link_id) ?>" <?php echo ( empty( $status ) || ! in_array( $status, array(
			   'active',
			   'inactive'
		   ) ) ) ? 'style="background-color: #ffd9d9;"' : ''; ?>>
          <th class="flag" style="font-size:1.6rem"><?php \WPSURL\App\Utility::showCountryFlagHtml( $report->ip ) ?></th>
          <th><?php echo \WPSURL\App\Number::numByLang($report->ip) ?></th>
          <th><?php echo \WPSURL\App\Number::numByLang($link_id) ?></th>
          <th>
              <?php
                if ( $link || in_array( $status, array( 'active', 'inactive' ) ) ) {
                    $url = \WPSURL\App\Utility::getShortHashLink($link_id);
                    echo "<a href='{$url}' target='_blank'>{$link->title}</a>";
                } else {
                    echo '<span style="color:white;background-color:#861919;padding:2px 7px;border-radius:3px;">' . __( 'Deleted Link', WPSURL_TEXT_DOMAIN ) . '</span>';
                }
                ?>
          </th>
          <th><?php echo \WPSURL\App\Number::numByLang($report->visit) ?></th>
          <th><?php echo \WPSURL\App\Number::numByLang($report->click) ?></th>
          <th>
              <?php
              $fv = $report->first_visit;
              echo \WPSURL\App\Utility::date( 'Y/m/d H:i:s', strtotime( $fv ) );
              ?>
          </th>
          <th>
              <?php
              $fl = $report->last_visit;
              echo \WPSURL\App\Utility::date( 'Y/m/d H:i:s', strtotime( $fl ) );
              ?>
          </th>
          <th>
			  <?php
	    if ( $status == 'active' ) {
		    echo '<span style="font-size:1.6rem;color:green" title="' . __( 'Active', WPSURL_TEXT_DOMAIN ) . '"><i class="wpsurl-icon-check"></i></span>';
	    } elseif ( $status == 'inactive' ) {
		    echo '<span style="font-size:1.6rem;color:#ffc7ad" title="' . __( 'Inactive', WPSURL_TEXT_DOMAIN ) . '"><i class="wpsurl-icon-close"></i></span>';
	    } else {
		    echo '<span style="font-size:1.6rem;color:#861919" title="' . __( 'Deleted Link', WPSURL_TEXT_DOMAIN ) . '"><i class="wpsurl-icon-trash"></i></span>';
	    }
	    ?>
          </th>
         </tr>
	  <?php
	  endforeach;
  else:
	  echo '<tr class="no-items"><td class="colspanchange" colspan="9">';
	  _e( 'No report found', WPSURL_TEXT_DOMAIN );
	  echo '</td></tr>';
  endif;
  ?>
    </tbody>
    <tfoot>
    <tr>
     <th scope="col" class="manage-column"><?php _e( 'Country', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'IP', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Link Id', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column"><?php _e( 'Link', WPSURL_TEXT_DOMAIN ) ?></th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'visit' ) ) ?>">
		  <?php _e( 'Visit', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'click' ) ) ?>">
		  <?php _e( 'Click', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'first_visit' ) ) ?>">
          <?php _e( 'First visit', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column">
      <a href="<?php echo add_query_arg( array( 'order-by' => 'last_visit' ) ) ?>">
          <?php _e( 'Last visit', WPSURL_TEXT_DOMAIN ) ?>
      </a>
     </th>
     <th scope="col" class="manage-column"><?php _e( 'Link status', WPSURL_TEXT_DOMAIN ) ?></th>
    </tr>
    </tfoot>
   </table>
  </div>
  <div id="wpsurl-pagenavi" style="width: 100%;text-align: center;margin: 15px 0">
	  <?php \WPSURL\App\Utility::renderPagination($per_page, \WPSURL\App\Statistics::count()) ?>
  </div>
 </div>
</div>
