<?php
namespace WPSURL\App;

class Assets {
    public static function getHandleName($handle){
        return str_replace(['.'], '-', $handle);
    }
    /**
     *
     * wp register style custom public static function
     *
     * @param $handle
     * @param $src
     * @param null $deps
     * @param null $ver
     * @param null $media
     * @param bool $enqueue
     */
    public static function registerStyle($handle, $src, $deps = null, $ver = null, $media = null, $enqueue = false)
    {
        if (!empty($handle)) {
            $handle = static::getHandleName($handle);
            if ($enqueue) {
                wp_enqueue_style($handle, $src, $deps, $ver, $media);
            } else {
                wp_register_style($handle, $src, $deps, $ver, $media);
            }
        }
    }

    /**
     * @param $handle
     * @param $src
     * @param $deps
     * @param $ver
     * @param $in_footer
     * @param $enqueue
     */
    public static function registerScript($handle, $src, $deps = null, $ver = null, $in_footer = null, $enqueue = false)
    {
        if (!empty($handle)) {
            $handle = static::getHandleName($handle);
            if ($enqueue) {
                wp_enqueue_script($handle, $src, $deps, $ver);
            } else {
                wp_register_script($handle, $src, $deps, $ver, $in_footer);
            }
        }
    }

    /**
     * @param $handle
     * @param $src
     * @param $deps
     * @param $ver
     * @param $media
     * @return void
     */
    public static function enqueueStyle($handle, $src = null, $deps = null, $ver = null, $media = null)
    {
        if (!empty($handle)) {
            self::registerStyle($handle, $src, $deps, $ver, $media, true);
        }
    }

    /**
     * @param $handle
     * @param $src
     * @param $deps
     * @param $ver
     * @param $in_footer
     * @return void
     */
    public static function enqueueScript($handle, $src = null, $deps = null, $ver = null, $in_footer = null)
    {
        if (!empty($handle)) {
            self::registerScript($handle, $src, $deps, $ver, $in_footer, true);
        }
    }

    /**
     *
     * Localize js translate
     *
     * @param null $key
     *
     * @return array|mixed
     */
    public static function getLocalizeData($key = null)
    {
        $translate = array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => Utility::generateNonce(),
            'codeEditor' => wp_enqueue_code_editor(array('type' => 'text/html')),
            'is_transfer_end_timer' => Settings::getOption('transfer_end_timer_status'),

            /**
             *
             * Translations
             *
             */

            'txt_copy_success' => __('Copied successfully', WPSURL_TEXT_DOMAIN),
            'txt_only_woo_users' => __('Use only woo customers', WPSURL_TEXT_DOMAIN),
            'txt_link_invalid' => __('Invalid link', WPSURL_TEXT_DOMAIN),
            'txt_switching' => __('Switching', WPSURL_TEXT_DOMAIN),
            'txt_chng_status' => __('Change link status', WPSURL_TEXT_DOMAIN),
            'txt_are_change' => __('Are you sure you want to change the item', WPSURL_TEXT_DOMAIN),
            'txt_entr_pwd' => __('Enter a new password to activate the lock', WPSURL_TEXT_DOMAIN),
            'txt_pls_entr_pwd' => __('Please enter the password', WPSURL_TEXT_DOMAIN),
            'txt_active' => __('Active', WPSURL_TEXT_DOMAIN),
            'txt_inactive' => __('Inactive', WPSURL_TEXT_DOMAIN),
            'txt_cancel' => __('Cancel', WPSURL_TEXT_DOMAIN),
            'txt_yes' => __('Yes', WPSURL_TEXT_DOMAIN),
            'txt_no' => __('No', WPSURL_TEXT_DOMAIN),
            'txt_delete' => __('Delete', WPSURL_TEXT_DOMAIN),
            'txt_send' => __('Send', WPSURL_TEXT_DOMAIN),
            'txt_delete_success' => __('Successfully deleted', WPSURL_TEXT_DOMAIN),
            'txt_inactive_lock' => __('Inactive link lock', WPSURL_TEXT_DOMAIN),
            'txt_pwd_inv_char' => __('Must not be less than 8 characters', WPSURL_TEXT_DOMAIN),
            'txt_pls_entr_value' => __('Please enter the value', WPSURL_TEXT_DOMAIN),
            'txt_password' => __('Password', WPSURL_TEXT_DOMAIN),
            'txt_link_empty_not_lock' => __('Link lock will be disabled if it is empty', WPSURL_TEXT_DOMAIN),
            'txt_create' => __('Create', WPSURL_TEXT_DOMAIN),
            'txt_update' => __('Update', WPSURL_TEXT_DOMAIN),
            'txt_next' => __('Next', WPSURL_TEXT_DOMAIN),
            'txt_prev' => __('Prev', WPSURL_TEXT_DOMAIN),
            'txt_link' => __('Link', WPSURL_TEXT_DOMAIN),
            'txt_title' => __('Title', WPSURL_TEXT_DOMAIN),
            'txt_type' => __('Type', WPSURL_TEXT_DOMAIN),
            'txt_web_url' => __('Website url', WPSURL_TEXT_DOMAIN),
            'txt_dl_url' => __('Download url', WPSURL_TEXT_DOMAIN),
            'txt_unknown_err' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
            'txt_complete_fields_err' => __('Complete the required information', WPSURL_TEXT_DOMAIN),
            'txt_reopen_uploader' => __('Close and reopen the file selector for details', WPSURL_TEXT_DOMAIN),
            'txt_link_copy_fo_user' => __('Copy the link to use', WPSURL_TEXT_DOMAIN),
            'txt_are_pwd_correct' => __('Are you sure your password is correct', WPSURL_TEXT_DOMAIN),
            'txt_redirect' => __('Redirect', WPSURL_TEXT_DOMAIN),
            'txt_one_less_char' => __('Must not be less than 8 characters', WPSURL_TEXT_DOMAIN),
            'txt_click_limit' => __('Click limit', WPSURL_TEXT_DOMAIN),
            'txt_views_count' => __('Views Count', WPSURL_TEXT_DOMAIN),
            'txt_clicks_count' => __('Clicks Count', WPSURL_TEXT_DOMAIN),
            'txt_are_clear_data' => __('Are you sure you want to delete this information?', WPSURL_TEXT_DOMAIN),
            'txt_are_sure' => __('Are you sure want to this request?', WPSURL_TEXT_DOMAIN),
            'txt_not_returned' => __('It cannot be returned.', WPSURL_TEXT_DOMAIN),
            'txt_report_des' => __('Please write a short comment about the problem with this link', WPSURL_TEXT_DOMAIN),
            'txt_pls_complete_field' => __('Please complete the fields', WPSURL_TEXT_DOMAIN),
            'txt_pls_select_file' => __('Please select a file', WPSURL_TEXT_DOMAIN),
            'txt_link_edit' => __('Edit Link', WPSURL_TEXT_DOMAIN),
            'txt_invalid_captcha' => __('The security code is invalid.', WPSURL_TEXT_DOMAIN),
            'txt_confirm' => __('Confirm', WPSURL_TEXT_DOMAIN),
            'txt_pls_db_backup' => __('Please make a backup of the database.', WPSURL_TEXT_DOMAIN),
        );

        $translate = apply_filters('wpsurl_script_localize_data', $translate);

        return (!empty($key)) ? $translate[$key] : $translate;
    }
}