<?php
namespace WPSURL\App;

final class Callbacks {
    /**
     * show view page index
     */
    public static function getViewContentHtmlCallback()
    {
        $file = WPSURL_VIEW_PAGES . 'index.content.php';
        if (file_exists($file)) {
            require_once $file;
        }
    }

    /**
     *
     * Fired after link insert/update
     *
     * @param $insert_id
     * @param $params
     * @return void|boolean
     */
    public static function afterLinkInsertCallback($insert_id, $params){
        $unique_id = !empty($insert_id) ? $insert_id : (isset($params['id']) ? $params['id'] : 0);

        if (!$unique_id)
            return false;

        Logger::debug($insert_id, $params);

        if(isset($params['type']))
            Links::changeType($unique_id, $params['type']);
        LinkOptions::updateOption($unique_id, 'iframe_preview', (isset($params['iframe_preview']) && $params['iframe_preview'] == 'true'));


        LinkOptions::updateOption($unique_id, 'restriction_woo', (Options::isActiveWoo() && isset($params['restriction_woo']) && $params['restriction_woo'] == 'true'));
        if (isset($params['restriction_woo']) && isset($params['woo_products'])){
            LinkOptions::updateOption($unique_id, 'woo_products', $params['woo_products']);
        }

        LinkOptions::updateOption($unique_id, 'restriction_edd', (Options::isActiveEdd() && isset($params['restriction_edd']) && $params['restriction_edd'] == 'true'));
        if (isset($params['restriction_edd']) && isset($params['edd_products'])){
            LinkOptions::updateOption($unique_id, 'edd_products', $params['edd_products']);
        }

        LinkOptions::updateOption($unique_id, 'view_restrictions_status', (isset($params['view_restrictions']) && $params['view_restrictions'] == 'true'));
        if (isset($params['view_restrictions'])){
            LinkOptions::updateOption($unique_id, 'view_limited_num', (!empty($params['view_limited_num']) ? $params['view_limited_num'] : 0));
            LinkOptions::updateOption($unique_id, 'click_limited_num', (!empty($params['click_limited_num']) ? $params['click_limited_num'] : 0));
        }
        LinkOptions::updateOption($unique_id, 'only_user_logged', (isset($params['only_user_logged']) && $params['only_user_logged'] == 'true'));

        LinkOptions::updateOption($unique_id, 'schedule_status', (isset($params['schedule_status']) && $params['schedule_status'] == 'true'));
        if (isset($params['schedule_status'])){
            LinkOptions::updateOption($unique_id, 'schedule_start', (!empty($params['schedule_start']) ? strtotime($params['schedule_start']) : 0));
            LinkOptions::updateOption($unique_id, 'schedule_end', (!empty($params['schedule_end']) ? strtotime($params['schedule_end']) : 0));
        }

        LinkOptions::updateOption($unique_id,'simple_text_content', (!empty($params['simple_text_content']) ? sanitize_textarea_field($params['simple_text_content']) : ''));

        LinkOptions::updateOption($unique_id,'views_count', 0);
        LinkOptions::updateOption($unique_id,'clicks_count', 0);
    }

    public static function applyStatisticsCallback($unique_id, $type = 'view')
    {
        if(is_user_logged_in() && current_user_can('administrator')){
            return false;
        }

        if(!empty($unique_id)){
            $link = Links::get($unique_id);
            if ($link){
                switch ($type){
                    case "click":
                        Statistics::incrementClick($link->unique_id);
                        break;
                    case "view":
                        Statistics::incrementView($link->unique_id);
                        break;
                }
            }
        }
    }

    public static function loadedLinkDataCallback($unique_id)
    {
        if(empty($unique_id))
            return;

        $link_data = Links::get($unique_id);

        if (!$link_data)
            return;

        # START REGISTER LINK DATA #

        $unique_id = $link_data->unique_id;
        $pwd = $link_data->password;
        $is_locked = !empty($link_data->password);
        $restrictions_status = LinkOptions::isRestrictByView($unique_id);
        $restrict_woo = LinkOptions::isRestrictByWoo($unique_id);
        $restrict_edd = LinkOptions::isRestrictByEdd($unique_id);
        $access_products = LinkOptions::isAccessForProducts($unique_id);
        $access_products_arr = explode(",", $access_products);
        $access_downloads = LinkOptions::isAccessForEddProducts($unique_id);
        $access_downloads_arr = explode(",", $access_downloads);
        $clicks = LinkOptions::getClickLimitNumber($unique_id);
        $views = LinkOptions::getViewLimitNumber($unique_id);
        $all_clicks = LinkOptions::getClicksCount($unique_id);
        $all_views = LinkOptions::getViewsCount($unique_id);
        $only_logged_user = LinkOptions::isOnlyLoggedUser($unique_id);
        $type = Links::getType($unique_id);

        # / END LINK DATA #

        if(get_defined_vars()){
            foreach (get_defined_vars() as $key => $value){
                $GLOBALS['link_data'][$key] = $value;
            }
        }
    }

    /**
     * add filter wp head
     */
    public static function viewHeadFilter()
    {
        if (Utility::issetQueryVars()){
            $title = Utility::getCurrentViewPageTitle();
            $output = '';
            $output .= '<meta name="robots" content="noindex,nofollow"/>';
            $output .= '<base href="' . site_url() . '">';
            $output .= '<meta name="description" content="' . esc_attr($title) . '">';
            $output .= '<meta name="og:title" content="' . esc_attr($title) . '">';
            $output .= '<meta name="og:description" content="' . esc_attr($title) . '">';
            $output .= '<meta name="og:url" content="' . esc_attr(Utility::getCurrentViewPageUrl()) . '">';
            $output .= '<meta name="og:site_name" content="' . esc_attr($title) . '">';
            echo $output;
        }
    }

    /**
     *
     * Append html to footer
     *
     * @return void
     */
    public static function appendToFooter(){
        include_once WPSURL_VIEW_PATH . 'append-footer.php';
    }

    /**
     *
     * Convert post content normal link to safe link (external to internal link)
     *
     * @param $content
     * @return mixed
     */
    public static function safelyPostContentLinks($content)
    {
        $dom = new \DOMDocument();
        $dom->loadHTML($content);
        $xpath = new \DOMXPath($dom);
        $safe_link = site_url('/%s/%s/');

        $links = [];
        $safe_links = [];
        $parsed_site_domain = parse_url(site_url());

        foreach ($xpath->query('//a') as $node) {
            $href = $node->getAttribute('href');
            if(empty($href) || !filter_var($href, FILTER_VALIDATE_URL)){
                continue;
            }

            $parsed_url = parse_url($href);
            if ($parsed_url && isset($parsed_url['host']) && $parsed_url['host'] !== $parsed_site_domain['host']) {
                $links[] = $href;
            }
        }

        if(!empty($links)){
            foreach ($links as $link){
                $safe_links[] = sprintf($safe_link, Utility::getPagesSlug(), base64_encode($link));
            }
        }

        return !empty($links) && !empty($safe_links) && count($links) === count($safe_links) ? str_replace($links, $safe_links, $content) : $content;
    }

    /**
     *
     * Links bulk actions
     *
     */
    public static function linkBulkActionsCallback()
    {
        global $alert;
        $result = false;
        if (isset($_GET['page']) && ($_GET['page'] == 'wp-safe-url' || strpos($_GET['page'], 'wpsurl-') !== false)) {
            if (isset($_GET['action']) && $_GET['action'] > 0) {
                $get_links_check = (isset($_GET['link_check']) && !empty($_GET['link_check'])) ? $_GET['link_check'] : null;
                if ($get_links_check && is_array($get_links_check)) {
                    $current_action = $_GET['action'];
                    if ($current_action == 1) {
                        foreach($get_links_check as $link_id){
                            $result = Links::changeStatus($link_id, 'active');
                        }
                    } elseif ($current_action == 2) {
                        foreach($get_links_check as $link_id){
                            $result = Links::changeStatus($link_id, 'inactive');
                        }
                    } elseif ($current_action == 3) {
                        foreach($get_links_check as $link_id){
                            $result = Links::delete($link_id);
                        }
                    }
                    do_action('wpsurl_links_bulk_action', $current_action);
                    if($result){
                        wp_safe_redirect(add_query_arg(array(
                            'page' => $_GET['page'],
                        ), admin_url( 'admin.php')));
                    }
                }
            }
        }
    }
}