<?php
namespace WPSURL\App;

class DatabaseModel
{
    private $wpdb;
    private $prefix;
    protected static $table;
    protected static $cols;

    /**
     *
     * DatabaseModel __construct
     *
     */
    public function __construct($table = '')
    {
        global $wpdb;
        $this->wpdb = $wpdb;
        $this->prefix = $this->wpdb->prefix;
        if(!empty($table)){
            static::$table = $table;
        }
    }

    /**
     * Generate where sql query
     *
     * @param array $params
     * @return string
     */
    private function preSql($params = []){
        $where = '';
        $value = '';
        $limit = '';

        $fields = (isset($params['fields']) && is_array($params['fields']) && count($params['fields']) > 0) ? $params['fields'] : [];
        if ($fields) {
            $i = 0;
            foreach ($fields as $field) {
                if (!empty($field) && is_array($field) && count($field) > 0) {
                    $i++;
                    if($i <= 1){
                        $where .= 'WHERE ';
                    }
                    if ($i > 1) {
                        $where .= ' AND ';
                    }
                    if(empty($field['compare'])){
                        $field['compare'] = '=';
                    }
                    $value = "'{$field['value']}'";
                    if(intval($field['value'])){
                        $value = $field['value'];
                    }
                    if ($field['compare'] === 'LIKE') {
                        $subject = '%{{VALUE}}%';
                        $value = str_replace('{{VALUE}}', $this->wpdb->esc_like($field['value']), $subject);
                        $where .= $this->wpdb->prepare(" %i LIKE %s", $field['key'], $value);
                    } elseif ($field['compare'] === '=') {
                        $where .= $this->wpdb->prepare(" %i = %s", $field['key'], $value);
                    } elseif ($field['compare'] === '>') {
                        $where .= $this->wpdb->prepare(" %i > %s", $field['key'], $value);
                    } elseif ($field['compare'] === '<') {
                        $where .= $this->wpdb->prepare(" %i < %s", $field['key'], $value);
                    }
                }
            }
        }

        if(isset($params['per_page']) && isset($params['offset'])){
            $limit = $this->wpdb->prepare(" LIMIT %d, %d", $params['offset'], $params['per_page']);
        } elseif(isset($params['per_page'])) {
            $limit = $this->wpdb->prepare(" LIMIT %d", $params['per_page']);
        }

        $order = (array_key_exists('order', $params)) ? $params['order'] : 'DESC';
        $order_by = (array_key_exists('order_by', $params)) ? $this->wpdb->prepare(" ORDER BY %i {$order}", $params['order_by']) : '';

        return "{$where} {$order_by} {$limit}";
    }

    /**
     * Get database results
     *
     * @param array $params
     * @return array|object
     */
    public function getResults($params = [])
    {
        $cols = isset($params['cols']) && !empty($params['cols']) ? $params['cols'] : '*';

        if(isset($params['cols'])){
            unset($params['cols']);
        }

        $table = static::$table;
        $pre_sql = $this->preSql($params);
        $sql = "SELECT {$cols} FROM `{$table}` $pre_sql";
        $output = OBJECT;
        if (array_key_exists('output', $params) && !empty($params['output'])) {
            $output = $params['output'];
        }

        $stmt = $this->wpdb->get_results($sql, $output);
        return $stmt;
    }

    /**
     * Get a row
     *
     * @param array $fields
     * @return array|object
     */
    public function get($fields = [])
    {
        $table = static::$table;
        $where = '';
        $cols = isset($fields['cols']) && !empty($fields['cols']) ? $fields['cols'] : '*';

        if(isset($fields['cols'])){
            unset($fields['cols']);
        }

        if (is_array($fields) && count($fields) > 0) {
            $where .= 'WHERE ';
            $i = 0;
            foreach ($fields as $key => $value) {
                $i++;
                if ($i > 1) {
                    $where .= ' AND ';
                }
                $where .= $this->wpdb->prepare(" %i = %s ", $key, $value);
            }
        }

        $sql = $this->wpdb->prepare("SELECT {$cols} FROM %i {$where}", $table);
        $stmt = $this->wpdb->get_row($sql);
        return $stmt;
    }

    /**
     * Insert data
     *
     * @param array $data
     * @return int|boolean
     */
    public function insert($data, $format = [])
    {
        $table = static::$table;
        $insert = $this->wpdb->insert($table, $data, $format);
        return ($insert) ? $this->wpdb->insert_id : false;
    }

    /**
     * Delete data
     *
     * @param array $where
     * @return int|boolean
     */
    public function delete($where)
    {
        $table = static::$table;
        $delete = $this->wpdb->delete($table, $where);
        return $delete;
    }

    /**
     * Update data
     *
     * @param array $data
     * @param array $where
     * @return int|boolean
     */
    public function update($data, $where)
    {
        $table = static::$table;
        $update = $this->wpdb->update($table, $data, $where);
        return $update;
    }

    /**
     * Get data count
     *
     * @param array $params
     * @return int|boolean
     */
    public function count($params = [])
    {
        $table = static::$table;
        $pre_sql = $this->preSql($params);
        $sql = "SELECT COUNT(id) FROM `{$table}` {$pre_sql}";
        $count = $this->wpdb->get_var($sql);
        return $count;
    }

    /**
     * Get data count by fields
     *
     * @param array $fields
     * @return int|boolean
     */
    public function countBy($fields = [])
    {
        $params = ['fields' => []];
        if($fields){
            foreach($fields as $key => $value){
                if(!empty($key)){
                    $params['fields'][] = [
                        'key' => $key,
                        'value' => $value,
                    ];
                }
            }
        }
        return $this->count($params);
    }


    /**
     *
     * Replace data in tables
     *
     * @param $params
     * @return mixed|boolean
     */
    public function replace($params){
        $table = isset($params['table']) && !empty($params['table']) ? $params['table'] : static::$table;
        $field = $params['field'];
        $search = $params['search'];
        $replace = $params['replace'];
        $where = isset($params['where']) && !empty($params['where']) ? $params['where'] : null;
        $sql = "UPDATE %i SET %i = REPLACE(%i, %s, %s)";
        if(!empty($where)){
            $sql .= " WHERE ";
            $i = 0;
            foreach ($where as $value){
                $i++;
                if ($i > 1) {
                    $sql .= ' AND ';
                }
                $sql .= $this->wpdb->prepare("%i = %s", $value['key'], $value['value']);
            }
        }
        $stmt = $this->wpdb->query($this->wpdb->prepare($sql, $table, $field, $field, $search, $replace));
        return $stmt;
    }

    /**
     * Get database last error
     *
     * @return void
     */
    public function getError()
    {
        return $this->wpdb->last_error;
    }
}