<?php
namespace WPSURL\App;

class Exporter {
    public static function exportOptions(){
        $db = LinkOptions::getDb();
        return $db->options()->getResults();
    }

    public static function exportStatistics(){
        $db = Statistics::getDb();
        return $db->statistics()->getResults();
    }

    public static function exportReports(){
        $db = Reports::getDb();
        return $db->reports()->getResults();
    }

    public static function exportLinks(){
        $db = Links::getDb();
        return $db->links()->getResults();
    }

    /**
     * @return array|object
     */
    public static function exportData(){
        $data = [
            'links' => self::exportLinks(),
            'options' => self::exportOptions(),
            'statistics' => self::exportStatistics(),
            'reports' => self::exportReports(),
        ];
        return $data;
    }
}