<?php
namespace WPSURL\App;

class Links {
    use \WPSURL\App\Traits\Singleton;

    use \WPSURL\App\Traits\Database\Connection;

    protected static $cols = 'id,unique_id,title,link,`key`,password,created_at,modified_at,type,status';

    public static function getResults($params = []){
        $params['cols'] = self::$cols;
        return self::getDb()->links()->getResults($params);
    }

    public static function insert($params){
        return self::getDb()->links()->insert($params);
    }

    public static function get($id_or_key){
        $item = self::getByID($id_or_key);
        if(!$item){
            $item = self::getByKey($id_or_key);
        }
        return $item ? $item : false;
    }

    public static function update($unique_id, $fields){
        return self::getDb()->links()->update($fields, ['unique_id' => $unique_id]);
    }

    public static function updateItem($unique_id, $item, $value){
        return self::update($unique_id, [$item => $value]);
    }

    public static function delete($unique_id){
        $delete = self::getDb()->links()->delete(['unique_id' => $unique_id]);
        if($delete){
            Statistics::truncate($unique_id);
            Reports::truncate($unique_id);
            LinkOptions::deleteOptions($unique_id);
            return true;
        }
        return false;
    }

    public static function changeStatus($unique_id, $status){
        return self::updateItem($unique_id, 'status' ,$status);
    }

    public static function changeType($unique_id, $type){
        return self::updateItem($unique_id, 'type', $type);
    }

    public static function getStatus($id)
    {
        return self::getItem($id, 'status');
    }

    public static function getType($id)
    {
        return self::getItem($id, 'type');
    }

    public static function getByID($id, $status = '')
    {
        $params = ['unique_id' => $id];
        if(!empty($status)){
            $params['status'] = $status;
        }
        $params['cols'] = self::$cols;
        return self::getDb()->links()->get($params);
    }

    public static function getByKey($key, $status = 'active')
    {
        $params = ['key' => $key];
        if(!empty($status)){
            $params['status'] = $status;
        }
        $params['cols'] = self::$cols;
        return self::getDb()->links()->get($params);
    }

    public static function getItem($id, $item = null)
    {
        $data = self::get($id);
        return $item && is_object($data) && isset($data->{$item}) ? $data->{$item} : false;
    }

    public static function count(){
        return self::getDb()->links()->count();
    }

    public static function getPreviewsItems(){
        global $wpdb;
        $links_table = Database::$table_links;
        $links_options_table = Database::$table_options;

        $sql = "SELECT * FROM {$links_table} JOIN {$links_options_table} ON {$links_table}.unique_id = {$links_options_table}.object_id WHERE {$links_table}.status = 'active' AND {$links_options_table}.link_option = 'iframe_preview' AND {$links_options_table}.link_option_value = '1'";
        $stmt = $wpdb->get_results($sql);
        return $stmt;
    }

    public static function getTypes(){
        $types = array(
            1 => __('Website', WPSURL_TEXT_DOMAIN),
            2 => __('Download Link', WPSURL_TEXT_DOMAIN),
            3 => __('Text', WPSURL_TEXT_DOMAIN),
        );
        $types = apply_filters('wpsurl_get_link_types', $types);
        return $types;
    }
}