<?php
namespace WPSURL\App;

class Number {
    public static function arToEN($chr){
        $fa = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $en = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
        return str_replace($fa, $en, $chr);
    }

    /**
     * Change fa number to en or reverse
     *
     * @param $num
     *
     * @return int|string
     */
    public static function numByLang($num)
    {
        $en = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
        $fa = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');

        $r = is_rtl() ? str_replace($en, $fa, $num) : self::arToEN($num);

        return apply_filters('wpsurl_convert_num_by_lang', $r);
    }
}