<?php
namespace WPSURL\App;

class Options {
    public static function isActivePlugin($plugin_rel_path){
		$check = in_array($plugin_rel_path, apply_filters('active_plugins', self::getOption('active_plugins')));
		if(!$check && is_multisite()){
			$check = is_plugin_active_for_network($plugin_rel_path);
		}
        return $check;
    }

    public static function isActiveWoo(){
        return self::isActivePlugin('woocommerce/woocommerce.php');
    }

    public static function isActiveEdd(){
        return self::isActivePlugin('easy-digital-downloads/easy-digital-downloads.php');
    }

    public static function isActiveElementor(){
        return self::isActivePlugin('elementor/elementor.php');
    }

    public static function isActiveElementorPro(){
        return self::isActivePlugin('elementor-pro/elementor-pro.php');
    }

    /**
     *
     * custom wp get option
     *
     * @param $option
     * @param bool $default
     * @param bool $deprecated
     *
     * @return mixed|void
     */
    public static function getOption($option, $default = false, $deprecated = true)
    {
        return is_multisite() ? get_blog_option(get_current_blog_id(), $option, $default) : get_option($option, $default);
    }

    /**
     *
     * custom wp update option
     *
     * @param $option
     * @param $value
     * @param null $autoload
     *
     * @return bool
     */
    public static function updateOption($option, $value, $autoload = null)
    {
        return is_multisite() ? update_blog_option(get_current_blog_id(), $option, $value, $autoload) : update_option($option, $value, $autoload);
    }

    /**
     *
     * custom wp add option
     *
     * @param $option
     * @param $value
     * @param bool $deprecated
     *
     * @return bool
     */
    public static function addOption($option, $value, $deprecated = true)
    {
        return is_multisite() ? add_blog_option(get_current_blog_id(), $option, $value) : add_option($option, $value, $deprecated);
    }

    /**
     *
     * custom wp add option
     *
     * @param $option
     *
     * @return bool
     */
    public static function deleteOption($option)
    {
        return is_multisite() ? delete_blog_option(get_current_blog_id(), $option) : delete_option($option);
    }

    /**
     *
     * check user logged option
     *
     * @return bool
     */
    public static function isViewOnlyLoggedUser()
    {
        $wp_option = (bool) Settings::getOption('view_only_logged_users');

        return $wp_option;
    }

    public static function hasFastDownload()
    {
        return (bool) Settings::getOption('has_fast_download');
    }

    public static function hasDirectTransfer()
    {
        return (bool) Settings::getOption('view_redirect_page_status');
    }

    public static function useHtmlCode()
    {
        return (bool) Settings::getOption('use_html_code');
    }
}