<?php
namespace WPSURL\App;

class PageConditionMessages {
    private static $messages = [
        "100" => 'This link has expired %url%',
        "101" => 'You must be logged in to use this section %url%',
        "102" => 'Access to this link is only allowed for customers of these products %url%',
        "103" => 'To access this link, you must have at least 1 completed purchase %url%',
    ];
    private $params;
    private $has_condition = false;

    public function __construct($params)
    {
        $this->params = $params;
    }

    public function getMessage($code = 0){
        $message = self::$messages[$code] ?? false;

        $url = '<a href="' . get_site_url() . '">' . __('Return to Home', WPSURL_TEXT_DOMAIN) . '</a>';

        $message = $message ? __(str_replace(['%url%'], [$url], $message), WPSURL_TEXT_DOMAIN) : false;
        return $message;
    }

    public function setHasCondition(){
        $this->has_condition = true;
    }

    public function hasCondition(){
        return $this->has_condition;
    }

    /**
     *
     * Register Conditions
     *
     * Conditions apply in the link page
     *
     * @return void
     */
    public function applyConditions(){
        $this->wooConditions();
        $this->eddConditions();
        $this->userConditions();
        $this->viewConditions();
        do_action('wpsurl_link_page_conditions', $this, $this->hasCondition());
        if ($this->hasCondition()){
            exit();
        }
    }

    public function wooConditions(){
        if (!Options::isActiveWoo())
            return false;

        if ($this->params->restrict_woo && $this->params->access_products){
            if (!Woocommerce::isUserCustomer() && empty($this->params->access_products_arr)) {
                Utility::showHtmlMsg($this->getMessage(103), 'warning');
                $this->setHasCondition();
            } else if (is_array($this->params->access_products_arr) && !empty($this->params->access_products_arr)) {
                if (!Woocommerce::isUserCustomerProducts($this->params->access_products_arr)) {
                    Utility::showHtmlMsg($this->getMessage(102), 'warning');
                    echo '<br><div class="wpsurl-alert info"><ul>';
                    foreach ($this->params->access_products_arr as $product_id) {
                        if (get_post_type($product_id) == 'product') {
                            echo '<li><a href="' . get_the_permalink($product_id) . '" target="_blank">' . get_the_title($product_id) . '</a></li>';
                        }
                    }
                    echo '</ul></div>';
                    $this->setHasCondition();
                }
            }
        }
    }
    public function eddConditions(){
        if (!Options::isActiveEdd())
            return false;

        if ($this->params->restrict_edd && $this->params->access_downloads){
            if (is_array($this->params->access_downloads_arr) && !empty($this->params->access_downloads_arr)) {
                if (!Edd::isUserCustomerProducts($this->params->access_downloads_arr)) {
                    Utility::showHtmlMsg($this->getMessage(102), 'warning');
                    echo '<br><div class="wpsurl-alert info"><ul>';
                    foreach ($this->params->access_downloads_arr as $download_id) {
                        if (get_post_type($download_id) == 'download') {
                            echo '<li><a href="' . get_the_permalink($download_id) . '" target="_blank">' . get_the_title($download_id) . '</a></li>';
                        }
                    }
                    echo '</ul></div>';
                }
                $this->setHasCondition();
            }
        }
    }
    public function userConditions(){
        if ($this->params->only_logged_user == 'true' || $this->params->only_logged_user == '1') {
            if (!is_user_logged_in()) {
                Utility::showHtmlMsg($this->getMessage(101), 'warning');
                $this->setHasCondition();
            }
        }
    }
    public function viewConditions(){
        if($this->params->restrictions_status){
            if (!empty($clicks) && $clicks > 0) {
                if (Statistics::getClicks($this->params->unique_id) > $clicks) {
                    Utility::showHtmlMsg($this->getMessage(100), 'warning');
                }
                $this->setHasCondition();
            }
            if (!empty($views) && $views > 0) {
                if (Statistics::getViews($this->params->unique_id) > $views) {
                    Utility::showHtmlMsg($this->getMessage(100), 'warning');
                }
                $this->setHasCondition();
            }
        }
    }
}