<?php
namespace WPSURL\App;

use WPSURL\App\Database;

class Reports {

    use \WPSURL\App\Traits\Database\Connection;

    protected static $cols = 'id,object_id,user_id,fullname,email,content,created_at,status';

    public static function getResults($params){
        $params['cols'] = self::$cols;
        return self::getDb()->reports()->getResults($params);
    }

    public static function insert($unique_id, $fields)
    {
        return intval($unique_id) ? self::getDb()->reports()->insert(array_merge(['object_id' => $unique_id], $fields)) : false;
    }

    public static function update($id, $fields)
    {
        return self::getDb()->reports()->update($fields, ['id' => $id]);
    }

    public static function truncate($unique_id)
    {
        return self::getDb()->reports()->delete(['object_id' => $unique_id]);
    }

    public static function count(){
        return self::getDb()->reports()->count();
    }
}