<?php
namespace WPSURL\App;

class Rewrite {

    use \WPSURL\App\Traits\Singleton;

    protected static function getSlug(){
        return Utility::getPagesSlug();
    }

    protected static function getShortSlug(){
        return Utility::getPagesSlug(2);
    }

    public static function registerRewrite()
    {
        add_rewrite_rule(static::getShortSlug() . '-download/([a-zA-Z0-9].*)/?$', 'index.php?' . static::getShortSlug() . '-download=$matches[1]', 'top');
        add_rewrite_rule(static::getSlug() . '/([^/]+)/?$', 'index.php?' . static::getSlug() . '=$matches[1]', 'top');
        add_rewrite_rule(static::getShortSlug() . '/([0-9].*)/?$', 'index.php?' . static::getShortSlug() . '=$matches[1]', 'top');
        flush_rewrite_rules();
    }

    public static function rewriteQueryVars($vars)
    {
        $vars[] = static::getSlug();
        $vars[] = static::getShortSlug();
        $vars[] = static::getShortSlug() . '-download';

        return $vars;
    }

    public static function handleRewriteQueryVarsRequest($query)
    {
        global $query_var_value;
        $is_download = isset($query->query_vars[static::getShortSlug() . '-download']);
        $is_page = isset($query->query_vars[static::getSlug()]) || isset($query->query_vars[static::getShortSlug()]);
        $query_var_value = Utility::getQueryVarsValue();
        $link_data = Links::get($query_var_value);
		
		if($is_page){
			$external_link = base64_decode($query_var_value);
			if($external_link && filter_var($external_link, FILTER_VALIDATE_URL)){
				wp_redirect($external_link);
				exit();
			}
		}

        if($is_download || $is_page){
            if(!$link_data){
                wp_redirect(site_url());
                exit();
            }

            $link_id = $link_data->unique_id;

            if(LinkOptions::hasSchedule($link_id)){
                if(!LinkOptions::isStartSchedule($link_id) || LinkOptions::isExpired($link_id)){
                    wp_redirect(site_url());
                    exit();
                }
            }
        }

        if ($is_download) {
            include_once(WPSURL_VIEW_PAGES . 'download.php');
            exit();
        } elseif ($is_page) {
            include_once(WPSURL_VIEW_PAGES . 'redirect.php');
            exit();
        }
    }
}