<?php
namespace WPSURL\App;

use WPSURL\App\Options;

class Settings {
    private static $option_name_prefix = 'wpsurl_';

    /**
     * Save general settings callback
     */
    public static function saveSettingsCallback()
    {
        if (isset($_POST['wpsurl-save-setting-options'])) {
            if (!isset($_POST['settings_nonce']) || !wp_verify_nonce($_POST['settings_nonce'], 'save_settings')) {
                exit('Sorry, your nonce did not verify!');
            } else {
                $options = [
                    'use_elementor' => ['type' => 'checkbox'],
                    'elementor_page' => [],
                    'view_page_logo_url' => [],
                    'view_redirect_page_status' => ['type' => 'checkbox'],
                    'view_only_logged_users' => ['type' => 'checkbox'],
                    'links_title_status' => ['type' => 'checkbox'],
                    'view_timer_status' => ['type' => 'checkbox'],
                    'transfer_end_timer_status' => ['type' => 'checkbox'],
                    'view_add_html_code' => [],
                    'redirect_page_slug' => [],
                    'redirect_page_short_slug' => [],
					'alert_status' => [],
                    'view_timer_second_value' => [],
                    'view_alert_text' => [],
                    'view_alert_type' => [],
                    'show_other_previews' => ['type' => 'checkbox'],
                    'has_fast_download' => ['type' => 'checkbox'],
                    'use_html_code' => ['type' => 'checkbox'],
                    'retention_data' => ['type' => 'checkbox'],
                    'show_responsive_buttons' => ['type' => 'checkbox'],
                    'convert_post_external_links_to_internal' => ['type' => 'checkbox'],
                ];

                if($options){
                    foreach ($options as $key => $value){
                        if(isset($_POST[$key])){
                            $is_slug = strpos($key, 'slug') !== false;
                            $option = sanitize_text_field($_POST[$key]);
                            if($is_slug){
                                if (!empty($option)) {
                                    self::updateOption($key, \WPSURL\App\Utility::slugRegexMatch($option));
                                    flush_rewrite_rules();
                                }
                            } else {
                                self::updateOption($key, $option);
                            }
                        } else {
							self::deleteOption($key);
						}
                    }
                }

                Alert::addMessage(__('Settings saved successfully.', WPSURL_TEXT_DOMAIN));
            }
        }
    }

    /**
     * import links action callback
     */
    public static function importDataCallback()
    {
        global $alert;
        if (isset($_POST['wpsurl_import_nonce']) && !wp_verify_nonce($_POST['wpsurl_import_nonce'], 'wpsurl_import_nonce_action')) {
            return;
        }
        if (isset($_GET['page']) && ($_GET['page'] == 'wp-safe-url' || strpos($_GET['page'], 'wpsurl-') !== false)) {
            if (isset($_POST['wpsurl-import-submit'])) {
                $file = (!empty($_FILES['import_links_file']['name'])) ? $_FILES['import_links_file'] : null;
                $file_name = $file['name'];
                if (!empty($file_name)) {
                    $tmp_name = $file['tmp_name'];
                    $json = Utility::isJson(file_get_contents($tmp_name), 1);
                    if (!empty($tmp_name) && strtolower(pathinfo($file_name, PATHINFO_EXTENSION)) == 'json') {
                        $import = Importer::importData($json);
                        if ($import) {
                            Alert::addMessage(__('Import successfully.', WPSURL_TEXT_DOMAIN));
                        } else {
                            Alert::addMessage(__('An error occurred, please try again', WPSURL_TEXT_DOMAIN), 1);
                        }
                    } else {
                        Alert::addMessage(__('Invalid file format.', WPSURL_TEXT_DOMAIN), 1);
                    }
                }
            }
        }
    }

    public static function getOption($key){
        $value = Options::getOption(self::$option_name_prefix . $key);
        if($value === 1 || $value === '1' || $value === true || $value === 'true'){
            return true;
        } elseif($value === 0 || $value === '0' || $value === false || $value === 'false'){
            return false;
        }
        return $value;
    }

    public static function updateOption($key, $value){
        return Options::updateOption(self::$option_name_prefix . $key, $value);
    }

    public static function deleteOption($key){
        return Options::deleteOption(self::$option_name_prefix . $key);
    }

    public static function getTabs(){
        $tabs = [
            'global' => [
              'icon' => 'wpsurl-icon-cog',
              'title' => __( 'Settings', WPSURL_TEXT_DOMAIN ),
              'description' => __('Element control and configuration', WPSURL_TEXT_DOMAIN),
            ],
            'alert' => [
              'icon' => 'wpsurl-icon-comment',
              'title' => __( 'Alert', WPSURL_TEXT_DOMAIN ),
              'description' => __('Notification bar', WPSURL_TEXT_DOMAIN)
            ],
            'backup' => [
                'icon' => 'wpsurl-icon-comment',
                'title' => __( 'Backup', WPSURL_TEXT_DOMAIN ),
                'description' => __('Import and Export data', WPSURL_TEXT_DOMAIN),
                'show' => false
            ],
        ];

        $tabs = apply_filters('wpsurl_get_setting_tabs', $tabs);

        return $tabs;
    }

    public static function getLogoUrl(){
        $logo_option = Settings::getOption( 'view_page_logo_url' );
        $logo_url = empty($logo_option) ? WPSURL_IMG_URL . 'default-logo.webp' : $logo_option;
        return $logo_url;
    }
}