<?php
namespace WPSURL\App;

class Shortcode {
    /**
     *
     * get safe url html button by short code
     *
     * @param $atts
     *
     * @return string
     */
    public static function buttonShortcodeCallback($atts)
    {
        $atts = shortcode_atts(
            array(
                'id' => '',
                'text' => '',
                'target' => '_blank',
                'views' => 'false',
                'clicks' => 'false',
            ),
            $atts
        );
        $unique_id = sanitize_text_field($atts['id']);
        if (!empty($unique_id)) {
            $data = Links::getByID($unique_id);
            if ($data) {
                $link = Utility::getShortHashLink($unique_id);
                $status = $data->status;
                $type = $data->type;
                $pwd = $data->password;
                $cls = '';
                if ($status === 'active') {
                    if (!Options::isViewOnlyLoggedUser()) {
                        if (!empty($pwd)) {
                            $cls .= ' locked';
                        }
                        if ($type === '2') {
                            $cls .= ' download';
                        } elseif (LinkOptions::isAccessForEddProducts($unique_id) || LinkOptions::isAccessForProducts($unique_id)) {
                            $cls .= ' customers';
                        }
                        $text = $data->title;
                    } else {
                        $text = __('Log in to access this link', WPSURL_TEXT_DOMAIN);
                        $link = wp_login_url(get_permalink());
                    }

                    $text = !empty($atts['text']) ? sanitize_text_field($atts['text']) : $text;
                    $target = !empty($atts['target']) && $atts['target'] !== 'false' ? 'target="'. sanitize_text_field($atts['target']) .'"' : '';
                    $views = $atts['views'] === 'true' ? sprintf('<span class="l-views-count" data-title="%s">%d</span>', esc_attr__('View', WPSURL_TEXT_DOMAIN), Number::numByLang(Statistics::getViews($unique_id))) : '';
                    $clicks = $atts['clicks'] === 'true' ? sprintf('<span class="l-clicks-count" data-title="%s">%d</span>', esc_attr__('Click', WPSURL_TEXT_DOMAIN), Number::numByLang(Statistics::getClicks($unique_id))) : '';

                    return "<a href='{$link}' {$target} class='wpsurl-button wpsurl-redirect-button {$cls}'>{$text}{$views}{$clicks}</a>";
                }
            }
        }
    }
}