<?php
namespace WPSURL\App;
class Statistics extends Database {
    private static $wpdb;

    private static $table;

    protected static $cols = 'id,object_id,ip,visit,click,first_visit,last_visit,status';

    use \WPSURL\App\Traits\Database\Connection;

    public function __construct()
    {
        global $wpdb;
        self::$wpdb = $wpdb;
        self::$table = $wpdb->_prefix . 'links_statistics';
    }

    public static function getResults($params){
        $params['cols'] = self::$cols;
        return self::getDb()->statistics()->getResults($params);
    }

    public static function insert($params)
    {
        $ip = isset($params['ip']) && !empty($params['ip']) ? $params['ip'] : Utility::getVisitorIP();
        $link = Links::get($params['unique_id']);
        if($link){
            return self::getDb()->statistics()->insert([
                'object_id' => $params['unique_id'],
                'ip' => $ip,
                'visit' => $params['visit'] ?? 1,
                'click' => $params['click'] ?? 0
            ]);
        }
        return false;
    }

    public static function update($unique_id, $fields)
    {
        if(Links::get($unique_id)){
            return self::getDb()->statistics()->update($fields, ['object_id' => $unique_id]);
        }
        return false;
    }

    public static function updateOption($unique_id, $option, $value)
    {
        return self::update($unique_id, [$option => $value]);
    }

    public static function incrementView($unique_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $table = Database::$table_statistics;
        if(self::isExistsIP($unique_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE %i SET visit = visit + 1, last_visit = %s WHERE object_id = %d AND ip = %s", $table, current_time('mysql'), $unique_id, $ip));
        } else {
            return self::insert(['unique_id' => $unique_id]);
        }
    }
    
    public static function incrementClick($unique_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $table = Database::$table_statistics;
        if(self::isExistsIP($unique_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE %i SET click = click + 1 WHERE object_id = %d AND ip = %s", $table, $unique_id, $ip));
        } else {
            return self::insert(['unique_id' => $unique_id, 'click' => 1]);
        }
    }

    public static function decrementView($unique_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $table = Database::$table_statistics;
        if(self::isExistsIP($unique_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE %i SET visit = visit - 1 WHERE object_id = %d AND ip = %s", $table, $unique_id, $ip));
        }
        return false;
    }
    
    public static function decrementClick($unique_id)
    {
        global $wpdb;
        $ip = \WPSURL\App\Utility::getVisitorIP();
        $table = Database::$table_statistics;
        if(self::isExistsIP($unique_id, $ip)){
            return $wpdb->query($wpdb->prepare("UPDATE %i SET click = click - 1 WHERE object_id = %d AND ip = %s", $table, $unique_id, $ip));
        }
        return false;
    }

    public static function getViews($unique_id)
    {
        global $wpdb;
        $table = Database::$table_statistics;
        $sql = "SELECT SUM(visit) FROM %i WHERE object_id = %d";
        $count = $wpdb->get_var($wpdb->prepare($sql, $table, $unique_id));
        return $count ?? 0;
    }

    public static function getClicks($unique_id)
    {
        global $wpdb;
        $table = Database::$table_statistics;
        $sql = "SELECT SUM(click) FROM %i WHERE object_id = %d";
        $count = $wpdb->get_var($wpdb->prepare($sql, $table, $unique_id));
        return $count ?? 0;
    }

    public static function isExistsIP($unique_id, $ip = ''){
        return self::getDb()->statistics()->get(['object_id' => $unique_id, 'ip' => $ip]);
    }

    public static function truncate($unique_id)
    {
        return self::getDb()->statistics()->delete(['object_id' => $unique_id]);
    }

    public static function count(){
        return self::getDb()->statistics()->count();
    }
}