<?php
namespace WPSURL\App\Admin;

use WPSURL\App\ApiKeys;
use WPSURL\App\Database;
use WPSURL\App\Exporter;
use WPSURL\App\Links;
use WPSURL\App\Options;
use WPSURL\App\LinkOptions;
use WPSURL\App\Reports;
use WPSURL\App\Settings;
use WPSURL\App\Statistics;
use WPSURL\App\Utility;

class Ajax {
    /**
     * Ajax action change link status
     */
    public static function changeLinkStatus()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $id = sanitize_text_field($_POST['unique_id']);

        if (Links::getByID($id)) {
            $link_status = Links::getStatus($id);
            $status = $link_status == 'active' ? 'inactive' : 'active';

            $change = Links::changeStatus($id, $status);

            if ($change) {
                $result = array(
                    'msg' => __('Link status changed successfully', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                    'status' => Links::getStatus($id)
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                    'status' => $link_status
                );
            }
        } else {
            $result = array(
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
                'status' => false
            );
        }
        wp_send_json($result);
    }

    /**
     * Ajax action link lock
     */
    public static function activeLinkLock()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $id = sanitize_text_field($_POST['unique_id']);
        $password = sanitize_text_field($_POST['password']);
        $unlocked = isset($_POST['unlock']) && $_POST['unlock'] == true;
        if (Links::getByID($id)) {
            if ($unlocked && empty($password)) {
                $lock = Links::updateItem($id, 'password', null);
                $msg = __('Link lock inactivated', WPSURL_TEXT_DOMAIN);
            } else {
                $lock = Links::updateItem($id, 'password', md5($password));
                $msg = __('Link successfully locked', WPSURL_TEXT_DOMAIN);
            }
            if ($lock) {
                $result = array(
                    'msg' => $msg,
                    'type' => 'success',
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                );
            }
        } else {
            $result = array(
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
            );
        }
        if(!empty($password)){
            $result['lock'] = Links::getItem($id, 'password');
        }
        wp_send_json($result);
    }

    /**
     * Ajax action delete link
     */
    public static function deleteLink()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $id = sanitize_text_field($_POST['unique_id']);
        $count = Links::count();
        if (Links::getByID($id)) {
            $delete = Links::delete($id);
            if ($delete) {
                $result = array(
                    'msg' => __('Successfully deleted', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                    'links_count' => $count
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                    'links_count' => $count
                );
            }
        } else {
            $result = array(
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
                'links_count' => $count
            );
        }
        wp_send_json($result);
    }

    /**
     * Ajax action insert new link
     */
    public static function insertLink()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $title = sanitize_text_field($_POST['title']);
        $link = sanitize_url($_POST['link']);
        $type = sanitize_text_field($_POST['type']);
        $password = sanitize_text_field($_POST['password']);
        $unique_id = Utility::generateUniqueLinkID();
	$allowed_types = Links::getTypes();
        if (!empty($title) && in_array($type, array_keys($allowed_types))) {
            $params = [
                'title' => $title,
                'link' => !empty($link) ? $link : 'Is Empty.',
                'type' => $type,
                'unique_id' => $unique_id,
                'key' => Utility::generateUniqueLinkKey()
            ];
            if (!empty($password)) {
                $params['password'] = $password;
            }
            $insert_id = Links::insert($params);
            if ($insert_id) {
                do_action('wpsurl_after_insert_link_action', $unique_id, array_merge($_POST, $params));
                $result = array(
                    'msg' => __('Link created successfully', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                    'links_count' => Links::count(),
                    'safe' => Utility::getHashLink($link),
                    'short' => Utility::getShortHashLink($insert_id)
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                    'links_count' => Links::count()
                );
            }
        } else {
            $result = array(
                'msg' => __('Invalid values entered', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
                'links_count' => Links::count()
            );
        }
        wp_send_json($result);
    }

    /**
     * Ajax action edit link
     */
    public static function editLink()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        ob_clean();
        $data = $_POST;
        $title = sanitize_text_field($data['title']);
        $link = sanitize_url($data['link']);
        $type = sanitize_text_field($data['type']);
        $id = sanitize_text_field($data['id']);
        if (!empty($title) || ($type !== 3 && !empty($link)) || !empty($type) && !empty($id)) {
            $link_data = Links::getByID($id);
            if ($link_data) {
                $args = [
                    'title' => $title,
                    'link' => !empty($link) ? $link : 'Is Empty.',
                    'type' => $type
                ];
                $update = Links::update($id, $args);
                do_action('wpsurl_after_edit_link_action', $id, $data);
                $result = array(
                    'msg' => __('Updated successfully', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                );
            } else {
                $result = array(
                    'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                    'type' => 'error'
                );
            }
        } else {
            $result = array(
                'msg' => __('Invalid values entered', WPSURL_TEXT_DOMAIN),
                'type' => 'error'
            );
        }
        wp_send_json($result);
    }

    /**
     *
     * Get edit modal html element by ajax
     *
     */
    public static function linkEditorHtmlTemplate()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $show = false;
        $unique_id = sanitize_text_field($_POST['unique_id']);
        $link_data = Links::getByID($unique_id);
        if ($link_data) {
            $link_title = $link_data->title;
            $link = $link_data->link;
            $link_type = (int) $link_data->type;
            $only_logged = LinkOptions::isOnlyLoggedUser($unique_id);
            $is_preview = LinkOptions::isIframePreview($unique_id);
            $restrictions_status = LinkOptions::isRestrictByView($unique_id);
            $restriction_woo = LinkOptions::isRestrictByWoo($unique_id);
            $restriction_edd = LinkOptions::isRestrictByEdd($unique_id);
            $schedule_status = LinkOptions::hasSchedule($unique_id);
            $schedule_start = LinkOptions::getScheduleStart($unique_id);
            $schedule_end = LinkOptions::getScheduleEnd($unique_id);
            $link_text = LinkOptions::getSimpleText($unique_id);
            include_once(WPSURL_VIEW_ADMIN_PATH . 'edit-link.php');
        }
        wp_die();
    }

    /**
     * Ajax action settings check is exists url slug(s)
     */
    public static function checkIsExistsSlug()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $rewrite = sanitize_text_field($_POST['rewrite']);
        if (!empty($rewrite)) {
            if (\WPSURL\App\Utility::isExistsRewrite($rewrite . '/([^/]+)/?$') || \WPSURL\App\Utility::isExistsRewrite($rewrite . '/([0-9].*)/?$')) {
                $result = array('type' => 'error');
            } else {
                $result = array('type' => 'success');
            }
        } else {
            $result = array('type' => 'error');
        }
        wp_send_json($result);
    }

    public static function clearLinkData()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        extract($_POST);
        $unique_id = sanitize_text_field($unique_id);
        $clear_type = sanitize_text_field($clear_type);
        if (Links::getByID($unique_id)) {
            if ($clear_type == 'views') {
                $clear_data = Statistics::update($unique_id, ['visit' => 0]);
                if ($clear_data) {
                    $result = array(
                        'type' => 'success',
                        'msg' => __('Number of visits was successfully cleared', WPSURL_TEXT_DOMAIN),
                        'count' => Statistics::getViews($unique_id)
                    );
                } else {
                    $result = array(
                        'type' => 'error',
                        'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                    );
                }
            } elseif ($clear_type == 'clicks') {
                $clear_data = Statistics::update($unique_id, ['click' => 0]);
                if ($clear_data) {
                    $result = array(
                        'type' => 'success',
                        'msg' => __('Number of clicks was successfully cleared', WPSURL_TEXT_DOMAIN),
                        'count' => Statistics::getClicks($unique_id)
                    );
                } else {
                    $result = array(
                        'type' => 'error',
                        'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                    );
                }
            }
        } else {
            $result = array(
                'status' => 'error',
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }

    public static function truncateTable()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        global $wpdb;
        $table = sanitize_text_field($_POST['table']);
        if(!empty($table)){
            $table_name = $wpdb->prefix . WPSURL_PREFIX . 'links_' . $table;
            $query = $wpdb->query("DELETE FROM {$table_name}");
            if ($query) {
                $result = array(
                    'type' => 'success',
                    'msg' => __('Empty was successfully', WPSURL_TEXT_DOMAIN)
                );
            } else {
                $result = array(
                    'type' => 'error',
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                );
            }
        } else {
            $result = array(
                'type' => 'error',
                'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }

    public static function reportItemAction()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        extract($_POST);
        $item_action = sanitize_text_field($item_action);
        $id = sanitize_text_field($id);
        if($item_action === 'reviewed'){
            if (Reports::update($id, ['status' => 2])){
                $result = array(
                    'type' => 'success',
                    'msg' => __('The request was successful.', WPSURL_TEXT_DOMAIN)
                );
            } else {
                $result = array(
                    'type' => 'error',
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                );
            }
        } else {
            $result = array(
                'type' => 'error',
                'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }

    public static function exportLinksAction()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        date_default_timezone_set('Asia/Tehran');
        $file_name = 'wp-safe-url-' . date('Y/d/m H:i:s') . '-export';
        $file_name = Utility::cleanSpecialChar($file_name, '-');
        $file_type = 'json';
        $file_name = $file_name . '.' . $file_type;
        $file_name = sanitize_file_name($file_name);
        $json_data = Exporter::exportData();
        wp_send_json_success(['file_name' => $file_name, 'json' => json_encode($json_data)]);
    }

    public static function beforeUninstallPlugin()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $action = sanitize_text_field($_POST['operator']);

        if(!in_array($action, ['kd', 'full'])){
            wp_send_json_error(['msg' => __('The operation is invalid.', WPSURL_TEXT_DOMAIN), 'type' => 'error']);
        }

        if($action === 'kd'){
            update_option('wpsurl_uninstall_erase_data', false);
        } else{
            update_option('wpsurl_uninstall_erase_data', true);
        }

        wp_send_json_success(['msg' => __('In progress, please wait...', WPSURL_TEXT_DOMAIN), 'type' => 'success']);
    }

    public static function realtimeSaveFields()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $name = sanitize_text_field($_POST['name']);
        $value = sanitize_text_field($_POST['value']);
        $type = sanitize_text_field($_POST['type']);

        $is_checkbox = $type === 'checkbox';

        $value = $is_checkbox ? ($value === 'true') : $value;

        if($is_checkbox && !$value){
            $update = Settings::deleteOption($name);
        } else {
            $update = Settings::updateOption($name, $value);
        }

        if($update){
            wp_send_json_success($value);
        } else {
            wp_send_json_error($value);
        }
    }

    public static function handleReplacement()
    {
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $field_id = sanitize_key($_POST['replace_field']);
        $search_value = sanitize_text_field($_POST['search_value']);
        $replace_value = sanitize_text_field($_POST['replace_value']);
        $allowed_fields = [1 => 'title', 2 => 'link', 3 => 'text'];
        $field = isset($allowed_fields[$field_id]) ? $allowed_fields[$field_id] : null;
        $args = [
            'field' => $field,
            'search' => $search_value,
            'replace' => $replace_value
        ];
        $update = false;

        if(!empty($field) && !empty($field_id) && !empty($search_value) && !empty($replace_value) && in_array($field_id, array_keys($allowed_fields))){
            if(in_array($field_id, ['1', '2'])){
                $update = Links::getDb()->links()->replace($args);
            } elseif($field_id === '3'){
                $args['field'] = 'link_option_value';
                $args['where'] = [
                    [
                        'key' => 'link_option',
                        'value' => 'simple_text_content'
                    ],
                ];
                $update = LinkOptions::getDb()->options()->replace($args);
            }

            if($update){
                $result = array(
                    'type' => 'success',
                    'msg' => __('The request was successful.', WPSURL_TEXT_DOMAIN)
                );
            } else {
                $result = array(
                    'type' => 'error',
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                );
            }
        } else {
            $result = array(
                'type' => 'error',
                'msg' => __('Please complete the fields', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }

    /**
     * @throws \Exception
     */
    public static function handleAddApiKey(){
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $title = sanitize_text_field($_POST['title']);
        $des = sanitize_text_field($_POST['description']);
        $permission = sanitize_text_field($_POST['permission']);

        $secret = bin2hex(random_bytes(30));

        $insert = ApiKeys::insert([
            'title' => $title,
            'secret' => $secret,
            'description' => $des,
            'permissions' => $permission,
        ]);

        if($insert){
            $result = array(
                'type' => 'success',
                'msg' => __('The request was successful.', WPSURL_TEXT_DOMAIN)
            );
        } else {
            $result = array(
                'type' => 'error',
                'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }

    public static function handleRevokeApiKey(){
        check_ajax_referer('wpsurl_nonce', 'nonce');

        $id = sanitize_key($_POST['id']);

        $revoke = ApiKeys::revoke($id);

        if($revoke){
            $result = array(
                'type' => 'success',
                'msg' => __('The revoke was successful.', WPSURL_TEXT_DOMAIN)
            );
        } else {
            $result = array(
                'type' => 'error',
                'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }
}