<?php
namespace WPSURL\App\Api;

use WPSURL\App\Utility;

class Client{
    protected $api;
    protected $slug = 'surl';
    protected $endpoint;

    public function __construct()
    {
        $this->api = get_rest_url() . $this->slug . '/' . $this->endpoint;
    }

    public function post($body){
        $json_data = wp_json_encode($body);
        $args = array(
            'body' => $json_data,
            'headers' => array(
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
            ),
        );
        $response = wp_remote_post($this->api, $args);
        $res = !is_wp_error($response) && !empty($response) ? wp_remote_retrieve_body($response) : false;
        $json = Utility::isJson($res);
        return $res && $json ? $json : false;
    }

    public function get(){
        $args = array(
            'headers' => array(
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
            ),
        );
        $response = wp_remote_get($this->api, $args);
        $res = !is_wp_error($response) && !empty($response) ? wp_remote_retrieve_body($response) : false;
        $json = Utility::isJson($res);
        return $res && $json ? $json : false;
    }
}