<?php
namespace WPSURL\App\Api;

use WPSURL\App\Utility;

class RequestLimiter
{
    private $maxRequests;
    private $duration;
    private $storagePath;
    private $ipAddress;
    private $requestCount;

    public function __construct($maxRequests, $duration, $storagePath = null)
    {
        $this->maxRequests = $maxRequests;
        $this->duration = $duration;
        $this->storagePath = $storagePath ? $storagePath : $this->getStoragePath();
        $this->ipAddress = Utility::getVisitorIP();
        $this->requestCount = 0;
    }

    public function getStoragePath(){
        $upload_dir = wp_upload_dir();
        $path = $upload_dir['basedir'] . '/bavance/cache/';

        if(!is_dir($path)){
            mkdir($path, 0755, true);
        }

        return $path;
    }

    public function checkRequest()
    {
        $requestFile = $this->storagePath . $this->ipAddress . ".json";
        if (file_exists($requestFile)) {
            $requests = json_decode(file_get_contents($requestFile), true);
            $this->requestCount = $requests['requestCount'];
            $lastRequestTime = strtotime($requests['lastRequestTime']);
            $currentTime = time();
            $elapsedTime = $currentTime - $lastRequestTime;
            if ($elapsedTime < $this->duration && $this->requestCount >= $this->maxRequests) {
                return false;
            } elseif ($elapsedTime > $this->duration) {
                $this->requestCount = 0;
            }
        }
        $this->requestCount++;
        $requests = array(
            'requestCount' => $this->requestCount,
            'lastRequestTime' => date("Y-m-d H:i:s")
        );
        file_put_contents($requestFile, json_encode($requests));
        return $this->requestCount;
    }
}
