<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;
use WPSURL\App\Elementor\ElementorBuilder;
use WPSURL\App\GlobalData;
use WPSURL\App\Links;
use WPSURL\App\Settings;
use WPSURL\App\Utility;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class RedirectButton extends \Elementor\Widget_Base
{
    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        Assets::registerStyle('wpsurl.button.css', WPSURL_ELEMENTOR_CSS_URL . 'button.css', null, WPSURL_VERSION);
    }

    public function get_style_depends()
    {
        return [Assets::getHandleName('wpsurl.button.css')];
    }

    public function get_name()
    {
        return 'wpsurl_redirect_button';
    }

    public function get_title()
    {
        return esc_html__('Redirect Button', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-button';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['redirect_button', 'redirectbutton', esc_html__('Redirect Button' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'use_custom_title',
            [
                'label' => esc_html__( 'Custom Title', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', WPSURL_TEXT_DOMAIN ),
                'label_off' => esc_html__( 'No', WPSURL_TEXT_DOMAIN ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__( 'Title', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Click for Redirect', WPSURL_TEXT_DOMAIN),
                'condition' => [
                        'use_custom_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
                'default' => [
                    'value' => 'fas fa-arrow-left',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Button', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_text_alignment',
            [
                'label' => esc_html__('Alignment', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-buttons' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'selector' => '{{WRAPPER}} a',
                'fields_options' =>
                    [
                        'background' =>
                            [
                                'default' => 'classic'
                            ],
                        'color' =>
                            [
                                'default' => '#fff'
                            ]
                    ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow',
                'label' => esc_html__('Box Shadow', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} a',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'text_color_hover',
            [
                'label' => esc_html__( 'Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_hover',
                'selector' => '{{WRAPPER}} a:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_hover',
                'selector' => '{{WRAPPER}} a:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} a:hover',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 9,
                            'vertical' => 9,
                            'blur' => 33,
                            'spread' => 0,
                            'color' => '#d1d1d1'
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $val = Utility::getQueryVarsValue();
        $link_data = Links::get($val);

        $extra = $link_data ? GlobalData::loadedExtraLinkData($link_data->unique_id) : false;
        $btn_cls = 'button';
        if(is_object($extra) && isset($extra->pwd)){
            $btn_cls = (empty($extra->pwd) || $extra->pwd == '') ? 'button' : 'by-pass';
        }
        $type = (int) Links::getType($val);
        ?>
        <div class="wpsurl-redirect-button-element wpsurl-redirect-button-element-<?php echo $wid; ?>">
            <div class="wpsurl-view-buttons wpsurl-buttons" style="display:<?php echo is_admin() ? 'block' : 'none' ?>">
                <a href="#" data-wpsurl-link-type="<?php echo $type ?>" data-wpsurl-link-token="<?php echo Utility::getQueryVarsValue() ?>" class="wpsurl-transfer-button wpsurl-redirect-<?php echo $btn_cls ?><?php echo (!Settings::getOption('view_timer_status')) ? ' wpsurl-button-disable' : ''; ?>">
                    <?php
                    \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );

                    if($settings['use_custom_title'] == 'yes'){
                        echo $settings['btn_title'];
                    } else {
                        if($type === 1){
                            _e('Click to transfer', WPSURL_TEXT_DOMAIN);
                        } elseif($type === 3) {
                            _e('Get Text', WPSURL_TEXT_DOMAIN);
                        } else {
                            _e('Download file', WPSURL_TEXT_DOMAIN);
                        }
                    }
                    ?>
                </a>
            </div>
            <div class="text-message" style="display: none"></div>
            <script type="text/javascript">
                jQuery(document).ready(function ($){
                    if(!$('#timer-app').length){
                        $('.wpsurl-view-buttons').slideDown();
                    }
                });
            </script>
        </div>
        <?php
    }
}