<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;
use WPSURL\App\Traits\ElementorWidgetMethods;
use WPSURL\App\Utility;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class ShareButtons extends \Elementor\Widget_Base
{
    use ElementorWidgetMethods;

    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        Assets::registerStyle('wpsurl.icons.css', WPSURL_CSS_URL . 'icons.css', null, WPSURL_VERSION);
        Assets::registerStyle('wpsurl.assets.css', WPSURL_CSS_URL . 'assets.css', null, WPSURL_VERSION);
        Assets::registerStyle('wpsurl.ui.css', WPSURL_CSS_URL . 'ui.css', null, WPSURL_VERSION);
    }

    public function get_style_depends()
    {
        return [Assets::getHandleName('wpsurl.icons.css'), Assets::getHandleName('wpsurl.assets.css'), Assets::getHandleName('wpsurl.ui.css')];
    }

    public function get_name()
    {
        return 'wpsurl_share';
    }

    public function get_title()
    {
        return esc_html__('Share', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-share';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['share', 'share_buttons', esc_html__('Share' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'use_custom_items',
            [
                'label' => esc_html__( 'Custom Items', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', WPSURL_TEXT_DOMAIN ),
                'label_off' => esc_html__( 'No', WPSURL_TEXT_DOMAIN ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_text_alignment',
            [
                'label' => esc_html__('Alignment', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .share' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Default title', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
                'default' => [
                    'value' => 'fab fa-twitter',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'important_note',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => esc_html__( "Page Title: %PAGE_TITLE% , Page Url: %PAGE_URL%", WPSURL_TEXT_DOMAIN ),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            ]
        );

        $repeater->start_controls_tabs('style_tabs');

        $repeater->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $repeater->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '#a5a5a5',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'exclude' => ['image'],
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
            ]
        );

        $repeater->add_control(
            'border_color',
            [
                'label' => esc_html__( 'Border Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '#f0f0f0',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', WPSURL_TEXT_DOMAIN ),
            ]
        );

        $repeater->add_control(
            'text_color_hover',
            [
                'label' => esc_html__( 'Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0072ff',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_hover',
                'exclude' => ['image'],
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}:hover',
            ]
        );

        $repeater->add_control(
            'border_color_hover',
            [
                'label' => esc_html__( 'Border Color', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0072ff',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $repeater->end_controls_tab();
        $repeater->end_controls_tabs();

        $this->add_control(
            'icons',
            [
                'label' => esc_html__( 'Icons', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
                'condition' => [
                        'use_custom_items' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();

        $page_title = Utility::getCurrentViewPageTitle();
        $page_link = Utility::getCurrentViewPageUrl();

        $icons = $settings['icons'];
        ?>
        <div class="wpsurl-socials-button wpsurl-socials-button-<?php echo $wid ?>">
            <div class="share">
            <?php if($settings['use_custom_items'] === 'yes'): ?>
                <?php
                if(!empty($icons)):
                    foreach ($icons as $icon):
                    ?>
                    <a <?php $this->render_url_attributes($icon['link'], ['%PAGE_TITLE%' => $page_title, '%PAGE_URL%' => $page_link]) ?> class="custom-share-btn elementor-repeater-item-<?php echo esc_attr($icon['_id']) ?>" title="<?php echo esc_attr($icon['title']) ?>">
                        <?php \Elementor\Icons_Manager::render_icon($icon['icon'], ['aria-hidden' => 'true']); ?>
                    </a>
                <?php
                    endforeach;
                endif;
                ?>
            <?php else: ?>
                <a href="https://twitter.com/share?text=<?php echo esc_attr($page_title) ?>&url=<?php echo esc_attr($page_link) ?>" target="_blank" class="twitter" title="<?php _e( 'Twitter', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-twitter"></i></a>
                <a href="https://wa.me/?text=<?php echo esc_attr($page_link) ?>" target="_blank" class="whatsapp" title="<?php _e( 'Whatsapp', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-whatsapp"></i></a>
                <a href="https://telegram.me/share/url?url=<?php echo esc_attr($page_link) ?>" target="_blank" class="telegram" title="<?php _e( 'Telegram', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-telegram"></i></a>
            <?php endif; ?>
            </div>
        </div>
        <?php
    }
}