<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;
use WPSURL\App\Elementor\ElementorBuilder;
use WPSURL\App\GlobalData;
use WPSURL\App\Links;
use WPSURL\App\Number;
use WPSURL\App\Settings;
use WPSURL\App\Utility;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class Timer extends \Elementor\Widget_Base
{
    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);
        Assets::registerStyle('wpsurl.assets.css', WPSURL_CSS_URL . 'assets.css', null, WPSURL_VERSION);
        Assets::registerStyle('wpsurl.ui.css', WPSURL_CSS_URL . 'ui.css', null, WPSURL_VERSION);

        Assets::registerScript('wpsurl.countdown.js', WPSURL_JS_URL . 'countdown.js', null, WPSURL_VERSION, true);
        wp_localize_script(Assets::getHandleName('wpsurl.countdown.js'), 'wpsurl_data', Assets::getLocalizeData());
    }

    public function get_style_depends()
    {
        return [Assets::getHandleName('wpsurl.assets.css'), Assets::getHandleName('wpsurl.ui.css')];
    }

    public function get_script_depends()
    {
        return [Assets::getHandleName('wpsurl.countdown.js')];
    }

    public function get_name()
    {
        return 'wpsurl_timer';
    }

    public function get_title()
    {
        return esc_html__('Timer', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-countdown';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['timer', esc_html__('Timer' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'timer_seconds',
            [
                'label' => esc_html__('Seconds', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'step' => 1,
                'default' => 5,
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'number_options',
            [
                'label' => esc_html__( 'Number', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => esc_html__('Number Color', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .base-timer__label' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'number_typo',
                'selector' => '{{WRAPPER}} .base-timer__label',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '27'
                        ]
                    ],
                ]
            ]
        );

        $this->add_control(
            'box_options',
            [
                'label' => esc_html__( 'Box', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_width',
            [
                'label' => esc_html__( 'Dimension', WPSURL_TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 30,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 150,
                ],
                'selectors' => [
                    '{{WRAPPER}} .base-timer' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .base-timer__label' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();

        $time = $settings['timer_seconds'];
        ?>
        <div class="wpsurl-timer-element wpsurl-timer-element-<?php echo $wid; ?>">
            <div class="wpsurl-timer-container">
                <div id="timer-app" data-time="<?php echo $time; ?>">
                    <?php if(is_admin()): ?>
                    <div class="base-timer">
                        <svg class="base-timer__svg" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"> <g class="base-timer__circle"> <circle class="base-timer__path-elapsed" cx="50" cy="50" r="45"></circle> <path id="base-timer-path-remaining" stroke-dasharray="170 283" class="base-timer__path-remaining green" d=" M 50, 50 m -45, 0 a 45,45 0 1,0 90,0 a 45,45 0 1,0 -90,0 " ></path> </g> </svg> <span id="base-timer-label" class="base-timer__label"><?php echo Number::numByLang($time); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }
}