<?php
namespace WPSURL\App\User;
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

class User
{
    /**
     *
     * Check is exists user by id
     *
     * @param $user_id
     * @return bool
     */
    public static function isExistsUser($user_id)
    {
        if ($user_id instanceof WP_User) {
            $user_id = $user_id->ID;
        }

        return (bool)get_user_by('id', $user_id);
    }

    /**
     * @param array $capabilities
     * @param int $user_id
     * @return bool
     */
    public static function accessCap(array $capabilities, $user_id = 0)
    {
        if (!is_user_logged_in())
            return false;

        $user_roles = UserData::getData($user_id)->roles;

        if (count(array_intersect($user_roles, $capabilities)) == count($user_roles))
            return true;

        return false;
    }

    /**
     * @param $username
     * @param $password
     * @param false $ssl
     * @return bool
     */
    public static function signon($username, $password, $ssl = false)
    {
        $creds = array(
            'user_login' => $username,
            'user_password' => $password,
            'remember' => true
        );
        $signon = wp_signon($creds, $ssl);

        if (!is_wp_error($signon))
            return true;

        return false;
    }
}