jQuery(document).ready(function ($) {
    var body = $('body');

    body.on("click", ".wpsurl-toggle", function (e) {
        e.preventDefault();
        let $this = $(this);
        let wrapper = $this.data('wpsurl-toggle');
        let wrapClass = $('.' + wrapper);
        wrapClass.slideToggle();
    });

    if ($('.wpsurl-view-nav').length > 0) {
        $('.wpsurl-view-nav ul li a').attr('target', '_blank');
    }

    if($('.wpsurl-iframe-page').length > 0){
        let iframe_event = function () {
            let iframeHeader = $('.iframe-header'),
                iframeContent = $('.iframe-content'),
                iframeEl = iframeContent.find('iframe'),
                newHeight = `calc(100vh - ${iframeHeader.outerHeight()}px)`;
            if(newHeight !== iframeContent.css('height')){
                iframeContent.css('height', newHeight);
                iframeContent.slideDown();
            }
        };
        iframe_event();
        setInterval(iframe_event, 3000);
    }

    body.on('click', '.navbar-burger', function (e) {
        e.preventDefault();
        let btn = $(this),
            target = $('#' + btn.data('target'));
        if(target.length){
            target.slideToggle();
        }
    });

    body.on('click', '.navbar-item.has-dropdown > .navbar-link', function (e) {
        e.preventDefault();
        let btn = $(this);
        btn.parent().children('.navbar-dropdown').slideToggle();
    });

    body.on('click', '.remove-parent', function (e) {
        e.preventDefault();
        let btn = $(this);
        btn.parent().slideUp(function () {
            $(this).remove();
        });
    });

    body.on('click', '.responsive-btns .responsive-btn', function (e) {
        e.preventDefault();
        let btn = $(this),
            device = btn.data('type'),
            screen = $('iframe'),
            windowWidth = $(window).width(),
            windowHeight = $(window).height(),
            width, height;

        if (device === 'mobile') {
            width = windowWidth < 768 ? '100%' : '30%';
            height = windowHeight < 1024 ? '100%' : '80%';
            screen.animate({ 'width': width, 'height': height }, 500);
        } else if (device === 'tablet') {
            width = windowWidth < 1024 ? '90%' : '60%';
            height = windowHeight < 1366 ? '90%' : '80%';
            screen.animate({ 'width': width, 'height': height }, 500);
        } else {
            screen.animate({ 'width': '100%', 'height': '100%' }, 500);
        }
    });

    let textMessageBox = document.querySelector('.text-message');
    textMessageBox.addEventListener('click', function() {
        let textToCopy = textMessageBox.innerText || textMessageBox.textContent;
        navigator.clipboard.writeText(textToCopy)
            .then(function() {
                surlMessager.fire(wpsurl_data.txt_copy_success, 'success');
            })
            .catch(function(err) {
                surlMessager.fire(wpsurl_data.txt_unknown_err, 'error');
            });
    });
});
