<?php
$iframes = \WPSURL\App\Links::getPreviewsItems();
$show_iframes = \WPSURL\App\Settings::getOption('show_other_previews') == true;
$show_responsive_buttons = \WPSURL\App\Settings::getOption('show_responsive_buttons') == true;
$is_verify_password = \WPSURL\App\LinkOptions::isVerifyPassword($extra->unique_id, ($_COOKIE['wpsurl-password-' . $extra->unique_id] ?? ''));
?>
<div class="wpsurl-iframe-page">
    <nav class="iframe-header navbar is-transparent">
        <div class="navbar-brand">
            <a href="<?php echo site_url() ?>" class="navbar-item" target="_blank">
                <img src="<?php echo \WPSURL\App\Settings::getLogoUrl(); ?>" alt="<?php bloginfo('name') ?>">
            </a>
            <?php if($show_iframes): ?>
            <div class="navbar-burger" data-target="navbarLinks">
                <span></span>
                <span></span>
                <span></span>
            </div>
            <?php endif; ?>
        </div>

        <div id="navbarLinks" class="navbar-menu">
            <div class="navbar-<?php echo is_rtl() ? 'end' : 'start' ?>">
                <?php if($show_iframes): ?>
                    <?php if ($iframes): ?>
                    <div class="navbar-item has-dropdown is-hoverable">
                        <a class="navbar-link" href="#">
                            <?php _e('All Previews', WPSURL_TEXT_DOMAIN) ?>
                        </a>
                        <div class="navbar-dropdown is-boxed iframe-items">
                            <?php foreach ($iframes as $iframe): ?>
                            <a class="navbar-item <?php echo $iframe->unique_id == $extra->unique_id ? ' is-active' : '' ?>" href="<?php echo \WPSURL\App\Utility::getHashLink($iframe->unique_id) ?>">
                                <?php echo $iframe->title ?>
                            </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if ($show_responsive_buttons): ?>
                <div class="responsive-btns">
                    <span class="responsive-btn" data-type="mobile">
                        <svg class="svg-icon" viewBox="0 0 20 20"> <path d="M13.372,1.781H6.628c-0.696,0-1.265,0.569-1.265,1.265v13.91c0,0.695,0.569,1.265,1.265,1.265h6.744c0.695,0,1.265-0.569,1.265-1.265V3.045C14.637,2.35,14.067,1.781,13.372,1.781 M13.794,16.955c0,0.228-0.194,0.421-0.422,0.421H6.628c-0.228,0-0.421-0.193-0.421-0.421v-0.843h7.587V16.955z M13.794,15.269H6.207V4.731h7.587V15.269z M13.794,3.888H6.207V3.045c0-0.228,0.194-0.421,0.421-0.421h6.744c0.228,0,0.422,0.194,0.422,0.421V3.888z"></path> </svg>
                    </span>
                        <span class="responsive-btn" data-type="tablet">
                        <svg class="svg-icon" viewBox="0 0 20 20"> <path d="M14.911,1.295H5.09c-0.737,0-1.339,0.603-1.339,1.339v14.733c0,0.736,0.603,1.338,1.339,1.338h9.821c0.737,0,1.339-0.602,1.339-1.338V2.634C16.25,1.898,15.648,1.295,14.911,1.295 M15.357,17.367c0,0.24-0.205,0.445-0.446,0.445H5.09c-0.241,0-0.446-0.205-0.446-0.445v-0.893h10.714V17.367z M15.357,15.58H4.644V4.42h10.714V15.58z M15.357,3.527H4.644V2.634c0-0.241,0.205-0.446,0.446-0.446h9.821c0.241,0,0.446,0.206,0.446,0.446V3.527z"></path> </svg>
                    </span>
                        <span class="responsive-btn" data-type="desktop">
                        <svg class="svg-icon" viewBox="0 0 20 20"> <path d="M17.237,3.056H2.93c-0.694,0-1.263,0.568-1.263,1.263v8.837c0,0.694,0.568,1.263,1.263,1.263h4.629v0.879c-0.015,0.086-0.183,0.306-0.273,0.423c-0.223,0.293-0.455,0.592-0.293,0.92c0.07,0.139,0.226,0.303,0.577,0.303h4.819c0.208,0,0.696,0,0.862-0.379c0.162-0.37-0.124-0.682-0.374-0.955c-0.089-0.097-0.231-0.252-0.268-0.328v-0.862h4.629c0.694,0,1.263-0.568,1.263-1.263V4.319C18.5,3.625,17.932,3.056,17.237,3.056 M8.053,16.102C8.232,15.862,8.4,15.597,8.4,15.309v-0.89h3.366v0.89c0,0.303,0.211,0.562,0.419,0.793H8.053z M17.658,13.156c0,0.228-0.193,0.421-0.421,0.421H2.93c-0.228,0-0.421-0.193-0.421-0.421v-1.263h15.149V13.156z M17.658,11.052H2.509V4.319c0-0.228,0.193-0.421,0.421-0.421h14.308c0.228,0,0.421,0.193,0.421,0.421V11.052z"></path> </svg>
                    </span>
                </div>
                <?php endif; ?>
            </div>

            <div class="navbar-<?php echo is_rtl() ? 'start' : 'end' ?>">
                <div class="navbar-item">
                    <div class="field">
                        <p class="control">
                            <a class="button is-link is-light report-problem-btn" href="#" data-id="<?php echo esc_attr($link_data->unique_id) ?>" data-hystmodal="#link-report-modal">
                                <span><?php _e('Report Problem', WPSURL_TEXT_DOMAIN) ?></span>
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <div class="iframe-content" style="display: none">
        <?php if ($extra->is_locked && !$is_verify_password): ?>
            <form action="" method="post" id="open-link-with-password-form" class="box" autocomplete="off" data-token="<?php echo esc_attr($link_data->unique_id) ?>">
                <article class="message is-danger">
                    <div class="message-body"><?php echo esc_html__('Protected by password.', WPSURL_TEXT_DOMAIN) ?></div>
                </article>
                <div class="field">
                    <label class="label"><?php echo esc_html__('Password', WPSURL_TEXT_DOMAIN) ?></label>
                    <div class="control">
                        <input class="input" type="password" id="password" name="password" autocomplete="off">
                    </div>
                </div>
                <div class="field captcha-wrap">
                    <p class="control has-icons-left">
                        <input class="input" type="text" name="security_code" placeholder="<?php _e( 'Security Code', WPSURL_TEXT_DOMAIN ) ?>">
                        <span class="icon is-small is-left">
                            <em class="captcha-code reload-captcha" id="password-form-captcha"></em>
                        </span>
                    </p>
                </div>
                <button class="button is-link"><?php echo esc_html__('Confirm', WPSURL_TEXT_DOMAIN) ?></button>
            </form>
        <?php else: ?>
            <iframe src="<?php echo esc_attr($link_data->link) ?>" data-id="<?php echo esc_attr($link_data->unique_id) ?>"></iframe>
        <?php endif; ?>
    </div>
</div>