<?php
/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
use WPSURL\App\{Utility, Links, Options};

if (!empty($query_var_value)) {
    if (Utility::isExistsQueryVarValue()) {
        do_action('wpsurl_action_apply_statistics', $query_var_value, 'view');
        $file = WPSURL_VIEW_PAGES . 'index.view.php';

        if ( file_exists( $file ) ) {
            if ( Utility::issetQueryVars( Utility::getPagesSlug() ) || Utility::issetQueryVars( Utility::getPagesSlug( 2 ) ) ) {
                $link   = $link_data->link;
                $status = $link_data->status;
                $logged = (bool) Options::isViewOnlyLoggedUser();

                if ($logged && !is_user_logged_in()) {
                    wp_redirect( site_url(), 301 );
                    exit;
                }
                if ( $link && $status == 'active' ) {
                    if ( Options::hasDirectTransfer() ) {
                        wp_redirect( $link );
                        exit();
                    } else {
                        if (Utility::isValidQueryVarToken($query_var_value)) {
                            wp_redirect( site_url() );
                            exit();
                        }
                        require_once $file;
                    }
                } else {
                    wp_redirect( site_url() );
                }
            }
        }
    } else {
        wp_redirect( site_url() );
    }
} else {
    wp_redirect( site_url() );
}
