/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-11-23 19:16:45 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3544 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=6462 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=10635 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_pro_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_pro_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_gla_attribute_mapping_rules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `attribute` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_condition_type` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `categories` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_gla_budget_recommendations` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `daily_budget_low` int NOT NULL,
  `daily_budget_high` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_currency` (`country`,`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=4231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_gla_merchant_issues` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `product_id` bigint NOT NULL,
  `issue` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'warning',
  `product` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_url` varchar(1024) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `applicable_countries` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'mc',
  `type` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'product',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_gla_shipping_rates` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate` double NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `country` (`country`),
  KEY `currency` (`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_gla_shipping_times` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_automation_run_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int unsigned NOT NULL,
  `step_id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `completed_at` timestamp NULL DEFAULT NULL,
  `error` longtext COLLATE utf8mb4_unicode_520_ci,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_automation_run_subjects` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `args` longtext COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_automation_runs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int unsigned NOT NULL,
  `version_id` int unsigned NOT NULL,
  `trigger_key` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `next_step_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_automation_triggers` (
  `automation_id` int unsigned NOT NULL,
  `trigger_key` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`automation_id`,`trigger_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_automation_versions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int unsigned NOT NULL,
  `steps` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_automations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `author` bigint NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `activated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_dynamic_segment_filters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `filter_data` longblob,
  `filter_type` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_feature_flags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `settings` longtext COLLATE utf8mb4_unicode_520_ci,
  `styles` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `level` int DEFAULT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `raw_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `completed_at` timestamp NULL DEFAULT NULL,
  `retries` int unsigned NOT NULL DEFAULT '0',
  `error` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_newsletter_links` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `url` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_newsletter_option` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `option_field_id` int unsigned NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_newsletter_option_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `newsletter_type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_newsletter_posts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `post_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_newsletter_segment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `segment_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_newsletter_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int DEFAULT '0',
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `categories` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '[]',
  `description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `thumbnail` longtext COLLATE utf8mb4_unicode_520_ci,
  `thumbnail_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `readonly` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_newsletters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `parent_id` int unsigned DEFAULT NULL,
  `subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sender_name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `preheader` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ga_campaign` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_scheduled_task_subscribers` (
  `task_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `processed` int NOT NULL,
  `failed` smallint NOT NULL DEFAULT '0',
  `error` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_scheduled_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` mediumint NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int DEFAULT NULL,
  `reschedule_count` int NOT NULL DEFAULT '0',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_segments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'default',
  `description` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `display_in_manage_subscription_page` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_sending_queues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `newsletter_id` int unsigned DEFAULT NULL,
  `newsletter_rendered_body` longtext COLLATE utf8mb4_unicode_520_ci,
  `newsletter_rendered_subject` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `subscribers` longtext COLLATE utf8mb4_unicode_520_ci,
  `count_total` int unsigned NOT NULL DEFAULT '0',
  `count_processed` int unsigned NOT NULL DEFAULT '0',
  `count_to_process` int unsigned NOT NULL DEFAULT '0',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_statistics_bounces` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_statistics_clicks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `link_id` int unsigned NOT NULL,
  `user_agent_id` int unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT '0',
  `count` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_statistics_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_statistics_newsletters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `sent_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_statistics_opens` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `user_agent_id` int unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_statistics_unsubscribes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned DEFAULT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `source` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT 'unknown',
  `meta` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `method` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_statistics_woocommerce_purchases` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `click_id` int unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `order_currency` char(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_stats_notifications` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_subscriber_custom_field` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int unsigned NOT NULL,
  `custom_field_id` int unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_subscriber_ips` (
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_subscriber_segment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int unsigned NOT NULL,
  `segment_id` int unsigned NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_subscriber_tag` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int unsigned NOT NULL,
  `tag_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_tag` (`subscriber_id`,`tag_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_subscribers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint DEFAULT NULL,
  `is_woocommerce_user` int NOT NULL DEFAULT '0',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `email` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `confirmed_ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') COLLATE utf8mb4_unicode_520_ci DEFAULT 'unknown',
  `count_confirmations` int unsigned NOT NULL DEFAULT '0',
  `unsubscribe_token` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `link_token` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  `woocommerce_synced_at` timestamp NULL DEFAULT NULL,
  `email_count` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `link_token` (`link_token`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_user_agents` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_mailpoet_user_flags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=41970 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4080 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=551 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_quform_entries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int unsigned NOT NULL,
  `unread` tinyint unsigned NOT NULL DEFAULT '1',
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referring_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'normal',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_quform_entry_data` (
  `entry_id` int unsigned NOT NULL,
  `element_id` int unsigned NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`entry_id`,`element_id`),
  KEY `element_id` (`element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_quform_entry_entry_labels` (
  `entry_id` int unsigned NOT NULL,
  `entry_label_id` int unsigned NOT NULL,
  PRIMARY KEY (`entry_id`,`entry_label_id`),
  KEY `entry_label_id` (`entry_label_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_quform_entry_labels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int unsigned NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `color` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_quform_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `config` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `trashed` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `active` (`active`),
  KEY `trashed` (`trashed`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_quform_sessions` (
  `id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_activity` int unsigned NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_ulike` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `post_id` bigint NOT NULL,
  `date_time` datetime NOT NULL,
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `date_time` (`date_time`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_ulike_activities` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `activity_id` bigint NOT NULL,
  `date_time` datetime NOT NULL,
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_id` (`activity_id`),
  KEY `date_time` (`date_time`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_ulike_comments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `comment_id` bigint NOT NULL,
  `date_time` datetime NOT NULL,
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `comment_id` (`comment_id`),
  KEY `date_time` (`date_time`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_ulike_forums` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `topic_id` bigint NOT NULL,
  `date_time` datetime NOT NULL,
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic_id` (`topic_id`),
  KEY `date_time` (`date_time`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_ulike_meta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_group` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `item_id` (`item_id`),
  KEY `meta_group` (`meta_group`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rocket_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpr_rucss_used_css` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `css` longtext COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `error_code` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `unprocessedcss` longtext COLLATE utf8mb4_unicode_520_ci,
  `retries` tinyint(1) NOT NULL DEFAULT '1',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `job_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `queue_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpsurl_links` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `modified_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpsurl_links_options` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int NOT NULL,
  `link_key` text COLLATE utf8mb4_unicode_520_ci,
  `link_option` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpsurl_links_reports` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wpsurl_links_statistics` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int NOT NULL,
  `link_key` text COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `visit` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `click` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_visit` datetime DEFAULT CURRENT_TIMESTAMP,
  `last_visit` datetime DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","alirezadehkar","$P$B/YJDCJerKj5ZxYRrXsF.bVMXYkfu.0","alirezadehkar","alirezadehkar@gmail.com","https://bavance.com","2023-03-13 18:45:27","","0","Bavance");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","Bavance"),
("2","1","first_name","Bavance"),
("3","1","last_name","Dehkar"),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers","wc_services_new_carrier_dhl_express,theme_editor_notice"),
("15","1","show_welcome_panel","0"),
("17","1","wp_dashboard_quick_press_last_post_id","550"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"49.13.146.0\";}"),
("19","1","_woocommerce_tracks_anon_id","woo:Sj0hug2lw0SGi/zjQiD5m792"),
("21","1","wc_last_active","1700697600"),
("22","1","meta-box-order_product","a:3:{s:4:\"side\";s:84:\"submitdiv,postimagediv,woocommerce-product-images,product_catdiv,tagsdiv-product_tag\";s:6:\"normal\";s:55:\"woocommerce-product-data,postcustom,slugdiv,postexcerpt\";s:8:\"advanced\";s:0:\"\";}"),
("23","1","wp_user-settings","libraryContent=browse&editor=tinymce&hidetb=1"),
("24","1","wp_user-settings-time","1679674212"),
("25","1","jetpack_tracks_wpcom_id","137062797"),
("27","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("28","1","dismissed_maxmind_license_key_notice","1"),
("30","1","rocket_boxes","a:1:{i:0;s:34:\"rocket_warning_plugin_modification\";}"),
("31","1","managenav-menuscolumnshidden","a:4:{i:0;s:11:\"link-target\";i:1;s:15:\"title-attribute\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}"),
("32","1","metaboxhidden_nav-menus","a:6:{i:0;s:28:\"add-post-type-e-landing-page\";i:1;s:21:\"add-post-type-product\";i:2;s:12:\"add-post_tag\";i:3;s:15:\"add-post_format\";i:4;s:15:\"add-product_cat\";i:5;s:15:\"add-product_tag\";}"),
("33","1","dismissed_update_notice","1"),
("34","1","last_update","1682898289"),
("35","1","wp_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:3:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;s:10:\"openPanels\";a:3:{i:0;s:11:\"post-status\";i:1;s:14:\"featured-image\";i:2;s:12:\"post-excerpt\";}}s:9:\"_modified\";s:24:\"2023-03-24T19:36:50.913Z\";}"),
("36","1","nav_menu_recently_edited","20"),
("37","1","quform_recent_forms","a:2:{i:0;i:2;i:1;i:1;}"),
("38","1","billing_first_name","Alireza"),
("39","1","billing_last_name","Dehkar"),
("40","1","billing_address_1","Essex Cottage"),
("41","1","billing_address_2","West Terrace"),
("42","1","billing_city","Ullapool"),
("43","1","billing_state","Highland"),
("44","1","billing_postcode","IV26 2UU"),
("45","1","billing_country","GB"),
("46","1","billing_email","alirezadehkar@gmail.com"),
("47","1","billing_phone","07975246985"),
("48","1","shipping_method",""),
("49","1","billing_company",""),
("50","1","shipping_first_name",""),
("51","1","shipping_last_name",""),
("52","1","shipping_company",""),
("53","1","shipping_address_1",""),
("54","1","shipping_address_2",""),
("55","1","shipping_city",""),
("56","1","shipping_postcode",""),
("57","1","shipping_country",""),
("58","1","shipping_state",""),
("59","1","shipping_phone",""),
("61","1","wp_user_avatar","396"),
("65","1","announcements_user_counter","1"),
("70","1","thwcfd_review_skipped","1"),
("71","1","thwcfd_review_skipped_time","1700766358"),
("72","1","elementor_introduction","a:4:{s:27:\"ai-get-started-announcement\";b:1;s:14:\"ai_get_started\";b:1;s:20:\"globals_introduction\";b:1;s:6:\"e-apps\";b:1;}"),
("73","1","wp_elementor_connect_common_data","a:7:{s:9:\"client_id\";s:32:\"QjjaJNX4AQ4DnLavFQDdkIvxTwompFiq\";s:11:\"auth_secret\";s:32:\"mICVsGm2SlKdz52TMPB3AOCodT080Cnl\";s:12:\"access_token\";s:284:\"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOjMwNjY0NDksImF1ZCI6Imh0dHBzOi8vYmF2YW5jZS5jb20vIiwiY2xpZW50X2lkIjoiUWpqYUpOWDRBUTREbkxhdkZRRGRrSXZ4VHdvbXBGaXEiLCJjb25uZWN0X3R5cGUiOiJsaWJyYXJ5IiwiaWF0IjoxNjg0MjYwOTEzLCJleHAiOjMxNzIyODcwMzMxM30.Oxb-hKcHA3vTJXJIKtPxVXNVuJMfI_KIeWhEsdIshDI\";s:19:\"access_token_secret\";s:32:\"fMdI6klz0x7iqF97SscSWFepXcO07Aes\";s:10:\"token_type\";s:6:\"bearer\";s:4:\"user\";O:8:\"stdClass\":1:{s:5:\"email\";s:18:\"mrdehkar@gmail.com\";}s:19:\"data_share_opted_in\";b:1;}"),
("76","1","duplicator_pro_created_format","1"),
("84","1","session_tokens","a:1:{s:64:\"569dbbd1e5e94256557bdbd19a19381fc8f8ebc5dd3acaa07049ca1a40b74a6f\";a:4:{s:10:\"expiration\";i:1700939126;s:2:\"ip\";s:13:\"49.13.146.196\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\";s:5:\"login\";i:1700766326;}}"),
("88","1","elementor_admin_notices","a:1:{s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:6:\"3.17.3\";}}}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("148","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-15 19:34:20","2023-03-15 19:34:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678908860;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678908860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-17 21:13:30","2023-03-17 21:13:30","0",NULL,"10"),
("155","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-15 00:29:57","2023-03-15 00:29:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678840197;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678840197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-15 00:53:27","2023-03-15 00:53:27","0",NULL,"10"),
("168","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-15 01:53:27","2023-03-15 01:53:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678845207;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678845207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-15 07:36:28","2023-03-15 07:36:28","0",NULL,"10"),
("170","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-15 08:36:28","2023-03-15 08:36:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678869388;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678869388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-15 08:37:04","2023-03-15 08:37:04","0",NULL,"10"),
("171","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-15 09:37:04","2023-03-15 09:37:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678873024;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678873024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-15 11:56:03","2023-03-15 11:56:03","0",NULL,"10"),
("172","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-15 12:56:03","2023-03-15 12:56:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678884963;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678884963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-15 12:56:37","2023-03-15 12:56:37","0",NULL,"10"),
("173","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-15 13:56:37","2023-03-15 13:56:37","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678888597;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678888597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-15 18:24:04","2023-03-15 18:24:04","0",NULL,"10"),
("174","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-15 19:24:04","2023-03-15 19:24:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678908244;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678908244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-17 21:13:30","2023-03-17 21:13:30","0",NULL,"10"),
("175","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-17 22:13:30","2023-03-17 22:13:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679091210;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679091210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-18 06:53:14","2023-03-18 06:53:14","0",NULL,"10"),
("178","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-18 21:13:30","2023-03-18 21:13:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679174010;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679174010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-19 20:04:48","2023-03-19 20:04:48","0",NULL,"10"),
("179","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-18 07:53:14","2023-03-18 07:53:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679125994;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679125994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-18 15:23:58","2023-03-18 15:23:58","0",NULL,"10"),
("180","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-18 16:23:58","2023-03-18 16:23:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679156638;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679156638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-19 20:04:48","2023-03-19 20:04:48","0",NULL,"10"),
("181","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-19 21:04:48","2023-03-19 21:04:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679259888;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679259888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-20 02:37:50","2023-03-20 02:37:50","0",NULL,"10"),
("184","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-20 20:04:48","2023-03-20 20:04:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679342688;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679342688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-21 07:52:51","2023-03-21 07:52:51","0",NULL,"10"),
("185","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-20 03:37:50","2023-03-20 03:37:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679283470;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679283470;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-21 07:52:51","2023-03-21 07:52:51","0",NULL,"10"),
("186","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-21 08:52:51","2023-03-21 08:52:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679388771;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679388771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-21 12:26:33","2023-03-21 12:26:33","0",NULL,"10"),
("189","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-22 07:52:51","2023-03-22 07:52:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679471571;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679471571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-23 21:58:42","2023-03-23 21:58:42","0",NULL,"10"),
("190","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-21 13:26:33","2023-03-21 13:26:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679405193;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679405193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-22 04:29:54","2023-03-22 04:29:54","0",NULL,"10"),
("191","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-22 05:29:54","2023-03-22 05:29:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679462994;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679462994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-22 06:31:51","2023-03-22 06:31:51","0",NULL,"10"),
("192","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-22 07:31:51","2023-03-22 07:31:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679470311;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679470311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-23 21:58:42","2023-03-23 21:58:42","0",NULL,"10"),
("193","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-23 22:58:42","2023-03-23 22:58:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679612322;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679612322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 05:42:10","2023-03-24 05:42:10","0",NULL,"10"),
("196","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-24 21:58:42","2023-03-24 21:58:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679695122;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679695122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-24 22:00:17","2023-03-24 22:00:17","0",NULL,"10"),
("207","woocommerce_run_on_woocommerce_admin_updated","failed","2023-03-23 22:37:38","2023-03-23 22:37:38","[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1679611058;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1679611058;}","7","1","2023-03-23 22:37:58","2023-03-23 22:37:58","0",NULL,"10"),
("216","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 06:42:10","2023-03-24 06:42:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679640130;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679640130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 07:23:08","2023-03-24 07:23:08","0",NULL,"10"),
("219","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 08:23:08","2023-03-24 08:23:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679646188;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679646188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 08:23:57","2023-03-24 08:23:57","0",NULL,"10"),
("256","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 09:23:57","2023-03-24 09:23:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679649837;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679649837;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 09:24:22","2023-03-24 09:24:22","0",NULL,"10"),
("290","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 10:24:22","2023-03-24 10:24:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679653462;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679653462;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 11:19:08","2023-03-24 11:19:08","0",NULL,"10"),
("308","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 12:19:08","2023-03-24 12:19:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679660348;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679660348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 12:19:29","2023-03-24 12:19:29","0",NULL,"10"),
("343","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 13:19:29","2023-03-24 13:19:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679663969;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679663969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 13:21:02","2023-03-24 13:21:02","0",NULL,"10"),
("374","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 14:21:02","2023-03-24 14:21:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679667662;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679667662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 14:21:28","2023-03-24 14:21:28","0",NULL,"10"),
("409","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 15:21:28","2023-03-24 15:21:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679671288;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679671288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 15:21:34","2023-03-24 15:21:34","0",NULL,"10"),
("445","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 16:21:34","2023-03-24 16:21:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679674894;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679674894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 16:22:26","2023-03-24 16:22:26","0",NULL,"10"),
("492","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 17:22:26","2023-03-24 17:22:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679678546;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679678546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 17:22:34","2023-03-24 17:22:34","0",NULL,"10"),
("535","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 18:22:34","2023-03-24 18:22:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679682154;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679682154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 18:58:05","2023-03-24 18:58:05","0",NULL,"10"),
("549","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 19:58:05","2023-03-24 19:58:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679687885;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679687885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 19:58:51","2023-03-24 19:58:51","0",NULL,"10"),
("592","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 20:58:51","2023-03-24 20:58:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679691531;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679691531;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 20:59:47","2023-03-24 20:59:47","0",NULL,"10"),
("629","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 21:59:47","2023-03-24 21:59:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679695187;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679695187;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 22:00:17","2023-03-24 22:00:17","0",NULL,"10"),
("661","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-25 22:00:17","2023-03-25 22:00:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679781617;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679781617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-25 23:27:03","2023-03-25 23:27:03","0",NULL,"10"),
("663","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-24 23:00:17","2023-03-24 23:00:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679698817;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679698817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-24 23:00:29","2023-03-24 23:00:29","0",NULL,"10"),
("694","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 00:00:29","2023-03-25 00:00:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679702429;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679702429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 00:01:46","2023-03-25 00:01:46","0",NULL,"10"),
("735","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 01:01:46","2023-03-25 01:01:46","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679706106;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679706106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 01:02:22","2023-03-25 01:02:22","0",NULL,"10"),
("783","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 02:02:22","2023-03-25 02:02:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679709742;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679709742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 06:14:00","2023-03-25 06:14:00","0",NULL,"10"),
("810","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 07:14:00","2023-03-25 07:14:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679728440;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679728440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 07:14:25","2023-03-25 07:14:25","0",NULL,"10"),
("812","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 08:14:25","2023-03-25 08:14:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679732065;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679732065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 09:14:54","2023-03-25 09:14:54","0",NULL,"10"),
("814","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 10:14:54","2023-03-25 10:14:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679739294;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679739294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 10:19:32","2023-03-25 10:19:32","0",NULL,"10"),
("828","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 11:19:32","2023-03-25 11:19:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679743172;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679743172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 14:23:34","2023-03-25 14:23:34","0",NULL,"10"),
("830","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 15:23:34","2023-03-25 15:23:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679757814;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679757814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 17:17:15","2023-03-25 17:17:15","0",NULL,"10"),
("844","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 18:17:15","2023-03-25 18:17:15","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679768235;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679768235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 18:29:35","2023-03-25 18:29:35","0",NULL,"10"),
("864","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-25 19:29:35","2023-03-25 19:29:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679772575;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679772575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-25 23:27:03","2023-03-25 23:27:03","0",NULL,"10"),
("867","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-26 00:27:03","2023-03-26 00:27:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679790423;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679790423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-26 18:56:38","2023-03-26 18:56:38","0",NULL,"10"),
("870","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-26 23:27:03","2023-03-26 23:27:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679873223;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679873223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-27 02:37:23","2023-03-27 02:37:23","0",NULL,"10"),
("872","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-26 19:56:38","2023-03-26 19:56:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679860598;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679860598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 02:37:23","2023-03-27 02:37:23","0",NULL,"10"),
("875","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 03:37:23","2023-03-27 03:37:23","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679888243;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679888243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 04:57:30","2023-03-27 04:57:30","0",NULL,"10"),
("878","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-28 02:37:23","2023-03-28 02:37:23","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679971043;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679971043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-28 04:57:47","2023-03-28 04:57:47","0",NULL,"10"),
("880","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 05:57:30","2023-03-27 05:57:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679896650;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679896650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 07:50:00","2023-03-27 07:50:00","0",NULL,"10"),
("882","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 08:50:00","2023-03-27 08:50:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679907000;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679907000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 10:33:09","2023-03-27 10:33:09","0",NULL,"10"),
("885","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 11:33:09","2023-03-27 11:33:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679916789;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679916789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 11:39:03","2023-03-27 11:39:03","0",NULL,"10"),
("887","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 12:39:03","2023-03-27 12:39:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679920743;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679920743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 12:50:10","2023-03-27 12:50:10","0",NULL,"10"),
("890","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 13:50:10","2023-03-27 13:50:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679925010;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679925010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 14:03:18","2023-03-27 14:03:18","0",NULL,"10"),
("892","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 15:03:18","2023-03-27 15:03:18","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679929398;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679929398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-27 18:58:24","2023-03-27 18:58:24","0",NULL,"10"),
("894","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-27 19:58:24","2023-03-27 19:58:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679947104;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679947104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-28 01:12:22","2023-03-28 01:12:22","0",NULL,"10"),
("897","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-28 02:12:22","2023-03-28 02:12:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679969542;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679969542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-28 02:16:12","2023-03-28 02:16:12","0",NULL,"10"),
("899","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-28 03:16:12","2023-03-28 03:16:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679973372;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679973372;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-28 04:57:47","2023-03-28 04:57:47","0",NULL,"10"),
("906","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-29 04:57:47","2023-03-29 04:57:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680065867;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680065867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-29 05:20:53","2023-03-29 05:20:53","0",NULL,"10"),
("907","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-28 05:57:47","2023-03-28 05:57:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679983067;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679983067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-28 09:31:28","2023-03-28 09:31:28","0",NULL,"10"),
("909","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-28 10:31:28","2023-03-28 10:31:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679999488;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679999488;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-28 18:14:32","2023-03-28 18:14:32","0",NULL,"10"),
("911","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-28 19:14:32","2023-03-28 19:14:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680030872;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680030872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-28 20:34:47","2023-03-28 20:34:47","0",NULL,"10"),
("913","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-28 21:34:47","2023-03-28 21:34:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680039287;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680039287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-28 23:44:04","2023-03-28 23:44:04","0",NULL,"10"),
("915","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-29 00:44:04","2023-03-29 00:44:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680050644;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680050644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-29 03:04:33","2023-03-29 03:04:33","0",NULL,"10"),
("918","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-29 04:04:33","2023-03-29 04:04:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680062673;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680062673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-29 05:20:53","2023-03-29 05:20:53","0",NULL,"10"),
("920","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-29 06:20:53","2023-03-29 06:20:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680070853;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680070853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-29 08:55:02","2023-03-29 08:55:02","0",NULL,"10"),
("923","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-30 05:20:53","2023-03-30 05:20:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680153653;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680153653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-30 07:09:24","2023-03-30 07:09:24","0",NULL,"10"),
("925","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-29 09:55:02","2023-03-29 09:55:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680083702;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680083702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-29 09:58:23","2023-03-29 09:58:23","0",NULL,"10"),
("928","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-29 10:58:23","2023-03-29 10:58:23","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680087503;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680087503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-29 16:38:55","2023-03-29 16:38:55","0",NULL,"10"),
("937","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-29 17:38:55","2023-03-29 17:38:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680111535;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680111535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-29 18:13:15","2023-03-29 18:13:15","0",NULL,"10"),
("939","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-29 19:13:15","2023-03-29 19:13:15","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680117195;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680117195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 07:09:24","2023-03-30 07:09:24","0",NULL,"10"),
("942","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 08:09:24","2023-03-30 08:09:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680163764;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680163764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 13:41:32","2023-03-30 13:41:32","0",NULL,"10"),
("945","pinterest_for_woocommerce_daily_heartbeat","failed","2023-03-31 07:09:24","2023-03-31 07:09:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680246564;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680246564;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-03-31 07:10:25","2023-03-31 07:10:25","0",NULL,"10"),
("949","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 14:41:32","2023-03-30 14:41:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680187292;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680187292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 15:29:10","2023-03-30 15:29:10","0",NULL,"10"),
("951","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 16:29:10","2023-03-30 16:29:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680193750;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680193750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 16:31:53","2023-03-30 16:31:53","0",NULL,"10"),
("967","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 17:31:53","2023-03-30 17:31:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680197513;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680197513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 17:32:08","2023-03-30 17:32:08","0",NULL,"10"),
("978","woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications","failed","2023-03-30 17:06:18","2023-03-30 17:06:18","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","0","1","2023-03-30 17:06:30","2023-03-30 17:06:30","0",NULL,"10"),
("996","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 18:32:08","2023-03-30 18:32:08","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680201128;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680201128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 18:32:38","2023-03-30 18:32:38","0",NULL,"10"),
("1027","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 19:32:38","2023-03-30 19:32:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680204758;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680204758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 20:32:02","2023-03-30 20:32:02","0",NULL,"10"),
("1047","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 21:32:02","2023-03-30 21:32:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680211922;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680211922;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-30 21:36:09","2023-03-30 21:36:09","0",NULL,"10"),
("1051","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-30 22:36:09","2023-03-30 22:36:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680215769;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680215769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-31 01:06:20","2023-03-31 01:06:20","0",NULL,"10"),
("1053","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-31 02:06:20","2023-03-31 02:06:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680228380;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680228380;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-31 07:08:18","2023-03-31 07:08:18","0",NULL,"10"),
("1078","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-31 08:08:18","2023-03-31 08:08:18","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680250098;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680250098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-31 08:10:55","2023-03-31 08:10:55","0",NULL,"10"),
("1082","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-01 07:10:25","2023-04-01 07:10:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680333025;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680333025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-02 05:17:36","2023-04-02 05:17:36","0",NULL,"10"),
("1112","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-31 09:10:55","2023-03-31 09:10:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680253855;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680253855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-31 10:33:22","2023-03-31 10:33:22","0",NULL,"10"),
("1143","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-31 11:33:22","2023-03-31 11:33:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680262402;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680262402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-03-31 18:13:40","2023-03-31 18:13:40","0",NULL,"10"),
("1145","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-03-31 19:13:40","2023-03-31 19:13:40","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680290020;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680290020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-01 01:47:02","2023-04-01 01:47:02","0",NULL,"10"),
("1147","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-01 02:47:02","2023-04-01 02:47:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680317222;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680317222;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-01 04:45:21","2023-04-01 04:45:21","0",NULL,"10"),
("1149","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-01 05:45:21","2023-04-01 05:45:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680327921;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680327921;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-02 05:17:36","2023-04-02 05:17:36","0",NULL,"10"),
("1152","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-02 06:17:36","2023-04-02 06:17:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680416256;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680416256;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-02 09:10:46","2023-04-02 09:10:46","0",NULL,"10"),
("1155","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-03 05:17:36","2023-04-03 05:17:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680499056;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680499056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-03 06:06:44","2023-04-03 06:06:44","0",NULL,"10"),
("1157","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-02 10:10:46","2023-04-02 10:10:46","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680430246;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680430246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-02 22:39:26","2023-04-02 22:39:26","0",NULL,"10"),
("1159","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-02 23:39:26","2023-04-02 23:39:26","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680478766;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680478766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-03 02:51:39","2023-04-03 02:51:39","0",NULL,"10"),
("1174","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-03 03:51:39","2023-04-03 03:51:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680493899;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680493899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-03 06:06:44","2023-04-03 06:06:44","0",NULL,"10"),
("1177","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-03 07:06:44","2023-04-03 07:06:44","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680505604;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680505604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-03 08:02:32","2023-04-03 08:02:32","0",NULL,"10"),
("1180","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-04 06:06:44","2023-04-04 06:06:44","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680588404;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680588404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-04 09:34:27","2023-04-04 09:34:27","0",NULL,"10"),
("1182","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-03 09:02:32","2023-04-03 09:02:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680512552;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680512552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-03 10:46:20","2023-04-03 10:46:20","0",NULL,"10"),
("1184","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-03 11:46:20","2023-04-03 11:46:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680522380;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680522380;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-03 17:31:02","2023-04-03 17:31:02","0",NULL,"10"),
("1186","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-03 18:31:02","2023-04-03 18:31:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680546662;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680546662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-03 21:40:01","2023-04-03 21:40:01","0",NULL,"10"),
("1188","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-03 22:40:01","2023-04-03 22:40:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680561601;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680561601;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-04 02:11:10","2023-04-04 02:11:10","0",NULL,"10"),
("1190","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-04 03:11:10","2023-04-04 03:11:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680577870;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680577870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-04 04:35:48","2023-04-04 04:35:48","0",NULL,"10"),
("1192","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-04 05:35:48","2023-04-04 05:35:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680586548;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680586548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-04 09:34:27","2023-04-04 09:34:27","0",NULL,"10"),
("1194","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-04 10:34:27","2023-04-04 10:34:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680604467;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680604467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-04 11:04:19","2023-04-04 11:04:19","0",NULL,"10"),
("1197","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-05 09:34:27","2023-04-05 09:34:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680687267;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680687267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-05 15:37:33","2023-04-05 15:37:33","0",NULL,"10"),
("1199","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-04 12:04:19","2023-04-04 12:04:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680609859;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680609859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-04 12:20:00","2023-04-04 12:20:00","0",NULL,"10"),
("1201","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-04 13:20:00","2023-04-04 13:20:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680614400;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680614400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-04 16:07:33","2023-04-04 16:07:33","0",NULL,"10"),
("1203","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-04 17:07:33","2023-04-04 17:07:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680628053;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680628053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-05 15:37:33","2023-04-05 15:37:33","0",NULL,"10"),
("1205","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-05 16:37:33","2023-04-05 16:37:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680712653;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680712653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-06 04:17:01","2023-04-06 04:17:01","0",NULL,"10"),
("1208","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-06 15:37:33","2023-04-06 15:37:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680795453;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680795453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-06 22:53:09","2023-04-06 22:53:09","0",NULL,"10"),
("1210","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-06 05:17:01","2023-04-06 05:17:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680758221;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680758221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-06 10:11:35","2023-04-06 10:11:35","0",NULL,"10"),
("1212","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-06 11:11:35","2023-04-06 11:11:35","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680779495;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680779495;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-06 12:28:20","2023-04-06 12:28:20","0",NULL,"10"),
("1214","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-06 13:28:20","2023-04-06 13:28:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680787700;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680787700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-06 22:53:09","2023-04-06 22:53:09","0",NULL,"10"),
("1216","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-06 23:53:09","2023-04-06 23:53:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680825189;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680825189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-07 01:50:07","2023-04-07 01:50:07","0",NULL,"10"),
("1219","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-07 22:53:09","2023-04-07 22:53:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680907989;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680907989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-08 05:19:50","2023-04-08 05:19:50","0",NULL,"10"),
("1221","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-07 02:50:07","2023-04-07 02:50:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680835807;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680835807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-07 05:09:37","2023-04-07 05:09:37","0",NULL,"10"),
("1223","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-07 06:09:37","2023-04-07 06:09:37","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680847777;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680847777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-07 06:40:52","2023-04-07 06:40:52","0",NULL,"10"),
("1225","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-07 07:40:52","2023-04-07 07:40:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680853252;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680853252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-07 10:50:23","2023-04-07 10:50:23","0",NULL,"10"),
("1228","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-07 11:50:23","2023-04-07 11:50:23","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680868223;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680868223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-07 12:19:50","2023-04-07 12:19:50","0",NULL,"10"),
("1231","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-07 13:19:50","2023-04-07 13:19:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680873590;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680873590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-07 20:32:50","2023-04-07 20:32:50","0",NULL,"10"),
("1233","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-07 21:32:50","2023-04-07 21:32:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680903170;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680903170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-08 05:19:50","2023-04-08 05:19:50","0",NULL,"10"),
("1235","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-08 06:19:50","2023-04-08 06:19:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680934790;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680934790;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-08 08:54:44","2023-04-08 08:54:44","0",NULL,"10"),
("1238","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-09 05:19:50","2023-04-09 05:19:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681017590;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681017590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-09 06:58:58","2023-04-09 06:58:58","0",NULL,"10"),
("1242","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-08 09:54:44","2023-04-08 09:54:44","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680947684;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680947684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-08 11:26:17","2023-04-08 11:26:17","0",NULL,"10"),
("1244","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-08 12:26:17","2023-04-08 12:26:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680956777;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680956777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-08 15:36:38","2023-04-08 15:36:38","0",NULL,"10"),
("1246","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-08 16:36:38","2023-04-08 16:36:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1680971798;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1680971798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-09 06:58:58","2023-04-09 06:58:58","0",NULL,"10"),
("1248","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-09 07:58:58","2023-04-09 07:58:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681027138;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681027138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-09 11:09:28","2023-04-09 11:09:28","0",NULL,"10"),
("1251","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-10 06:58:58","2023-04-10 06:58:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681109938;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681109938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-10 08:21:31","2023-04-10 08:21:31","0",NULL,"10"),
("1253","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-09 12:09:28","2023-04-09 12:09:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681042168;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681042168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-09 16:08:24","2023-04-09 16:08:24","0",NULL,"10"),
("1255","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-09 17:08:24","2023-04-09 17:08:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681060104;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681060104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-10 02:52:13","2023-04-10 02:52:13","0",NULL,"10"),
("1257","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-10 03:52:13","2023-04-10 03:52:13","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681098733;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681098733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-10 08:21:31","2023-04-10 08:21:31","0",NULL,"10"),
("1259","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-10 09:21:31","2023-04-10 09:21:31","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681118491;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681118491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-10 19:25:20","2023-04-10 19:25:20","0",NULL,"10"),
("1262","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-11 08:21:31","2023-04-11 08:21:31","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681201291;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681201291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-11 13:10:47","2023-04-11 13:10:47","0",NULL,"10"),
("1264","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-10 20:25:20","2023-04-10 20:25:20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681158320;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681158320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-10 20:55:38","2023-04-10 20:55:38","0",NULL,"10"),
("1266","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-10 21:55:38","2023-04-10 21:55:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681163738;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681163738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-11 00:31:11","2023-04-11 00:31:11","0",NULL,"10"),
("1268","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-11 01:31:11","2023-04-11 01:31:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681176671;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681176671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-11 13:10:47","2023-04-11 13:10:47","0",NULL,"10"),
("1270","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-11 14:10:47","2023-04-11 14:10:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681222247;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681222247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-11 19:44:32","2023-04-11 19:44:32","0",NULL,"10"),
("1273","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-12 13:10:47","2023-04-12 13:10:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681305047;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681305047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-12 19:04:16","2023-04-12 19:04:16","0",NULL,"10"),
("1275","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-11 20:44:32","2023-04-11 20:44:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681245872;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681245872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-11 21:34:41","2023-04-11 21:34:41","0",NULL,"10"),
("1277","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-11 22:34:41","2023-04-11 22:34:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681252481;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681252481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-11 23:25:30","2023-04-11 23:25:30","0",NULL,"10"),
("1279","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-12 00:25:30","2023-04-12 00:25:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681259130;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681259130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-12 12:59:27","2023-04-12 12:59:27","0",NULL,"10"),
("1282","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-12 13:59:27","2023-04-12 13:59:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681307967;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681307967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-12 19:04:16","2023-04-12 19:04:16","0",NULL,"10"),
("1286","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-13 19:04:16","2023-04-13 19:04:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681412656;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681412656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-14 19:50:09","2023-04-14 19:50:09","0",NULL,"10"),
("1287","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-12 20:04:16","2023-04-12 20:04:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681329856;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681329856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-12 22:46:33","2023-04-12 22:46:33","0",NULL,"10"),
("1289","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-12 23:46:33","2023-04-12 23:46:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681343193;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681343193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-13 00:16:40","2023-04-13 00:16:40","0",NULL,"10"),
("1291","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-13 01:16:40","2023-04-13 01:16:40","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681348600;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681348600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-13 03:16:45","2023-04-13 03:16:45","0",NULL,"10"),
("1293","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-13 04:16:45","2023-04-13 04:16:45","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681359405;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681359405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-13 05:39:39","2023-04-13 05:39:39","0",NULL,"10"),
("1295","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-13 06:39:39","2023-04-13 06:39:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681367979;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681367979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-13 18:54:12","2023-04-13 18:54:12","0",NULL,"10"),
("1297","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-13 19:54:12","2023-04-13 19:54:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681415652;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681415652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-14 19:50:09","2023-04-14 19:50:09","0",NULL,"10"),
("1301","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-15 19:50:09","2023-04-15 19:50:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681588209;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681588209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-16 19:03:33","2023-04-16 19:03:33","0",NULL,"10"),
("1302","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-14 20:50:09","2023-04-14 20:50:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681505409;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681505409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-14 21:20:19","2023-04-14 21:20:19","0",NULL,"10"),
("1304","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-14 22:20:19","2023-04-14 22:20:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681510819;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681510819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-15 02:57:41","2023-04-15 02:57:41","0",NULL,"10"),
("1306","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-15 03:57:41","2023-04-15 03:57:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681531061;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681531061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-15 04:42:00","2023-04-15 04:42:00","0",NULL,"10"),
("1308","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-15 05:42:00","2023-04-15 05:42:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681537320;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681537320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-15 19:05:53","2023-04-15 19:05:53","0",NULL,"10"),
("1310","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-15 20:05:53","2023-04-15 20:05:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681589153;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681589153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-16 19:03:33","2023-04-16 19:03:33","0",NULL,"10"),
("1314","pinterest_for_woocommerce_daily_heartbeat","failed","2023-04-17 19:03:33","2023-04-17 19:03:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681758213;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681758213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2023-04-17 19:04:52","2023-04-17 19:04:52","0",NULL,"10"),
("1315","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-16 20:03:33","2023-04-16 20:03:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681675413;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681675413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-17 19:04:52","2023-04-17 19:04:52","0",NULL,"10"),
("1317","pinterest_for_woocommerce_hourly_heartbeat","failed","2023-04-17 20:04:52","2023-04-17 20:04:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1681761892;s:18:\"\0*\0first_timestamp\";i:1678733816;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1681761892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}","4","1","2023-04-18 11:51:44","2023-04-18 11:51:44","0",NULL,"10"),
("1391","woocommerce_run_on_woocommerce_admin_updated","failed","2023-04-27 19:47:22","2023-04-27 19:47:22","[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682624842;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682624842;}","7","1","2023-04-27 19:48:25","2023-04-27 19:48:25","0",NULL,"10"),
("1785","woocommerce_run_on_woocommerce_admin_updated","failed","2023-05-16 18:10:57","2023-05-16 18:10:57","[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1684260657;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1684260657;}","7","1","2023-05-16 18:10:58","2023-05-16 18:10:58","0",NULL,"10"),
("2115","woocommerce_run_on_woocommerce_admin_updated","failed","2023-06-03 11:16:15","2023-06-03 11:16:15","[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685790975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685790975;}","7","1","2023-06-03 11:16:16","2023-06-03 11:16:16","0",NULL,"10"),
("2117","woocommerce_run_on_woocommerce_admin_updated","failed","2023-06-03 11:16:20","2023-06-03 11:16:20","[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685790980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685790980;}","7","1","2023-06-03 11:16:23","2023-06-03 11:16:23","0",NULL,"10"),
("2578","wc-admin_import_orders","failed","2023-09-09 13:08:12","2023-09-09 13:08:12","[537]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694264892;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694264892;}","5","1","2023-09-09 14:18:30","2023-09-09 14:18:30","4491",NULL,"10"),
("2924","rocket_preload_job_preload_url","failed","2023-10-03 12:32:02","2023-10-03 12:32:02","[\"https:\\/\\/bavance.com\\/category\\/tutorials\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2023-10-03 12:33:46","2023-10-03 12:33:46","4973",NULL,"10"),
("2940","rocket_preload_job_preload_url","failed","2023-10-03 12:47:20","2023-10-03 12:47:20","[\"https:\\/\\/bavance.com\\/terms-of-service\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2023-10-03 12:47:42","2023-10-03 12:47:42","4984",NULL,"10"),
("3115","rocket_preload_job_preload_url","failed","2023-10-10 14:31:50","2023-10-10 14:31:50","[\"https:\\/\\/bavance.com\\/category\\/tutorials\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2023-10-10 14:31:52","2023-10-10 14:31:52","5220",NULL,"10"),
("3199","rocket_preload_job_preload_url","failed","2023-10-14 13:38:22","2023-10-14 13:38:22","[\"https:\\/\\/bavance.com\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2023-10-14 13:38:23","2023-10-14 13:38:23","5379",NULL,"10"),
("3306","woocommerce_cleanup_draft_orders","complete","2023-10-20 10:39:17","2023-10-20 10:39:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697798357;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697798357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-10-28 21:21:36","2023-10-28 21:21:36","0",NULL,"10"),
("3307","wc_gla_cron_daily_notes","complete","2023-10-20 10:39:17","2023-10-20 10:39:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697798357;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697798357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-10-28 21:21:36","2023-10-28 21:21:36","0",NULL,"10"),
("3332","woocommerce_cleanup_draft_orders","complete","2023-10-29 21:21:36","2023-10-29 21:21:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698614496;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698614496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-10-29 21:45:43","2023-10-29 21:45:43","0",NULL,"10"),
("3333","wc_gla_cron_daily_notes","complete","2023-10-29 21:21:36","2023-10-29 21:21:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698614496;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698614496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-10-29 21:45:43","2023-10-29 21:45:43","0",NULL,"10"),
("3357","woocommerce_cleanup_draft_orders","complete","2023-10-30 21:45:43","2023-10-30 21:45:43","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698702343;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698702343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-10-30 22:32:05","2023-10-30 22:32:05","0",NULL,"10"),
("3358","wc_gla_cron_daily_notes","complete","2023-10-30 21:45:43","2023-10-30 21:45:43","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698702343;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698702343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-10-30 22:32:05","2023-10-30 22:32:05","0",NULL,"10"),
("3371","woocommerce_cleanup_draft_orders","complete","2023-10-31 22:32:05","2023-10-31 22:32:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698791525;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698791525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-10-31 23:09:49","2023-10-31 23:09:49","0",NULL,"10"),
("3372","wc_gla_cron_daily_notes","complete","2023-10-31 22:32:05","2023-10-31 22:32:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698791525;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698791525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-10-31 23:09:49","2023-10-31 23:09:49","0",NULL,"10"),
("3386","woocommerce_cleanup_draft_orders","complete","2023-11-01 23:09:49","2023-11-01 23:09:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698880189;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698880189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-02 00:08:29","2023-11-02 00:08:29","0",NULL,"10"),
("3387","wc_gla_cron_daily_notes","complete","2023-11-01 23:09:49","2023-11-01 23:09:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698880189;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698880189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-02 00:08:29","2023-11-02 00:08:29","0",NULL,"10"),
("3412","woocommerce_cleanup_draft_orders","complete","2023-11-03 00:08:29","2023-11-03 00:08:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698970109;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698970109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-03 00:19:03","2023-11-03 00:19:03","0",NULL,"10"),
("3413","wc_gla_cron_daily_notes","complete","2023-11-03 00:08:29","2023-11-03 00:08:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698970109;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698970109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-03 00:19:03","2023-11-03 00:19:03","0",NULL,"10"),
("3431","woocommerce_cleanup_draft_orders","complete","2023-11-04 00:19:03","2023-11-04 00:19:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699057143;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699057143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-04 00:27:07","2023-11-04 00:27:07","0",NULL,"10"),
("3432","wc_gla_cron_daily_notes","complete","2023-11-04 00:19:03","2023-11-04 00:19:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699057143;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699057143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-04 00:27:07","2023-11-04 00:27:07","0",NULL,"10"),
("3439","woocommerce_cleanup_draft_orders","complete","2023-11-05 00:27:07","2023-11-05 00:27:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699144027;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699144027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-05 00:49:42","2023-11-05 00:49:42","0",NULL,"10"),
("3440","wc_gla_cron_daily_notes","complete","2023-11-05 00:27:07","2023-11-05 00:27:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699144027;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699144027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-05 00:49:42","2023-11-05 00:49:42","0",NULL,"10"),
("3453","woocommerce_cleanup_draft_orders","complete","2023-11-06 00:49:42","2023-11-06 00:49:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699231782;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699231782;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-06 01:41:44","2023-11-06 01:41:44","0",NULL,"10"),
("3454","wc_gla_cron_daily_notes","complete","2023-11-06 00:49:42","2023-11-06 00:49:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699231782;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699231782;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-06 01:41:44","2023-11-06 01:41:44","0",NULL,"10"),
("3462","woocommerce_cleanup_draft_orders","complete","2023-11-07 01:41:44","2023-11-07 01:41:44","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699321304;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699321304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-07 01:43:29","2023-11-07 01:43:29","0",NULL,"10"),
("3463","wc_gla_cron_daily_notes","complete","2023-11-07 01:41:44","2023-11-07 01:41:44","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699321304;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699321304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-07 01:43:29","2023-11-07 01:43:29","0",NULL,"10"),
("3476","woocommerce_cleanup_draft_orders","complete","2023-11-08 01:43:29","2023-11-08 01:43:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699407809;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699407809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-08 03:44:37","2023-11-08 03:44:37","0",NULL,"10"),
("3477","wc_gla_cron_daily_notes","complete","2023-11-08 01:43:29","2023-11-08 01:43:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699407809;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699407809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-08 03:44:37","2023-11-08 03:44:37","0",NULL,"10"),
("3491","woocommerce_cleanup_draft_orders","complete","2023-11-09 03:44:37","2023-11-09 03:44:37","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699501477;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699501477;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-09 03:49:46","2023-11-09 03:49:46","0",NULL,"10"),
("3492","wc_gla_cron_daily_notes","complete","2023-11-09 03:44:37","2023-11-09 03:44:37","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699501477;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699501477;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-09 03:49:46","2023-11-09 03:49:46","0",NULL,"10"),
("3507","woocommerce_cleanup_draft_orders","complete","2023-11-10 03:49:46","2023-11-10 03:49:46","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699588186;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699588186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-10 03:51:14","2023-11-10 03:51:14","0",NULL,"10"),
("3508","wc_gla_cron_daily_notes","complete","2023-11-10 03:49:46","2023-11-10 03:49:46","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699588186;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699588186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-10 03:51:14","2023-11-10 03:51:14","0",NULL,"10"),
("3509","woocommerce_cleanup_draft_orders","complete","2023-11-11 03:51:14","2023-11-11 03:51:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699674674;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699674674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-11 05:30:19","2023-11-11 05:30:19","0",NULL,"10"),
("3510","wc_gla_cron_daily_notes","complete","2023-11-11 03:51:14","2023-11-11 03:51:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699674674;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699674674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-11 05:30:19","2023-11-11 05:30:19","0",NULL,"10"),
("3512","woocommerce_cleanup_draft_orders","complete","2023-11-12 05:30:19","2023-11-12 05:30:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699767019;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699767019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-12 08:06:24","2023-11-12 08:06:24","0",NULL,"10"),
("3513","wc_gla_cron_daily_notes","complete","2023-11-12 05:30:19","2023-11-12 05:30:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699767019;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699767019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-12 08:06:24","2023-11-12 08:06:24","0",NULL,"10"),
("3514","woocommerce_cleanup_draft_orders","complete","2023-11-13 08:06:24","2023-11-13 08:06:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699862784;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699862784;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-13 08:18:13","2023-11-13 08:18:13","0",NULL,"10"),
("3515","wc_gla_cron_daily_notes","complete","2023-11-13 08:06:24","2023-11-13 08:06:24","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699862784;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699862784;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-13 08:18:13","2023-11-13 08:18:13","0",NULL,"10"),
("3516","woocommerce_cleanup_draft_orders","complete","2023-11-14 08:18:13","2023-11-14 08:18:13","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699949893;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699949893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-14 10:20:30","2023-11-14 10:20:30","0",NULL,"10"),
("3517","wc_gla_cron_daily_notes","complete","2023-11-14 08:18:13","2023-11-14 08:18:13","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699949893;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699949893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-14 10:20:30","2023-11-14 10:20:30","0",NULL,"10"),
("3518","woocommerce_cleanup_draft_orders","complete","2023-11-15 10:20:30","2023-11-15 10:20:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700043630;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700043630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-15 10:48:50","2023-11-15 10:48:50","0",NULL,"10"),
("3519","wc_gla_cron_daily_notes","complete","2023-11-15 10:20:30","2023-11-15 10:20:30","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700043630;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700043630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-15 10:48:50","2023-11-15 10:48:50","0",NULL,"10"),
("3520","woocommerce_cleanup_draft_orders","complete","2023-11-16 10:48:50","2023-11-16 10:48:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700131730;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700131730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-16 11:59:38","2023-11-16 11:59:38","0",NULL,"10"),
("3521","wc_gla_cron_daily_notes","complete","2023-11-16 10:48:50","2023-11-16 10:48:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700131730;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700131730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-16 11:59:38","2023-11-16 11:59:38","0",NULL,"10"),
("3522","woocommerce_cleanup_draft_orders","complete","2023-11-17 11:59:38","2023-11-17 11:59:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700222378;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700222378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-17 13:35:25","2023-11-17 13:35:25","0",NULL,"10"),
("3523","wc_gla_cron_daily_notes","complete","2023-11-17 11:59:38","2023-11-17 11:59:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700222378;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700222378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-17 13:35:25","2023-11-17 13:35:25","0",NULL,"10"),
("3524","woocommerce_cleanup_draft_orders","complete","2023-11-18 13:35:25","2023-11-18 13:35:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700314525;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700314525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-18 13:44:47","2023-11-18 13:44:47","0",NULL,"10"),
("3525","wc_gla_cron_daily_notes","complete","2023-11-18 13:35:25","2023-11-18 13:35:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700314525;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700314525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-18 13:44:47","2023-11-18 13:44:47","0",NULL,"10"),
("3526","woocommerce_cleanup_draft_orders","complete","2023-11-19 13:44:47","2023-11-19 13:44:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700401487;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700401487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-19 15:14:49","2023-11-19 15:14:49","0",NULL,"10"),
("3527","wc_gla_cron_daily_notes","complete","2023-11-19 13:44:47","2023-11-19 13:44:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700401487;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700401487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-19 15:14:49","2023-11-19 15:14:49","0",NULL,"10"),
("3528","woocommerce_cleanup_draft_orders","complete","2023-11-20 15:14:49","2023-11-20 15:14:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700493289;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700493289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-20 15:21:05","2023-11-20 15:21:05","0",NULL,"10"),
("3529","wc_gla_cron_daily_notes","complete","2023-11-20 15:14:49","2023-11-20 15:14:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700493289;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700493289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-20 15:21:05","2023-11-20 15:21:05","0",NULL,"10"),
("3530","woocommerce_cleanup_draft_orders","complete","2023-11-21 15:21:05","2023-11-21 15:21:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700580065;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700580065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-21 16:04:14","2023-11-21 16:04:14","0",NULL,"10"),
("3531","wc_gla_cron_daily_notes","complete","2023-11-21 15:21:05","2023-11-21 15:21:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700580065;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700580065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-21 16:04:14","2023-11-21 16:04:14","0",NULL,"10"),
("3532","woocommerce_cleanup_draft_orders","complete","2023-11-22 16:04:14","2023-11-22 16:04:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700669054;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700669054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-22 18:01:59","2023-11-22 18:01:59","0",NULL,"10"),
("3533","wc_gla_cron_daily_notes","complete","2023-11-22 16:04:14","2023-11-22 16:04:14","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700669054;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700669054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-22 18:01:59","2023-11-22 18:01:59","0",NULL,"10"),
("3534","woocommerce_cleanup_draft_orders","complete","2023-11-23 18:01:59","2023-11-23 18:01:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700762519;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700762519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","1","2023-11-23 18:28:19","2023-11-23 18:28:19","0",NULL,"10"),
("3535","wc_gla_cron_daily_notes","complete","2023-11-23 18:01:59","2023-11-23 18:01:59","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700762519;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700762519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","1","2023-11-23 18:28:19","2023-11-23 18:28:19","0",NULL,"10"),
("3536","woocommerce_cleanup_draft_orders","pending","2023-11-24 18:28:19","2023-11-24 18:28:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700850499;s:18:\"\0*\0first_timestamp\";i:1678733632;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700850499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","9","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("3537","wc_gla_cron_daily_notes","pending","2023-11-24 18:28:19","2023-11-24 18:28:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1700850499;s:18:\"\0*\0first_timestamp\";i:1678733801;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1700850499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"10"),
("3538","rocket_preload_job_check_finished","complete","2023-11-23 19:09:04","2023-11-23 19:09:04","[1700766484]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700766544;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700766544;}","6","1","2023-11-23 19:10:00","2023-11-23 19:10:00","0",NULL,"10"),
("3539","woocommerce_run_product_attribute_lookup_regeneration_callback","complete","2023-11-23 19:08:31","2023-11-23 19:08:31","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700766511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700766511;}","8","1","2023-11-23 19:08:33","2023-11-23 19:08:33","0",NULL,"10"),
("3540","woocommerce_run_on_woocommerce_admin_updated","complete","2023-11-23 19:08:31","2023-11-23 19:08:31","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700766511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700766511;}","7","1","2023-11-23 19:08:33","2023-11-23 19:08:33","0",NULL,"10"),
("3541","rocket_preload_job_preload_url","complete","2023-11-23 19:08:33","2023-11-23 19:08:33","[\"https:\\/\\/bavance.com\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2023-11-23 19:08:34","2023-11-23 19:08:34","0",NULL,"10"),
("3542","rocket_preload_job_preload_url","complete","2023-11-23 19:10:00","2023-11-23 19:10:00","[\"https:\\/\\/bavance.com\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","6","1","2023-11-23 19:10:02","2023-11-23 19:10:02","0",NULL,"10"),
("3543","rocket_preload_job_check_finished","complete","2023-11-23 19:11:00","2023-11-23 19:11:00","[1700766600]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700766660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700766660;}","6","1","2023-11-23 19:11:00","2023-11-23 19:11:00","0",NULL,"10");

INSERT IGNORE INTO `wp_actionscheduler_claims` VALUES 
("4332","2023-07-29 06:02:20"),
("4398","2023-08-28 06:27:50"),
("4462","2023-09-03 15:00:01"),
("4491","2023-09-09 14:18:30"),
("4973","2023-10-03 12:33:46"),
("4984","2023-10-03 12:47:42"),
("5220","2023-10-10 14:31:52"),
("5379","2023-10-14 13:38:23");

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","gla"),
("3","mailpoet-cron"),
("4","pinterest-for-woocommerce"),
("5","wc-admin-data"),
("6","rocket-preload"),
("7","woocommerce-remote-inbox-engine"),
("8","woocommerce-db-updates"),
("9","");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("416","148","action created","2023-03-14 19:34:20","2023-03-14 19:34:20"),
("437","155","action created","2023-03-14 23:29:57","2023-03-14 23:29:57"),
("476","155","action started via Async Request","2023-03-15 00:53:27","2023-03-15 00:53:27"),
("477","155","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-15 00:53:27","2023-03-15 00:53:27"),
("478","168","action created","2023-03-15 00:53:27","2023-03-15 00:53:27"),
("482","168","action started via Async Request","2023-03-15 07:36:28","2023-03-15 07:36:28"),
("483","168","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-15 07:36:28","2023-03-15 07:36:28"),
("484","170","action created","2023-03-15 07:36:28","2023-03-15 07:36:28"),
("485","170","action started via Async Request","2023-03-15 08:37:04","2023-03-15 08:37:04"),
("486","170","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-15 08:37:04","2023-03-15 08:37:04"),
("487","171","action created","2023-03-15 08:37:04","2023-03-15 08:37:04"),
("488","171","action started via Async Request","2023-03-15 11:56:03","2023-03-15 11:56:03"),
("489","171","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-15 11:56:03","2023-03-15 11:56:03"),
("490","172","action created","2023-03-15 11:56:03","2023-03-15 11:56:03"),
("491","172","action started via Async Request","2023-03-15 12:56:37","2023-03-15 12:56:37"),
("492","172","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-15 12:56:37","2023-03-15 12:56:37"),
("493","173","action created","2023-03-15 12:56:37","2023-03-15 12:56:37"),
("494","173","action started via Async Request","2023-03-15 18:24:04","2023-03-15 18:24:04"),
("495","173","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-15 18:24:04","2023-03-15 18:24:04"),
("496","174","action created","2023-03-15 18:24:04","2023-03-15 18:24:04"),
("497","174","action started via Async Request","2023-03-17 21:13:30","2023-03-17 21:13:30"),
("498","174","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-17 21:13:30","2023-03-17 21:13:30"),
("499","175","action created","2023-03-17 21:13:30","2023-03-17 21:13:30"),
("506","148","action started via Async Request","2023-03-17 21:13:30","2023-03-17 21:13:30"),
("507","148","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-17 21:13:30","2023-03-17 21:13:30"),
("508","178","action created","2023-03-17 21:13:30","2023-03-17 21:13:30"),
("509","175","action started via Async Request","2023-03-18 06:53:14","2023-03-18 06:53:14"),
("510","175","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-18 06:53:14","2023-03-18 06:53:14"),
("511","179","action created","2023-03-18 06:53:14","2023-03-18 06:53:14"),
("512","179","action started via Async Request","2023-03-18 15:23:58","2023-03-18 15:23:58"),
("513","179","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-18 15:23:58","2023-03-18 15:23:58"),
("514","180","action created","2023-03-18 15:23:58","2023-03-18 15:23:58"),
("515","180","action started via Async Request","2023-03-19 20:04:48","2023-03-19 20:04:48"),
("516","180","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-19 20:04:48","2023-03-19 20:04:48"),
("517","181","action created","2023-03-19 20:04:48","2023-03-19 20:04:48"),
("524","178","action started via Async Request","2023-03-19 20:04:48","2023-03-19 20:04:48"),
("525","178","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-19 20:04:48","2023-03-19 20:04:48"),
("526","184","action created","2023-03-19 20:04:48","2023-03-19 20:04:48"),
("527","181","action started via Async Request","2023-03-20 02:37:50","2023-03-20 02:37:50"),
("528","181","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-20 02:37:50","2023-03-20 02:37:50"),
("529","185","action created","2023-03-20 02:37:50","2023-03-20 02:37:50"),
("530","185","action started via Async Request","2023-03-21 07:52:51","2023-03-21 07:52:51"),
("531","185","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-21 07:52:51","2023-03-21 07:52:51"),
("532","186","action created","2023-03-21 07:52:51","2023-03-21 07:52:51"),
("539","184","action started via Async Request","2023-03-21 07:52:51","2023-03-21 07:52:51"),
("540","184","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-21 07:52:51","2023-03-21 07:52:51"),
("541","189","action created","2023-03-21 07:52:51","2023-03-21 07:52:51"),
("542","186","action started via Async Request","2023-03-21 12:26:33","2023-03-21 12:26:33"),
("543","186","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-21 12:26:33","2023-03-21 12:26:33"),
("544","190","action created","2023-03-21 12:26:33","2023-03-21 12:26:33"),
("545","190","action started via Async Request","2023-03-22 04:29:54","2023-03-22 04:29:54"),
("546","190","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-22 04:29:54","2023-03-22 04:29:54"),
("547","191","action created","2023-03-22 04:29:54","2023-03-22 04:29:54"),
("548","191","action started via Async Request","2023-03-22 06:31:51","2023-03-22 06:31:51"),
("549","191","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-22 06:31:51","2023-03-22 06:31:51"),
("550","192","action created","2023-03-22 06:31:51","2023-03-22 06:31:51"),
("551","192","action started via Async Request","2023-03-23 21:58:42","2023-03-23 21:58:42"),
("552","192","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-23 21:58:42","2023-03-23 21:58:42"),
("553","193","action created","2023-03-23 21:58:42","2023-03-23 21:58:42"),
("560","189","action started via Async Request","2023-03-23 21:58:42","2023-03-23 21:58:42"),
("561","189","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-23 21:58:42","2023-03-23 21:58:42"),
("562","196","action created","2023-03-23 21:58:42","2023-03-23 21:58:42"),
("591","207","action created","2023-03-23 22:37:38","2023-03-23 22:37:38"),
("592","207","action started via Async Request","2023-03-23 22:37:58","2023-03-23 22:37:58"),
("593","207","action failed via Async Request: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.","2023-03-23 22:37:58","2023-03-23 22:37:58"),
("618","193","action started via Async Request","2023-03-24 05:42:10","2023-03-24 05:42:10"),
("619","193","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 05:42:10","2023-03-24 05:42:10"),
("620","216","action created","2023-03-24 05:42:10","2023-03-24 05:42:10"),
("625","216","action started via Async Request","2023-03-24 07:23:08","2023-03-24 07:23:08"),
("626","216","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 07:23:08","2023-03-24 07:23:08"),
("627","219","action created","2023-03-24 07:23:08","2023-03-24 07:23:08"),
("738","219","action started via Async Request","2023-03-24 08:23:57","2023-03-24 08:23:57"),
("739","219","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 08:23:57","2023-03-24 08:23:57"),
("740","256","action created","2023-03-24 08:23:57","2023-03-24 08:23:57"),
("840","256","action started via Async Request","2023-03-24 09:24:22","2023-03-24 09:24:22"),
("841","256","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 09:24:22","2023-03-24 09:24:22"),
("842","290","action created","2023-03-24 09:24:22","2023-03-24 09:24:22"),
("894","290","action started via Async Request","2023-03-24 11:19:08","2023-03-24 11:19:08"),
("895","290","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 11:19:08","2023-03-24 11:19:08"),
("896","308","action created","2023-03-24 11:19:08","2023-03-24 11:19:08"),
("999","308","action started via Async Request","2023-03-24 12:19:29","2023-03-24 12:19:29"),
("1000","308","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 12:19:29","2023-03-24 12:19:29"),
("1001","343","action created","2023-03-24 12:19:29","2023-03-24 12:19:29"),
("1092","343","action started via Async Request","2023-03-24 13:21:02","2023-03-24 13:21:02"),
("1093","343","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 13:21:02","2023-03-24 13:21:02"),
("1094","374","action created","2023-03-24 13:21:02","2023-03-24 13:21:02"),
("1197","374","action started via Async Request","2023-03-24 14:21:28","2023-03-24 14:21:28"),
("1198","374","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 14:21:28","2023-03-24 14:21:28"),
("1199","409","action created","2023-03-24 14:21:28","2023-03-24 14:21:28"),
("1305","409","action started via Async Request","2023-03-24 15:21:34","2023-03-24 15:21:34"),
("1306","409","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 15:21:34","2023-03-24 15:21:34"),
("1307","445","action created","2023-03-24 15:21:34","2023-03-24 15:21:34"),
("1446","445","action started via Async Request","2023-03-24 16:22:26","2023-03-24 16:22:26"),
("1447","445","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 16:22:26","2023-03-24 16:22:26"),
("1448","492","action created","2023-03-24 16:22:26","2023-03-24 16:22:26"),
("1575","492","action started via Async Request","2023-03-24 17:22:34","2023-03-24 17:22:34"),
("1576","492","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 17:22:34","2023-03-24 17:22:34"),
("1577","535","action created","2023-03-24 17:22:34","2023-03-24 17:22:34"),
("1617","535","action started via Async Request","2023-03-24 18:58:05","2023-03-24 18:58:05"),
("1618","535","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 18:58:05","2023-03-24 18:58:05"),
("1619","549","action created","2023-03-24 18:58:05","2023-03-24 18:58:05"),
("1746","549","action started via Async Request","2023-03-24 19:58:51","2023-03-24 19:58:51"),
("1747","549","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 19:58:51","2023-03-24 19:58:51"),
("1748","592","action created","2023-03-24 19:58:51","2023-03-24 19:58:51"),
("1857","592","action started via Async Request","2023-03-24 20:59:47","2023-03-24 20:59:47"),
("1858","592","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 20:59:47","2023-03-24 20:59:47"),
("1859","629","action created","2023-03-24 20:59:47","2023-03-24 20:59:47"),
("1953","196","action started via Async Request","2023-03-24 22:00:17","2023-03-24 22:00:17"),
("1954","196","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-24 22:00:17","2023-03-24 22:00:17"),
("1955","661","action created","2023-03-24 22:00:17","2023-03-24 22:00:17"),
("1959","629","action started via Async Request","2023-03-24 22:00:17","2023-03-24 22:00:17"),
("1960","629","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 22:00:17","2023-03-24 22:00:17"),
("1961","663","action created","2023-03-24 22:00:17","2023-03-24 22:00:17"),
("2052","663","action started via Async Request","2023-03-24 23:00:29","2023-03-24 23:00:29"),
("2053","663","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-24 23:00:29","2023-03-24 23:00:29"),
("2054","694","action created","2023-03-24 23:00:29","2023-03-24 23:00:29"),
("2175","694","action started via Async Request","2023-03-25 00:01:46","2023-03-25 00:01:46"),
("2176","694","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 00:01:46","2023-03-25 00:01:46"),
("2177","735","action created","2023-03-25 00:01:46","2023-03-25 00:01:46"),
("2319","735","action started via Async Request","2023-03-25 01:02:22","2023-03-25 01:02:22"),
("2320","735","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 01:02:22","2023-03-25 01:02:22"),
("2321","783","action created","2023-03-25 01:02:22","2023-03-25 01:02:22"),
("2400","783","action started via Async Request","2023-03-25 06:14:00","2023-03-25 06:14:00"),
("2401","783","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 06:14:00","2023-03-25 06:14:00"),
("2402","810","action created","2023-03-25 06:14:00","2023-03-25 06:14:00"),
("2406","810","action started via Async Request","2023-03-25 07:14:25","2023-03-25 07:14:25"),
("2407","810","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 07:14:25","2023-03-25 07:14:25"),
("2408","812","action created","2023-03-25 07:14:25","2023-03-25 07:14:25"),
("2412","812","action started via Async Request","2023-03-25 09:14:54","2023-03-25 09:14:54"),
("2413","812","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 09:14:54","2023-03-25 09:14:54"),
("2414","814","action created","2023-03-25 09:14:54","2023-03-25 09:14:54"),
("2454","814","action started via Async Request","2023-03-25 10:19:32","2023-03-25 10:19:32"),
("2455","814","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 10:19:32","2023-03-25 10:19:32"),
("2456","828","action created","2023-03-25 10:19:32","2023-03-25 10:19:32"),
("2460","828","action started via Async Request","2023-03-25 14:23:34","2023-03-25 14:23:34"),
("2461","828","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 14:23:34","2023-03-25 14:23:34"),
("2462","830","action created","2023-03-25 14:23:34","2023-03-25 14:23:34"),
("2502","830","action started via Async Request","2023-03-25 17:17:15","2023-03-25 17:17:15"),
("2503","830","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 17:17:15","2023-03-25 17:17:15"),
("2504","844","action created","2023-03-25 17:17:15","2023-03-25 17:17:15"),
("2562","844","action started via Async Request","2023-03-25 18:29:35","2023-03-25 18:29:35"),
("2563","844","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 18:29:35","2023-03-25 18:29:35"),
("2564","864","action created","2023-03-25 18:29:35","2023-03-25 18:29:35"),
("2571","864","action started via Async Request","2023-03-25 23:27:03","2023-03-25 23:27:03"),
("2572","864","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-25 23:27:03","2023-03-25 23:27:03"),
("2573","867","action created","2023-03-25 23:27:03","2023-03-25 23:27:03"),
("2580","661","action started via Async Request","2023-03-25 23:27:03","2023-03-25 23:27:03"),
("2581","661","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-25 23:27:03","2023-03-25 23:27:03"),
("2582","870","action created","2023-03-25 23:27:03","2023-03-25 23:27:03"),
("2586","867","action started via Async Request","2023-03-26 18:56:38","2023-03-26 18:56:38"),
("2587","867","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-26 18:56:38","2023-03-26 18:56:38"),
("2588","872","action created","2023-03-26 18:56:38","2023-03-26 18:56:38"),
("2595","872","action started via Async Request","2023-03-27 02:37:23","2023-03-27 02:37:23"),
("2596","872","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 02:37:23","2023-03-27 02:37:23"),
("2597","875","action created","2023-03-27 02:37:23","2023-03-27 02:37:23"),
("2604","870","action started via Async Request","2023-03-27 02:37:23","2023-03-27 02:37:23"),
("2605","870","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-27 02:37:23","2023-03-27 02:37:23"),
("2606","878","action created","2023-03-27 02:37:23","2023-03-27 02:37:23"),
("2610","875","action started via Async Request","2023-03-27 04:57:30","2023-03-27 04:57:30"),
("2611","875","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 04:57:30","2023-03-27 04:57:30"),
("2612","880","action created","2023-03-27 04:57:30","2023-03-27 04:57:30"),
("2616","880","action started via Async Request","2023-03-27 07:50:00","2023-03-27 07:50:00"),
("2617","880","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 07:50:00","2023-03-27 07:50:00"),
("2618","882","action created","2023-03-27 07:50:00","2023-03-27 07:50:00"),
("2625","882","action started via Async Request","2023-03-27 10:33:09","2023-03-27 10:33:09"),
("2626","882","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 10:33:09","2023-03-27 10:33:09"),
("2627","885","action created","2023-03-27 10:33:09","2023-03-27 10:33:09"),
("2631","885","action started via Async Request","2023-03-27 11:39:03","2023-03-27 11:39:03"),
("2632","885","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 11:39:03","2023-03-27 11:39:03"),
("2633","887","action created","2023-03-27 11:39:03","2023-03-27 11:39:03"),
("2640","887","action started via Async Request","2023-03-27 12:50:10","2023-03-27 12:50:10"),
("2641","887","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 12:50:10","2023-03-27 12:50:10"),
("2642","890","action created","2023-03-27 12:50:10","2023-03-27 12:50:10"),
("2646","890","action started via Async Request","2023-03-27 14:03:18","2023-03-27 14:03:18"),
("2647","890","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 14:03:18","2023-03-27 14:03:18"),
("2648","892","action created","2023-03-27 14:03:18","2023-03-27 14:03:18"),
("2652","892","action started via Async Request","2023-03-27 18:58:24","2023-03-27 18:58:24"),
("2653","892","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-27 18:58:24","2023-03-27 18:58:24"),
("2654","894","action created","2023-03-27 18:58:24","2023-03-27 18:58:24"),
("2661","894","action started via Async Request","2023-03-28 01:12:22","2023-03-28 01:12:22"),
("2662","894","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-28 01:12:22","2023-03-28 01:12:22"),
("2663","897","action created","2023-03-28 01:12:22","2023-03-28 01:12:22"),
("2667","897","action started via Async Request","2023-03-28 02:16:12","2023-03-28 02:16:12"),
("2668","897","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-28 02:16:12","2023-03-28 02:16:12"),
("2669","899","action created","2023-03-28 02:16:12","2023-03-28 02:16:12"),
("2688","878","action started via Async Request","2023-03-28 04:57:47","2023-03-28 04:57:47"),
("2689","878","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-28 04:57:47","2023-03-28 04:57:47"),
("2690","906","action created","2023-03-28 04:57:47","2023-03-28 04:57:47"),
("2691","899","action started via Async Request","2023-03-28 04:57:47","2023-03-28 04:57:47"),
("2692","899","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-28 04:57:47","2023-03-28 04:57:47"),
("2693","907","action created","2023-03-28 04:57:47","2023-03-28 04:57:47"),
("2697","907","action started via Async Request","2023-03-28 09:31:28","2023-03-28 09:31:28"),
("2698","907","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-28 09:31:28","2023-03-28 09:31:28"),
("2699","909","action created","2023-03-28 09:31:28","2023-03-28 09:31:28"),
("2703","909","action started via Async Request","2023-03-28 18:14:32","2023-03-28 18:14:32"),
("2704","909","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-28 18:14:32","2023-03-28 18:14:32"),
("2705","911","action created","2023-03-28 18:14:32","2023-03-28 18:14:32"),
("2709","911","action started via Async Request","2023-03-28 20:34:47","2023-03-28 20:34:47"),
("2710","911","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-28 20:34:47","2023-03-28 20:34:47"),
("2711","913","action created","2023-03-28 20:34:47","2023-03-28 20:34:47"),
("2715","913","action started via Async Request","2023-03-28 23:44:04","2023-03-28 23:44:04"),
("2716","913","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-28 23:44:04","2023-03-28 23:44:04"),
("2717","915","action created","2023-03-28 23:44:04","2023-03-28 23:44:04"),
("2724","915","action started via Async Request","2023-03-29 03:04:33","2023-03-29 03:04:33"),
("2725","915","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-29 03:04:33","2023-03-29 03:04:33"),
("2726","918","action created","2023-03-29 03:04:33","2023-03-29 03:04:33"),
("2730","918","action started via Async Request","2023-03-29 05:20:53","2023-03-29 05:20:53"),
("2731","918","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-29 05:20:53","2023-03-29 05:20:53"),
("2732","920","action created","2023-03-29 05:20:53","2023-03-29 05:20:53"),
("2739","906","action started via Async Request","2023-03-29 05:20:53","2023-03-29 05:20:53"),
("2740","906","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-29 05:20:53","2023-03-29 05:20:53"),
("2741","923","action created","2023-03-29 05:20:53","2023-03-29 05:20:53"),
("2745","920","action started via Async Request","2023-03-29 08:55:02","2023-03-29 08:55:02"),
("2746","920","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-29 08:55:02","2023-03-29 08:55:02"),
("2747","925","action created","2023-03-29 08:55:02","2023-03-29 08:55:02"),
("2754","925","action started via Async Request","2023-03-29 09:58:23","2023-03-29 09:58:23"),
("2755","925","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-29 09:58:23","2023-03-29 09:58:23"),
("2756","928","action created","2023-03-29 09:58:23","2023-03-29 09:58:23"),
("2781","928","action started via Async Request","2023-03-29 16:38:55","2023-03-29 16:38:55"),
("2782","928","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-29 16:38:55","2023-03-29 16:38:55"),
("2783","937","action created","2023-03-29 16:38:55","2023-03-29 16:38:55"),
("2787","937","action started via Async Request","2023-03-29 18:13:15","2023-03-29 18:13:15"),
("2788","937","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-29 18:13:15","2023-03-29 18:13:15"),
("2789","939","action created","2023-03-29 18:13:15","2023-03-29 18:13:15"),
("2794","939","action started via Async Request","2023-03-30 07:09:24","2023-03-30 07:09:24"),
("2795","939","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 07:09:24","2023-03-30 07:09:24"),
("2796","942","action created","2023-03-30 07:09:24","2023-03-30 07:09:24"),
("2803","923","action started via Async Request","2023-03-30 07:09:24","2023-03-30 07:09:24"),
("2804","923","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-30 07:09:24","2023-03-30 07:09:24"),
("2805","945","action created","2023-03-30 07:09:24","2023-03-30 07:09:24"),
("2817","942","action started via Async Request","2023-03-30 13:41:32","2023-03-30 13:41:32"),
("2818","942","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 13:41:32","2023-03-30 13:41:32"),
("2819","949","action created","2023-03-30 13:41:32","2023-03-30 13:41:32"),
("2823","949","action started via Async Request","2023-03-30 15:29:10","2023-03-30 15:29:10"),
("2824","949","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 15:29:10","2023-03-30 15:29:10"),
("2825","951","action created","2023-03-30 15:29:10","2023-03-30 15:29:10"),
("2871","951","action started via Async Request","2023-03-30 16:31:53","2023-03-30 16:31:53"),
("2872","951","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 16:31:53","2023-03-30 16:31:53"),
("2873","967","action created","2023-03-30 16:31:53","2023-03-30 16:31:53"),
("2904","978","action created","2023-03-30 17:06:18","2023-03-30 17:06:18"),
("2906","978","action started via Async Request","2023-03-30 17:06:30","2023-03-30 17:06:30"),
("2907","978","action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.","2023-03-30 17:06:30","2023-03-30 17:06:30"),
("2958","967","action started via Async Request","2023-03-30 17:32:08","2023-03-30 17:32:08"),
("2959","967","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 17:32:08","2023-03-30 17:32:08"),
("2960","996","action created","2023-03-30 17:32:08","2023-03-30 17:32:08"),
("3051","996","action started via Async Request","2023-03-30 18:32:38","2023-03-30 18:32:38"),
("3052","996","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 18:32:38","2023-03-30 18:32:38"),
("3053","1027","action created","2023-03-30 18:32:38","2023-03-30 18:32:38"),
("3111","1027","action started via Async Request","2023-03-30 20:32:02","2023-03-30 20:32:02"),
("3112","1027","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 20:32:02","2023-03-30 20:32:02"),
("3113","1047","action created","2023-03-30 20:32:02","2023-03-30 20:32:02"),
("3123","1047","action started via Async Request","2023-03-30 21:36:09","2023-03-30 21:36:09"),
("3124","1047","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-30 21:36:09","2023-03-30 21:36:09"),
("3125","1051","action created","2023-03-30 21:36:09","2023-03-30 21:36:09"),
("3129","1051","action started via Async Request","2023-03-31 01:06:20","2023-03-31 01:06:20"),
("3130","1051","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-31 01:06:20","2023-03-31 01:06:20"),
("3131","1053","action created","2023-03-31 01:06:20","2023-03-31 01:06:20"),
("3204","1053","action started via Async Request","2023-03-31 07:08:18","2023-03-31 07:08:18"),
("3205","1053","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-31 07:08:18","2023-03-31 07:08:18"),
("3206","1078","action created","2023-03-31 07:08:18","2023-03-31 07:08:18"),
("3216","945","action started via Async Request","2023-03-31 07:10:25","2023-03-31 07:10:25"),
("3217","945","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-03-31 07:10:25","2023-03-31 07:10:25"),
("3218","1082","action created","2023-03-31 07:10:25","2023-03-31 07:10:25"),
("3306","1078","action started via Async Request","2023-03-31 08:10:55","2023-03-31 08:10:55"),
("3307","1078","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-31 08:10:55","2023-03-31 08:10:55"),
("3308","1112","action created","2023-03-31 08:10:55","2023-03-31 08:10:55"),
("3399","1112","action started via Async Request","2023-03-31 10:33:22","2023-03-31 10:33:22"),
("3400","1112","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-31 10:33:22","2023-03-31 10:33:22"),
("3401","1143","action created","2023-03-31 10:33:22","2023-03-31 10:33:22"),
("3405","1143","action started via Async Request","2023-03-31 18:13:40","2023-03-31 18:13:40"),
("3406","1143","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-03-31 18:13:40","2023-03-31 18:13:40"),
("3407","1145","action created","2023-03-31 18:13:40","2023-03-31 18:13:40"),
("3411","1145","action started via Async Request","2023-04-01 01:47:02","2023-04-01 01:47:02"),
("3412","1145","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-01 01:47:02","2023-04-01 01:47:02"),
("3413","1147","action created","2023-04-01 01:47:02","2023-04-01 01:47:02"),
("3417","1147","action started via Async Request","2023-04-01 04:45:21","2023-04-01 04:45:21"),
("3418","1147","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-01 04:45:21","2023-04-01 04:45:21"),
("3419","1149","action created","2023-04-01 04:45:21","2023-04-01 04:45:21"),
("3426","1149","action started via Async Request","2023-04-02 05:17:36","2023-04-02 05:17:36"),
("3427","1149","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-02 05:17:36","2023-04-02 05:17:36"),
("3428","1152","action created","2023-04-02 05:17:36","2023-04-02 05:17:36"),
("3435","1082","action started via Async Request","2023-04-02 05:17:36","2023-04-02 05:17:36"),
("3436","1082","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-02 05:17:36","2023-04-02 05:17:36"),
("3437","1155","action created","2023-04-02 05:17:36","2023-04-02 05:17:36"),
("3441","1152","action started via Async Request","2023-04-02 09:10:46","2023-04-02 09:10:46"),
("3442","1152","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-02 09:10:46","2023-04-02 09:10:46"),
("3443","1157","action created","2023-04-02 09:10:46","2023-04-02 09:10:46"),
("3447","1157","action started via Async Request","2023-04-02 22:39:26","2023-04-02 22:39:26"),
("3448","1157","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-02 22:39:26","2023-04-02 22:39:26"),
("3449","1159","action created","2023-04-02 22:39:26","2023-04-02 22:39:26"),
("3492","1159","action started via Async Request","2023-04-03 02:51:39","2023-04-03 02:51:39"),
("3493","1159","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-03 02:51:39","2023-04-03 02:51:39"),
("3494","1174","action created","2023-04-03 02:51:39","2023-04-03 02:51:39"),
("3499","1174","action started via Async Request","2023-04-03 06:06:44","2023-04-03 06:06:44"),
("3500","1174","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-03 06:06:44","2023-04-03 06:06:44"),
("3501","1177","action created","2023-04-03 06:06:44","2023-04-03 06:06:44"),
("3508","1155","action started via Async Request","2023-04-03 06:06:44","2023-04-03 06:06:44"),
("3509","1155","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-03 06:06:44","2023-04-03 06:06:44"),
("3510","1180","action created","2023-04-03 06:06:44","2023-04-03 06:06:44"),
("3516","1177","action started via Async Request","2023-04-03 08:02:32","2023-04-03 08:02:32"),
("3517","1177","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-03 08:02:32","2023-04-03 08:02:32"),
("3518","1182","action created","2023-04-03 08:02:32","2023-04-03 08:02:32"),
("3522","1182","action started via Async Request","2023-04-03 10:46:20","2023-04-03 10:46:20"),
("3523","1182","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-03 10:46:20","2023-04-03 10:46:20"),
("3524","1184","action created","2023-04-03 10:46:20","2023-04-03 10:46:20"),
("3528","1184","action started via Async Request","2023-04-03 17:31:02","2023-04-03 17:31:02"),
("3529","1184","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-03 17:31:02","2023-04-03 17:31:02"),
("3530","1186","action created","2023-04-03 17:31:02","2023-04-03 17:31:02"),
("3534","1186","action started via Async Request","2023-04-03 21:40:01","2023-04-03 21:40:01"),
("3535","1186","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-03 21:40:01","2023-04-03 21:40:01"),
("3536","1188","action created","2023-04-03 21:40:01","2023-04-03 21:40:01"),
("3540","1188","action started via Async Request","2023-04-04 02:11:10","2023-04-04 02:11:10"),
("3541","1188","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-04 02:11:10","2023-04-04 02:11:10"),
("3542","1190","action created","2023-04-04 02:11:10","2023-04-04 02:11:10"),
("3546","1190","action started via Async Request","2023-04-04 04:35:48","2023-04-04 04:35:48"),
("3547","1190","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-04 04:35:48","2023-04-04 04:35:48"),
("3548","1192","action created","2023-04-04 04:35:48","2023-04-04 04:35:48"),
("3552","1192","action started via Async Request","2023-04-04 09:34:27","2023-04-04 09:34:27"),
("3553","1192","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-04 09:34:27","2023-04-04 09:34:27"),
("3554","1194","action created","2023-04-04 09:34:27","2023-04-04 09:34:27"),
("3561","1180","action started via Async Request","2023-04-04 09:34:27","2023-04-04 09:34:27"),
("3562","1180","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-04 09:34:27","2023-04-04 09:34:27"),
("3563","1197","action created","2023-04-04 09:34:27","2023-04-04 09:34:27"),
("3567","1194","action started via Async Request","2023-04-04 11:04:19","2023-04-04 11:04:19"),
("3568","1194","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-04 11:04:19","2023-04-04 11:04:19"),
("3569","1199","action created","2023-04-04 11:04:19","2023-04-04 11:04:19"),
("3573","1199","action started via Async Request","2023-04-04 12:20:00","2023-04-04 12:20:00"),
("3574","1199","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-04 12:20:00","2023-04-04 12:20:00"),
("3575","1201","action created","2023-04-04 12:20:00","2023-04-04 12:20:00"),
("3579","1201","action started via Async Request","2023-04-04 16:07:33","2023-04-04 16:07:33"),
("3580","1201","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-04 16:07:33","2023-04-04 16:07:33"),
("3581","1203","action created","2023-04-04 16:07:33","2023-04-04 16:07:33"),
("3585","1203","action started via Async Request","2023-04-05 15:37:33","2023-04-05 15:37:33"),
("3586","1203","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-05 15:37:33","2023-04-05 15:37:33"),
("3587","1205","action created","2023-04-05 15:37:33","2023-04-05 15:37:33"),
("3594","1197","action started via Async Request","2023-04-05 15:37:33","2023-04-05 15:37:33"),
("3595","1197","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-05 15:37:33","2023-04-05 15:37:33"),
("3596","1208","action created","2023-04-05 15:37:33","2023-04-05 15:37:33"),
("3600","1205","action started via Async Request","2023-04-06 04:17:00","2023-04-06 04:17:00"),
("3601","1205","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-06 04:17:01","2023-04-06 04:17:01"),
("3602","1210","action created","2023-04-06 04:17:01","2023-04-06 04:17:01"),
("3606","1210","action started via Async Request","2023-04-06 10:11:35","2023-04-06 10:11:35"),
("3607","1210","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-06 10:11:35","2023-04-06 10:11:35"),
("3608","1212","action created","2023-04-06 10:11:35","2023-04-06 10:11:35"),
("3612","1212","action started via Async Request","2023-04-06 12:28:20","2023-04-06 12:28:20"),
("3613","1212","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-06 12:28:20","2023-04-06 12:28:20"),
("3614","1214","action created","2023-04-06 12:28:20","2023-04-06 12:28:20"),
("3618","1214","action started via Async Request","2023-04-06 22:53:09","2023-04-06 22:53:09"),
("3619","1214","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-06 22:53:09","2023-04-06 22:53:09"),
("3620","1216","action created","2023-04-06 22:53:09","2023-04-06 22:53:09"),
("3627","1208","action started via Async Request","2023-04-06 22:53:09","2023-04-06 22:53:09"),
("3628","1208","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-06 22:53:09","2023-04-06 22:53:09"),
("3629","1219","action created","2023-04-06 22:53:09","2023-04-06 22:53:09"),
("3633","1216","action started via Async Request","2023-04-07 01:50:07","2023-04-07 01:50:07"),
("3634","1216","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-07 01:50:07","2023-04-07 01:50:07"),
("3635","1221","action created","2023-04-07 01:50:07","2023-04-07 01:50:07"),
("3639","1221","action started via Async Request","2023-04-07 05:09:37","2023-04-07 05:09:37"),
("3640","1221","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-07 05:09:37","2023-04-07 05:09:37"),
("3641","1223","action created","2023-04-07 05:09:37","2023-04-07 05:09:37"),
("3645","1223","action started via Async Request","2023-04-07 06:40:52","2023-04-07 06:40:52"),
("3646","1223","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-07 06:40:52","2023-04-07 06:40:52"),
("3647","1225","action created","2023-04-07 06:40:52","2023-04-07 06:40:52"),
("3654","1225","action started via Async Request","2023-04-07 10:50:23","2023-04-07 10:50:23"),
("3655","1225","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-07 10:50:23","2023-04-07 10:50:23"),
("3656","1228","action created","2023-04-07 10:50:23","2023-04-07 10:50:23"),
("3663","1228","action started via Async Request","2023-04-07 12:19:50","2023-04-07 12:19:50"),
("3664","1228","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-07 12:19:50","2023-04-07 12:19:50"),
("3665","1231","action created","2023-04-07 12:19:50","2023-04-07 12:19:50"),
("3669","1231","action started via Async Request","2023-04-07 20:32:50","2023-04-07 20:32:50"),
("3670","1231","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-07 20:32:50","2023-04-07 20:32:50"),
("3671","1233","action created","2023-04-07 20:32:50","2023-04-07 20:32:50"),
("3675","1233","action started via Async Request","2023-04-08 05:19:50","2023-04-08 05:19:50"),
("3676","1233","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-08 05:19:50","2023-04-08 05:19:50"),
("3677","1235","action created","2023-04-08 05:19:50","2023-04-08 05:19:50"),
("3684","1219","action started via Async Request","2023-04-08 05:19:50","2023-04-08 05:19:50"),
("3685","1219","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-08 05:19:50","2023-04-08 05:19:50"),
("3686","1238","action created","2023-04-08 05:19:50","2023-04-08 05:19:50"),
("3696","1235","action started via Async Request","2023-04-08 08:54:44","2023-04-08 08:54:44"),
("3697","1235","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-08 08:54:44","2023-04-08 08:54:44"),
("3698","1242","action created","2023-04-08 08:54:44","2023-04-08 08:54:44"),
("3702","1242","action started via Async Request","2023-04-08 11:26:17","2023-04-08 11:26:17"),
("3703","1242","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-08 11:26:17","2023-04-08 11:26:17"),
("3704","1244","action created","2023-04-08 11:26:17","2023-04-08 11:26:17"),
("3708","1244","action started via Async Request","2023-04-08 15:36:38","2023-04-08 15:36:38"),
("3709","1244","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-08 15:36:38","2023-04-08 15:36:38"),
("3710","1246","action created","2023-04-08 15:36:38","2023-04-08 15:36:38"),
("3714","1246","action started via Async Request","2023-04-09 06:58:58","2023-04-09 06:58:58"),
("3715","1246","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-09 06:58:58","2023-04-09 06:58:58"),
("3716","1248","action created","2023-04-09 06:58:58","2023-04-09 06:58:58"),
("3723","1238","action started via Async Request","2023-04-09 06:58:58","2023-04-09 06:58:58"),
("3724","1238","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-09 06:58:58","2023-04-09 06:58:58"),
("3725","1251","action created","2023-04-09 06:58:58","2023-04-09 06:58:58"),
("3729","1248","action started via Async Request","2023-04-09 11:09:28","2023-04-09 11:09:28"),
("3730","1248","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-09 11:09:28","2023-04-09 11:09:28"),
("3731","1253","action created","2023-04-09 11:09:28","2023-04-09 11:09:28"),
("3735","1253","action started via Async Request","2023-04-09 16:08:24","2023-04-09 16:08:24"),
("3736","1253","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-09 16:08:24","2023-04-09 16:08:24"),
("3737","1255","action created","2023-04-09 16:08:24","2023-04-09 16:08:24"),
("3741","1255","action started via Async Request","2023-04-10 02:52:13","2023-04-10 02:52:13"),
("3742","1255","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-10 02:52:13","2023-04-10 02:52:13"),
("3743","1257","action created","2023-04-10 02:52:13","2023-04-10 02:52:13"),
("3747","1257","action started via Async Request","2023-04-10 08:21:31","2023-04-10 08:21:31"),
("3748","1257","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-10 08:21:31","2023-04-10 08:21:31"),
("3749","1259","action created","2023-04-10 08:21:31","2023-04-10 08:21:31"),
("3756","1251","action started via Async Request","2023-04-10 08:21:31","2023-04-10 08:21:31"),
("3757","1251","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-10 08:21:31","2023-04-10 08:21:31"),
("3758","1262","action created","2023-04-10 08:21:31","2023-04-10 08:21:31"),
("3762","1259","action started via Async Request","2023-04-10 19:25:20","2023-04-10 19:25:20"),
("3763","1259","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-10 19:25:20","2023-04-10 19:25:20"),
("3764","1264","action created","2023-04-10 19:25:20","2023-04-10 19:25:20"),
("3768","1264","action started via Async Request","2023-04-10 20:55:38","2023-04-10 20:55:38"),
("3769","1264","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-10 20:55:38","2023-04-10 20:55:38"),
("3770","1266","action created","2023-04-10 20:55:38","2023-04-10 20:55:38"),
("3774","1266","action started via Async Request","2023-04-11 00:31:11","2023-04-11 00:31:11"),
("3775","1266","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-11 00:31:11","2023-04-11 00:31:11"),
("3776","1268","action created","2023-04-11 00:31:11","2023-04-11 00:31:11"),
("3780","1268","action started via Async Request","2023-04-11 13:10:47","2023-04-11 13:10:47"),
("3781","1268","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-11 13:10:47","2023-04-11 13:10:47"),
("3782","1270","action created","2023-04-11 13:10:47","2023-04-11 13:10:47"),
("3789","1262","action started via Async Request","2023-04-11 13:10:47","2023-04-11 13:10:47"),
("3790","1262","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-11 13:10:47","2023-04-11 13:10:47"),
("3791","1273","action created","2023-04-11 13:10:47","2023-04-11 13:10:47"),
("3795","1270","action started via Async Request","2023-04-11 19:44:32","2023-04-11 19:44:32"),
("3796","1270","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-11 19:44:32","2023-04-11 19:44:32"),
("3797","1275","action created","2023-04-11 19:44:32","2023-04-11 19:44:32"),
("3801","1275","action started via Async Request","2023-04-11 21:34:41","2023-04-11 21:34:41"),
("3802","1275","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-11 21:34:41","2023-04-11 21:34:41"),
("3803","1277","action created","2023-04-11 21:34:41","2023-04-11 21:34:41"),
("3807","1277","action started via Async Request","2023-04-11 23:25:30","2023-04-11 23:25:30"),
("3808","1277","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-11 23:25:30","2023-04-11 23:25:30"),
("3809","1279","action created","2023-04-11 23:25:30","2023-04-11 23:25:30"),
("3816","1279","action started via Async Request","2023-04-12 12:59:27","2023-04-12 12:59:27"),
("3817","1279","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-12 12:59:27","2023-04-12 12:59:27"),
("3818","1282","action created","2023-04-12 12:59:27","2023-04-12 12:59:27"),
("3828","1273","action started via Async Request","2023-04-12 19:04:16","2023-04-12 19:04:16"),
("3829","1273","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-12 19:04:16","2023-04-12 19:04:16"),
("3830","1286","action created","2023-04-12 19:04:16","2023-04-12 19:04:16"),
("3831","1282","action started via Async Request","2023-04-12 19:04:16","2023-04-12 19:04:16"),
("3832","1282","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-12 19:04:16","2023-04-12 19:04:16"),
("3833","1287","action created","2023-04-12 19:04:16","2023-04-12 19:04:16"),
("3837","1287","action started via Async Request","2023-04-12 22:46:33","2023-04-12 22:46:33"),
("3838","1287","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-12 22:46:33","2023-04-12 22:46:33"),
("3839","1289","action created","2023-04-12 22:46:33","2023-04-12 22:46:33"),
("3843","1289","action started via Async Request","2023-04-13 00:16:40","2023-04-13 00:16:40"),
("3844","1289","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-13 00:16:40","2023-04-13 00:16:40"),
("3845","1291","action created","2023-04-13 00:16:40","2023-04-13 00:16:40"),
("3849","1291","action started via Async Request","2023-04-13 03:16:45","2023-04-13 03:16:45"),
("3850","1291","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-13 03:16:45","2023-04-13 03:16:45"),
("3851","1293","action created","2023-04-13 03:16:45","2023-04-13 03:16:45"),
("3855","1293","action started via Async Request","2023-04-13 05:39:39","2023-04-13 05:39:39"),
("3856","1293","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-13 05:39:39","2023-04-13 05:39:39"),
("3857","1295","action created","2023-04-13 05:39:39","2023-04-13 05:39:39"),
("3861","1295","action started via Async Request","2023-04-13 18:54:12","2023-04-13 18:54:12"),
("3862","1295","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-13 18:54:12","2023-04-13 18:54:12"),
("3863","1297","action created","2023-04-13 18:54:12","2023-04-13 18:54:12"),
("3873","1286","action started via Async Request","2023-04-14 19:50:09","2023-04-14 19:50:09"),
("3874","1286","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-14 19:50:09","2023-04-14 19:50:09"),
("3875","1301","action created","2023-04-14 19:50:09","2023-04-14 19:50:09"),
("3876","1297","action started via Async Request","2023-04-14 19:50:09","2023-04-14 19:50:09"),
("3877","1297","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-14 19:50:09","2023-04-14 19:50:09"),
("3878","1302","action created","2023-04-14 19:50:09","2023-04-14 19:50:09"),
("3882","1302","action started via Async Request","2023-04-14 21:20:19","2023-04-14 21:20:19"),
("3883","1302","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-14 21:20:19","2023-04-14 21:20:19"),
("3884","1304","action created","2023-04-14 21:20:19","2023-04-14 21:20:19"),
("3888","1304","action started via Async Request","2023-04-15 02:57:41","2023-04-15 02:57:41"),
("3889","1304","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-15 02:57:41","2023-04-15 02:57:41"),
("3890","1306","action created","2023-04-15 02:57:41","2023-04-15 02:57:41"),
("3894","1306","action started via Async Request","2023-04-15 04:42:00","2023-04-15 04:42:00"),
("3895","1306","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-15 04:42:00","2023-04-15 04:42:00"),
("3896","1308","action created","2023-04-15 04:42:00","2023-04-15 04:42:00"),
("3900","1308","action started via Async Request","2023-04-15 19:05:53","2023-04-15 19:05:53"),
("3901","1308","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-15 19:05:53","2023-04-15 19:05:53"),
("3902","1310","action created","2023-04-15 19:05:53","2023-04-15 19:05:53"),
("3912","1301","action started via Async Request","2023-04-16 19:03:33","2023-04-16 19:03:33"),
("3913","1301","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-16 19:03:33","2023-04-16 19:03:33"),
("3914","1314","action created","2023-04-16 19:03:33","2023-04-16 19:03:33"),
("3915","1310","action started via Async Request","2023-04-16 19:03:33","2023-04-16 19:03:33"),
("3916","1310","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-16 19:03:33","2023-04-16 19:03:33"),
("3917","1315","action created","2023-04-16 19:03:33","2023-04-16 19:03:33"),
("3921","1315","action started via Async Request","2023-04-17 19:04:52","2023-04-17 19:04:52"),
("3922","1315","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-17 19:04:52","2023-04-17 19:04:52"),
("3923","1317","action created","2023-04-17 19:04:52","2023-04-17 19:04:52"),
("3930","1314","action started via Async Request","2023-04-17 19:04:52","2023-04-17 19:04:52"),
("3931","1314","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_daily_heartbeat will not be executed as no callbacks are registered.","2023-04-17 19:04:52","2023-04-17 19:04:52"),
("3932","1314","This action appears to be consistently failing. A new instance will not be scheduled.","2023-04-17 19:04:52","2023-04-17 19:04:52"),
("3936","1317","action started via Async Request","2023-04-18 11:51:44","2023-04-18 11:51:44"),
("3937","1317","action failed via Async Request: Scheduled action for pinterest_for_woocommerce_hourly_heartbeat will not be executed as no callbacks are registered.","2023-04-18 11:51:44","2023-04-18 11:51:44"),
("3938","1317","This action appears to be consistently failing. A new instance will not be scheduled.","2023-04-18 11:51:44","2023-04-18 11:51:44"),
("4147","1391","action created","2023-04-27 19:47:22","2023-04-27 19:47:22"),
("4151","1391","action started via Async Request","2023-04-27 19:48:25","2023-04-27 19:48:25"),
("4152","1391","action failed via Async Request: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.","2023-04-27 19:48:25","2023-04-27 19:48:25"),
("5329","1785","action created","2023-05-16 18:10:57","2023-05-16 18:10:57"),
("5335","1785","action started via Async Request","2023-05-16 18:10:58","2023-05-16 18:10:58"),
("5336","1785","action failed via Async Request: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.","2023-05-16 18:10:58","2023-05-16 18:10:58"),
("6319","2115","action created","2023-06-03 11:16:15","2023-06-03 11:16:15"),
("6323","2115","action started via Async Request","2023-06-03 11:16:16","2023-06-03 11:16:16"),
("6324","2115","action failed via Async Request: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.","2023-06-03 11:16:16","2023-06-03 11:16:16"),
("6327","2117","action created","2023-06-03 11:16:20","2023-06-03 11:16:20"),
("6328","2117","action started via Async Request","2023-06-03 11:16:23","2023-06-03 11:16:23"),
("6329","2117","action failed via Async Request: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.","2023-06-03 11:16:23","2023-06-03 11:16:23"),
("7710","2578","action created","2023-09-09 13:08:07","2023-09-09 13:08:07"),
("7720","2578","action started via Async Request","2023-09-09 14:18:30","2023-09-09 14:18:30"),
("7721","2578","action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.","2023-09-19 00:06:38","2023-09-19 00:06:38"),
("8748","2924","action created","2023-10-03 12:32:02","2023-10-03 12:32:02"),
("8760","2924","action started via Async Request","2023-10-03 12:33:46","2023-10-03 12:33:46"),
("8776","2924","action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.","2023-10-03 12:39:55","2023-10-03 12:39:55"),
("8810","2940","action created","2023-10-03 12:47:20","2023-10-03 12:47:20"),
("8813","2940","action started via Async Request","2023-10-03 12:47:42","2023-10-03 12:47:42"),
("8834","2940","action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.","2023-10-03 14:27:14","2023-10-03 14:27:14"),
("9337","3115","action created","2023-10-10 14:31:50","2023-10-10 14:31:50"),
("9349","3115","action started via Async Request","2023-10-10 14:31:52","2023-10-10 14:31:52"),
("9361","3115","action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.","2023-10-10 16:07:17","2023-10-10 16:07:17"),
("9600","3199","action created","2023-10-14 13:38:22","2023-10-14 13:38:22"),
("9601","3199","action started via Async Request","2023-10-14 13:38:23","2023-10-14 13:38:23"),
("9602","3199","action marked as failed after 300 seconds. Unknown error occurred. Check server, PHP and database error logs to diagnose cause.","2023-10-14 16:39:39","2023-10-14 16:39:39"),
("9923","3306","action created","2023-10-19 10:39:17","2023-10-19 10:39:17"),
("9926","3307","action created","2023-10-19 10:39:17","2023-10-19 10:39:17"),
("9999","3306","action started via WP Cron","2023-10-28 21:21:36","2023-10-28 21:21:36"),
("10000","3306","action complete via WP Cron","2023-10-28 21:21:36","2023-10-28 21:21:36"),
("10001","3332","action created","2023-10-28 21:21:36","2023-10-28 21:21:36"),
("10002","3307","action started via WP Cron","2023-10-28 21:21:36","2023-10-28 21:21:36"),
("10003","3307","action complete via WP Cron","2023-10-28 21:21:36","2023-10-28 21:21:36"),
("10004","3333","action created","2023-10-28 21:21:36","2023-10-28 21:21:36"),
("10074","3332","action started via WP Cron","2023-10-29 21:45:43","2023-10-29 21:45:43"),
("10075","3332","action complete via WP Cron","2023-10-29 21:45:43","2023-10-29 21:45:43"),
("10076","3357","action created","2023-10-29 21:45:43","2023-10-29 21:45:43"),
("10077","3333","action started via WP Cron","2023-10-29 21:45:43","2023-10-29 21:45:43"),
("10078","3333","action complete via WP Cron","2023-10-29 21:45:43","2023-10-29 21:45:43"),
("10079","3358","action created","2023-10-29 21:45:43","2023-10-29 21:45:43"),
("10116","3357","action started via WP Cron","2023-10-30 22:32:05","2023-10-30 22:32:05"),
("10117","3357","action complete via WP Cron","2023-10-30 22:32:05","2023-10-30 22:32:05"),
("10118","3371","action created","2023-10-30 22:32:05","2023-10-30 22:32:05"),
("10119","3358","action started via WP Cron","2023-10-30 22:32:05","2023-10-30 22:32:05"),
("10120","3358","action complete via WP Cron","2023-10-30 22:32:05","2023-10-30 22:32:05"),
("10121","3372","action created","2023-10-30 22:32:05","2023-10-30 22:32:05"),
("10159","3371","action started via WP Cron","2023-10-31 23:09:49","2023-10-31 23:09:49"),
("10160","3371","action complete via WP Cron","2023-10-31 23:09:49","2023-10-31 23:09:49"),
("10161","3386","action created","2023-10-31 23:09:49","2023-10-31 23:09:49"),
("10162","3372","action started via WP Cron","2023-10-31 23:09:49","2023-10-31 23:09:49"),
("10163","3372","action complete via WP Cron","2023-10-31 23:09:49","2023-10-31 23:09:49"),
("10164","3387","action created","2023-10-31 23:09:49","2023-10-31 23:09:49"),
("10239","3386","action started via WP Cron","2023-11-02 00:08:29","2023-11-02 00:08:29"),
("10240","3386","action complete via WP Cron","2023-11-02 00:08:29","2023-11-02 00:08:29"),
("10241","3412","action created","2023-11-02 00:08:29","2023-11-02 00:08:29"),
("10242","3387","action started via WP Cron","2023-11-02 00:08:29","2023-11-02 00:08:29"),
("10243","3387","action complete via WP Cron","2023-11-02 00:08:29","2023-11-02 00:08:29"),
("10244","3413","action created","2023-11-02 00:08:29","2023-11-02 00:08:29"),
("10296","3412","action started via WP Cron","2023-11-03 00:19:03","2023-11-03 00:19:03"),
("10297","3412","action complete via WP Cron","2023-11-03 00:19:03","2023-11-03 00:19:03"),
("10298","3431","action created","2023-11-03 00:19:03","2023-11-03 00:19:03"),
("10299","3413","action started via WP Cron","2023-11-03 00:19:03","2023-11-03 00:19:03"),
("10300","3413","action complete via WP Cron","2023-11-03 00:19:03","2023-11-03 00:19:03"),
("10301","3432","action created","2023-11-03 00:19:03","2023-11-03 00:19:03"),
("10320","3431","action started via WP Cron","2023-11-04 00:27:07","2023-11-04 00:27:07"),
("10321","3431","action complete via WP Cron","2023-11-04 00:27:07","2023-11-04 00:27:07"),
("10322","3439","action created","2023-11-04 00:27:07","2023-11-04 00:27:07"),
("10323","3432","action started via WP Cron","2023-11-04 00:27:07","2023-11-04 00:27:07"),
("10324","3432","action complete via WP Cron","2023-11-04 00:27:07","2023-11-04 00:27:07"),
("10325","3440","action created","2023-11-04 00:27:07","2023-11-04 00:27:07"),
("10362","3439","action started via WP Cron","2023-11-05 00:49:42","2023-11-05 00:49:42"),
("10363","3439","action complete via WP Cron","2023-11-05 00:49:42","2023-11-05 00:49:42"),
("10364","3453","action created","2023-11-05 00:49:42","2023-11-05 00:49:42"),
("10365","3440","action started via WP Cron","2023-11-05 00:49:42","2023-11-05 00:49:42"),
("10366","3440","action complete via WP Cron","2023-11-05 00:49:42","2023-11-05 00:49:42"),
("10367","3454","action created","2023-11-05 00:49:42","2023-11-05 00:49:42"),
("10389","3453","action started via WP Cron","2023-11-06 01:41:44","2023-11-06 01:41:44"),
("10390","3453","action complete via WP Cron","2023-11-06 01:41:44","2023-11-06 01:41:44"),
("10391","3462","action created","2023-11-06 01:41:44","2023-11-06 01:41:44"),
("10392","3454","action started via WP Cron","2023-11-06 01:41:44","2023-11-06 01:41:44"),
("10393","3454","action complete via WP Cron","2023-11-06 01:41:44","2023-11-06 01:41:44"),
("10394","3463","action created","2023-11-06 01:41:44","2023-11-06 01:41:44"),
("10431","3462","action started via WP Cron","2023-11-07 01:43:29","2023-11-07 01:43:29"),
("10432","3462","action complete via WP Cron","2023-11-07 01:43:29","2023-11-07 01:43:29"),
("10433","3476","action created","2023-11-07 01:43:29","2023-11-07 01:43:29"),
("10434","3463","action started via WP Cron","2023-11-07 01:43:29","2023-11-07 01:43:29"),
("10435","3463","action complete via WP Cron","2023-11-07 01:43:29","2023-11-07 01:43:29"),
("10436","3477","action created","2023-11-07 01:43:29","2023-11-07 01:43:29"),
("10476","3476","action started via WP Cron","2023-11-08 03:44:37","2023-11-08 03:44:37"),
("10477","3476","action complete via WP Cron","2023-11-08 03:44:37","2023-11-08 03:44:37"),
("10478","3491","action created","2023-11-08 03:44:37","2023-11-08 03:44:37"),
("10479","3477","action started via WP Cron","2023-11-08 03:44:37","2023-11-08 03:44:37"),
("10480","3477","action complete via WP Cron","2023-11-08 03:44:37","2023-11-08 03:44:37"),
("10481","3492","action created","2023-11-08 03:44:37","2023-11-08 03:44:37"),
("10524","3491","action started via WP Cron","2023-11-09 03:49:46","2023-11-09 03:49:46"),
("10525","3491","action complete via WP Cron","2023-11-09 03:49:46","2023-11-09 03:49:46"),
("10526","3507","action created","2023-11-09 03:49:46","2023-11-09 03:49:46"),
("10527","3492","action started via WP Cron","2023-11-09 03:49:46","2023-11-09 03:49:46"),
("10528","3492","action complete via WP Cron","2023-11-09 03:49:46","2023-11-09 03:49:46"),
("10529","3508","action created","2023-11-09 03:49:46","2023-11-09 03:49:46"),
("10530","3507","action started via WP Cron","2023-11-10 03:51:14","2023-11-10 03:51:14"),
("10531","3507","action complete via WP Cron","2023-11-10 03:51:14","2023-11-10 03:51:14"),
("10532","3509","action created","2023-11-10 03:51:14","2023-11-10 03:51:14"),
("10533","3508","action started via WP Cron","2023-11-10 03:51:14","2023-11-10 03:51:14"),
("10534","3508","action complete via WP Cron","2023-11-10 03:51:14","2023-11-10 03:51:14"),
("10535","3510","action created","2023-11-10 03:51:14","2023-11-10 03:51:14"),
("10539","3509","action started via WP Cron","2023-11-11 05:30:19","2023-11-11 05:30:19"),
("10540","3509","action complete via WP Cron","2023-11-11 05:30:19","2023-11-11 05:30:19"),
("10541","3512","action created","2023-11-11 05:30:19","2023-11-11 05:30:19"),
("10542","3510","action started via WP Cron","2023-11-11 05:30:19","2023-11-11 05:30:19"),
("10543","3510","action complete via WP Cron","2023-11-11 05:30:19","2023-11-11 05:30:19"),
("10544","3513","action created","2023-11-11 05:30:19","2023-11-11 05:30:19"),
("10545","3512","action started via WP Cron","2023-11-12 08:06:24","2023-11-12 08:06:24"),
("10546","3512","action complete via WP Cron","2023-11-12 08:06:24","2023-11-12 08:06:24"),
("10547","3514","action created","2023-11-12 08:06:24","2023-11-12 08:06:24"),
("10548","3513","action started via WP Cron","2023-11-12 08:06:24","2023-11-12 08:06:24"),
("10549","3513","action complete via WP Cron","2023-11-12 08:06:24","2023-11-12 08:06:24"),
("10550","3515","action created","2023-11-12 08:06:24","2023-11-12 08:06:24"),
("10551","3514","action started via WP Cron","2023-11-13 08:18:13","2023-11-13 08:18:13"),
("10552","3514","action complete via WP Cron","2023-11-13 08:18:13","2023-11-13 08:18:13"),
("10553","3516","action created","2023-11-13 08:18:13","2023-11-13 08:18:13"),
("10554","3515","action started via WP Cron","2023-11-13 08:18:13","2023-11-13 08:18:13"),
("10555","3515","action complete via WP Cron","2023-11-13 08:18:13","2023-11-13 08:18:13"),
("10556","3517","action created","2023-11-13 08:18:13","2023-11-13 08:18:13"),
("10557","3516","action started via WP Cron","2023-11-14 10:20:30","2023-11-14 10:20:30"),
("10558","3516","action complete via WP Cron","2023-11-14 10:20:30","2023-11-14 10:20:30"),
("10559","3518","action created","2023-11-14 10:20:30","2023-11-14 10:20:30"),
("10560","3517","action started via WP Cron","2023-11-14 10:20:30","2023-11-14 10:20:30"),
("10561","3517","action complete via WP Cron","2023-11-14 10:20:30","2023-11-14 10:20:30"),
("10562","3519","action created","2023-11-14 10:20:30","2023-11-14 10:20:30"),
("10563","3518","action started via WP Cron","2023-11-15 10:48:50","2023-11-15 10:48:50"),
("10564","3518","action complete via WP Cron","2023-11-15 10:48:50","2023-11-15 10:48:50"),
("10565","3520","action created","2023-11-15 10:48:50","2023-11-15 10:48:50"),
("10566","3519","action started via WP Cron","2023-11-15 10:48:50","2023-11-15 10:48:50"),
("10567","3519","action complete via WP Cron","2023-11-15 10:48:50","2023-11-15 10:48:50"),
("10568","3521","action created","2023-11-15 10:48:50","2023-11-15 10:48:50"),
("10569","3520","action started via WP Cron","2023-11-16 11:59:38","2023-11-16 11:59:38"),
("10570","3520","action complete via WP Cron","2023-11-16 11:59:38","2023-11-16 11:59:38"),
("10571","3522","action created","2023-11-16 11:59:38","2023-11-16 11:59:38"),
("10572","3521","action started via WP Cron","2023-11-16 11:59:38","2023-11-16 11:59:38"),
("10573","3521","action complete via WP Cron","2023-11-16 11:59:38","2023-11-16 11:59:38"),
("10574","3523","action created","2023-11-16 11:59:38","2023-11-16 11:59:38"),
("10575","3522","action started via WP Cron","2023-11-17 13:35:25","2023-11-17 13:35:25"),
("10576","3522","action complete via WP Cron","2023-11-17 13:35:25","2023-11-17 13:35:25"),
("10577","3524","action created","2023-11-17 13:35:25","2023-11-17 13:35:25"),
("10578","3523","action started via WP Cron","2023-11-17 13:35:25","2023-11-17 13:35:25"),
("10579","3523","action complete via WP Cron","2023-11-17 13:35:25","2023-11-17 13:35:25"),
("10580","3525","action created","2023-11-17 13:35:25","2023-11-17 13:35:25"),
("10581","3524","action started via WP Cron","2023-11-18 13:44:47","2023-11-18 13:44:47"),
("10582","3524","action complete via WP Cron","2023-11-18 13:44:47","2023-11-18 13:44:47"),
("10583","3526","action created","2023-11-18 13:44:47","2023-11-18 13:44:47"),
("10584","3525","action started via WP Cron","2023-11-18 13:44:47","2023-11-18 13:44:47"),
("10585","3525","action complete via WP Cron","2023-11-18 13:44:47","2023-11-18 13:44:47"),
("10586","3527","action created","2023-11-18 13:44:47","2023-11-18 13:44:47"),
("10587","3526","action started via WP Cron","2023-11-19 15:14:49","2023-11-19 15:14:49"),
("10588","3526","action complete via WP Cron","2023-11-19 15:14:49","2023-11-19 15:14:49"),
("10589","3528","action created","2023-11-19 15:14:49","2023-11-19 15:14:49"),
("10590","3527","action started via WP Cron","2023-11-19 15:14:49","2023-11-19 15:14:49"),
("10591","3527","action complete via WP Cron","2023-11-19 15:14:49","2023-11-19 15:14:49"),
("10592","3529","action created","2023-11-19 15:14:49","2023-11-19 15:14:49"),
("10593","3528","action started via WP Cron","2023-11-20 15:21:05","2023-11-20 15:21:05"),
("10594","3528","action complete via WP Cron","2023-11-20 15:21:05","2023-11-20 15:21:05"),
("10595","3530","action created","2023-11-20 15:21:05","2023-11-20 15:21:05"),
("10596","3529","action started via WP Cron","2023-11-20 15:21:05","2023-11-20 15:21:05"),
("10597","3529","action complete via WP Cron","2023-11-20 15:21:05","2023-11-20 15:21:05"),
("10598","3531","action created","2023-11-20 15:21:05","2023-11-20 15:21:05"),
("10599","3530","action started via WP Cron","2023-11-21 16:04:14","2023-11-21 16:04:14"),
("10600","3530","action complete via WP Cron","2023-11-21 16:04:14","2023-11-21 16:04:14"),
("10601","3532","action created","2023-11-21 16:04:14","2023-11-21 16:04:14"),
("10602","3531","action started via WP Cron","2023-11-21 16:04:14","2023-11-21 16:04:14"),
("10603","3531","action complete via WP Cron","2023-11-21 16:04:14","2023-11-21 16:04:14"),
("10604","3533","action created","2023-11-21 16:04:14","2023-11-21 16:04:14"),
("10605","3532","action started via WP Cron","2023-11-22 18:01:59","2023-11-22 18:01:59"),
("10606","3532","action complete via WP Cron","2023-11-22 18:01:59","2023-11-22 18:01:59"),
("10607","3534","action created","2023-11-22 18:01:59","2023-11-22 18:01:59"),
("10608","3533","action started via WP Cron","2023-11-22 18:01:59","2023-11-22 18:01:59"),
("10609","3533","action complete via WP Cron","2023-11-22 18:01:59","2023-11-22 18:01:59"),
("10610","3535","action created","2023-11-22 18:01:59","2023-11-22 18:01:59"),
("10611","3534","action started via WP Cron","2023-11-23 18:28:19","2023-11-23 18:28:19"),
("10612","3534","action complete via WP Cron","2023-11-23 18:28:19","2023-11-23 18:28:19"),
("10613","3536","action created","2023-11-23 18:28:19","2023-11-23 18:28:19"),
("10614","3535","action started via WP Cron","2023-11-23 18:28:19","2023-11-23 18:28:19"),
("10615","3535","action complete via WP Cron","2023-11-23 18:28:19","2023-11-23 18:28:19"),
("10616","3537","action created","2023-11-23 18:28:19","2023-11-23 18:28:19"),
("10617","3538","action created","2023-11-23 19:08:04","2023-11-23 19:08:04"),
("10618","3539","action created","2023-11-23 19:08:30","2023-11-23 19:08:30"),
("10619","3540","action created","2023-11-23 19:08:31","2023-11-23 19:08:31"),
("10620","3541","action created","2023-11-23 19:08:33","2023-11-23 19:08:33"),
("10621","3539","action started via WP Cron","2023-11-23 19:08:33","2023-11-23 19:08:33"),
("10622","3539","action complete via WP Cron","2023-11-23 19:08:33","2023-11-23 19:08:33"),
("10623","3540","action started via WP Cron","2023-11-23 19:08:33","2023-11-23 19:08:33"),
("10624","3540","action complete via WP Cron","2023-11-23 19:08:33","2023-11-23 19:08:33"),
("10625","3541","action started via WP Cron","2023-11-23 19:08:33","2023-11-23 19:08:33"),
("10626","3541","action complete via WP Cron","2023-11-23 19:08:34","2023-11-23 19:08:34"),
("10627","3542","action created","2023-11-23 19:10:00","2023-11-23 19:10:00"),
("10628","3538","action started via WP Cron","2023-11-23 19:10:00","2023-11-23 19:10:00"),
("10629","3543","action created","2023-11-23 19:10:00","2023-11-23 19:10:00"),
("10630","3538","action complete via WP Cron","2023-11-23 19:10:00","2023-11-23 19:10:00"),
("10631","3542","action started via WP Cron","2023-11-23 19:10:00","2023-11-23 19:10:00"),
("10632","3542","action complete via WP Cron","2023-11-23 19:10:02","2023-11-23 19:10:02"),
("10633","3543","action started via WP Cron","2023-11-23 19:11:00","2023-11-23 19:11:00"),
("10634","3543","action complete via WP Cron","2023-11-23 19:11:00","2023-11-23 19:11:00");

INSERT IGNORE INTO `wp_comments` VALUES 
("3","281","WooCommerce","woocommerce@bavance.com","","","2023-03-24 19:03:51","2023-03-24 19:03:51","Coinbase payment cancelled. Order status changed from Pending payment to Cancelled.","0","1","WooCommerce","order_note","0","0"),
("5","489","WooCommerce","woocommerce@bavance.com","","","2023-09-19 00:07:16","2023-09-19 00:07:16","Unpaid order cancelled - time limit reached. Order status changed from Pending payment to Cancelled.","0","1","WooCommerce","order_note","0","0"),
("6","526","WooCommerce","woocommerce@bavance.com","","","2023-09-19 00:07:16","2023-09-19 00:07:16","Unpaid order cancelled - time limit reached. Order status changed from Pending payment to Cancelled.","0","1","WooCommerce","order_note","0","0"),
("7","537","WooCommerce","woocommerce@bavance.com","","","2023-09-19 00:07:16","2023-09-19 00:07:16","Unpaid order cancelled - time limit reached. Order status changed from Pending payment to Cancelled.","0","1","WooCommerce","order_note","0","0");

INSERT IGNORE INTO `wp_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"alirezadehkar@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/bavance.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"local_upload_chunksize_in_MB\": 16,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": -1,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"license_type\": -1,\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1700750786,\n    \"initial_activation_timestamp\": 1684924855,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2\n}"),
("3","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"v4FW216G+jT6Bz+a6aY7onp25+p242l37EBZEXu1IGJ5PHMy8a4NE+8MgCYTr+S6CUkU28WeyDZEW90Ie\\/coig==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 3\n}"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"UdGWH1twk20BVLoNoGNHvpEu89HYYXfzujHy90JhpRKDz3wGeKiBLQElFP5R553oy5CATOL9mLqFumJuPLybVQ==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 4\n}"),
("5","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1700767002,\n    \"id\": 5\n}");

INSERT IGNORE INTO `wp_duplicator_pro_packages` VALUES 
("2","20231123_bavance","bc3fab77015e57572372_20231123191524","20","2023-11-23 19:16:29","alirezadehkar","{\n    \"ID\": 2,\n    \"Created\": \"2023-11-23 19:15:24\",\n    \"Version\": \"4.5.10\",\n    \"VersionWP\": \"6.4.1\",\n    \"VersionDB\": \"8.0.34\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231123_bavance\",\n    \"Hash\": \"bc3fab77015e57572372_20231123191524\",\n    \"NameHash\": \"20231123_bavance_bc3fab77015e57572372_20231123191524\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/bavancec\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/bavance.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231123_bavance_bc3fab77015e57572372_20231123191524_scan.json\",\n    \"timer_start\": 1700767003.7070639133453369140625,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/bavancec\\/public_html\\/.opcache\",\n            \"\\/home\\/bavancec\\/public_html\\/.tmb\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/bavancec\\/public_html\\/.htaccess\",\n            \"\\/home\\/bavancec\\/public_html\\/.user.ini\",\n            \"\\/home\\/bavancec\\/public_html\\/php.ini\",\n            \"\\/home\\/bavancec\\/public_html\\/web.config\",\n            \"\\/home\\/bavancec\\/public_html\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231123_bavance_bc3fab77015e57572372_20231123191524_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/bavancec\\/public_html\",\n        \"Size\": 759572745,\n        \"Dirs\": null,\n        \"DirCount\": 10096,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 73076,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20231123_bavance_bc3fab77015e57572372_20231123191524_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"PNe2+GvIwOwr7E\\/88cnWRmotI0pbQQSyflDB4lnkVLP1DfGVBt5K30xQYiY8w2f7S3TUapHpv0X0HxFv2oEhMQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"bavancec_smain\",\n            \"tablesBaseCount\": 118,\n            \"tablesFinalCount\": 118,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 9034,\n            \"tablesSizeOnDisk\": 34373632,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": 221,\n                    \"insertedRows\": false,\n                    \"size\": 245760\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": 676,\n                    \"insertedRows\": false,\n                    \"size\": 147456\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 294912\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 131072\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_gla_attribute_mapping_rules\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_gla_budget_recommendations\": {\n                    \"inaccurateRows\": 4230,\n                    \"insertedRows\": false,\n                    \"size\": 376832\n                },\n                \"wp_gla_merchant_issues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_gla_shipping_rates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_gla_shipping_times\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_automation_run_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_automation_run_subjects\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_automation_runs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_automation_triggers\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_mailpoet_automation_versions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_automations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_mailpoet_custom_fields\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_dynamic_segment_filters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_feature_flags\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_forms\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_mailpoet_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_mailpoet_migrations\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_newsletter_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_mailpoet_newsletter_option\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_newsletter_option_fields\": {\n                    \"inaccurateRows\": 24,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_newsletter_posts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_newsletter_segment\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_newsletter_templates\": {\n                    \"inaccurateRows\": 69,\n                    \"insertedRows\": false,\n                    \"size\": 2637824\n                },\n                \"wp_mailpoet_newsletters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_scheduled_task_subscribers\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_scheduled_tasks\": {\n                    \"inaccurateRows\": 21,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_segments\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_sending_queues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_settings\": {\n                    \"inaccurateRows\": 16,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_statistics_bounces\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_mailpoet_statistics_clicks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_mailpoet_statistics_forms\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_statistics_newsletters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_statistics_opens\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 98304\n                },\n                \"wp_mailpoet_statistics_unsubscribes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_mailpoet_statistics_woocommerce_purchases\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_mailpoet_stats_notifications\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_subscriber_custom_field\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_subscriber_ips\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_subscriber_segment\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_subscriber_tag\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_mailpoet_subscribers\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 147456\n                },\n                \"wp_mailpoet_tags\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_user_agents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_mailpoet_user_flags\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 1152,\n                    \"insertedRows\": false,\n                    \"size\": 13254656\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 1706,\n                    \"insertedRows\": false,\n                    \"size\": 9814016\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 290,\n                    \"insertedRows\": false,\n                    \"size\": 2310144\n                },\n                \"wp_quform_entries\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_quform_entry_data\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_quform_entry_entry_labels\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_quform_entry_labels\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_quform_forms\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 98304\n                },\n                \"wp_quform_sessions\": {\n                    \"inaccurateRows\": 112,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 40,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 35,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 35,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_ulike\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_ulike_activities\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_ulike_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_ulike_forums\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_ulike_meta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 63,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"inaccurateRows\": 132,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wc_admin_notes\": {\n                    \"inaccurateRows\": 91,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wc_category_lookup\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_download_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_addresses\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wc_order_stats\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_orders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 131072\n                },\n                \"wp_wc_orders_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 114688\n                },\n                \"wp_wc_rate_limits\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_wc_webhooks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_woocommerce_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": 34,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 32768\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 49152\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 81920\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 65536\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 114688\n                },\n                \"wp_wpsurl_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpsurl_links_options\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpsurl_links_reports\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_wpsurl_links_statistics\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.34\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20231123_bavance_bc3fab77015e57572372_20231123191524_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/bavancec\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\\/20231123_bavance_bc3fab77015e57572372_20231123191524_database.sql\"\n    },\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1700767006,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_e_events\",\n            \"wp_e_submissions\",\n            \"wp_e_submissions_actions_log\",\n            \"wp_e_submissions_values\",\n            \"wp_gla_attribute_mapping_rules\",\n            \"wp_gla_budget_recommendations\",\n            \"wp_gla_merchant_issues\",\n            \"wp_gla_shipping_rates\",\n            \"wp_gla_shipping_times\",\n            \"wp_links\",\n            \"wp_mailpoet_automation_run_logs\",\n            \"wp_mailpoet_automation_run_subjects\",\n            \"wp_mailpoet_automation_runs\",\n            \"wp_mailpoet_automation_triggers\",\n            \"wp_mailpoet_automation_versions\",\n            \"wp_mailpoet_automations\",\n            \"wp_mailpoet_custom_fields\",\n            \"wp_mailpoet_dynamic_segment_filters\",\n            \"wp_mailpoet_feature_flags\",\n            \"wp_mailpoet_forms\",\n            \"wp_mailpoet_log\",\n            \"wp_mailpoet_migrations\",\n            \"wp_mailpoet_newsletter_links\",\n            \"wp_mailpoet_newsletter_option\",\n            \"wp_mailpoet_newsletter_option_fields\",\n            \"wp_mailpoet_newsletter_posts\",\n            \"wp_mailpoet_newsletter_segment\",\n            \"wp_mailpoet_newsletter_templates\",\n            \"wp_mailpoet_newsletters\",\n            \"wp_mailpoet_scheduled_task_subscribers\",\n            \"wp_mailpoet_scheduled_tasks\",\n            \"wp_mailpoet_segments\",\n            \"wp_mailpoet_sending_queues\",\n            \"wp_mailpoet_settings\",\n            \"wp_mailpoet_statistics_bounces\",\n            \"wp_mailpoet_statistics_clicks\",\n            \"wp_mailpoet_statistics_forms\",\n            \"wp_mailpoet_statistics_newsletters\",\n            \"wp_mailpoet_statistics_opens\",\n            \"wp_mailpoet_statistics_unsubscribes\",\n            \"wp_mailpoet_statistics_woocommerce_purchases\",\n            \"wp_mailpoet_stats_notifications\",\n            \"wp_mailpoet_subscriber_custom_field\",\n            \"wp_mailpoet_subscriber_ips\",\n            \"wp_mailpoet_subscriber_segment\",\n            \"wp_mailpoet_subscriber_tag\",\n            \"wp_mailpoet_subscribers\",\n            \"wp_mailpoet_tags\",\n            \"wp_mailpoet_user_agents\",\n            \"wp_mailpoet_user_flags\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_quform_entries\",\n            \"wp_quform_entry_data\",\n            \"wp_quform_entry_entry_labels\",\n            \"wp_quform_entry_labels\",\n            \"wp_quform_forms\",\n            \"wp_quform_sessions\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_ulike\",\n            \"wp_ulike_activities\",\n            \"wp_ulike_comments\",\n            \"wp_ulike_forums\",\n            \"wp_ulike_meta\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_order_addresses\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_operational_data\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_orders\",\n            \"wp_wc_orders_meta\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_wpr_rocket_cache\",\n            \"wp_wpr_rucss_used_css\",\n            \"wp_wpsurl_links\",\n            \"wp_wpsurl_links_options\",\n            \"wp_wpsurl_links_reports\",\n            \"wp_wpsurl_links_statistics\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1700767003.7261869907379150390625,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 9034,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_gla_attribute_mapping_rules\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_gla_budget_recommendations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_gla_merchant_issues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_gla_shipping_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_gla_shipping_times\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_automation_run_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_automation_run_subjects\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_automation_runs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_automation_triggers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_automation_versions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_automations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_custom_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_dynamic_segment_filters\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_feature_flags\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_migrations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_newsletter_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_newsletter_option\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_newsletter_option_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_newsletter_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_newsletter_segment\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_newsletter_templates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_newsletters\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_scheduled_task_subscribers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_scheduled_tasks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_segments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_sending_queues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_statistics_bounces\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_statistics_clicks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_statistics_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_statistics_newsletters\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_statistics_opens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_statistics_unsubscribes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_statistics_woocommerce_purchases\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_stats_notifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_subscriber_custom_field\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_subscriber_ips\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_subscriber_segment\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_subscriber_tag\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_subscribers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_tags\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_user_agents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mailpoet_user_flags\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_quform_entries\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_quform_entry_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_quform_entry_entry_labels\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_quform_entry_labels\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_quform_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_quform_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_ulike\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_ulike_activities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_ulike_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_ulike_forums\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_ulike_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_note_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_admin_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_category_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_customer_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_addresses\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_coupon_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_operational_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_product_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_stats\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_order_tax_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_orders_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_attributes_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_download_directories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_product_meta_lookup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_rate_limits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_reserved_stock\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_tax_rate_classes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpsurl_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpsurl_links_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpsurl_links_reports\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpsurl_links_statistics\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 4\n}");

INSERT IGNORE INTO `wp_gla_budget_recommendations` VALUES 
("1","AED","US","80","225"),
("2","AED","CH","75","195"),
("3","AED","AU","70","175"),
("4","AED","GB","60","150"),
("5","AED","DE","60","150"),
("6","AED","DK","55","135"),
("7","AED","AT","40","120"),
("8","AED","NO","45","125"),
("9","AED","CA","50","150"),
("10","AED","NL","55","135"),
("11","AED","SE","40","115"),
("12","AED","IE","40","110"),
("13","AED","BE","40","115"),
("14","AED","FI","30","85"),
("15","AED","FR","35","95"),
("16","AED","NZ","35","105"),
("17","AED","HK","35","95"),
("18","AED","CZ","30","75"),
("19","AED","SK","30","65"),
("20","AED","AE","30","90"),
("21","AED","SG","35","110"),
("22","AED","IL","30","80"),
("23","AED","KW","15","70"),
("24","AED","IT","20","55"),
("25","AED","JP","25","75"),
("26","AED","ES","20","60"),
("27","AED","VE","5","45"),
("28","AED","HU","20","45"),
("29","AED","PT","20","50"),
("30","AED","GR","25","45"),
("31","AED","KR","30","75"),
("32","AED","TW","25","60"),
("33","AED","PL","20","50"),
("34","AED","ZM","5","15"),
("35","AED","PR","5","65"),
("36","AED","CI","5","15"),
("37","AED","RO","20","45"),
("38","AED","BH","10","45"),
("39","AED","PA","5","65"),
("40","AED","GH","5","20"),
("41","AED","KH","5","20"),
("42","AED","SN","5","20"),
("43","AED","SA","10","45"),
("44","AED","RU","10","40"),
("45","AED","UG","5","15"),
("46","AED","BR","15","30"),
("47","AED","NI","5","20"),
("48","AED","MG","5","15"),
("49","AED","DO","5","25"),
("50","AED","MX","10","35"),
("51","AED","OM","5","35"),
("52","AED","CM","5","25"),
("53","AED","ZA","10","35"),
("54","AED","CL","10","35"),
("55","AED","KE","5","15"),
("56","AED","NP","5","15"),
("57","AED","PE","5","30"),
("58","AED","UA","5","20"),
("59","AED","MZ","5","30"),
("60","AED","TZ","5","10"),
("61","AED","AO","5","15"),
("62","AED","JO","5","20"),
("63","AED","ZW","5","15"),
("64","AED","TR","5","20"),
("65","AED","MU","5","15"),
("66","AED","SV","5","15"),
("67","AED","TH","10","35"),
("68","AED","CO","5","20"),
("69","AED","LK","5","10"),
("70","AED","CR","5","20"),
("71","AED","AR","5","20"),
("72","AED","MA","5","15"),
("73","AED","MY","10","35"),
("74","AED","KZ","5","15"),
("75","AED","DZ","5","10"),
("76","AED","ID","10","30"),
("77","AED","NG","5","30"),
("78","AED","GT","5","25"),
("79","AED","VN","5","25"),
("80","AED","BY","5","15"),
("81","AED","EG","5","25"),
("82","AED","UY","5","15"),
("83","AED","BD","5","10"),
("84","AED","PK","5","20"),
("85","AED","PH","5","20"),
("86","AED","ET","5","10"),
("87","AED","TN","5","10"),
("88","AED","LB","5","10"),
("89","AED","IN","5","15"),
("90","AED","PY","5","10"),
("91","AED","UZ","5","10"),
("92","AED","EC","5","10"),
("93","AED","MM","5","10"),
("94","AED","GE","5","10"),
("95","ARS","US","1860","5245"),
("96","ARS","CH","1735","4560"),
("97","ARS","AU","1575","4050"),
("98","ARS","GB","1375","3520"),
("99","ARS","DE","1365","3490"),
("100","ARS","DK","1255","3115"),
("101","ARS","AT","915","2845"),
("102","ARS","NO","1040","2900"),
("103","ARS","CA","1150","3520"),
("104","ARS","NL","1230","3115"),
("105","ARS","SE","985","2660"),
("106","ARS","IE","975","2565"),
("107","ARS","BE","895","2620"),
("108","ARS","FI","670","2030"),
("109","ARS","FR","830","2215"),
("110","ARS","NZ","845","2480"),
("111","ARS","HK","765","2165"),
("112","ARS","CZ","730","1755"),
("113","ARS","SK","690","1495"),
("114","ARS","AE","650","2040"),
("115","ARS","SG","850","2510"),
("116","ARS","IL","740","1810"),
("117","ARS","KW","335","1630"),
("118","ARS","IT","505","1330"),
("119","ARS","JP","630","1795"),
("120","ARS","ES","520","1370"),
("121","ARS","VE","70","1050"),
("122","ARS","HU","435","1015"),
("123","ARS","PT","435","1135"),
("124","ARS","GR","540","1100"),
("125","ARS","KR","665","1755"),
("126","ARS","TW","540","1440"),
("127","ARS","PL","460","1140"),
("128","ARS","ZM","65","380"),
("129","ARS","PR","165","1530"),
("130","ARS","CI","90","365"),
("131","ARS","RO","425","1025"),
("132","ARS","BH","190","1065"),
("133","ARS","PA","130","1465"),
("134","ARS","GH","155","430"),
("135","ARS","KH","90","425"),
("136","ARS","SN","65","465"),
("137","ARS","SA","275","1060"),
("138","ARS","RU","275","875"),
("139","ARS","UG","65","340"),
("140","ARS","BR","295","720"),
("141","ARS","NI","65","460"),
("142","ARS","MG","65","330"),
("143","ARS","DO","80","545"),
("144","ARS","MX","220","800"),
("145","ARS","OM","140","800"),
("146","ARS","CM","65","595"),
("147","ARS","ZA","265","845"),
("148","ARS","CL","275","820"),
("149","ARS","KE","80","340"),
("150","ARS","NP","65","310"),
("151","ARS","PE","165","690"),
("152","ARS","UA","155","490"),
("153","ARS","MZ","65","645"),
("154","ARS","TZ","10","150"),
("155","ARS","AO","145","370"),
("156","ARS","JO","105","500"),
("157","ARS","ZW","65","355"),
("158","ARS","TR","170","460"),
("159","ARS","MU","85","295"),
("160","ARS","SV","65","355"),
("161","ARS","TH","250","790"),
("162","ARS","CO","125","495"),
("163","ARS","LK","60","85"),
("164","ARS","CR","80","515"),
("165","ARS","AR","175","470"),
("166","ARS","MA","80","305"),
("167","ARS","MY","220","810"),
("168","ARS","KZ","95","345"),
("169","ARS","DZ","75","165"),
("170","ARS","ID","195","730"),
("171","ARS","NG","110","700"),
("172","ARS","GT","75","545"),
("173","ARS","VN","160","610"),
("174","ARS","BY","75","295"),
("175","ARS","EG","100","620"),
("176","ARS","UY","80","370"),
("177","ARS","BD","65","145"),
("178","ARS","PK","70","415"),
("179","ARS","PH","125","460"),
("180","ARS","ET","20","155"),
("181","ARS","TN","75","140"),
("182","ARS","LB","80","235"),
("183","ARS","IN","70","325"),
("184","ARS","PY","75","250"),
("185","ARS","UZ","75","150"),
("186","ARS","EC","75","260"),
("187","ARS","MM","75","85"),
("188","ARS","GE","80","100"),
("189","AUD","US","30","80"),
("190","AUD","CH","25","70"),
("191","AUD","AU","25","60"),
("192","AUD","GB","20","55"),
("193","AUD","DE","20","55"),
("194","AUD","DK","20","45"),
("195","AUD","AT","15","45"),
("196","AUD","NO","15","45"),
("197","AUD","CA","15","55"),
("198","AUD","NL","20","45"),
("199","AUD","SE","15","40"),
("200","AUD","IE","15","40"),
("201","AUD","BE","15","40"),
("202","AUD","FI","10","30"),
("203","AUD","FR","15","35"),
("204","AUD","NZ","15","35"),
("205","AUD","HK","10","35"),
("206","AUD","CZ","10","25"),
("207","AUD","SK","10","25"),
("208","AUD","AE","10","30"),
("209","AUD","SG","15","40"),
("210","AUD","IL","10","25"),
("211","AUD","KW","5","25"),
("212","AUD","IT","10","20"),
("213","AUD","JP","10","25"),
("214","AUD","ES","10","20"),
("215","AUD","VE","5","15"),
("216","AUD","HU","5","15"),
("217","AUD","PT","5","15"),
("218","AUD","GR","10","15"),
("219","AUD","KR","10","25"),
("220","AUD","TW","10","20"),
("221","AUD","PL","5","15"),
("222","AUD","ZM","5","10"),
("223","AUD","PR","5","25"),
("224","AUD","CI","5","10"),
("225","AUD","RO","5","15"),
("226","AUD","BH","5","15"),
("227","AUD","PA","5","20"),
("228","AUD","GH","5","10"),
("229","AUD","KH","5","10"),
("230","AUD","SN","5","10"),
("231","AUD","SA","5","15"),
("232","AUD","RU","5","15"),
("233","AUD","UG","5","10"),
("234","AUD","BR","5","10"),
("235","AUD","NI","5","10"),
("236","AUD","MG","5","10"),
("237","AUD","DO","5","10"),
("238","AUD","MX","5","10"),
("239","AUD","OM","5","10"),
("240","AUD","CM","5","10"),
("241","AUD","ZA","5","15"),
("242","AUD","CL","5","10"),
("243","AUD","KE","5","10"),
("244","AUD","NP","5","10"),
("245","AUD","PE","5","10"),
("246","AUD","UA","5","10"),
("247","AUD","MZ","5","10"),
("248","AUD","TZ","5","10"),
("249","AUD","AO","5","10"),
("250","AUD","JO","5","10"),
("251","AUD","ZW","5","10"),
("252","AUD","TR","5","10"),
("253","AUD","MU","5","10"),
("254","AUD","SV","5","10"),
("255","AUD","TH","5","10"),
("256","AUD","CO","5","10"),
("257","AUD","LK","5","10"),
("258","AUD","CR","5","10"),
("259","AUD","AR","5","10"),
("260","AUD","MA","5","10"),
("261","AUD","MY","5","10"),
("262","AUD","KZ","5","10"),
("263","AUD","DZ","5","10"),
("264","AUD","ID","5","10"),
("265","AUD","NG","5","10"),
("266","AUD","GT","5","10"),
("267","AUD","VN","5","10"),
("268","AUD","BY","5","10"),
("269","AUD","EG","5","10"),
("270","AUD","UY","5","10"),
("271","AUD","BD","5","10"),
("272","AUD","PK","5","10"),
("273","AUD","PH","5","10"),
("274","AUD","ET","5","10"),
("275","AUD","TN","5","10"),
("276","AUD","LB","5","10"),
("277","AUD","IN","5","10"),
("278","AUD","PY","5","10"),
("279","AUD","UZ","5","10"),
("280","AUD","EC","5","10"),
("281","AUD","MM","5","10"),
("282","AUD","GE","5","10"),
("283","BGN","US","35","100"),
("284","BGN","CH","35","85"),
("285","BGN","AU","30","75"),
("286","BGN","GB","25","65"),
("287","BGN","DE","25","65"),
("288","BGN","DK","25","60"),
("289","BGN","AT","15","55"),
("290","BGN","NO","20","55"),
("291","BGN","CA","20","65"),
("292","BGN","NL","25","60"),
("293","BGN","SE","20","50"),
("294","BGN","IE","20","50"),
("295","BGN","BE","15","50"),
("296","BGN","FI","15","40"),
("297","BGN","FR","15","40"),
("298","BGN","NZ","15","45"),
("299","BGN","HK","15","40"),
("300","BGN","CZ","15","35"),
("301","BGN","SK","15","30"),
("302","BGN","AE","10","40"),
("303","BGN","SG","15","45"),
("304","BGN","IL","15","35"),
("305","BGN","KW","5","30"),
("306","BGN","IT","10","25"),
("307","BGN","JP","10","35"),
("308","BGN","ES","10","25"),
("309","BGN","VE","5","20"),
("310","BGN","HU","10","20"),
("311","BGN","PT","10","20"),
("312","BGN","GR","10","20"),
("313","BGN","KR","10","35"),
("314","BGN","TW","10","25"),
("315","BGN","PL","10","20"),
("316","BGN","ZM","5","10"),
("317","BGN","PR","5","30"),
("318","BGN","CI","5","10"),
("319","BGN","RO","10","20"),
("320","BGN","BH","5","20"),
("321","BGN","PA","5","30"),
("322","BGN","GH","5","10"),
("323","BGN","KH","5","10"),
("324","BGN","SN","5","10"),
("325","BGN","SA","5","20"),
("326","BGN","RU","5","15"),
("327","BGN","UG","5","10"),
("328","BGN","BR","5","15"),
("329","BGN","NI","5","10"),
("330","BGN","MG","5","10"),
("331","BGN","DO","5","10"),
("332","BGN","MX","5","15"),
("333","BGN","OM","5","15"),
("334","BGN","CM","5","10"),
("335","BGN","ZA","5","15"),
("336","BGN","CL","5","15"),
("337","BGN","KE","5","10"),
("338","BGN","NP","5","10"),
("339","BGN","PE","5","15"),
("340","BGN","UA","5","10"),
("341","BGN","MZ","5","10"),
("342","BGN","TZ","5","10"),
("343","BGN","AO","5","10"),
("344","BGN","JO","5","10"),
("345","BGN","ZW","5","10"),
("346","BGN","TR","5","10"),
("347","BGN","MU","5","10"),
("348","BGN","SV","5","10"),
("349","BGN","TH","5","15"),
("350","BGN","CO","5","10"),
("351","BGN","LK","5","10"),
("352","BGN","CR","5","10"),
("353","BGN","AR","5","10"),
("354","BGN","MA","5","10"),
("355","BGN","MY","5","15"),
("356","BGN","KZ","5","10"),
("357","BGN","DZ","5","10"),
("358","BGN","ID","5","15"),
("359","BGN","NG","5","15"),
("360","BGN","GT","5","10"),
("361","BGN","VN","5","10"),
("362","BGN","BY","5","10"),
("363","BGN","EG","5","10"),
("364","BGN","UY","5","10"),
("365","BGN","BD","5","10"),
("366","BGN","PK","5","10"),
("367","BGN","PH","5","10"),
("368","BGN","ET","5","10"),
("369","BGN","TN","5","10"),
("370","BGN","LB","5","10"),
("371","BGN","IN","5","10"),
("372","BGN","PY","5","10"),
("373","BGN","UZ","5","10"),
("374","BGN","EC","5","10"),
("375","BGN","MM","5","10"),
("376","BGN","GE","5","10"),
("377","BOB","US","150","420"),
("378","BOB","CH","140","365"),
("379","BOB","AU","125","325"),
("380","BOB","GB","110","280"),
("381","BOB","DE","110","280"),
("382","BOB","DK","100","250"),
("383","BOB","AT","75","230"),
("384","BOB","NO","85","235"),
("385","BOB","CA","90","285"),
("386","BOB","NL","100","250"),
("387","BOB","SE","80","215"),
("388","BOB","IE","80","205"),
("389","BOB","BE","70","210"),
("390","BOB","FI","55","165"),
("391","BOB","FR","65","180"),
("392","BOB","NZ","70","200"),
("393","BOB","HK","60","175"),
("394","BOB","CZ","60","140"),
("395","BOB","SK","55","120"),
("396","BOB","AE","50","165"),
("397","BOB","SG","70","200"),
("398","BOB","IL","60","145"),
("399","BOB","KW","25","130"),
("400","BOB","IT","40","105"),
("401","BOB","JP","50","145"),
("402","BOB","ES","40","110"),
("403","BOB","VE","5","85"),
("404","BOB","HU","35","80"),
("405","BOB","PT","35","90"),
("406","BOB","GR","45","90"),
("407","BOB","KR","55","140"),
("408","BOB","TW","45","115"),
("409","BOB","PL","35","90"),
("410","BOB","ZM","5","30"),
("411","BOB","PR","15","125"),
("412","BOB","CI","5","30"),
("413","BOB","RO","35","80"),
("414","BOB","BH","15","85"),
("415","BOB","PA","10","115"),
("416","BOB","GH","10","35"),
("417","BOB","KH","5","35"),
("418","BOB","SN","5","35"),
("419","BOB","SA","20","85"),
("420","BOB","RU","20","70"),
("421","BOB","UG","5","25"),
("422","BOB","BR","25","60"),
("423","BOB","NI","5","35"),
("424","BOB","MG","5","25"),
("425","BOB","DO","5","45"),
("426","BOB","MX","20","65"),
("427","BOB","OM","10","65"),
("428","BOB","CM","5","50"),
("429","BOB","ZA","20","70"),
("430","BOB","CL","20","65"),
("431","BOB","KE","5","25"),
("432","BOB","NP","5","25"),
("433","BOB","PE","15","55"),
("434","BOB","UA","15","40"),
("435","BOB","MZ","5","50"),
("436","BOB","TZ","5","10"),
("437","BOB","AO","10","30"),
("438","BOB","JO","10","40"),
("439","BOB","ZW","5","30"),
("440","BOB","TR","15","35"),
("441","BOB","MU","5","25"),
("442","BOB","SV","5","30"),
("443","BOB","TH","20","65"),
("444","BOB","CO","10","40"),
("445","BOB","LK","5","10"),
("446","BOB","CR","5","40"),
("447","BOB","AR","15","40"),
("448","BOB","MA","5","25"),
("449","BOB","MY","20","65"),
("450","BOB","KZ","10","30"),
("451","BOB","DZ","5","15"),
("452","BOB","ID","15","60"),
("453","BOB","NG","10","55"),
("454","BOB","GT","5","45"),
("455","BOB","VN","15","50"),
("456","BOB","BY","5","25"),
("457","BOB","EG","10","50"),
("458","BOB","UY","5","30"),
("459","BOB","BD","5","10"),
("460","BOB","PK","5","35"),
("461","BOB","PH","10","35"),
("462","BOB","ET","5","10"),
("463","BOB","TN","5","10"),
("464","BOB","LB","5","20"),
("465","BOB","IN","5","25"),
("466","BOB","PY","5","20"),
("467","BOB","UZ","5","10"),
("468","BOB","EC","5","20"),
("469","BOB","MM","5","10"),
("470","BOB","GE","5","10"),
("471","BRL","US","115","325"),
("472","BRL","CH","105","285"),
("473","BRL","AU","100","250"),
("474","BRL","GB","85","220"),
("475","BRL","DE","85","215"),
("476","BRL","DK","80","195"),
("477","BRL","AT","55","175"),
("478","BRL","NO","65","180"),
("479","BRL","CA","70","220"),
("480","BRL","NL","75","195"),
("481","BRL","SE","60","165"),
("482","BRL","IE","60","160"),
("483","BRL","BE","55","160"),
("484","BRL","FI","40","125"),
("485","BRL","FR","50","135"),
("486","BRL","NZ","50","155"),
("487","BRL","HK","45","135"),
("488","BRL","CZ","45","110"),
("489","BRL","SK","45","95"),
("490","BRL","AE","40","125"),
("491","BRL","SG","55","155"),
("492","BRL","IL","45","110"),
("493","BRL","KW","20","100"),
("494","BRL","IT","30","80"),
("495","BRL","JP","40","110"),
("496","BRL","ES","30","85"),
("497","BRL","VE","5","65"),
("498","BRL","HU","25","65"),
("499","BRL","PT","25","70"),
("500","BRL","GR","35","70"),
("501","BRL","KR","40","110"),
("502","BRL","TW","35","90"),
("503","BRL","PL","30","70"),
("504","BRL","ZM","5","25"),
("505","BRL","PR","10","95"),
("506","BRL","CI","5","25"),
("507","BRL","RO","25","65"),
("508","BRL","BH","10","65"),
("509","BRL","PA","10","90"),
("510","BRL","GH","10","25"),
("511","BRL","KH","5","25"),
("512","BRL","SN","5","30"),
("513","BRL","SA","15","65"),
("514","BRL","RU","15","55"),
("515","BRL","UG","5","20"),
("516","BRL","BR","20","45"),
("517","BRL","NI","5","30"),
("518","BRL","MG","5","20"),
("519","BRL","DO","5","35"),
("520","BRL","MX","15","50"),
("521","BRL","OM","10","50"),
("522","BRL","CM","5","35"),
("523","BRL","ZA","15","50"),
("524","BRL","CL","15","50"),
("525","BRL","KE","5","20"),
("526","BRL","NP","5","20"),
("527","BRL","PE","10","45"),
("528","BRL","UA","10","30"),
("529","BRL","MZ","5","40"),
("530","BRL","TZ","5","10"),
("531","BRL","AO","10","25"),
("532","BRL","JO","5","30"),
("533","BRL","ZW","5","20"),
("534","BRL","TR","10","30"),
("535","BRL","MU","5","20"),
("536","BRL","SV","5","20"),
("537","BRL","TH","15","50"),
("538","BRL","CO","10","30"),
("539","BRL","LK","5","10"),
("540","BRL","CR","5","30"),
("541","BRL","AR","10","30"),
("542","BRL","MA","5","20"),
("543","BRL","MY","15","50"),
("544","BRL","KZ","5","20"),
("545","BRL","DZ","5","10"),
("546","BRL","ID","10","45"),
("547","BRL","NG","5","45"),
("548","BRL","GT","5","35"),
("549","BRL","VN","10","40"),
("550","BRL","BY","5","20"),
("551","BRL","EG","5","40"),
("552","BRL","UY","5","25"),
("553","BRL","BD","5","10"),
("554","BRL","PK","5","25"),
("555","BRL","PH","10","30"),
("556","BRL","ET","5","10"),
("557","BRL","TN","5","10"),
("558","BRL","LB","5","15"),
("559","BRL","IN","5","20"),
("560","BRL","PY","5","15"),
("561","BRL","UZ","5","10"),
("562","BRL","EC","5","15"),
("563","BRL","MM","5","10"),
("564","BRL","GE","5","10"),
("565","CAD","US","30","80"),
("566","CAD","CH","25","70"),
("567","CAD","AU","25","60"),
("568","CAD","GB","20","50"),
("569","CAD","DE","20","50"),
("570","CAD","DK","20","45"),
("571","CAD","AT","15","40"),
("572","CAD","NO","15","45"),
("573","CAD","CA","15","50"),
("574","CAD","NL","20","45"),
("575","CAD","SE","15","40"),
("576","CAD","IE","15","40"),
("577","CAD","BE","15","40"),
("578","CAD","FI","10","30"),
("579","CAD","FR","10","35"),
("580","CAD","NZ","15","35"),
("581","CAD","HK","10","30"),
("582","CAD","CZ","10","25"),
("583","CAD","SK","10","20"),
("584","CAD","AE","10","30"),
("585","CAD","SG","15","35"),
("586","CAD","IL","10","25"),
("587","CAD","KW","5","25"),
("588","CAD","IT","5","20"),
("589","CAD","JP","10","25"),
("590","CAD","ES","10","20"),
("591","CAD","VE","5","15"),
("592","CAD","HU","5","15"),
("593","CAD","PT","5","15"),
("594","CAD","GR","10","15"),
("595","CAD","KR","10","25"),
("596","CAD","TW","10","20"),
("597","CAD","PL","5","15"),
("598","CAD","ZM","5","10"),
("599","CAD","PR","5","25"),
("600","CAD","CI","5","10"),
("601","CAD","RO","5","15"),
("602","CAD","BH","5","15"),
("603","CAD","PA","5","20"),
("604","CAD","GH","5","10"),
("605","CAD","KH","5","10"),
("606","CAD","SN","5","10"),
("607","CAD","SA","5","15"),
("608","CAD","RU","5","15"),
("609","CAD","UG","5","10"),
("610","CAD","BR","5","10"),
("611","CAD","NI","5","10"),
("612","CAD","MG","5","10"),
("613","CAD","DO","5","10"),
("614","CAD","MX","5","10"),
("615","CAD","OM","5","10"),
("616","CAD","CM","5","10"),
("617","CAD","ZA","5","15"),
("618","CAD","CL","5","10"),
("619","CAD","KE","5","10"),
("620","CAD","NP","5","10"),
("621","CAD","PE","5","10"),
("622","CAD","UA","5","10"),
("623","CAD","MZ","5","10"),
("624","CAD","TZ","5","10"),
("625","CAD","AO","5","10"),
("626","CAD","JO","5","10"),
("627","CAD","ZW","5","10"),
("628","CAD","TR","5","10"),
("629","CAD","MU","5","10"),
("630","CAD","SV","5","10"),
("631","CAD","TH","5","10"),
("632","CAD","CO","5","10"),
("633","CAD","LK","5","10"),
("634","CAD","CR","5","10"),
("635","CAD","AR","5","10"),
("636","CAD","MA","5","10"),
("637","CAD","MY","5","10"),
("638","CAD","KZ","5","10"),
("639","CAD","DZ","5","10"),
("640","CAD","ID","5","10"),
("641","CAD","NG","5","10"),
("642","CAD","GT","5","10"),
("643","CAD","VN","5","10"),
("644","CAD","BY","5","10"),
("645","CAD","EG","5","10"),
("646","CAD","UY","5","10"),
("647","CAD","BD","5","10"),
("648","CAD","PK","5","10"),
("649","CAD","PH","5","10"),
("650","CAD","ET","5","10"),
("651","CAD","TN","5","10"),
("652","CAD","LB","5","10"),
("653","CAD","IN","5","10"),
("654","CAD","PY","5","10"),
("655","CAD","UZ","5","10"),
("656","CAD","EC","5","10"),
("657","CAD","MM","5","10"),
("658","CAD","GE","5","10"),
("659","CHF","US","20","55"),
("660","CHF","CH","20","45"),
("661","CHF","AU","15","40"),
("662","CHF","GB","15","35"),
("663","CHF","DE","15","35"),
("664","CHF","DK","15","30"),
("665","CHF","AT","10","30"),
("666","CHF","NO","10","30"),
("667","CHF","CA","10","35"),
("668","CHF","NL","15","30"),
("669","CHF","SE","10","30"),
("670","CHF","IE","10","25"),
("671","CHF","BE","10","25"),
("672","CHF","FI","5","20"),
("673","CHF","FR","10","25"),
("674","CHF","NZ","10","25"),
("675","CHF","HK","10","20"),
("676","CHF","CZ","10","20"),
("677","CHF","SK","5","15"),
("678","CHF","AE","5","20"),
("679","CHF","SG","10","25"),
("680","CHF","IL","10","20"),
("681","CHF","KW","5","15"),
("682","CHF","IT","5","15"),
("683","CHF","JP","5","20"),
("684","CHF","ES","5","15"),
("685","CHF","VE","5","10"),
("686","CHF","HU","5","10"),
("687","CHF","PT","5","10"),
("688","CHF","GR","5","10"),
("689","CHF","KR","5","20"),
("690","CHF","TW","5","15"),
("691","CHF","PL","5","10"),
("692","CHF","ZM","5","10"),
("693","CHF","PR","5","15"),
("694","CHF","CI","5","10"),
("695","CHF","RO","5","10"),
("696","CHF","BH","5","10"),
("697","CHF","PA","5","15"),
("698","CHF","GH","5","10"),
("699","CHF","KH","5","10"),
("700","CHF","SN","5","10"),
("701","CHF","SA","5","10"),
("702","CHF","RU","5","10"),
("703","CHF","UG","5","10"),
("704","CHF","BR","5","10"),
("705","CHF","NI","5","10"),
("706","CHF","MG","5","10"),
("707","CHF","DO","5","10"),
("708","CHF","MX","5","10"),
("709","CHF","OM","5","10"),
("710","CHF","CM","5","10"),
("711","CHF","ZA","5","10"),
("712","CHF","CL","5","10"),
("713","CHF","KE","5","10"),
("714","CHF","NP","5","10"),
("715","CHF","PE","5","10"),
("716","CHF","UA","5","10"),
("717","CHF","MZ","5","10"),
("718","CHF","TZ","5","10"),
("719","CHF","AO","5","10"),
("720","CHF","JO","5","10"),
("721","CHF","ZW","5","10"),
("722","CHF","TR","5","10"),
("723","CHF","MU","5","10"),
("724","CHF","SV","5","10"),
("725","CHF","TH","5","10"),
("726","CHF","CO","5","10"),
("727","CHF","LK","5","10"),
("728","CHF","CR","5","10"),
("729","CHF","AR","5","10"),
("730","CHF","MA","5","10"),
("731","CHF","MY","5","10"),
("732","CHF","KZ","5","10"),
("733","CHF","DZ","5","10"),
("734","CHF","ID","5","10"),
("735","CHF","NG","5","10"),
("736","CHF","GT","5","10"),
("737","CHF","VN","5","10"),
("738","CHF","BY","5","10"),
("739","CHF","EG","5","10"),
("740","CHF","UY","5","10"),
("741","CHF","BD","5","10"),
("742","CHF","PK","5","10"),
("743","CHF","PH","5","10"),
("744","CHF","ET","5","10"),
("745","CHF","TN","5","10"),
("746","CHF","LB","5","10"),
("747","CHF","IN","5","10"),
("748","CHF","PY","5","10"),
("749","CHF","UZ","5","10"),
("750","CHF","EC","5","10"),
("751","CHF","MM","5","10"),
("752","CHF","GE","5","10"),
("753","CLP","US","16030","45230"),
("754","CLP","CH","14950","39340"),
("755","CLP","AU","13600","34925"),
("756","CLP","GB","11860","30350"),
("757","CLP","DE","11770","30105"),
("758","CLP","DK","10830","26875"),
("759","CLP","AT","7900","24555"),
("760","CLP","NO","8955","25005"),
("761","CLP","CA","9900","30360"),
("762","CLP","NL","10590","26885"),
("763","CLP","SE","8480","22925"),
("764","CLP","IE","8390","22115"),
("765","CLP","BE","7715","22610"),
("766","CLP","FI","5770","17515"),
("767","CLP","FR","7140","19115"),
("768","CLP","NZ","7270","21400"),
("769","CLP","HK","6610","18695"),
("770","CLP","CZ","6300","15130"),
("771","CLP","SK","5945","12885"),
("772","CLP","AE","5610","17610"),
("773","CLP","SG","7320","21635"),
("774","CLP","IL","6390","15630"),
("775","CLP","KW","2880","14045"),
("776","CLP","IT","4350","11480"),
("777","CLP","JP","5455","15495"),
("778","CLP","ES","4470","11820"),
("779","CLP","VE","585","9055"),
("780","CLP","HU","3765","8765"),
("781","CLP","PT","3760","9805"),
("782","CLP","GR","4635","9495"),
("783","CLP","KR","5715","15140"),
("784","CLP","TW","4645","12440"),
("785","CLP","PL","3975","9840"),
("786","CLP","ZM","575","3275"),
("787","CLP","PR","1405","13200"),
("788","CLP","CI","765","3165"),
("789","CLP","RO","3650","8835"),
("790","CLP","BH","1660","9195"),
("791","CLP","PA","1110","12620"),
("792","CLP","GH","1330","3715"),
("793","CLP","KH","770","3685"),
("794","CLP","SN","560","4005"),
("795","CLP","SA","2385","9130"),
("796","CLP","RU","2370","7560"),
("797","CLP","UG","555","2925"),
("798","CLP","BR","2525","6230"),
("799","CLP","NI","555","3990"),
("800","CLP","MG","560","2825"),
("801","CLP","DO","675","4685"),
("802","CLP","MX","1905","6895"),
("803","CLP","OM","1195","6895"),
("804","CLP","CM","555","5135"),
("805","CLP","ZA","2270","7305"),
("806","CLP","CL","2365","7065"),
("807","CLP","KE","685","2950"),
("808","CLP","NP","555","2680"),
("809","CLP","PE","1410","5945"),
("810","CLP","UA","1345","4205"),
("811","CLP","MZ","555","5580"),
("812","CLP","TZ","70","1280"),
("813","CLP","AO","1230","3205"),
("814","CLP","JO","905","4310"),
("815","CLP","ZW","560","3055"),
("816","CLP","TR","1445","3955"),
("817","CLP","MU","740","2530"),
("818","CLP","SV","555","3065"),
("819","CLP","TH","2170","6820"),
("820","CLP","CO","1100","4255"),
("821","CLP","LK","535","735"),
("822","CLP","CR","670","4450"),
("823","CLP","AR","1495","4055"),
("824","CLP","MA","670","2625"),
("825","CLP","MY","1895","6975"),
("826","CLP","KZ","810","2970"),
("827","CLP","DZ","665","1410"),
("828","CLP","ID","1695","6280"),
("829","CLP","NG","950","6020"),
("830","CLP","GT","665","4715"),
("831","CLP","VN","1385","5250"),
("832","CLP","BY","650","2530"),
("833","CLP","EG","875","5355"),
("834","CLP","UY","690","3185"),
("835","CLP","BD","570","1260"),
("836","CLP","PK","625","3590"),
("837","CLP","PH","1080","3990"),
("838","CLP","ET","175","1320"),
("839","CLP","TN","665","1205"),
("840","CLP","LB","670","2010"),
("841","CLP","IN","620","2800"),
("842","CLP","PY","665","2140"),
("843","CLP","UZ","665","1300"),
("844","CLP","EC","650","2220"),
("845","CLP","MM","665","730"),
("846","CLP","GE","670","850"),
("847","CNY","US","140","395"),
("848","CNY","CH","130","345"),
("849","CNY","AU","120","305"),
("850","CNY","GB","105","265"),
("851","CNY","DE","105","265"),
("852","CNY","DK","95","235"),
("853","CNY","AT","70","215"),
("854","CNY","NO","80","220"),
("855","CNY","CA","85","265"),
("856","CNY","NL","95","235"),
("857","CNY","SE","75","200"),
("858","CNY","IE","75","195"),
("859","CNY","BE","70","200"),
("860","CNY","FI","50","155"),
("861","CNY","FR","65","170"),
("862","CNY","NZ","65","190"),
("863","CNY","HK","60","165"),
("864","CNY","CZ","55","135"),
("865","CNY","SK","50","115"),
("866","CNY","AE","50","155"),
("867","CNY","SG","65","190"),
("868","CNY","IL","55","135"),
("869","CNY","KW","25","125"),
("870","CNY","IT","40","100"),
("871","CNY","JP","50","135"),
("872","CNY","ES","40","105"),
("873","CNY","VE","5","80"),
("874","CNY","HU","35","75"),
("875","CNY","PT","35","85"),
("876","CNY","GR","40","85"),
("877","CNY","KR","50","135"),
("878","CNY","TW","40","110"),
("879","CNY","PL","35","85"),
("880","CNY","ZM","5","30"),
("881","CNY","PR","10","115"),
("882","CNY","CI","5","30"),
("883","CNY","RO","30","75"),
("884","CNY","BH","15","80"),
("885","CNY","PA","10","110"),
("886","CNY","GH","10","35"),
("887","CNY","KH","5","30"),
("888","CNY","SN","5","35"),
("889","CNY","SA","20","80"),
("890","CNY","RU","20","65"),
("891","CNY","UG","5","25"),
("892","CNY","BR","20","55"),
("893","CNY","NI","5","35"),
("894","CNY","MG","5","25"),
("895","CNY","DO","5","40"),
("896","CNY","MX","15","60"),
("897","CNY","OM","10","60"),
("898","CNY","CM","5","45"),
("899","CNY","ZA","20","65"),
("900","CNY","CL","20","60"),
("901","CNY","KE","5","25"),
("902","CNY","NP","5","25"),
("903","CNY","PE","10","50"),
("904","CNY","UA","10","35"),
("905","CNY","MZ","5","50"),
("906","CNY","TZ","5","10"),
("907","CNY","AO","10","30"),
("908","CNY","JO","10","40"),
("909","CNY","ZW","5","25"),
("910","CNY","TR","15","35"),
("911","CNY","MU","5","20"),
("912","CNY","SV","5","25"),
("913","CNY","TH","20","60"),
("914","CNY","CO","10","35"),
("915","CNY","LK","5","10"),
("916","CNY","CR","5","40"),
("917","CNY","AR","15","35"),
("918","CNY","MA","5","25"),
("919","CNY","MY","15","60"),
("920","CNY","KZ","5","25"),
("921","CNY","DZ","5","10"),
("922","CNY","ID","15","55"),
("923","CNY","NG","10","55"),
("924","CNY","GT","5","40"),
("925","CNY","VN","10","45"),
("926","CNY","BY","5","20"),
("927","CNY","EG","10","45"),
("928","CNY","UY","5","30"),
("929","CNY","BD","5","10"),
("930","CNY","PK","5","30"),
("931","CNY","PH","10","35"),
("932","CNY","ET","5","10"),
("933","CNY","TN","5","10"),
("934","CNY","LB","5","20"),
("935","CNY","IN","5","25"),
("936","CNY","PY","5","20"),
("937","CNY","UZ","5","10"),
("938","CNY","EC","5","20"),
("939","CNY","MM","5","10"),
("940","CNY","GE","5","10"),
("941","COP","US","75545","213150"),
("942","COP","CH","70445","185375"),
("943","COP","AU","64100","164575"),
("944","COP","GB","55885","143015"),
("945","COP","DE","55460","141860"),
("946","COP","DK","51030","126635"),
("947","COP","AT","37235","115710"),
("948","COP","NO","42205","117830"),
("949","COP","CA","46655","143060"),
("950","COP","NL","49915","126685"),
("951","COP","SE","39955","108040"),
("952","COP","IE","39535","104220"),
("953","COP","BE","36360","106555"),
("954","COP","FI","27180","82545"),
("955","COP","FR","33655","90085"),
("956","COP","NZ","34255","100840"),
("957","COP","HK","31150","88090"),
("958","COP","CZ","29700","71300"),
("959","COP","SK","28020","60720"),
("960","COP","AE","26440","82980"),
("961","COP","SG","34500","101960"),
("962","COP","IL","30105","73645"),
("963","COP","KW","13580","66195"),
("964","COP","IT","20495","54100"),
("965","COP","JP","25695","73030"),
("966","COP","ES","21065","55710"),
("967","COP","VE","2760","42675"),
("968","COP","HU","17750","41305"),
("969","COP","PT","17720","46195"),
("970","COP","GR","21850","44750"),
("971","COP","KR","26940","71345"),
("972","COP","TW","21895","58620"),
("973","COP","PL","18735","46380"),
("974","COP","ZM","2705","15440"),
("975","COP","PR","6620","62215"),
("976","COP","CI","3610","14925"),
("977","COP","RO","17210","41645"),
("978","COP","BH","7815","43325"),
("979","COP","PA","5235","59470"),
("980","COP","GH","6275","17510"),
("981","COP","KH","3615","17370"),
("982","COP","SN","2635","18870"),
("983","COP","SA","11235","43010"),
("984","COP","RU","11165","35625"),
("985","COP","UG","2625","13790"),
("986","COP","BR","11905","29345"),
("987","COP","NI","2620","18790"),
("988","COP","MG","2650","13320"),
("989","COP","DO","3175","22085"),
("990","COP","MX","8975","32480"),
("991","COP","OM","5640","32485"),
("992","COP","CM","2615","24205"),
("993","COP","ZA","10695","34425"),
("994","COP","CL","11145","33300"),
("995","COP","KE","3215","13900"),
("996","COP","NP","2615","12625"),
("997","COP","PE","6655","28015"),
("998","COP","UA","6345","19820"),
("999","COP","MZ","2615","26290"),
("1000","COP","TZ","330","6035"),
("1001","COP","AO","5795","15115"),
("1002","COP","JO","4275","20300"),
("1003","COP","ZW","2625","14405"),
("1004","COP","TR","6810","18630"),
("1005","COP","MU","3485","11915"),
("1006","COP","SV","2615","14435"),
("1007","COP","TH","10215","32140"),
("1008","COP","CO","5180","20050"),
("1009","COP","LK","2515","3475"),
("1010","COP","CR","3160","20980"),
("1011","COP","AR","7055","19110"),
("1012","COP","MA","3150","12365"),
("1013","COP","MY","8940","32875"),
("1014","COP","KZ","3825","13995"),
("1015","COP","DZ","3135","6635"),
("1016","COP","ID","7975","29590"),
("1017","COP","NG","4485","28365"),
("1018","COP","GT","3140","22210"),
("1019","COP","VN","6525","24735"),
("1020","COP","BY","3065","11930"),
("1021","COP","EG","4135","25245"),
("1022","COP","UY","3260","15015"),
("1023","COP","BD","2680","5940"),
("1024","COP","PK","2940","16930"),
("1025","COP","PH","5095","18795"),
("1026","COP","ET","815","6225"),
("1027","COP","TN","3140","5685"),
("1028","COP","LB","3170","9470"),
("1029","COP","IN","2920","13195"),
("1030","COP","PY","3140","10095"),
("1031","COP","UZ","3140","6130"),
("1032","COP","EC","3050","10470"),
("1033","COP","MM","3140","3430"),
("1034","COP","GE","3150","4015"),
("1035","CZK","US","470","1320"),
("1036","CZK","CH","435","1145"),
("1037","CZK","AU","395","1020"),
("1038","CZK","GB","345","885"),
("1039","CZK","DE","345","880"),
("1040","CZK","DK","315","785"),
("1041","CZK","AT","230","715"),
("1042","CZK","NO","260","730"),
("1043","CZK","CA","290","885"),
("1044","CZK","NL","310","785"),
("1045","CZK","SE","245","670"),
("1046","CZK","IE","245","645"),
("1047","CZK","BE","225","660"),
("1048","CZK","FI","170","510"),
("1049","CZK","FR","210","560"),
("1050","CZK","NZ","210","625"),
("1051","CZK","HK","195","545"),
("1052","CZK","CZ","185","440"),
("1053","CZK","SK","175","375"),
("1054","CZK","AE","165","515"),
("1055","CZK","SG","215","630"),
("1056","CZK","IL","185","455"),
("1057","CZK","KW","85","410"),
("1058","CZK","IT","125","335"),
("1059","CZK","JP","160","450"),
("1060","CZK","ES","130","345"),
("1061","CZK","VE","15","265"),
("1062","CZK","HU","110","255"),
("1063","CZK","PT","110","285"),
("1064","CZK","GR","135","275"),
("1065","CZK","KR","165","440"),
("1066","CZK","TW","135","365"),
("1067","CZK","PL","115","285"),
("1068","CZK","ZM","15","95"),
("1069","CZK","PR","40","385"),
("1070","CZK","CI","20","90"),
("1071","CZK","RO","105","260"),
("1072","CZK","BH","50","270"),
("1073","CZK","PA","30","370"),
("1074","CZK","GH","40","110"),
("1075","CZK","KH","20","110"),
("1076","CZK","SN","15","115"),
("1077","CZK","SA","70","265"),
("1078","CZK","RU","70","220"),
("1079","CZK","UG","15","85"),
("1080","CZK","BR","75","180"),
("1081","CZK","NI","15","115"),
("1082","CZK","MG","15","80"),
("1083","CZK","DO","20","135"),
("1084","CZK","MX","55","200"),
("1085","CZK","OM","35","200"),
("1086","CZK","CM","15","150"),
("1087","CZK","ZA","65","215"),
("1088","CZK","CL","70","205"),
("1089","CZK","KE","20","85"),
("1090","CZK","NP","15","80"),
("1091","CZK","PE","40","175"),
("1092","CZK","UA","40","125"),
("1093","CZK","MZ","15","165"),
("1094","CZK","TZ","5","35"),
("1095","CZK","AO","35","95"),
("1096","CZK","JO","25","125"),
("1097","CZK","ZW","15","90"),
("1098","CZK","TR","40","115"),
("1099","CZK","MU","20","75"),
("1100","CZK","SV","15","90"),
("1101","CZK","TH","65","200"),
("1102","CZK","CO","30","125"),
("1103","CZK","LK","15","20"),
("1104","CZK","CR","20","130"),
("1105","CZK","AR","45","120"),
("1106","CZK","MA","20","75"),
("1107","CZK","MY","55","205"),
("1108","CZK","KZ","25","85"),
("1109","CZK","DZ","20","40"),
("1110","CZK","ID","50","185"),
("1111","CZK","NG","30","175"),
("1112","CZK","GT","20","135"),
("1113","CZK","VN","40","155"),
("1114","CZK","BY","20","75"),
("1115","CZK","EG","25","155"),
("1116","CZK","UY","20","95"),
("1117","CZK","BD","15","35"),
("1118","CZK","PK","20","105"),
("1119","CZK","PH","30","115"),
("1120","CZK","ET","5","40"),
("1121","CZK","TN","20","35"),
("1122","CZK","LB","20","60"),
("1123","CZK","IN","20","80"),
("1124","CZK","PY","20","60"),
("1125","CZK","UZ","20","40"),
("1126","CZK","EC","20","65"),
("1127","CZK","MM","20","25"),
("1128","CZK","GE","20","25"),
("1129","DKK","US","135","375"),
("1130","DKK","CH","125","325"),
("1131","DKK","AU","115","290"),
("1132","DKK","GB","100","250"),
("1133","DKK","DE","100","250"),
("1134","DKK","DK","90","225"),
("1135","DKK","AT","65","205"),
("1136","DKK","NO","75","205"),
("1137","DKK","CA","80","250"),
("1138","DKK","NL","90","225"),
("1139","DKK","SE","70","190"),
("1140","DKK","IE","70","185"),
("1141","DKK","BE","65","190"),
("1142","DKK","FI","50","145"),
("1143","DKK","FR","60","160"),
("1144","DKK","NZ","60","175"),
("1145","DKK","HK","55","155"),
("1146","DKK","CZ","50","125"),
("1147","DKK","SK","50","105"),
("1148","DKK","AE","45","145"),
("1149","DKK","SG","60","180"),
("1150","DKK","IL","55","130"),
("1151","DKK","KW","25","115"),
("1152","DKK","IT","35","95"),
("1153","DKK","JP","45","130"),
("1154","DKK","ES","35","100"),
("1155","DKK","VE","5","75"),
("1156","DKK","HU","30","75"),
("1157","DKK","PT","30","80"),
("1158","DKK","GR","40","80"),
("1159","DKK","KR","45","125"),
("1160","DKK","TW","40","105"),
("1161","DKK","PL","35","80"),
("1162","DKK","ZM","5","25"),
("1163","DKK","PR","10","110"),
("1164","DKK","CI","5","25"),
("1165","DKK","RO","30","75"),
("1166","DKK","BH","15","75"),
("1167","DKK","PA","10","105"),
("1168","DKK","GH","10","30"),
("1169","DKK","KH","5","30"),
("1170","DKK","SN","5","35"),
("1171","DKK","SA","20","75"),
("1172","DKK","RU","20","65"),
("1173","DKK","UG","5","25"),
("1174","DKK","BR","20","50"),
("1175","DKK","NI","5","35"),
("1176","DKK","MG","5","25"),
("1177","DKK","DO","5","40"),
("1178","DKK","MX","15","55"),
("1179","DKK","OM","10","55"),
("1180","DKK","CM","5","45"),
("1181","DKK","ZA","20","60"),
("1182","DKK","CL","20","60"),
("1183","DKK","KE","5","25"),
("1184","DKK","NP","5","20"),
("1185","DKK","PE","10","50"),
("1186","DKK","UA","10","35"),
("1187","DKK","MZ","5","45"),
("1188","DKK","TZ","5","10"),
("1189","DKK","AO","10","25"),
("1190","DKK","JO","10","35"),
("1191","DKK","ZW","5","25"),
("1192","DKK","TR","10","35"),
("1193","DKK","MU","5","20"),
("1194","DKK","SV","5","25"),
("1195","DKK","TH","20","55"),
("1196","DKK","CO","10","35"),
("1197","DKK","LK","5","10"),
("1198","DKK","CR","5","35"),
("1199","DKK","AR","10","35"),
("1200","DKK","MA","5","20"),
("1201","DKK","MY","15","60"),
("1202","DKK","KZ","5","25"),
("1203","DKK","DZ","5","10"),
("1204","DKK","ID","15","50"),
("1205","DKK","NG","10","50"),
("1206","DKK","GT","5","40"),
("1207","DKK","VN","10","45"),
("1208","DKK","BY","5","20"),
("1209","DKK","EG","5","45"),
("1210","DKK","UY","5","25"),
("1211","DKK","BD","5","10"),
("1212","DKK","PK","5","30"),
("1213","DKK","PH","10","35"),
("1214","DKK","ET","5","10"),
("1215","DKK","TN","5","10"),
("1216","DKK","LB","5","15"),
("1217","DKK","IN","5","25"),
("1218","DKK","PY","5","20"),
("1219","DKK","UZ","5","10"),
("1220","DKK","EC","5","20"),
("1221","DKK","MM","5","10"),
("1222","DKK","GE","5","10"),
("1223","EGP","US","340","960"),
("1224","EGP","CH","315","835"),
("1225","EGP","AU","290","740"),
("1226","EGP","GB","250","645"),
("1227","EGP","DE","250","640"),
("1228","EGP","DK","230","570"),
("1229","EGP","AT","170","520"),
("1230","EGP","NO","190","530"),
("1231","EGP","CA","210","645"),
("1232","EGP","NL","225","570"),
("1233","EGP","SE","180","485"),
("1234","EGP","IE","180","470"),
("1235","EGP","BE","165","480"),
("1236","EGP","FI","120","370"),
("1237","EGP","FR","150","405"),
("1238","EGP","NZ","155","455"),
("1239","EGP","HK","140","395"),
("1240","EGP","CZ","135","320"),
("1241","EGP","SK","125","275"),
("1242","EGP","AE","120","375"),
("1243","EGP","SG","155","460"),
("1244","EGP","IL","135","330"),
("1245","EGP","KW","60","300"),
("1246","EGP","IT","90","245"),
("1247","EGP","JP","115","330"),
("1248","EGP","ES","95","250"),
("1249","EGP","VE","10","190"),
("1250","EGP","HU","80","185"),
("1251","EGP","PT","80","210"),
("1252","EGP","GR","100","200"),
("1253","EGP","KR","120","320"),
("1254","EGP","TW","100","265"),
("1255","EGP","PL","85","210"),
("1256","EGP","ZM","10","70"),
("1257","EGP","PR","30","280"),
("1258","EGP","CI","15","65"),
("1259","EGP","RO","80","190"),
("1260","EGP","BH","35","195"),
("1261","EGP","PA","25","270"),
("1262","EGP","GH","30","80"),
("1263","EGP","KH","15","80"),
("1264","EGP","SN","10","85"),
("1265","EGP","SA","50","195"),
("1266","EGP","RU","50","160"),
("1267","EGP","UG","10","60"),
("1268","EGP","BR","55","130"),
("1269","EGP","NI","10","85"),
("1270","EGP","MG","10","60"),
("1271","EGP","DO","15","100"),
("1272","EGP","MX","40","145"),
("1273","EGP","OM","25","145"),
("1274","EGP","CM","10","110"),
("1275","EGP","ZA","50","155"),
("1276","EGP","CL","50","150"),
("1277","EGP","KE","15","65"),
("1278","EGP","NP","10","55"),
("1279","EGP","PE","30","125"),
("1280","EGP","UA","30","90"),
("1281","EGP","MZ","10","120"),
("1282","EGP","TZ","5","25"),
("1283","EGP","AO","25","70"),
("1284","EGP","JO","20","90"),
("1285","EGP","ZW","10","65"),
("1286","EGP","TR","30","85"),
("1287","EGP","MU","15","55"),
("1288","EGP","SV","10","65"),
("1289","EGP","TH","45","145"),
("1290","EGP","CO","25","90"),
("1291","EGP","LK","10","15"),
("1292","EGP","CR","15","95"),
("1293","EGP","AR","30","85"),
("1294","EGP","MA","15","55"),
("1295","EGP","MY","40","150"),
("1296","EGP","KZ","15","65"),
("1297","EGP","DZ","15","30"),
("1298","EGP","ID","35","135"),
("1299","EGP","NG","20","130"),
("1300","EGP","GT","15","100"),
("1301","EGP","VN","30","110"),
("1302","EGP","BY","15","55"),
("1303","EGP","EG","20","115"),
("1304","EGP","UY","15","70"),
("1305","EGP","BD","10","25"),
("1306","EGP","PK","15","75"),
("1307","EGP","PH","25","85"),
("1308","EGP","ET","5","30"),
("1309","EGP","TN","15","25"),
("1310","EGP","LB","15","45"),
("1311","EGP","IN","15","60"),
("1312","EGP","PY","15","45"),
("1313","EGP","UZ","15","30"),
("1314","EGP","EC","15","45"),
("1315","EGP","MM","15","20"),
("1316","EGP","GE","15","20"),
("1317","EUR","US","20","50"),
("1318","EUR","CH","15","45"),
("1319","EUR","AU","15","40"),
("1320","EUR","GB","15","35"),
("1321","EUR","DE","15","35"),
("1322","EUR","DK","10","30"),
("1323","EUR","AT","10","25"),
("1324","EUR","NO","10","30"),
("1325","EUR","CA","10","35"),
("1326","EUR","NL","10","30"),
("1327","EUR","SE","10","25"),
("1328","EUR","IE","10","25"),
("1329","EUR","BE","10","25"),
("1330","EUR","FI","5","20"),
("1331","EUR","FR","10","20"),
("1332","EUR","NZ","10","25"),
("1333","EUR","HK","5","20"),
("1334","EUR","CZ","5","15"),
("1335","EUR","SK","5","15"),
("1336","EUR","AE","5","20"),
("1337","EUR","SG","10","25"),
("1338","EUR","IL","5","15"),
("1339","EUR","KW","5","15"),
("1340","EUR","IT","5","15"),
("1341","EUR","JP","5","15"),
("1342","EUR","ES","5","15"),
("1343","EUR","VE","5","10"),
("1344","EUR","HU","5","10"),
("1345","EUR","PT","5","10"),
("1346","EUR","GR","5","10"),
("1347","EUR","KR","5","15"),
("1348","EUR","TW","5","15"),
("1349","EUR","PL","5","10"),
("1350","EUR","ZM","5","10"),
("1351","EUR","PR","5","15"),
("1352","EUR","CI","5","10"),
("1353","EUR","RO","5","10"),
("1354","EUR","BH","5","10"),
("1355","EUR","PA","5","15"),
("1356","EUR","GH","5","10"),
("1357","EUR","KH","5","10"),
("1358","EUR","SN","5","10"),
("1359","EUR","SA","5","10"),
("1360","EUR","RU","5","10"),
("1361","EUR","UG","5","10"),
("1362","EUR","BR","5","10"),
("1363","EUR","NI","5","10"),
("1364","EUR","MG","5","10"),
("1365","EUR","DO","5","10"),
("1366","EUR","MX","5","10"),
("1367","EUR","OM","5","10"),
("1368","EUR","CM","5","10"),
("1369","EUR","ZA","5","10"),
("1370","EUR","CL","5","10"),
("1371","EUR","KE","5","10"),
("1372","EUR","NP","5","10"),
("1373","EUR","PE","5","10"),
("1374","EUR","UA","5","10"),
("1375","EUR","MZ","5","10"),
("1376","EUR","TZ","5","10"),
("1377","EUR","AO","5","10"),
("1378","EUR","JO","5","10"),
("1379","EUR","ZW","5","10"),
("1380","EUR","TR","5","10"),
("1381","EUR","MU","5","10"),
("1382","EUR","SV","5","10"),
("1383","EUR","TH","5","10"),
("1384","EUR","CO","5","10"),
("1385","EUR","LK","5","10"),
("1386","EUR","CR","5","10"),
("1387","EUR","AR","5","10"),
("1388","EUR","MA","5","10"),
("1389","EUR","MY","5","10"),
("1390","EUR","KZ","5","10"),
("1391","EUR","DZ","5","10"),
("1392","EUR","ID","5","10"),
("1393","EUR","NG","5","10"),
("1394","EUR","GT","5","10"),
("1395","EUR","VN","5","10"),
("1396","EUR","BY","5","10"),
("1397","EUR","EG","5","10"),
("1398","EUR","UY","5","10"),
("1399","EUR","BD","5","10"),
("1400","EUR","PK","5","10"),
("1401","EUR","PH","5","10"),
("1402","EUR","ET","5","10"),
("1403","EUR","TN","5","10"),
("1404","EUR","LB","5","10"),
("1405","EUR","IN","5","10"),
("1406","EUR","PY","5","10"),
("1407","EUR","UZ","5","10"),
("1408","EUR","EC","5","10"),
("1409","EUR","MM","5","10"),
("1410","EUR","GE","5","10"),
("1411","GBP","US","15","45"),
("1412","GBP","CH","15","40"),
("1413","GBP","AU","15","35"),
("1414","GBP","GB","10","30"),
("1415","GBP","DE","10","30"),
("1416","GBP","DK","10","25"),
("1417","GBP","AT","10","25"),
("1418","GBP","NO","10","25"),
("1419","GBP","CA","10","30"),
("1420","GBP","NL","10","25"),
("1421","GBP","SE","10","25"),
("1422","GBP","IE","10","20"),
("1423","GBP","BE","10","20"),
("1424","GBP","FI","5","15"),
("1425","GBP","FR","5","20"),
("1426","GBP","NZ","5","20"),
("1427","GBP","HK","5","20"),
("1428","GBP","CZ","5","15"),
("1429","GBP","SK","5","15"),
("1430","GBP","AE","5","20"),
("1431","GBP","SG","5","20"),
("1432","GBP","IL","5","15"),
("1433","GBP","KW","5","15"),
("1434","GBP","IT","5","10"),
("1435","GBP","JP","5","15"),
("1436","GBP","ES","5","10"),
("1437","GBP","VE","5","10"),
("1438","GBP","HU","5","10"),
("1439","GBP","PT","5","10"),
("1440","GBP","GR","5","10"),
("1441","GBP","KR","5","15"),
("1442","GBP","TW","5","10"),
("1443","GBP","PL","5","10"),
("1444","GBP","ZM","5","10"),
("1445","GBP","PR","5","15"),
("1446","GBP","CI","5","10"),
("1447","GBP","RO","5","10"),
("1448","GBP","BH","5","10"),
("1449","GBP","PA","5","15"),
("1450","GBP","GH","5","10"),
("1451","GBP","KH","5","10"),
("1452","GBP","SN","5","10"),
("1453","GBP","SA","5","10"),
("1454","GBP","RU","5","10"),
("1455","GBP","UG","5","10"),
("1456","GBP","BR","5","10"),
("1457","GBP","NI","5","10"),
("1458","GBP","MG","5","10"),
("1459","GBP","DO","5","10"),
("1460","GBP","MX","5","10"),
("1461","GBP","OM","5","10"),
("1462","GBP","CM","5","10"),
("1463","GBP","ZA","5","10"),
("1464","GBP","CL","5","10"),
("1465","GBP","KE","5","10"),
("1466","GBP","NP","5","10"),
("1467","GBP","PE","5","10"),
("1468","GBP","UA","5","10"),
("1469","GBP","MZ","5","10"),
("1470","GBP","TZ","5","10"),
("1471","GBP","AO","5","10"),
("1472","GBP","JO","5","10"),
("1473","GBP","ZW","5","10"),
("1474","GBP","TR","5","10"),
("1475","GBP","MU","5","10"),
("1476","GBP","SV","5","10"),
("1477","GBP","TH","5","10"),
("1478","GBP","CO","5","10"),
("1479","GBP","LK","5","10"),
("1480","GBP","CR","5","10"),
("1481","GBP","AR","5","10"),
("1482","GBP","MA","5","10"),
("1483","GBP","MY","5","10"),
("1484","GBP","KZ","5","10"),
("1485","GBP","DZ","5","10"),
("1486","GBP","ID","5","10"),
("1487","GBP","NG","5","10"),
("1488","GBP","GT","5","10"),
("1489","GBP","VN","5","10"),
("1490","GBP","BY","5","10"),
("1491","GBP","EG","5","10"),
("1492","GBP","UY","5","10"),
("1493","GBP","BD","5","10"),
("1494","GBP","PK","5","10"),
("1495","GBP","PH","5","10"),
("1496","GBP","ET","5","10"),
("1497","GBP","TN","5","10"),
("1498","GBP","LB","5","10"),
("1499","GBP","IN","5","10"),
("1500","GBP","PY","5","10"),
("1501","GBP","UZ","5","10"),
("1502","GBP","EC","5","10"),
("1503","GBP","MM","5","10"),
("1504","GBP","GE","5","10"),
("1505","HKD","US","170","475"),
("1506","HKD","CH","155","415"),
("1507","HKD","AU","145","365"),
("1508","HKD","GB","125","320"),
("1509","HKD","DE","125","315"),
("1510","HKD","DK","115","280"),
("1511","HKD","AT","85","260"),
("1512","HKD","NO","95","265"),
("1513","HKD","CA","105","320"),
("1514","HKD","NL","110","285"),
("1515","HKD","SE","90","240"),
("1516","HKD","IE","90","230"),
("1517","HKD","BE","80","240"),
("1518","HKD","FI","60","185"),
("1519","HKD","FR","75","200"),
("1520","HKD","NZ","75","225"),
("1521","HKD","HK","70","195"),
("1522","HKD","CZ","65","160"),
("1523","HKD","SK","60","135"),
("1524","HKD","AE","60","185"),
("1525","HKD","SG","75","225"),
("1526","HKD","IL","65","165"),
("1527","HKD","KW","30","150"),
("1528","HKD","IT","45","120"),
("1529","HKD","JP","55","165"),
("1530","HKD","ES","45","125"),
("1531","HKD","VE","5","95"),
("1532","HKD","HU","40","90"),
("1533","HKD","PT","40","105"),
("1534","HKD","GR","50","100"),
("1535","HKD","KR","60","160"),
("1536","HKD","TW","50","130"),
("1537","HKD","PL","40","105"),
("1538","HKD","ZM","5","35"),
("1539","HKD","PR","15","140"),
("1540","HKD","CI","10","35"),
("1541","HKD","RO","40","95"),
("1542","HKD","BH","15","95"),
("1543","HKD","PA","10","135"),
("1544","HKD","GH","15","40"),
("1545","HKD","KH","10","40"),
("1546","HKD","SN","5","40"),
("1547","HKD","SA","25","95"),
("1548","HKD","RU","25","80"),
("1549","HKD","UG","5","30"),
("1550","HKD","BR","25","65"),
("1551","HKD","NI","5","40"),
("1552","HKD","MG","5","30"),
("1553","HKD","DO","5","50"),
("1554","HKD","MX","20","70"),
("1555","HKD","OM","15","70"),
("1556","HKD","CM","5","55"),
("1557","HKD","ZA","25","75"),
("1558","HKD","CL","25","75"),
("1559","HKD","KE","5","30"),
("1560","HKD","NP","5","30"),
("1561","HKD","PE","15","60"),
("1562","HKD","UA","15","45"),
("1563","HKD","MZ","5","60"),
("1564","HKD","TZ","5","15"),
("1565","HKD","AO","15","35"),
("1566","HKD","JO","10","45"),
("1567","HKD","ZW","5","30"),
("1568","HKD","TR","15","40"),
("1569","HKD","MU","10","25"),
("1570","HKD","SV","5","30"),
("1571","HKD","TH","25","70"),
("1572","HKD","CO","10","45"),
("1573","HKD","LK","5","10"),
("1574","HKD","CR","5","45"),
("1575","HKD","AR","15","45"),
("1576","HKD","MA","5","30"),
("1577","HKD","MY","20","75"),
("1578","HKD","KZ","10","30"),
("1579","HKD","DZ","5","15"),
("1580","HKD","ID","20","65"),
("1581","HKD","NG","10","65"),
("1582","HKD","GT","5","50"),
("1583","HKD","VN","15","55"),
("1584","HKD","BY","5","25"),
("1585","HKD","EG","10","55"),
("1586","HKD","UY","5","35"),
("1587","HKD","BD","5","15"),
("1588","HKD","PK","5","40"),
("1589","HKD","PH","10","40"),
("1590","HKD","ET","5","15"),
("1591","HKD","TN","5","15"),
("1592","HKD","LB","5","20"),
("1593","HKD","IN","5","30"),
("1594","HKD","PY","5","25"),
("1595","HKD","UZ","5","15"),
("1596","HKD","EC","5","25"),
("1597","HKD","MM","5","10"),
("1598","HKD","GE","5","10"),
("1599","HUF","US","6445","18185"),
("1600","HUF","CH","6010","15815"),
("1601","HUF","AU","5470","14040"),
("1602","HUF","GB","4765","12200"),
("1603","HUF","DE","4730","12100"),
("1604","HUF","DK","4355","10805"),
("1605","HUF","AT","3175","9870"),
("1606","HUF","NO","3600","10050"),
("1607","HUF","CA","3980","12205"),
("1608","HUF","NL","4260","10805"),
("1609","HUF","SE","3410","9215"),
("1610","HUF","IE","3375","8890"),
("1611","HUF","BE","3100","9090"),
("1612","HUF","FI","2320","7040"),
("1613","HUF","FR","2870","7685"),
("1614","HUF","NZ","2920","8600"),
("1615","HUF","HK","2655","7515"),
("1616","HUF","CZ","2535","6080"),
("1617","HUF","SK","2390","5180"),
("1618","HUF","AE","2255","7080"),
("1619","HUF","SG","2945","8700"),
("1620","HUF","IL","2570","6280"),
("1621","HUF","KW","1160","5645"),
("1622","HUF","IT","1750","4615"),
("1623","HUF","JP","2190","6230"),
("1624","HUF","ES","1795","4755"),
("1625","HUF","VE","235","3640"),
("1626","HUF","HU","1515","3525"),
("1627","HUF","PT","1510","3940"),
("1628","HUF","GR","1865","3820"),
("1629","HUF","KR","2300","6085"),
("1630","HUF","TW","1870","5000"),
("1631","HUF","PL","1600","3955"),
("1632","HUF","ZM","230","1315"),
("1633","HUF","PR","565","5305"),
("1634","HUF","CI","310","1275"),
("1635","HUF","RO","1470","3555"),
("1636","HUF","BH","665","3695"),
("1637","HUF","PA","445","5075"),
("1638","HUF","GH","535","1495"),
("1639","HUF","KH","310","1480"),
("1640","HUF","SN","225","1610"),
("1641","HUF","SA","960","3670"),
("1642","HUF","RU","950","3040"),
("1643","HUF","UG","225","1175"),
("1644","HUF","BR","1015","2505"),
("1645","HUF","NI","225","1605"),
("1646","HUF","MG","225","1135"),
("1647","HUF","DO","270","1885"),
("1648","HUF","MX","765","2770"),
("1649","HUF","OM","480","2770"),
("1650","HUF","CM","225","2065"),
("1651","HUF","ZA","910","2935"),
("1652","HUF","CL","950","2840"),
("1653","HUF","KE","275","1185"),
("1654","HUF","NP","225","1075"),
("1655","HUF","PE","570","2390"),
("1656","HUF","UA","540","1690"),
("1657","HUF","MZ","225","2245"),
("1658","HUF","TZ","30","515"),
("1659","HUF","AO","495","1290"),
("1660","HUF","JO","365","1730"),
("1661","HUF","ZW","225","1230"),
("1662","HUF","TR","580","1590"),
("1663","HUF","MU","295","1015"),
("1664","HUF","SV","225","1230"),
("1665","HUF","TH","870","2740"),
("1666","HUF","CO","440","1710"),
("1667","HUF","LK","215","295"),
("1668","HUF","CR","270","1790"),
("1669","HUF","AR","600","1630"),
("1670","HUF","MA","270","1055"),
("1671","HUF","MY","765","2805"),
("1672","HUF","KZ","325","1195"),
("1673","HUF","DZ","265","565"),
("1674","HUF","ID","680","2525"),
("1675","HUF","NG","385","2420"),
("1676","HUF","GT","270","1895"),
("1677","HUF","VN","555","2110"),
("1678","HUF","BY","260","1020"),
("1679","HUF","EG","355","2155"),
("1680","HUF","UY","280","1280"),
("1681","HUF","BD","230","505"),
("1682","HUF","PK","250","1445"),
("1683","HUF","PH","435","1605"),
("1684","HUF","ET","70","530"),
("1685","HUF","TN","270","485"),
("1686","HUF","LB","270","810"),
("1687","HUF","IN","250","1125"),
("1688","HUF","PY","270","860"),
("1689","HUF","UZ","270","525"),
("1690","HUF","EC","260","895"),
("1691","HUF","MM","270","295"),
("1692","HUF","GE","270","345"),
("1693","IDR","US","305805","862850"),
("1694","IDR","CH","285175","750420"),
("1695","IDR","AU","259480","666220"),
("1696","IDR","GB","226230","578945"),
("1697","IDR","DE","224510","574265"),
("1698","IDR","DK","206565","512635"),
("1699","IDR","AT","150725","468395"),
("1700","IDR","NO","170840","476995"),
("1701","IDR","CA","188855","579125"),
("1702","IDR","NL","202060","512840"),
("1703","IDR","SE","161735","437360"),
("1704","IDR","IE","160045","421890"),
("1705","IDR","BE","147180","431340"),
("1706","IDR","FI","110030","334155"),
("1707","IDR","FR","136245","364680"),
("1708","IDR","NZ","138660","408205"),
("1709","IDR","HK","126095","356600"),
("1710","IDR","CZ","120220","288620"),
("1711","IDR","SK","113420","245805"),
("1712","IDR","AE","107035","335905"),
("1713","IDR","SG","139655","412750"),
("1714","IDR","IL","121875","298120"),
("1715","IDR","KW","54975","267955"),
("1716","IDR","IT","82960","219010"),
("1717","IDR","JP","104020","295625"),
("1718","IDR","ES","85280","225525"),
("1719","IDR","VE","11180","172745"),
("1720","IDR","HU","71860","167205"),
("1721","IDR","PT","71735","187005"),
("1722","IDR","GR","88455","181160"),
("1723","IDR","KR","109060","288805"),
("1724","IDR","TW","88640","237295"),
("1725","IDR","PL","75845","187750"),
("1726","IDR","ZM","10955","62500"),
("1727","IDR","PR","26790","251850"),
("1728","IDR","CI","14620","60420"),
("1729","IDR","RO","69670","168580"),
("1730","IDR","BH","31635","175390"),
("1731","IDR","PA","21190","240735"),
("1732","IDR","GH","25400","70875"),
("1733","IDR","KH","14640","70310"),
("1734","IDR","SN","10660","76395"),
("1735","IDR","SA","45475","174115"),
("1736","IDR","RU","45190","144210"),
("1737","IDR","UG","10620","55825"),
("1738","IDR","BR","48185","118800"),
("1739","IDR","NI","10595","76070"),
("1740","IDR","MG","10720","53925"),
("1741","IDR","DO","12860","89405"),
("1742","IDR","MX","36335","131490"),
("1743","IDR","OM","22840","131495"),
("1744","IDR","CM","10585","97990"),
("1745","IDR","ZA","43300","139355"),
("1746","IDR","CL","45110","134805"),
("1747","IDR","KE","13020","56270"),
("1748","IDR","NP","10585","51110"),
("1749","IDR","PE","26945","113410"),
("1750","IDR","UA","25685","80225"),
("1751","IDR","MZ","10585","106420"),
("1752","IDR","TZ","1335","24420"),
("1753","IDR","AO","23465","61185"),
("1754","IDR","JO","17305","82175"),
("1755","IDR","ZW","10635","58315"),
("1756","IDR","TR","27565","75415"),
("1757","IDR","MU","14115","48240"),
("1758","IDR","SV","10585","58430"),
("1759","IDR","TH","41350","130110"),
("1760","IDR","CO","20970","81160"),
("1761","IDR","LK","10185","14065"),
("1762","IDR","CR","12785","84925"),
("1763","IDR","AR","28555","77350"),
("1764","IDR","MA","12755","50060"),
("1765","IDR","MY","36190","133085"),
("1766","IDR","KZ","15480","56655"),
("1767","IDR","DZ","12690","26860"),
("1768","IDR","ID","32290","119790"),
("1769","IDR","NG","18150","114815"),
("1770","IDR","GT","12715","89915"),
("1771","IDR","VN","26420","100125"),
("1772","IDR","BY","12405","48295"),
("1773","IDR","EG","16730","102190"),
("1774","IDR","UY","13190","60785"),
("1775","IDR","BD","10860","24040"),
("1776","IDR","PK","11905","68530"),
("1777","IDR","PH","20615","76080"),
("1778","IDR","ET","3305","25200"),
("1779","IDR","TN","12700","23015"),
("1780","IDR","LB","12825","38335"),
("1781","IDR","IN","11825","53405"),
("1782","IDR","PY","12710","40865"),
("1783","IDR","UZ","12715","24810"),
("1784","IDR","EC","12355","42380"),
("1785","IDR","MM","12720","13890"),
("1786","IDR","GE","12760","16260"),
("1787","ILS","US","70","190"),
("1788","ILS","CH","65","165"),
("1789","ILS","AU","60","150"),
("1790","ILS","GB","50","130"),
("1791","ILS","DE","50","130"),
("1792","ILS","DK","45","115"),
("1793","ILS","AT","35","105"),
("1794","ILS","NO","40","105"),
("1795","ILS","CA","40","130"),
("1796","ILS","NL","45","115"),
("1797","ILS","SE","35","95"),
("1798","ILS","IE","35","95"),
("1799","ILS","BE","35","95"),
("1800","ILS","FI","25","75"),
("1801","ILS","FR","30","80"),
("1802","ILS","NZ","30","90"),
("1803","ILS","HK","30","80"),
("1804","ILS","CZ","25","65"),
("1805","ILS","SK","25","55"),
("1806","ILS","AE","25","75"),
("1807","ILS","SG","30","90"),
("1808","ILS","IL","25","65"),
("1809","ILS","KW","10","60"),
("1810","ILS","IT","20","50"),
("1811","ILS","JP","25","65"),
("1812","ILS","ES","20","50"),
("1813","ILS","VE","5","40"),
("1814","ILS","HU","15","35"),
("1815","ILS","PT","15","40"),
("1816","ILS","GR","20","40"),
("1817","ILS","KR","25","65"),
("1818","ILS","TW","20","55"),
("1819","ILS","PL","15","40"),
("1820","ILS","ZM","5","15"),
("1821","ILS","PR","5","55"),
("1822","ILS","CI","5","15"),
("1823","ILS","RO","15","35"),
("1824","ILS","BH","5","40"),
("1825","ILS","PA","5","55"),
("1826","ILS","GH","5","15"),
("1827","ILS","KH","5","15"),
("1828","ILS","SN","5","15"),
("1829","ILS","SA","10","40"),
("1830","ILS","RU","10","30"),
("1831","ILS","UG","5","10"),
("1832","ILS","BR","10","25"),
("1833","ILS","NI","5","15"),
("1834","ILS","MG","5","10"),
("1835","ILS","DO","5","20"),
("1836","ILS","MX","10","30"),
("1837","ILS","OM","5","30"),
("1838","ILS","CM","5","20"),
("1839","ILS","ZA","10","30"),
("1840","ILS","CL","10","30"),
("1841","ILS","KE","5","15"),
("1842","ILS","NP","5","10"),
("1843","ILS","PE","5","25"),
("1844","ILS","UA","5","20"),
("1845","ILS","MZ","5","25"),
("1846","ILS","TZ","5","10"),
("1847","ILS","AO","5","15"),
("1848","ILS","JO","5","20"),
("1849","ILS","ZW","5","15"),
("1850","ILS","TR","5","15"),
("1851","ILS","MU","5","10"),
("1852","ILS","SV","5","15"),
("1853","ILS","TH","10","30"),
("1854","ILS","CO","5","20"),
("1855","ILS","LK","5","10"),
("1856","ILS","CR","5","20"),
("1857","ILS","AR","5","15"),
("1858","ILS","MA","5","10"),
("1859","ILS","MY","10","30"),
("1860","ILS","KZ","5","15"),
("1861","ILS","DZ","5","10"),
("1862","ILS","ID","5","25"),
("1863","ILS","NG","5","25"),
("1864","ILS","GT","5","20"),
("1865","ILS","VN","5","20"),
("1866","ILS","BY","5","10"),
("1867","ILS","EG","5","25"),
("1868","ILS","UY","5","15"),
("1869","ILS","BD","5","10"),
("1870","ILS","PK","5","15"),
("1871","ILS","PH","5","15"),
("1872","ILS","ET","5","10"),
("1873","ILS","TN","5","10"),
("1874","ILS","LB","5","10"),
("1875","ILS","IN","5","10"),
("1876","ILS","PY","5","10"),
("1877","ILS","UZ","5","10"),
("1878","ILS","EC","5","10"),
("1879","ILS","MM","5","10"),
("1880","ILS","GE","5","10"),
("1881","INR","US","1590","4485"),
("1882","INR","CH","1480","3900"),
("1883","INR","AU","1350","3460"),
("1884","INR","GB","1175","3010"),
("1885","INR","DE","1165","2985"),
("1886","INR","DK","1075","2665"),
("1887","INR","AT","785","2435"),
("1888","INR","NO","890","2480"),
("1889","INR","CA","980","3010"),
("1890","INR","NL","1050","2665"),
("1891","INR","SE","840","2275"),
("1892","INR","IE","830","2195"),
("1893","INR","BE","765","2240"),
("1894","INR","FI","570","1735"),
("1895","INR","FR","710","1895"),
("1896","INR","NZ","720","2120"),
("1897","INR","HK","655","1855"),
("1898","INR","CZ","625","1500"),
("1899","INR","SK","590","1280"),
("1900","INR","AE","555","1745"),
("1901","INR","SG","725","2145"),
("1902","INR","IL","635","1550"),
("1903","INR","KW","285","1395"),
("1904","INR","IT","430","1140"),
("1905","INR","JP","540","1535"),
("1906","INR","ES","445","1170"),
("1907","INR","VE","60","900"),
("1908","INR","HU","375","870"),
("1909","INR","PT","375","970"),
("1910","INR","GR","460","940"),
("1911","INR","KR","565","1500"),
("1912","INR","TW","460","1235"),
("1913","INR","PL","395","975"),
("1914","INR","ZM","55","325"),
("1915","INR","PR","140","1310"),
("1916","INR","CI","75","315"),
("1917","INR","RO","360","875"),
("1918","INR","BH","165","910"),
("1919","INR","PA","110","1250"),
("1920","INR","GH","130","370"),
("1921","INR","KH","75","365"),
("1922","INR","SN","55","395"),
("1923","INR","SA","235","905"),
("1924","INR","RU","235","750"),
("1925","INR","UG","55","290"),
("1926","INR","BR","250","615"),
("1927","INR","NI","55","395"),
("1928","INR","MG","55","280"),
("1929","INR","DO","65","465"),
("1930","INR","MX","190","685"),
("1931","INR","OM","120","685"),
("1932","INR","CM","55","510"),
("1933","INR","ZA","225","725"),
("1934","INR","CL","235","700"),
("1935","INR","KE","70","290"),
("1936","INR","NP","55","265"),
("1937","INR","PE","140","590"),
("1938","INR","UA","135","415"),
("1939","INR","MZ","55","555"),
("1940","INR","TZ","5","125"),
("1941","INR","AO","120","320"),
("1942","INR","JO","90","425"),
("1943","INR","ZW","55","305"),
("1944","INR","TR","145","390"),
("1945","INR","MU","75","250"),
("1946","INR","SV","55","305"),
("1947","INR","TH","215","675"),
("1948","INR","CO","110","420"),
("1949","INR","LK","55","75"),
("1950","INR","CR","65","440"),
("1951","INR","AR","150","400"),
("1952","INR","MA","65","260"),
("1953","INR","MY","190","690"),
("1954","INR","KZ","80","295"),
("1955","INR","DZ","65","140"),
("1956","INR","ID","170","625"),
("1957","INR","NG","95","595"),
("1958","INR","GT","65","465"),
("1959","INR","VN","135","520"),
("1960","INR","BY","65","250"),
("1961","INR","EG","85","530"),
("1962","INR","UY","70","315"),
("1963","INR","BD","55","125"),
("1964","INR","PK","60","355"),
("1965","INR","PH","105","395"),
("1966","INR","ET","15","130"),
("1967","INR","TN","65","120"),
("1968","INR","LB","65","200"),
("1969","INR","IN","60","280"),
("1970","INR","PY","65","210"),
("1971","INR","UZ","65","130"),
("1972","INR","EC","65","220"),
("1973","INR","MM","65","70"),
("1974","INR","GE","65","85"),
("1975","JPY","US","2255","6370"),
("1976","JPY","CH","2105","5540"),
("1977","JPY","AU","1915","4915"),
("1978","JPY","GB","1670","4275"),
("1979","JPY","DE","1655","4240"),
("1980","JPY","DK","1525","3785"),
("1981","JPY","AT","1110","3455"),
("1982","JPY","NO","1260","3520"),
("1983","JPY","CA","1395","4275"),
("1984","JPY","NL","1490","3785"),
("1985","JPY","SE","1195","3230"),
("1986","JPY","IE","1180","3115"),
("1987","JPY","BE","1085","3185"),
("1988","JPY","FI","810","2465"),
("1989","JPY","FR","1005","2690"),
("1990","JPY","NZ","1025","3015"),
("1991","JPY","HK","930","2630"),
("1992","JPY","CZ","885","2130"),
("1993","JPY","SK","835","1815"),
("1994","JPY","AE","790","2480"),
("1995","JPY","SG","1030","3045"),
("1996","JPY","IL","900","2200"),
("1997","JPY","KW","405","1980"),
("1998","JPY","IT","610","1615"),
("1999","JPY","JP","770","2180"),
("2000","JPY","ES","630","1665"),
("2001","JPY","VE","85","1275"),
("2002","JPY","HU","530","1235"),
("2003","JPY","PT","530","1380"),
("2004","JPY","GR","655","1335"),
("2005","JPY","KR","805","2130"),
("2006","JPY","TW","655","1750"),
("2007","JPY","PL","560","1385"),
("2008","JPY","ZM","80","460"),
("2009","JPY","PR","200","1860"),
("2010","JPY","CI","110","445"),
("2011","JPY","RO","515","1245"),
("2012","JPY","BH","235","1295"),
("2013","JPY","PA","155","1775"),
("2014","JPY","GH","185","525"),
("2015","JPY","KH","110","520"),
("2016","JPY","SN","80","565"),
("2017","JPY","SA","335","1285"),
("2018","JPY","RU","335","1065"),
("2019","JPY","UG","80","410"),
("2020","JPY","BR","355","875"),
("2021","JPY","NI","80","560"),
("2022","JPY","MG","80","400"),
("2023","JPY","DO","95","660"),
("2024","JPY","MX","270","970"),
("2025","JPY","OM","170","970"),
("2026","JPY","CM","80","725"),
("2027","JPY","ZA","320","1030"),
("2028","JPY","CL","335","995"),
("2029","JPY","KE","95","415"),
("2030","JPY","NP","80","375"),
("2031","JPY","PE","200","835"),
("2032","JPY","UA","190","590"),
("2033","JPY","MZ","80","785"),
("2034","JPY","TZ","10","180"),
("2035","JPY","AO","175","450"),
("2036","JPY","JO","130","605"),
("2037","JPY","ZW","80","430"),
("2038","JPY","TR","205","555"),
("2039","JPY","MU","105","355"),
("2040","JPY","SV","80","430"),
("2041","JPY","TH","305","960"),
("2042","JPY","CO","155","600"),
("2043","JPY","LK","75","105"),
("2044","JPY","CR","95","625"),
("2045","JPY","AR","210","570"),
("2046","JPY","MA","95","370"),
("2047","JPY","MY","265","980"),
("2048","JPY","KZ","115","420"),
("2049","JPY","DZ","95","200"),
("2050","JPY","ID","240","885"),
("2051","JPY","NG","135","845"),
("2052","JPY","GT","95","665"),
("2053","JPY","VN","195","740"),
("2054","JPY","BY","90","355"),
("2055","JPY","EG","125","755"),
("2056","JPY","UY","95","450"),
("2057","JPY","BD","80","175"),
("2058","JPY","PK","90","505"),
("2059","JPY","PH","150","560"),
("2060","JPY","ET","25","185"),
("2061","JPY","TN","95","170"),
("2062","JPY","LB","95","285"),
("2063","JPY","IN","85","395"),
("2064","JPY","PY","95","300"),
("2065","JPY","UZ","95","185"),
("2066","JPY","EC","90","315"),
("2067","JPY","MM","95","105"),
("2068","JPY","GE","95","120"),
("2069","KRW","US","23860","67325"),
("2070","KRW","CH","22250","58550"),
("2071","KRW","AU","20245","51980"),
("2072","KRW","GB","17650","45170"),
("2073","KRW","DE","17515","44805"),
("2074","KRW","DK","16115","40000"),
("2075","KRW","AT","11760","36545"),
("2076","KRW","NO","13330","37215"),
("2077","KRW","CA","14735","45185"),
("2078","KRW","NL","15765","40015"),
("2079","KRW","SE","12620","34125"),
("2080","KRW","IE","12490","32920"),
("2081","KRW","BE","11485","33655"),
("2082","KRW","FI","8585","26070"),
("2083","KRW","FR","10630","28455"),
("2084","KRW","NZ","10820","31850"),
("2085","KRW","HK","9840","27825"),
("2086","KRW","CZ","9380","22520"),
("2087","KRW","SK","8850","19180"),
("2088","KRW","AE","8350","26210"),
("2089","KRW","SG","10895","32205"),
("2090","KRW","IL","9510","23260"),
("2091","KRW","KW","4290","20905"),
("2092","KRW","IT","6475","17090"),
("2093","KRW","JP","8115","23065"),
("2094","KRW","ES","6655","17595"),
("2095","KRW","VE","870","13480"),
("2096","KRW","HU","5605","13045"),
("2097","KRW","PT","5595","14590"),
("2098","KRW","GR","6900","14135"),
("2099","KRW","KR","8510","22535"),
("2100","KRW","TW","6915","18515"),
("2101","KRW","PL","5920","14650"),
("2102","KRW","ZM","855","4875"),
("2103","KRW","PR","2090","19650"),
("2104","KRW","CI","1140","4715"),
("2105","KRW","RO","5435","13155"),
("2106","KRW","BH","2470","13685"),
("2107","KRW","PA","1655","18785"),
("2108","KRW","GH","1980","5530"),
("2109","KRW","KH","1140","5485"),
("2110","KRW","SN","830","5960"),
("2111","KRW","SA","3550","13585"),
("2112","KRW","RU","3525","11250"),
("2113","KRW","UG","830","4355"),
("2114","KRW","BR","3760","9270"),
("2115","KRW","NI","825","5935"),
("2116","KRW","MG","835","4205"),
("2117","KRW","DO","1005","6975"),
("2118","KRW","MX","2835","10260"),
("2119","KRW","OM","1780","10260"),
("2120","KRW","CM","825","7645"),
("2121","KRW","ZA","3380","10875"),
("2122","KRW","CL","3520","10520"),
("2123","KRW","KE","1015","4390"),
("2124","KRW","NP","825","3990"),
("2125","KRW","PE","2100","8850"),
("2126","KRW","UA","2005","6260"),
("2127","KRW","MZ","825","8305"),
("2128","KRW","TZ","105","1905"),
("2129","KRW","AO","1830","4775"),
("2130","KRW","JO","1350","6410"),
("2131","KRW","ZW","830","4550"),
("2132","KRW","TR","2150","5885"),
("2133","KRW","MU","1100","3765"),
("2134","KRW","SV","825","4560"),
("2135","KRW","TH","3225","10150"),
("2136","KRW","CO","1635","6335"),
("2137","KRW","LK","795","1095"),
("2138","KRW","CR","995","6625"),
("2139","KRW","AR","2230","6035"),
("2140","KRW","MA","995","3905"),
("2141","KRW","MY","2825","10385"),
("2142","KRW","KZ","1210","4420"),
("2143","KRW","DZ","990","2095"),
("2144","KRW","ID","2520","9345"),
("2145","KRW","NG","1415","8960"),
("2146","KRW","GT","990","7015"),
("2147","KRW","VN","2060","7810"),
("2148","KRW","BY","970","3770"),
("2149","KRW","EG","1305","7975"),
("2150","KRW","UY","1030","4745"),
("2151","KRW","BD","845","1875"),
("2152","KRW","PK","930","5345"),
("2153","KRW","PH","1610","5935"),
("2154","KRW","ET","260","1965"),
("2155","KRW","TN","990","1795"),
("2156","KRW","LB","1000","2990"),
("2157","KRW","IN","925","4165"),
("2158","KRW","PY","990","3190"),
("2159","KRW","UZ","990","1935"),
("2160","KRW","EC","965","3305"),
("2161","KRW","MM","990","1085"),
("2162","KRW","GE","995","1270"),
("2163","MAD","US","195","545"),
("2164","MAD","CH","180","475"),
("2165","MAD","AU","165","420"),
("2166","MAD","GB","145","365"),
("2167","MAD","DE","140","360"),
("2168","MAD","DK","130","325"),
("2169","MAD","AT","95","295"),
("2170","MAD","NO","110","300"),
("2171","MAD","CA","120","365"),
("2172","MAD","NL","125","325"),
("2173","MAD","SE","100","275"),
("2174","MAD","IE","100","265"),
("2175","MAD","BE","95","270"),
("2176","MAD","FI","70","210"),
("2177","MAD","FR","85","230"),
("2178","MAD","NZ","85","255"),
("2179","MAD","HK","80","225"),
("2180","MAD","CZ","75","180"),
("2181","MAD","SK","70","155"),
("2182","MAD","AE","65","210"),
("2183","MAD","SG","90","260"),
("2184","MAD","IL","75","190"),
("2185","MAD","KW","35","170"),
("2186","MAD","IT","50","140"),
("2187","MAD","JP","65","185"),
("2188","MAD","ES","55","140"),
("2189","MAD","VE","5","110"),
("2190","MAD","HU","45","105"),
("2191","MAD","PT","45","120"),
("2192","MAD","GR","55","115"),
("2193","MAD","KR","70","180"),
("2194","MAD","TW","55","150"),
("2195","MAD","PL","50","120"),
("2196","MAD","ZM","5","40"),
("2197","MAD","PR","15","160"),
("2198","MAD","CI","10","40"),
("2199","MAD","RO","45","105"),
("2200","MAD","BH","20","110"),
("2201","MAD","PA","15","150"),
("2202","MAD","GH","15","45"),
("2203","MAD","KH","10","45"),
("2204","MAD","SN","5","50"),
("2205","MAD","SA","30","110"),
("2206","MAD","RU","30","90"),
("2207","MAD","UG","5","35"),
("2208","MAD","BR","30","75"),
("2209","MAD","NI","5","50"),
("2210","MAD","MG","5","35"),
("2211","MAD","DO","10","55"),
("2212","MAD","MX","25","85"),
("2213","MAD","OM","15","85"),
("2214","MAD","CM","5","60"),
("2215","MAD","ZA","25","90"),
("2216","MAD","CL","30","85"),
("2217","MAD","KE","10","35"),
("2218","MAD","NP","5","30"),
("2219","MAD","PE","15","70"),
("2220","MAD","UA","15","50"),
("2221","MAD","MZ","5","65"),
("2222","MAD","TZ","5","15"),
("2223","MAD","AO","15","40"),
("2224","MAD","JO","10","50"),
("2225","MAD","ZW","5","35"),
("2226","MAD","TR","15","50"),
("2227","MAD","MU","10","30"),
("2228","MAD","SV","5","35"),
("2229","MAD","TH","25","80"),
("2230","MAD","CO","15","50"),
("2231","MAD","LK","5","10"),
("2232","MAD","CR","10","55"),
("2233","MAD","AR","20","50"),
("2234","MAD","MA","10","30"),
("2235","MAD","MY","25","85"),
("2236","MAD","KZ","10","35"),
("2237","MAD","DZ","10","15"),
("2238","MAD","ID","20","75"),
("2239","MAD","NG","10","70"),
("2240","MAD","GT","10","55"),
("2241","MAD","VN","15","65"),
("2242","MAD","BY","10","30"),
("2243","MAD","EG","10","65"),
("2244","MAD","UY","10","40"),
("2245","MAD","BD","5","15"),
("2246","MAD","PK","10","45"),
("2247","MAD","PH","15","50"),
("2248","MAD","ET","5","15"),
("2249","MAD","TN","10","15"),
("2250","MAD","LB","10","25"),
("2251","MAD","IN","5","35"),
("2252","MAD","PY","10","25"),
("2253","MAD","UZ","10","15"),
("2254","MAD","EC","10","25"),
("2255","MAD","MM","10","15"),
("2256","MAD","GE","10","15"),
("2257","MXN","US","430","1215"),
("2258","MXN","CH","400","1060"),
("2259","MXN","AU","365","940"),
("2260","MXN","GB","320","815"),
("2261","MXN","DE","315","810"),
("2262","MXN","DK","290","725"),
("2263","MXN","AT","215","660"),
("2264","MXN","NO","240","675"),
("2265","MXN","CA","265","815"),
("2266","MXN","NL","285","725"),
("2267","MXN","SE","230","615"),
("2268","MXN","IE","225","595"),
("2269","MXN","BE","210","610"),
("2270","MXN","FI","155","470"),
("2271","MXN","FR","190","515"),
("2272","MXN","NZ","195","575"),
("2273","MXN","HK","180","505"),
("2274","MXN","CZ","170","405"),
("2275","MXN","SK","160","345"),
("2276","MXN","AE","150","475"),
("2277","MXN","SG","195","580"),
("2278","MXN","IL","170","420"),
("2279","MXN","KW","80","380"),
("2280","MXN","IT","115","310"),
("2281","MXN","JP","145","415"),
("2282","MXN","ES","120","320"),
("2283","MXN","VE","15","245"),
("2284","MXN","HU","100","235"),
("2285","MXN","PT","100","265"),
("2286","MXN","GR","125","255"),
("2287","MXN","KR","155","405"),
("2288","MXN","TW","125","335"),
("2289","MXN","PL","105","265"),
("2290","MXN","ZM","15","90"),
("2291","MXN","PR","40","355"),
("2292","MXN","CI","20","85"),
("2293","MXN","RO","100","240"),
("2294","MXN","BH","45","245"),
("2295","MXN","PA","30","340"),
("2296","MXN","GH","35","100"),
("2297","MXN","KH","20","100"),
("2298","MXN","SN","15","110"),
("2299","MXN","SA","65","245"),
("2300","MXN","RU","65","205"),
("2301","MXN","UG","15","80"),
("2302","MXN","BR","70","165"),
("2303","MXN","NI","15","105"),
("2304","MXN","MG","15","75"),
("2305","MXN","DO","20","125"),
("2306","MXN","MX","50","185"),
("2307","MXN","OM","30","185"),
("2308","MXN","CM","15","140"),
("2309","MXN","ZA","60","195"),
("2310","MXN","CL","65","190"),
("2311","MXN","KE","20","80"),
("2312","MXN","NP","15","70"),
("2313","MXN","PE","40","160"),
("2314","MXN","UA","35","115"),
("2315","MXN","MZ","15","150"),
("2316","MXN","TZ","5","35"),
("2317","MXN","AO","35","85"),
("2318","MXN","JO","25","115"),
("2319","MXN","ZW","15","80"),
("2320","MXN","TR","40","105"),
("2321","MXN","MU","20","70"),
("2322","MXN","SV","15","80"),
("2323","MXN","TH","60","185"),
("2324","MXN","CO","30","115"),
("2325","MXN","LK","15","20"),
("2326","MXN","CR","20","120"),
("2327","MXN","AR","40","110"),
("2328","MXN","MA","20","70"),
("2329","MXN","MY","50","190"),
("2330","MXN","KZ","20","80"),
("2331","MXN","DZ","20","40"),
("2332","MXN","ID","45","170"),
("2333","MXN","NG","25","160"),
("2334","MXN","GT","20","125"),
("2335","MXN","VN","35","140"),
("2336","MXN","BY","15","70"),
("2337","MXN","EG","25","145"),
("2338","MXN","UY","20","85"),
("2339","MXN","BD","15","35"),
("2340","MXN","PK","15","95"),
("2341","MXN","PH","30","105"),
("2342","MXN","ET","5","35"),
("2343","MXN","TN","20","30"),
("2344","MXN","LB","20","55"),
("2345","MXN","IN","15","75"),
("2346","MXN","PY","20","60"),
("2347","MXN","UZ","20","35"),
("2348","MXN","EC","15","60"),
("2349","MXN","MM","20","25"),
("2350","MXN","GE","20","25"),
("2351","MYR","US","90","250"),
("2352","MYR","CH","80","215"),
("2353","MYR","AU","75","190"),
("2354","MYR","GB","65","165"),
("2355","MYR","DE","65","165"),
("2356","MYR","DK","60","145"),
("2357","MYR","AT","45","135"),
("2358","MYR","NO","50","135"),
("2359","MYR","CA","55","165"),
("2360","MYR","NL","60","145"),
("2361","MYR","SE","45","125"),
("2362","MYR","IE","45","120"),
("2363","MYR","BE","40","125"),
("2364","MYR","FI","30","95"),
("2365","MYR","FR","40","105"),
("2366","MYR","NZ","40","115"),
("2367","MYR","HK","35","100"),
("2368","MYR","CZ","35","85"),
("2369","MYR","SK","35","70"),
("2370","MYR","AE","30","95"),
("2371","MYR","SG","40","120"),
("2372","MYR","IL","35","85"),
("2373","MYR","KW","15","75"),
("2374","MYR","IT","25","65"),
("2375","MYR","JP","30","85"),
("2376","MYR","ES","25","65"),
("2377","MYR","VE","5","50"),
("2378","MYR","HU","20","50"),
("2379","MYR","PT","20","55"),
("2380","MYR","GR","25","50"),
("2381","MYR","KR","30","85"),
("2382","MYR","TW","25","70"),
("2383","MYR","PL","20","55"),
("2384","MYR","ZM","5","20"),
("2385","MYR","PR","10","70"),
("2386","MYR","CI","5","15"),
("2387","MYR","RO","20","50"),
("2388","MYR","BH","10","50"),
("2389","MYR","PA","5","70"),
("2390","MYR","GH","5","20"),
("2391","MYR","KH","5","20"),
("2392","MYR","SN","5","20"),
("2393","MYR","SA","15","50"),
("2394","MYR","RU","15","40"),
("2395","MYR","UG","5","15"),
("2396","MYR","BR","15","35"),
("2397","MYR","NI","5","20"),
("2398","MYR","MG","5","15"),
("2399","MYR","DO","5","25"),
("2400","MYR","MX","10","40"),
("2401","MYR","OM","5","40"),
("2402","MYR","CM","5","30"),
("2403","MYR","ZA","10","40"),
("2404","MYR","CL","15","40"),
("2405","MYR","KE","5","15"),
("2406","MYR","NP","5","15"),
("2407","MYR","PE","10","35"),
("2408","MYR","UA","5","25"),
("2409","MYR","MZ","5","30"),
("2410","MYR","TZ","5","10"),
("2411","MYR","AO","5","20"),
("2412","MYR","JO","5","25"),
("2413","MYR","ZW","5","15"),
("2414","MYR","TR","10","20"),
("2415","MYR","MU","5","15"),
("2416","MYR","SV","5","15"),
("2417","MYR","TH","10","35"),
("2418","MYR","CO","5","25"),
("2419","MYR","LK","5","10"),
("2420","MYR","CR","5","25"),
("2421","MYR","AR","10","20"),
("2422","MYR","MA","5","15"),
("2423","MYR","MY","10","40"),
("2424","MYR","KZ","5","15"),
("2425","MYR","DZ","5","10"),
("2426","MYR","ID","10","35"),
("2427","MYR","NG","5","35"),
("2428","MYR","GT","5","25"),
("2429","MYR","VN","10","30"),
("2430","MYR","BY","5","15"),
("2431","MYR","EG","5","30"),
("2432","MYR","UY","5","15"),
("2433","MYR","BD","5","10"),
("2434","MYR","PK","5","20"),
("2435","MYR","PH","5","20"),
("2436","MYR","ET","5","10"),
("2437","MYR","TN","5","10"),
("2438","MYR","LB","5","10"),
("2439","MYR","IN","5","15"),
("2440","MYR","PY","5","10"),
("2441","MYR","UZ","5","10"),
("2442","MYR","EC","5","10"),
("2443","MYR","MM","5","10"),
("2444","MYR","GE","5","10"),
("2445","NGN","US","8270","23330"),
("2446","NGN","CH","7710","20290"),
("2447","NGN","AU","7015","18010"),
("2448","NGN","GB","6115","15650"),
("2449","NGN","DE","6070","15525"),
("2450","NGN","DK","5585","13860"),
("2451","NGN","AT","4075","12665"),
("2452","NGN","NO","4620","12895"),
("2453","NGN","CA","5105","15655"),
("2454","NGN","NL","5465","13865"),
("2455","NGN","SE","4375","11825"),
("2456","NGN","IE","4325","11405"),
("2457","NGN","BE","3980","11660"),
("2458","NGN","FI","2975","9035"),
("2459","NGN","FR","3685","9860"),
("2460","NGN","NZ","3750","11035"),
("2461","NGN","HK","3410","9640"),
("2462","NGN","CZ","3250","7805"),
("2463","NGN","SK","3065","6645"),
("2464","NGN","AE","2895","9080"),
("2465","NGN","SG","3775","11160"),
("2466","NGN","IL","3295","8060"),
("2467","NGN","KW","1485","7245"),
("2468","NGN","IT","2245","5920"),
("2469","NGN","JP","2810","7995"),
("2470","NGN","ES","2305","6095"),
("2471","NGN","VE","300","4670"),
("2472","NGN","HU","1945","4520"),
("2473","NGN","PT","1940","5055"),
("2474","NGN","GR","2390","4900"),
("2475","NGN","KR","2950","7810"),
("2476","NGN","TW","2395","6415"),
("2477","NGN","PL","2050","5075"),
("2478","NGN","ZM","295","1690"),
("2479","NGN","PR","725","6810"),
("2480","NGN","CI","395","1635"),
("2481","NGN","RO","1885","4560"),
("2482","NGN","BH","855","4740"),
("2483","NGN","PA","575","6510"),
("2484","NGN","GH","685","1915"),
("2485","NGN","KH","395","1900"),
("2486","NGN","SN","290","2065"),
("2487","NGN","SA","1230","4705"),
("2488","NGN","RU","1220","3900"),
("2489","NGN","UG","285","1510"),
("2490","NGN","BR","1305","3210"),
("2491","NGN","NI","285","2055"),
("2492","NGN","MG","290","1460"),
("2493","NGN","DO","350","2415"),
("2494","NGN","MX","980","3555"),
("2495","NGN","OM","620","3555"),
("2496","NGN","CM","285","2650"),
("2497","NGN","ZA","1170","3770"),
("2498","NGN","CL","1220","3645"),
("2499","NGN","KE","350","1520"),
("2500","NGN","NP","285","1380"),
("2501","NGN","PE","730","3065"),
("2502","NGN","UA","695","2170"),
("2503","NGN","MZ","285","2875"),
("2504","NGN","TZ","35","660"),
("2505","NGN","AO","635","1655"),
("2506","NGN","JO","470","2220"),
("2507","NGN","ZW","290","1575"),
("2508","NGN","TR","745","2040"),
("2509","NGN","MU","380","1305"),
("2510","NGN","SV","285","1580"),
("2511","NGN","TH","1120","3520"),
("2512","NGN","CO","565","2195"),
("2513","NGN","LK","275","380"),
("2514","NGN","CR","345","2295"),
("2515","NGN","AR","770","2090"),
("2516","NGN","MA","345","1355"),
("2517","NGN","MY","980","3600"),
("2518","NGN","KZ","420","1530"),
("2519","NGN","DZ","345","725"),
("2520","NGN","ID","875","3240"),
("2521","NGN","NG","490","3105"),
("2522","NGN","GT","345","2430"),
("2523","NGN","VN","715","2705"),
("2524","NGN","BY","335","1305"),
("2525","NGN","EG","450","2765"),
("2526","NGN","UY","355","1645"),
("2527","NGN","BD","295","650"),
("2528","NGN","PK","320","1855"),
("2529","NGN","PH","555","2055"),
("2530","NGN","ET","90","680"),
("2531","NGN","TN","345","620"),
("2532","NGN","LB","345","1035"),
("2533","NGN","IN","320","1445"),
("2534","NGN","PY","345","1105"),
("2535","NGN","UZ","345","670"),
("2536","NGN","EC","335","1145"),
("2537","NGN","MM","345","375"),
("2538","NGN","GE","345","440"),
("2539","NOK","US","185","520"),
("2540","NOK","CH","170","450"),
("2541","NOK","AU","155","400"),
("2542","NOK","GB","135","350"),
("2543","NOK","DE","135","345"),
("2544","NOK","DK","125","310"),
("2545","NOK","AT","90","280"),
("2546","NOK","NO","105","285"),
("2547","NOK","CA","115","350"),
("2548","NOK","NL","120","310"),
("2549","NOK","SE","95","265"),
("2550","NOK","IE","95","255"),
("2551","NOK","BE","90","260"),
("2552","NOK","FI","65","200"),
("2553","NOK","FR","80","220"),
("2554","NOK","NZ","85","245"),
("2555","NOK","HK","75","215"),
("2556","NOK","CZ","70","175"),
("2557","NOK","SK","70","150"),
("2558","NOK","AE","65","200"),
("2559","NOK","SG","85","250"),
("2560","NOK","IL","75","180"),
("2561","NOK","KW","35","160"),
("2562","NOK","IT","50","130"),
("2563","NOK","JP","65","180"),
("2564","NOK","ES","50","135"),
("2565","NOK","VE","5","105"),
("2566","NOK","HU","45","100"),
("2567","NOK","PT","45","115"),
("2568","NOK","GR","55","110"),
("2569","NOK","KR","65","175"),
("2570","NOK","TW","55","145"),
("2571","NOK","PL","45","115"),
("2572","NOK","ZM","5","40"),
("2573","NOK","PR","15","150"),
("2574","NOK","CI","10","35"),
("2575","NOK","RO","40","100"),
("2576","NOK","BH","20","105"),
("2577","NOK","PA","15","145"),
("2578","NOK","GH","15","45"),
("2579","NOK","KH","10","40"),
("2580","NOK","SN","5","45"),
("2581","NOK","SA","25","105"),
("2582","NOK","RU","25","85"),
("2583","NOK","UG","5","35"),
("2584","NOK","BR","30","70"),
("2585","NOK","NI","5","45"),
("2586","NOK","MG","5","30"),
("2587","NOK","DO","10","55"),
("2588","NOK","MX","20","80"),
("2589","NOK","OM","15","80"),
("2590","NOK","CM","5","60"),
("2591","NOK","ZA","25","85"),
("2592","NOK","CL","25","80"),
("2593","NOK","KE","10","35"),
("2594","NOK","NP","5","30"),
("2595","NOK","PE","15","70"),
("2596","NOK","UA","15","50"),
("2597","NOK","MZ","5","65"),
("2598","NOK","TZ","5","15"),
("2599","NOK","AO","15","35"),
("2600","NOK","JO","10","50"),
("2601","NOK","ZW","5","35"),
("2602","NOK","TR","15","45"),
("2603","NOK","MU","10","30"),
("2604","NOK","SV","5","35"),
("2605","NOK","TH","25","80"),
("2606","NOK","CO","15","50"),
("2607","NOK","LK","5","10"),
("2608","NOK","CR","10","50"),
("2609","NOK","AR","15","45"),
("2610","NOK","MA","10","30"),
("2611","NOK","MY","20","80"),
("2612","NOK","KZ","10","35"),
("2613","NOK","DZ","10","15"),
("2614","NOK","ID","20","70"),
("2615","NOK","NG","10","70"),
("2616","NOK","GT","10","55"),
("2617","NOK","VN","15","60"),
("2618","NOK","BY","5","30"),
("2619","NOK","EG","10","60"),
("2620","NOK","UY","10","35"),
("2621","NOK","BD","5","15"),
("2622","NOK","PK","5","40"),
("2623","NOK","PH","10","45"),
("2624","NOK","ET","5","15"),
("2625","NOK","TN","10","15"),
("2626","NOK","LB","10","25"),
("2627","NOK","IN","5","30"),
("2628","NOK","PY","10","25"),
("2629","NOK","UZ","10","15"),
("2630","NOK","EC","5","25"),
("2631","NOK","MM","10","15"),
("2632","NOK","GE","10","15"),
("2633","PEN","US","80","220"),
("2634","PEN","CH","75","195"),
("2635","PEN","AU","65","170"),
("2636","PEN","GB","60","150"),
("2637","PEN","DE","60","145"),
("2638","PEN","DK","55","130"),
("2639","PEN","AT","40","120"),
("2640","PEN","NO","45","120"),
("2641","PEN","CA","50","150"),
("2642","PEN","NL","50","130"),
("2643","PEN","SE","40","110"),
("2644","PEN","IE","40","110"),
("2645","PEN","BE","40","110"),
("2646","PEN","FI","30","85"),
("2647","PEN","FR","35","95"),
("2648","PEN","NZ","35","105"),
("2649","PEN","HK","30","90"),
("2650","PEN","CZ","30","75"),
("2651","PEN","SK","30","65"),
("2652","PEN","AE","25","85"),
("2653","PEN","SG","35","105"),
("2654","PEN","IL","30","75"),
("2655","PEN","KW","15","70"),
("2656","PEN","IT","20","55"),
("2657","PEN","JP","25","75"),
("2658","PEN","ES","20","60"),
("2659","PEN","VE","5","45"),
("2660","PEN","HU","20","45"),
("2661","PEN","PT","20","50"),
("2662","PEN","GR","25","45"),
("2663","PEN","KR","30","75"),
("2664","PEN","TW","25","60"),
("2665","PEN","PL","20","50"),
("2666","PEN","ZM","5","15"),
("2667","PEN","PR","5","65"),
("2668","PEN","CI","5","15"),
("2669","PEN","RO","20","45"),
("2670","PEN","BH","10","45"),
("2671","PEN","PA","5","60"),
("2672","PEN","GH","5","20"),
("2673","PEN","KH","5","20"),
("2674","PEN","SN","5","20"),
("2675","PEN","SA","10","45"),
("2676","PEN","RU","10","35"),
("2677","PEN","UG","5","15"),
("2678","PEN","BR","10","30"),
("2679","PEN","NI","5","20"),
("2680","PEN","MG","5","15"),
("2681","PEN","DO","5","25"),
("2682","PEN","MX","10","35"),
("2683","PEN","OM","5","35"),
("2684","PEN","CM","5","25"),
("2685","PEN","ZA","10","35"),
("2686","PEN","CL","10","35"),
("2687","PEN","KE","5","15"),
("2688","PEN","NP","5","15"),
("2689","PEN","PE","5","30"),
("2690","PEN","UA","5","20"),
("2691","PEN","MZ","5","25"),
("2692","PEN","TZ","5","10"),
("2693","PEN","AO","5","15"),
("2694","PEN","JO","5","20"),
("2695","PEN","ZW","5","15"),
("2696","PEN","TR","5","20"),
("2697","PEN","MU","5","10"),
("2698","PEN","SV","5","15"),
("2699","PEN","TH","10","35"),
("2700","PEN","CO","5","20"),
("2701","PEN","LK","5","10"),
("2702","PEN","CR","5","20"),
("2703","PEN","AR","5","20"),
("2704","PEN","MA","5","15"),
("2705","PEN","MY","10","35"),
("2706","PEN","KZ","5","15"),
("2707","PEN","DZ","5","10"),
("2708","PEN","ID","10","30"),
("2709","PEN","NG","5","30"),
("2710","PEN","GT","5","25"),
("2711","PEN","VN","5","25"),
("2712","PEN","BY","5","10"),
("2713","PEN","EG","5","25"),
("2714","PEN","UY","5","15"),
("2715","PEN","BD","5","10"),
("2716","PEN","PK","5","20"),
("2717","PEN","PH","5","20"),
("2718","PEN","ET","5","10"),
("2719","PEN","TN","5","10"),
("2720","PEN","LB","5","10"),
("2721","PEN","IN","5","15"),
("2722","PEN","PY","5","10"),
("2723","PEN","UZ","5","10"),
("2724","PEN","EC","5","10"),
("2725","PEN","MM","5","10"),
("2726","PEN","GE","5","10"),
("2727","PHP","US","1045","2945"),
("2728","PHP","CH","975","2560"),
("2729","PHP","AU","885","2270"),
("2730","PHP","GB","770","1975"),
("2731","PHP","DE","765","1960"),
("2732","PHP","DK","705","1750"),
("2733","PHP","AT","515","1600"),
("2734","PHP","NO","585","1625"),
("2735","PHP","CA","645","1975"),
("2736","PHP","NL","690","1750"),
("2737","PHP","SE","550","1490"),
("2738","PHP","IE","545","1440"),
("2739","PHP","BE","500","1470"),
("2740","PHP","FI","375","1140"),
("2741","PHP","FR","465","1245"),
("2742","PHP","NZ","475","1390"),
("2743","PHP","HK","430","1215"),
("2744","PHP","CZ","410","985"),
("2745","PHP","SK","385","840"),
("2746","PHP","AE","365","1145"),
("2747","PHP","SG","475","1410"),
("2748","PHP","IL","415","1015"),
("2749","PHP","KW","185","915"),
("2750","PHP","IT","285","745"),
("2751","PHP","JP","355","1010"),
("2752","PHP","ES","290","770"),
("2753","PHP","VE","40","590"),
("2754","PHP","HU","245","570"),
("2755","PHP","PT","245","640"),
("2756","PHP","GR","300","620"),
("2757","PHP","KR","370","985"),
("2758","PHP","TW","300","810"),
("2759","PHP","PL","260","640"),
("2760","PHP","ZM","35","215"),
("2761","PHP","PR","90","860"),
("2762","PHP","CI","50","205"),
("2763","PHP","RO","240","575"),
("2764","PHP","BH","110","600"),
("2765","PHP","PA","70","820"),
("2766","PHP","GH","85","240"),
("2767","PHP","KH","50","240"),
("2768","PHP","SN","35","260"),
("2769","PHP","SA","155","595"),
("2770","PHP","RU","155","490"),
("2771","PHP","UG","35","190"),
("2772","PHP","BR","165","405"),
("2773","PHP","NI","35","260"),
("2774","PHP","MG","35","185"),
("2775","PHP","DO","45","305"),
("2776","PHP","MX","125","450"),
("2777","PHP","OM","80","450"),
("2778","PHP","CM","35","335"),
("2779","PHP","ZA","150","475"),
("2780","PHP","CL","155","460"),
("2781","PHP","KE","45","190"),
("2782","PHP","NP","35","175"),
("2783","PHP","PE","90","385"),
("2784","PHP","UA","90","275"),
("2785","PHP","MZ","35","365"),
("2786","PHP","TZ","5","85"),
("2787","PHP","AO","80","210"),
("2788","PHP","JO","60","280"),
("2789","PHP","ZW","35","200"),
("2790","PHP","TR","95","255"),
("2791","PHP","MU","50","165"),
("2792","PHP","SV","35","200"),
("2793","PHP","TH","140","445"),
("2794","PHP","CO","70","275"),
("2795","PHP","LK","35","50"),
("2796","PHP","CR","45","290"),
("2797","PHP","AR","95","265"),
("2798","PHP","MA","45","170"),
("2799","PHP","MY","125","455"),
("2800","PHP","KZ","55","195"),
("2801","PHP","DZ","45","90"),
("2802","PHP","ID","110","410"),
("2803","PHP","NG","60","390"),
("2804","PHP","GT","45","305"),
("2805","PHP","VN","90","340"),
("2806","PHP","BY","40","165"),
("2807","PHP","EG","55","350"),
("2808","PHP","UY","45","205"),
("2809","PHP","BD","35","80"),
("2810","PHP","PK","40","235"),
("2811","PHP","PH","70","260"),
("2812","PHP","ET","10","85"),
("2813","PHP","TN","45","80"),
("2814","PHP","LB","45","130"),
("2815","PHP","IN","40","180"),
("2816","PHP","PY","45","140"),
("2817","PHP","UZ","45","85"),
("2818","PHP","EC","40","145"),
("2819","PHP","MM","45","50"),
("2820","PHP","GE","45","55"),
("2821","PKR","US","3485","9840"),
("2822","PKR","CH","3250","8555"),
("2823","PKR","AU","2960","7595"),
("2824","PKR","GB","2580","6600"),
("2825","PKR","DE","2560","6550"),
("2826","PKR","DK","2355","5845"),
("2827","PKR","AT","1720","5340"),
("2828","PKR","NO","1950","5440"),
("2829","PKR","CA","2155","6605"),
("2830","PKR","NL","2305","5850"),
("2831","PKR","SE","1845","4985"),
("2832","PKR","IE","1825","4810"),
("2833","PKR","BE","1680","4920"),
("2834","PKR","FI","1255","3810"),
("2835","PKR","FR","1555","4160"),
("2836","PKR","NZ","1580","4655"),
("2837","PKR","HK","1440","4065"),
("2838","PKR","CZ","1370","3290"),
("2839","PKR","SK","1295","2805"),
("2840","PKR","AE","1220","3830"),
("2841","PKR","SG","1590","4705"),
("2842","PKR","IL","1390","3400"),
("2843","PKR","KW","625","3055"),
("2844","PKR","IT","945","2495"),
("2845","PKR","JP","1185","3370"),
("2846","PKR","ES","970","2570"),
("2847","PKR","VE","125","1970"),
("2848","PKR","HU","820","1905"),
("2849","PKR","PT","820","2130"),
("2850","PKR","GR","1010","2065"),
("2851","PKR","KR","1245","3295"),
("2852","PKR","TW","1010","2705"),
("2853","PKR","PL","865","2140"),
("2854","PKR","ZM","125","715"),
("2855","PKR","PR","305","2870"),
("2856","PKR","CI","165","690"),
("2857","PKR","RO","795","1920"),
("2858","PKR","BH","360","2000"),
("2859","PKR","PA","240","2745"),
("2860","PKR","GH","290","810"),
("2861","PKR","KH","165","800"),
("2862","PKR","SN","120","870"),
("2863","PKR","SA","520","1985"),
("2864","PKR","RU","515","1645"),
("2865","PKR","UG","120","635"),
("2866","PKR","BR","550","1355"),
("2867","PKR","NI","120","865"),
("2868","PKR","MG","120","615"),
("2869","PKR","DO","145","1020"),
("2870","PKR","MX","415","1500"),
("2871","PKR","OM","260","1500"),
("2872","PKR","CM","120","1115"),
("2873","PKR","ZA","495","1590"),
("2874","PKR","CL","515","1535"),
("2875","PKR","KE","150","640"),
("2876","PKR","NP","120","585"),
("2877","PKR","PE","305","1295"),
("2878","PKR","UA","295","915"),
("2879","PKR","MZ","120","1215"),
("2880","PKR","TZ","15","280"),
("2881","PKR","AO","270","700"),
("2882","PKR","JO","195","935"),
("2883","PKR","ZW","120","665"),
("2884","PKR","TR","315","860"),
("2885","PKR","MU","160","550"),
("2886","PKR","SV","120","665"),
("2887","PKR","TH","470","1485"),
("2888","PKR","CO","240","925"),
("2889","PKR","LK","115","160"),
("2890","PKR","CR","145","970"),
("2891","PKR","AR","325","880"),
("2892","PKR","MA","145","570"),
("2893","PKR","MY","415","1515"),
("2894","PKR","KZ","175","645"),
("2895","PKR","DZ","145","305"),
("2896","PKR","ID","370","1365"),
("2897","PKR","NG","205","1310"),
("2898","PKR","GT","145","1025"),
("2899","PKR","VN","300","1140"),
("2900","PKR","BY","140","550"),
("2901","PKR","EG","190","1165"),
("2902","PKR","UY","150","695"),
("2903","PKR","BD","125","275"),
("2904","PKR","PK","135","780"),
("2905","PKR","PH","235","870"),
("2906","PKR","ET","40","285"),
("2907","PKR","TN","145","260"),
("2908","PKR","LB","145","435"),
("2909","PKR","IN","135","610"),
("2910","PKR","PY","145","465"),
("2911","PKR","UZ","145","285"),
("2912","PKR","EC","140","485"),
("2913","PKR","MM","145","160"),
("2914","PKR","GE","145","185"),
("2915","PLN","US","80","230"),
("2916","PLN","CH","75","200"),
("2917","PLN","AU","70","175"),
("2918","PLN","GB","60","155"),
("2919","PLN","DE","60","150"),
("2920","PLN","DK","55","135"),
("2921","PLN","AT","40","125"),
("2922","PLN","NO","45","125"),
("2923","PLN","CA","50","155"),
("2924","PLN","NL","55","135"),
("2925","PLN","SE","45","115"),
("2926","PLN","IE","40","110"),
("2927","PLN","BE","40","115"),
("2928","PLN","FI","30","90"),
("2929","PLN","FR","35","95"),
("2930","PLN","NZ","35","110"),
("2931","PLN","HK","35","95"),
("2932","PLN","CZ","30","75"),
("2933","PLN","SK","30","65"),
("2934","PLN","AE","30","90"),
("2935","PLN","SG","35","110"),
("2936","PLN","IL","30","80"),
("2937","PLN","KW","15","70"),
("2938","PLN","IT","20","60"),
("2939","PLN","JP","30","80"),
("2940","PLN","ES","25","60"),
("2941","PLN","VE","5","45"),
("2942","PLN","HU","20","45"),
("2943","PLN","PT","20","50"),
("2944","PLN","GR","25","50"),
("2945","PLN","KR","30","75"),
("2946","PLN","TW","25","65"),
("2947","PLN","PL","20","50"),
("2948","PLN","ZM","5","15"),
("2949","PLN","PR","5","65"),
("2950","PLN","CI","5","15"),
("2951","PLN","RO","20","45"),
("2952","PLN","BH","10","45"),
("2953","PLN","PA","5","65"),
("2954","PLN","GH","5","20"),
("2955","PLN","KH","5","20"),
("2956","PLN","SN","5","20"),
("2957","PLN","SA","10","45"),
("2958","PLN","RU","10","40"),
("2959","PLN","UG","5","15"),
("2960","PLN","BR","15","30"),
("2961","PLN","NI","5","20"),
("2962","PLN","MG","5","15"),
("2963","PLN","DO","5","25"),
("2964","PLN","MX","10","35"),
("2965","PLN","OM","5","35"),
("2966","PLN","CM","5","25"),
("2967","PLN","ZA","10","35"),
("2968","PLN","CL","10","35"),
("2969","PLN","KE","5","15"),
("2970","PLN","NP","5","15"),
("2971","PLN","PE","5","30"),
("2972","PLN","UA","5","20"),
("2973","PLN","MZ","5","30"),
("2974","PLN","TZ","5","10"),
("2975","PLN","AO","5","15"),
("2976","PLN","JO","5","20"),
("2977","PLN","ZW","5","15"),
("2978","PLN","TR","5","20"),
("2979","PLN","MU","5","15"),
("2980","PLN","SV","5","15"),
("2981","PLN","TH","10","35"),
("2982","PLN","CO","5","20"),
("2983","PLN","LK","5","10"),
("2984","PLN","CR","5","25"),
("2985","PLN","AR","10","20"),
("2986","PLN","MA","5","15"),
("2987","PLN","MY","10","35"),
("2988","PLN","KZ","5","15"),
("2989","PLN","DZ","5","10"),
("2990","PLN","ID","10","30"),
("2991","PLN","NG","5","30"),
("2992","PLN","GT","5","25"),
("2993","PLN","VN","5","25"),
("2994","PLN","BY","5","15"),
("2995","PLN","EG","5","25"),
("2996","PLN","UY","5","15"),
("2997","PLN","BD","5","10"),
("2998","PLN","PK","5","20"),
("2999","PLN","PH","5","20"),
("3000","PLN","ET","5","10"),
("3001","PLN","TN","5","10"),
("3002","PLN","LB","5","10"),
("3003","PLN","IN","5","15"),
("3004","PLN","PY","5","10"),
("3005","PLN","UZ","5","10"),
("3006","PLN","EC","5","10"),
("3007","PLN","MM","5","10"),
("3008","PLN","GE","5","10"),
("3009","RON","US","85","245"),
("3010","RON","CH","80","215"),
("3011","RON","AU","75","190"),
("3012","RON","GB","65","165"),
("3013","RON","DE","65","165"),
("3014","RON","DK","60","145"),
("3015","RON","AT","45","135"),
("3016","RON","NO","50","135"),
("3017","RON","CA","55","165"),
("3018","RON","NL","60","145"),
("3019","RON","SE","45","125"),
("3020","RON","IE","45","120"),
("3021","RON","BE","40","125"),
("3022","RON","FI","30","95"),
("3023","RON","FR","40","105"),
("3024","RON","NZ","40","115"),
("3025","RON","HK","35","100"),
("3026","RON","CZ","35","80"),
("3027","RON","SK","30","70"),
("3028","RON","AE","30","95"),
("3029","RON","SG","40","120"),
("3030","RON","IL","35","85"),
("3031","RON","KW","15","75"),
("3032","RON","IT","25","60"),
("3033","RON","JP","30","85"),
("3034","RON","ES","25","65"),
("3035","RON","VE","5","50"),
("3036","RON","HU","20","50"),
("3037","RON","PT","20","55"),
("3038","RON","GR","25","50"),
("3039","RON","KR","30","80"),
("3040","RON","TW","25","70"),
("3041","RON","PL","20","55"),
("3042","RON","ZM","5","20"),
("3043","RON","PR","10","70"),
("3044","RON","CI","5","15"),
("3045","RON","RO","20","50"),
("3046","RON","BH","10","50"),
("3047","RON","PA","5","70"),
("3048","RON","GH","5","20"),
("3049","RON","KH","5","20"),
("3050","RON","SN","5","20"),
("3051","RON","SA","15","50"),
("3052","RON","RU","15","40"),
("3053","RON","UG","5","15"),
("3054","RON","BR","15","35"),
("3055","RON","NI","5","20"),
("3056","RON","MG","5","15"),
("3057","RON","DO","5","25"),
("3058","RON","MX","10","35"),
("3059","RON","OM","5","35"),
("3060","RON","CM","5","30"),
("3061","RON","ZA","10","40"),
("3062","RON","CL","15","40"),
("3063","RON","KE","5","15"),
("3064","RON","NP","5","15"),
("3065","RON","PE","10","30"),
("3066","RON","UA","5","25"),
("3067","RON","MZ","5","30"),
("3068","RON","TZ","5","10"),
("3069","RON","AO","5","15"),
("3070","RON","JO","5","25"),
("3071","RON","ZW","5","15"),
("3072","RON","TR","10","20"),
("3073","RON","MU","5","15"),
("3074","RON","SV","5","15"),
("3075","RON","TH","10","35"),
("3076","RON","CO","5","25"),
("3077","RON","LK","5","10"),
("3078","RON","CR","5","25"),
("3079","RON","AR","10","20"),
("3080","RON","MA","5","15"),
("3081","RON","MY","10","40"),
("3082","RON","KZ","5","15"),
("3083","RON","DZ","5","10"),
("3084","RON","ID","10","35"),
("3085","RON","NG","5","35"),
("3086","RON","GT","5","25"),
("3087","RON","VN","10","30"),
("3088","RON","BY","5","15"),
("3089","RON","EG","5","30"),
("3090","RON","UY","5","15"),
("3091","RON","BD","5","10"),
("3092","RON","PK","5","20"),
("3093","RON","PH","5","20"),
("3094","RON","ET","5","10"),
("3095","RON","TN","5","10"),
("3096","RON","LB","5","10"),
("3097","RON","IN","5","15"),
("3098","RON","PY","5","10"),
("3099","RON","UZ","5","10"),
("3100","RON","EC","5","10"),
("3101","RON","MM","5","10"),
("3102","RON","GE","5","10"),
("3103","RSD","US","2100","5930"),
("3104","RSD","CH","1960","5155"),
("3105","RSD","AU","1785","4580"),
("3106","RSD","GB","1555","3980"),
("3107","RSD","DE","1545","3945"),
("3108","RSD","DK","1420","3525"),
("3109","RSD","AT","1035","3220"),
("3110","RSD","NO","1175","3280"),
("3111","RSD","CA","1300","3980"),
("3112","RSD","NL","1390","3525"),
("3113","RSD","SE","1110","3005"),
("3114","RSD","IE","1100","2900"),
("3115","RSD","BE","1010","2965"),
("3116","RSD","FI","755","2295"),
("3117","RSD","FR","935","2505"),
("3118","RSD","NZ","955","2805"),
("3119","RSD","HK","865","2450"),
("3120","RSD","CZ","825","1985"),
("3121","RSD","SK","780","1690"),
("3122","RSD","AE","735","2310"),
("3123","RSD","SG","960","2835"),
("3124","RSD","IL","840","2050"),
("3125","RSD","KW","380","1840"),
("3126","RSD","IT","570","1505"),
("3127","RSD","JP","715","2030"),
("3128","RSD","ES","585","1550"),
("3129","RSD","VE","75","1185"),
("3130","RSD","HU","495","1150"),
("3131","RSD","PT","495","1285"),
("3132","RSD","GR","610","1245"),
("3133","RSD","KR","750","1985"),
("3134","RSD","TW","610","1630"),
("3135","RSD","PL","520","1290"),
("3136","RSD","ZM","75","430"),
("3137","RSD","PR","185","1730"),
("3138","RSD","CI","100","415"),
("3139","RSD","RO","480","1160"),
("3140","RSD","BH","215","1205"),
("3141","RSD","PA","145","1655"),
("3142","RSD","GH","175","485"),
("3143","RSD","KH","100","485"),
("3144","RSD","SN","75","525"),
("3145","RSD","SA","315","1195"),
("3146","RSD","RU","310","990"),
("3147","RSD","UG","75","385"),
("3148","RSD","BR","330","815"),
("3149","RSD","NI","75","525"),
("3150","RSD","MG","75","370"),
("3151","RSD","DO","90","615"),
("3152","RSD","MX","250","905"),
("3153","RSD","OM","155","905"),
("3154","RSD","CM","75","675"),
("3155","RSD","ZA","300","960"),
("3156","RSD","CL","310","925"),
("3157","RSD","KE","90","385"),
("3158","RSD","NP","75","350"),
("3159","RSD","PE","185","780"),
("3160","RSD","UA","175","550"),
("3161","RSD","MZ","75","730"),
("3162","RSD","TZ","10","170"),
("3163","RSD","AO","160","420"),
("3164","RSD","JO","120","565"),
("3165","RSD","ZW","75","400"),
("3166","RSD","TR","190","520"),
("3167","RSD","MU","95","330"),
("3168","RSD","SV","75","400"),
("3169","RSD","TH","285","895"),
("3170","RSD","CO","145","560"),
("3171","RSD","LK","70","95"),
("3172","RSD","CR","90","585"),
("3173","RSD","AR","195","530"),
("3174","RSD","MA","90","345"),
("3175","RSD","MY","250","915"),
("3176","RSD","KZ","105","390"),
("3177","RSD","DZ","85","185"),
("3178","RSD","ID","220","825"),
("3179","RSD","NG","125","790"),
("3180","RSD","GT","85","620"),
("3181","RSD","VN","180","690"),
("3182","RSD","BY","85","330"),
("3183","RSD","EG","115","700"),
("3184","RSD","UY","90","420"),
("3185","RSD","BD","75","165"),
("3186","RSD","PK","80","470"),
("3187","RSD","PH","140","525"),
("3188","RSD","ET","25","175"),
("3189","RSD","TN","85","160"),
("3190","RSD","LB","90","265"),
("3191","RSD","IN","80","365"),
("3192","RSD","PY","85","280"),
("3193","RSD","UZ","85","170"),
("3194","RSD","EC","85","290"),
("3195","RSD","MM","85","95"),
("3196","RSD","GE","90","110"),
("3197","RUB","US","1605","4525"),
("3198","RUB","CH","1495","3935"),
("3199","RUB","AU","1360","3495"),
("3200","RUB","GB","1185","3035"),
("3201","RUB","DE","1180","3010"),
("3202","RUB","DK","1085","2690"),
("3203","RUB","AT","790","2455"),
("3204","RUB","NO","895","2500"),
("3205","RUB","CA","990","3040"),
("3206","RUB","NL","1060","2690"),
("3207","RUB","SE","850","2295"),
("3208","RUB","IE","840","2215"),
("3209","RUB","BE","770","2260"),
("3210","RUB","FI","575","1755"),
("3211","RUB","FR","715","1915"),
("3212","RUB","NZ","725","2140"),
("3213","RUB","HK","660","1870"),
("3214","RUB","CZ","630","1515"),
("3215","RUB","SK","595","1290"),
("3216","RUB","AE","560","1760"),
("3217","RUB","SG","735","2165"),
("3218","RUB","IL","640","1565"),
("3219","RUB","KW","290","1405"),
("3220","RUB","IT","435","1150"),
("3221","RUB","JP","545","1550"),
("3222","RUB","ES","445","1185"),
("3223","RUB","VE","60","905"),
("3224","RUB","HU","375","875"),
("3225","RUB","PT","375","980"),
("3226","RUB","GR","465","950"),
("3227","RUB","KR","570","1515"),
("3228","RUB","TW","465","1245"),
("3229","RUB","PL","400","985"),
("3230","RUB","ZM","55","330"),
("3231","RUB","PR","140","1320"),
("3232","RUB","CI","75","315"),
("3233","RUB","RO","365","885"),
("3234","RUB","BH","165","920"),
("3235","RUB","PA","110","1265"),
("3236","RUB","GH","135","370"),
("3237","RUB","KH","75","370"),
("3238","RUB","SN","55","400"),
("3239","RUB","SA","240","915"),
("3240","RUB","RU","235","755"),
("3241","RUB","UG","55","295"),
("3242","RUB","BR","255","625"),
("3243","RUB","NI","55","400"),
("3244","RUB","MG","55","285"),
("3245","RUB","DO","65","470"),
("3246","RUB","MX","190","690"),
("3247","RUB","OM","120","690"),
("3248","RUB","CM","55","515"),
("3249","RUB","ZA","225","730"),
("3250","RUB","CL","235","705"),
("3251","RUB","KE","70","295"),
("3252","RUB","NP","55","270"),
("3253","RUB","PE","140","595"),
("3254","RUB","UA","135","420"),
("3255","RUB","MZ","55","560"),
("3256","RUB","TZ","5","130"),
("3257","RUB","AO","125","320"),
("3258","RUB","JO","90","430"),
("3259","RUB","ZW","55","305"),
("3260","RUB","TR","145","395"),
("3261","RUB","MU","75","255"),
("3262","RUB","SV","55","305"),
("3263","RUB","TH","215","680"),
("3264","RUB","CO","110","425"),
("3265","RUB","LK","55","75"),
("3266","RUB","CR","65","445"),
("3267","RUB","AR","150","405"),
("3268","RUB","MA","65","265"),
("3269","RUB","MY","190","700"),
("3270","RUB","KZ","80","295"),
("3271","RUB","DZ","65","140"),
("3272","RUB","ID","170","630"),
("3273","RUB","NG","95","600"),
("3274","RUB","GT","65","470"),
("3275","RUB","VN","140","525"),
("3276","RUB","BY","65","255"),
("3277","RUB","EG","90","535"),
("3278","RUB","UY","70","320"),
("3279","RUB","BD","55","125"),
("3280","RUB","PK","60","360"),
("3281","RUB","PH","110","400"),
("3282","RUB","ET","15","130"),
("3283","RUB","TN","65","120"),
("3284","RUB","LB","65","200"),
("3285","RUB","IN","60","280"),
("3286","RUB","PY","65","215"),
("3287","RUB","UZ","65","130"),
("3288","RUB","EC","65","220"),
("3289","RUB","MM","65","75"),
("3290","RUB","GE","65","85"),
("3291","SAR","US","80","230"),
("3292","SAR","CH","75","200"),
("3293","SAR","AU","70","180"),
("3294","SAR","GB","60","155"),
("3295","SAR","DE","60","155"),
("3296","SAR","DK","55","135"),
("3297","SAR","AT","40","125"),
("3298","SAR","NO","45","125"),
("3299","SAR","CA","50","155"),
("3300","SAR","NL","55","135"),
("3301","SAR","SE","45","115"),
("3302","SAR","IE","45","110"),
("3303","SAR","BE","40","115"),
("3304","SAR","FI","30","90"),
("3305","SAR","FR","35","95"),
("3306","SAR","NZ","35","110"),
("3307","SAR","HK","35","95"),
("3308","SAR","CZ","30","75"),
("3309","SAR","SK","30","65"),
("3310","SAR","AE","30","90"),
("3311","SAR","SG","35","110"),
("3312","SAR","IL","30","80"),
("3313","SAR","KW","15","70"),
("3314","SAR","IT","20","60"),
("3315","SAR","JP","30","80"),
("3316","SAR","ES","25","60"),
("3317","SAR","VE","5","45"),
("3318","SAR","HU","20","45"),
("3319","SAR","PT","20","50"),
("3320","SAR","GR","25","50"),
("3321","SAR","KR","30","75"),
("3322","SAR","TW","25","65"),
("3323","SAR","PL","20","50"),
("3324","SAR","ZM","5","15"),
("3325","SAR","PR","5","65"),
("3326","SAR","CI","5","15"),
("3327","SAR","RO","20","45"),
("3328","SAR","BH","10","45"),
("3329","SAR","PA","5","65"),
("3330","SAR","GH","5","20"),
("3331","SAR","KH","5","20"),
("3332","SAR","SN","5","20"),
("3333","SAR","SA","10","45"),
("3334","SAR","RU","10","40"),
("3335","SAR","UG","5","15"),
("3336","SAR","BR","15","30"),
("3337","SAR","NI","5","20"),
("3338","SAR","MG","5","15"),
("3339","SAR","DO","5","25"),
("3340","SAR","MX","10","35"),
("3341","SAR","OM","5","35"),
("3342","SAR","CM","5","25"),
("3343","SAR","ZA","10","35"),
("3344","SAR","CL","10","35"),
("3345","SAR","KE","5","15"),
("3346","SAR","NP","5","15"),
("3347","SAR","PE","5","30"),
("3348","SAR","UA","5","20"),
("3349","SAR","MZ","5","30"),
("3350","SAR","TZ","5","10"),
("3351","SAR","AO","5","15"),
("3352","SAR","JO","5","20"),
("3353","SAR","ZW","5","15"),
("3354","SAR","TR","5","20"),
("3355","SAR","MU","5","15"),
("3356","SAR","SV","5","15"),
("3357","SAR","TH","10","35"),
("3358","SAR","CO","5","20"),
("3359","SAR","LK","5","10"),
("3360","SAR","CR","5","25"),
("3361","SAR","AR","10","20"),
("3362","SAR","MA","5","15"),
("3363","SAR","MY","10","35"),
("3364","SAR","KZ","5","15"),
("3365","SAR","DZ","5","10"),
("3366","SAR","ID","10","30"),
("3367","SAR","NG","5","30"),
("3368","SAR","GT","5","25"),
("3369","SAR","VN","5","25"),
("3370","SAR","BY","5","15"),
("3371","SAR","EG","5","25"),
("3372","SAR","UY","5","15"),
("3373","SAR","BD","5","10"),
("3374","SAR","PK","5","20"),
("3375","SAR","PH","5","20"),
("3376","SAR","ET","5","10"),
("3377","SAR","TN","5","10"),
("3378","SAR","LB","5","10"),
("3379","SAR","IN","5","15"),
("3380","SAR","PY","5","10"),
("3381","SAR","UZ","5","10"),
("3382","SAR","EC","5","10"),
("3383","SAR","MM","5","10"),
("3384","SAR","GE","5","10"),
("3385","SEK","US","180","510"),
("3386","SEK","CH","170","445"),
("3387","SEK","AU","155","395"),
("3388","SEK","GB","135","345"),
("3389","SEK","DE","135","340"),
("3390","SEK","DK","125","305"),
("3391","SEK","AT","90","280"),
("3392","SEK","NO","100","285"),
("3393","SEK","CA","110","345"),
("3394","SEK","NL","120","305"),
("3395","SEK","SE","95","260"),
("3396","SEK","IE","95","250"),
("3397","SEK","BE","85","255"),
("3398","SEK","FI","65","200"),
("3399","SEK","FR","80","215"),
("3400","SEK","NZ","80","240"),
("3401","SEK","HK","75","210"),
("3402","SEK","CZ","70","170"),
("3403","SEK","SK","65","145"),
("3404","SEK","AE","65","200"),
("3405","SEK","SG","85","245"),
("3406","SEK","IL","70","175"),
("3407","SEK","KW","35","160"),
("3408","SEK","IT","50","130"),
("3409","SEK","JP","60","175"),
("3410","SEK","ES","50","135"),
("3411","SEK","VE","5","105"),
("3412","SEK","HU","45","100"),
("3413","SEK","PT","45","110"),
("3414","SEK","GR","50","110"),
("3415","SEK","KR","65","170"),
("3416","SEK","TW","55","140"),
("3417","SEK","PL","45","110"),
("3418","SEK","ZM","5","35"),
("3419","SEK","PR","15","150"),
("3420","SEK","CI","10","35"),
("3421","SEK","RO","40","100"),
("3422","SEK","BH","20","105"),
("3423","SEK","PA","15","145"),
("3424","SEK","GH","15","40"),
("3425","SEK","KH","10","40"),
("3426","SEK","SN","5","45"),
("3427","SEK","SA","25","105"),
("3428","SEK","RU","25","85"),
("3429","SEK","UG","5","35"),
("3430","SEK","BR","30","70"),
("3431","SEK","NI","5","45"),
("3432","SEK","MG","5","30"),
("3433","SEK","DO","10","55"),
("3434","SEK","MX","20","80"),
("3435","SEK","OM","15","80"),
("3436","SEK","CM","5","60"),
("3437","SEK","ZA","25","85"),
("3438","SEK","CL","25","80"),
("3439","SEK","KE","10","35"),
("3440","SEK","NP","5","30"),
("3441","SEK","PE","15","65"),
("3442","SEK","UA","15","50"),
("3443","SEK","MZ","5","65"),
("3444","SEK","TZ","5","15"),
("3445","SEK","AO","15","35"),
("3446","SEK","JO","10","50"),
("3447","SEK","ZW","5","35"),
("3448","SEK","TR","15","45"),
("3449","SEK","MU","10","30"),
("3450","SEK","SV","5","35"),
("3451","SEK","TH","25","75"),
("3452","SEK","CO","10","50"),
("3453","SEK","LK","5","10"),
("3454","SEK","CR","10","50"),
("3455","SEK","AR","15","45"),
("3456","SEK","MA","10","30"),
("3457","SEK","MY","20","80"),
("3458","SEK","KZ","10","35"),
("3459","SEK","DZ","10","15"),
("3460","SEK","ID","20","70"),
("3461","SEK","NG","10","70"),
("3462","SEK","GT","10","55"),
("3463","SEK","VN","15","60"),
("3464","SEK","BY","5","30"),
("3465","SEK","EG","10","60"),
("3466","SEK","UY","10","35"),
("3467","SEK","BD","5","15"),
("3468","SEK","PK","5","40"),
("3469","SEK","PH","10","45"),
("3470","SEK","ET","5","15"),
("3471","SEK","TN","10","15"),
("3472","SEK","LB","10","25"),
("3473","SEK","IN","5","30"),
("3474","SEK","PY","10","25"),
("3475","SEK","UZ","10","15"),
("3476","SEK","EC","5","25"),
("3477","SEK","MM","10","15"),
("3478","SEK","GE","10","15"),
("3479","SGD","US","30","80"),
("3480","SGD","CH","25","70"),
("3481","SGD","AU","25","65"),
("3482","SGD","GB","20","55"),
("3483","SGD","DE","20","55"),
("3484","SGD","DK","20","50"),
("3485","SGD","AT","15","45"),
("3486","SGD","NO","15","45"),
("3487","SGD","CA","20","55"),
("3488","SGD","NL","20","50"),
("3489","SGD","SE","15","40"),
("3490","SGD","IE","15","40"),
("3491","SGD","BE","15","40"),
("3492","SGD","FI","10","30"),
("3493","SGD","FR","15","35"),
("3494","SGD","NZ","15","40"),
("3495","SGD","HK","10","35"),
("3496","SGD","CZ","10","25"),
("3497","SGD","SK","10","25"),
("3498","SGD","AE","10","30"),
("3499","SGD","SG","15","40"),
("3500","SGD","IL","10","30"),
("3501","SGD","KW","5","25"),
("3502","SGD","IT","10","20"),
("3503","SGD","JP","10","30"),
("3504","SGD","ES","10","20"),
("3505","SGD","VE","5","15"),
("3506","SGD","HU","5","15"),
("3507","SGD","PT","5","20"),
("3508","SGD","GR","10","15"),
("3509","SGD","KR","10","25"),
("3510","SGD","TW","10","20"),
("3511","SGD","PL","5","20"),
("3512","SGD","ZM","5","10"),
("3513","SGD","PR","5","25"),
("3514","SGD","CI","5","10"),
("3515","SGD","RO","5","15"),
("3516","SGD","BH","5","15"),
("3517","SGD","PA","5","25"),
("3518","SGD","GH","5","10"),
("3519","SGD","KH","5","10"),
("3520","SGD","SN","5","10"),
("3521","SGD","SA","5","15"),
("3522","SGD","RU","5","15"),
("3523","SGD","UG","5","10"),
("3524","SGD","BR","5","10"),
("3525","SGD","NI","5","10"),
("3526","SGD","MG","5","10"),
("3527","SGD","DO","5","10"),
("3528","SGD","MX","5","10"),
("3529","SGD","OM","5","10"),
("3530","SGD","CM","5","10"),
("3531","SGD","ZA","5","15"),
("3532","SGD","CL","5","15"),
("3533","SGD","KE","5","10"),
("3534","SGD","NP","5","10"),
("3535","SGD","PE","5","10"),
("3536","SGD","UA","5","10"),
("3537","SGD","MZ","5","10"),
("3538","SGD","TZ","5","10"),
("3539","SGD","AO","5","10"),
("3540","SGD","JO","5","10"),
("3541","SGD","ZW","5","10"),
("3542","SGD","TR","5","10"),
("3543","SGD","MU","5","10"),
("3544","SGD","SV","5","10"),
("3545","SGD","TH","5","10"),
("3546","SGD","CO","5","10"),
("3547","SGD","LK","5","10"),
("3548","SGD","CR","5","10"),
("3549","SGD","AR","5","10"),
("3550","SGD","MA","5","10"),
("3551","SGD","MY","5","15"),
("3552","SGD","KZ","5","10"),
("3553","SGD","DZ","5","10"),
("3554","SGD","ID","5","10"),
("3555","SGD","NG","5","10"),
("3556","SGD","GT","5","10"),
("3557","SGD","VN","5","10"),
("3558","SGD","BY","5","10"),
("3559","SGD","EG","5","10"),
("3560","SGD","UY","5","10"),
("3561","SGD","BD","5","10"),
("3562","SGD","PK","5","10"),
("3563","SGD","PH","5","10"),
("3564","SGD","ET","5","10"),
("3565","SGD","TN","5","10"),
("3566","SGD","LB","5","10"),
("3567","SGD","IN","5","10"),
("3568","SGD","PY","5","10"),
("3569","SGD","UZ","5","10"),
("3570","SGD","EC","5","10"),
("3571","SGD","MM","5","10"),
("3572","SGD","GE","5","10"),
("3573","THB","US","650","1840"),
("3574","THB","CH","610","1600"),
("3575","THB","AU","555","1420"),
("3576","THB","GB","485","1235"),
("3577","THB","DE","480","1225"),
("3578","THB","DK","440","1095"),
("3579","THB","AT","320","1000"),
("3580","THB","NO","365","1020"),
("3581","THB","CA","405","1235"),
("3582","THB","NL","430","1095"),
("3583","THB","SE","345","935"),
("3584","THB","IE","340","900"),
("3585","THB","BE","315","920"),
("3586","THB","FI","235","715"),
("3587","THB","FR","290","780"),
("3588","THB","NZ","295","870"),
("3589","THB","HK","270","760"),
("3590","THB","CZ","255","615"),
("3591","THB","SK","240","525"),
("3592","THB","AE","230","715"),
("3593","THB","SG","300","880"),
("3594","THB","IL","260","635"),
("3595","THB","KW","115","570"),
("3596","THB","IT","175","465"),
("3597","THB","JP","220","630"),
("3598","THB","ES","180","480"),
("3599","THB","VE","25","370"),
("3600","THB","HU","155","355"),
("3601","THB","PT","155","400"),
("3602","THB","GR","190","385"),
("3603","THB","KR","235","615"),
("3604","THB","TW","190","505"),
("3605","THB","PL","160","400"),
("3606","THB","ZM","25","135"),
("3607","THB","PR","55","535"),
("3608","THB","CI","30","130"),
("3609","THB","RO","150","360"),
("3610","THB","BH","70","375"),
("3611","THB","PA","45","515"),
("3612","THB","GH","55","150"),
("3613","THB","KH","30","150"),
("3614","THB","SN","25","165"),
("3615","THB","SA","95","370"),
("3616","THB","RU","95","310"),
("3617","THB","UG","25","120"),
("3618","THB","BR","105","255"),
("3619","THB","NI","25","160"),
("3620","THB","MG","25","115"),
("3621","THB","DO","25","190"),
("3622","THB","MX","80","280"),
("3623","THB","OM","50","280"),
("3624","THB","CM","25","210"),
("3625","THB","ZA","90","295"),
("3626","THB","CL","95","290"),
("3627","THB","KE","30","120"),
("3628","THB","NP","25","110"),
("3629","THB","PE","55","240"),
("3630","THB","UA","55","170"),
("3631","THB","MZ","25","225"),
("3632","THB","TZ","5","50"),
("3633","THB","AO","50","130"),
("3634","THB","JO","35","175"),
("3635","THB","ZW","25","125"),
("3636","THB","TR","60","160"),
("3637","THB","MU","30","105"),
("3638","THB","SV","25","125"),
("3639","THB","TH","90","280"),
("3640","THB","CO","45","175"),
("3641","THB","LK","20","30"),
("3642","THB","CR","25","180"),
("3643","THB","AR","60","165"),
("3644","THB","MA","25","105"),
("3645","THB","MY","75","285"),
("3646","THB","KZ","35","120"),
("3647","THB","DZ","25","55"),
("3648","THB","ID","70","255"),
("3649","THB","NG","40","245"),
("3650","THB","GT","25","190"),
("3651","THB","VN","55","215"),
("3652","THB","BY","25","105"),
("3653","THB","EG","35","220"),
("3654","THB","UY","30","130"),
("3655","THB","BD","25","50"),
("3656","THB","PK","25","145"),
("3657","THB","PH","45","160"),
("3658","THB","ET","5","55"),
("3659","THB","TN","25","50"),
("3660","THB","LB","25","80"),
("3661","THB","IN","25","115"),
("3662","THB","PY","25","85"),
("3663","THB","UZ","25","55"),
("3664","THB","EC","25","90"),
("3665","THB","MM","25","30"),
("3666","THB","GE","25","35"),
("3667","TRY","US","160","455"),
("3668","TRY","CH","150","395"),
("3669","TRY","AU","135","350"),
("3670","TRY","GB","120","305"),
("3671","TRY","DE","120","300"),
("3672","TRY","DK","110","270"),
("3673","TRY","AT","80","245"),
("3674","TRY","NO","90","250"),
("3675","TRY","CA","100","305"),
("3676","TRY","NL","105","270"),
("3677","TRY","SE","85","230"),
("3678","TRY","IE","85","220"),
("3679","TRY","BE","75","225"),
("3680","TRY","FI","60","175"),
("3681","TRY","FR","70","190"),
("3682","TRY","NZ","75","215"),
("3683","TRY","HK","65","190"),
("3684","TRY","CZ","65","150"),
("3685","TRY","SK","60","130"),
("3686","TRY","AE","55","175"),
("3687","TRY","SG","75","215"),
("3688","TRY","IL","65","155"),
("3689","TRY","KW","30","140"),
("3690","TRY","IT","45","115"),
("3691","TRY","JP","55","155"),
("3692","TRY","ES","45","120"),
("3693","TRY","VE","5","90"),
("3694","TRY","HU","40","90"),
("3695","TRY","PT","40","100"),
("3696","TRY","GR","45","95"),
("3697","TRY","KR","55","150"),
("3698","TRY","TW","45","125"),
("3699","TRY","PL","40","100"),
("3700","TRY","ZM","5","35"),
("3701","TRY","PR","15","135"),
("3702","TRY","CI","10","30"),
("3703","TRY","RO","35","90"),
("3704","TRY","BH","15","90"),
("3705","TRY","PA","10","125"),
("3706","TRY","GH","15","35"),
("3707","TRY","KH","10","35"),
("3708","TRY","SN","5","40"),
("3709","TRY","SA","25","90"),
("3710","TRY","RU","25","75"),
("3711","TRY","UG","5","30"),
("3712","TRY","BR","25","65"),
("3713","TRY","NI","5","40"),
("3714","TRY","MG","5","30"),
("3715","TRY","DO","5","45"),
("3716","TRY","MX","20","70"),
("3717","TRY","OM","10","70"),
("3718","TRY","CM","5","50"),
("3719","TRY","ZA","25","75"),
("3720","TRY","CL","25","70"),
("3721","TRY","KE","5","30"),
("3722","TRY","NP","5","25"),
("3723","TRY","PE","15","60"),
("3724","TRY","UA","15","40"),
("3725","TRY","MZ","5","55"),
("3726","TRY","TZ","5","15"),
("3727","TRY","AO","10","30"),
("3728","TRY","JO","10","45"),
("3729","TRY","ZW","5","30"),
("3730","TRY","TR","15","40"),
("3731","TRY","MU","5","25"),
("3732","TRY","SV","5","30"),
("3733","TRY","TH","20","70"),
("3734","TRY","CO","10","45"),
("3735","TRY","LK","5","10"),
("3736","TRY","CR","5","45"),
("3737","TRY","AR","15","40"),
("3738","TRY","MA","5","25"),
("3739","TRY","MY","20","70"),
("3740","TRY","KZ","10","30"),
("3741","TRY","DZ","5","15"),
("3742","TRY","ID","15","65"),
("3743","TRY","NG","10","60"),
("3744","TRY","GT","5","45"),
("3745","TRY","VN","15","55"),
("3746","TRY","BY","5","25"),
("3747","TRY","EG","10","55"),
("3748","TRY","UY","5","30"),
("3749","TRY","BD","5","15"),
("3750","TRY","PK","5","35"),
("3751","TRY","PH","10","40"),
("3752","TRY","ET","5","15"),
("3753","TRY","TN","5","10"),
("3754","TRY","LB","5","20"),
("3755","TRY","IN","5","30"),
("3756","TRY","PY","5","20"),
("3757","TRY","UZ","5","15"),
("3758","TRY","EC","5","20"),
("3759","TRY","MM","5","10"),
("3760","TRY","GE","5","10"),
("3761","TWD","US","610","1715"),
("3762","TWD","CH","570","1495"),
("3763","TWD","AU","515","1325"),
("3764","TWD","GB","450","1150"),
("3765","TWD","DE","445","1145"),
("3766","TWD","DK","410","1020"),
("3767","TWD","AT","300","930"),
("3768","TWD","NO","340","950"),
("3769","TWD","CA","375","1155"),
("3770","TWD","NL","400","1020"),
("3771","TWD","SE","320","870"),
("3772","TWD","IE","320","840"),
("3773","TWD","BE","295","860"),
("3774","TWD","FI","220","665"),
("3775","TWD","FR","270","725"),
("3776","TWD","NZ","275","810"),
("3777","TWD","HK","250","710"),
("3778","TWD","CZ","240","575"),
("3779","TWD","SK","225","490"),
("3780","TWD","AE","215","670"),
("3781","TWD","SG","280","820"),
("3782","TWD","IL","245","595"),
("3783","TWD","KW","110","535"),
("3784","TWD","IT","165","435"),
("3785","TWD","JP","205","590"),
("3786","TWD","ES","170","450"),
("3787","TWD","VE","20","345"),
("3788","TWD","HU","145","335"),
("3789","TWD","PT","145","370"),
("3790","TWD","GR","175","360"),
("3791","TWD","KR","215","575"),
("3792","TWD","TW","175","470"),
("3793","TWD","PL","150","375"),
("3794","TWD","ZM","20","125"),
("3795","TWD","PR","55","500"),
("3796","TWD","CI","30","120"),
("3797","TWD","RO","140","335"),
("3798","TWD","BH","65","350"),
("3799","TWD","PA","40","480"),
("3800","TWD","GH","50","140"),
("3801","TWD","KH","30","140"),
("3802","TWD","SN","20","150"),
("3803","TWD","SA","90","345"),
("3804","TWD","RU","90","285"),
("3805","TWD","UG","20","110"),
("3806","TWD","BR","95","235"),
("3807","TWD","NI","20","150"),
("3808","TWD","MG","20","105"),
("3809","TWD","DO","25","180"),
("3810","TWD","MX","70","260"),
("3811","TWD","OM","45","260"),
("3812","TWD","CM","20","195"),
("3813","TWD","ZA","85","275"),
("3814","TWD","CL","90","270"),
("3815","TWD","KE","25","110"),
("3816","TWD","NP","20","100"),
("3817","TWD","PE","55","225"),
("3818","TWD","UA","50","160"),
("3819","TWD","MZ","20","210"),
("3820","TWD","TZ","5","50"),
("3821","TWD","AO","45","120"),
("3822","TWD","JO","35","165"),
("3823","TWD","ZW","20","115"),
("3824","TWD","TR","55","150"),
("3825","TWD","MU","30","95"),
("3826","TWD","SV","20","115"),
("3827","TWD","TH","80","260"),
("3828","TWD","CO","40","160"),
("3829","TWD","LK","20","30"),
("3830","TWD","CR","25","170"),
("3831","TWD","AR","55","155"),
("3832","TWD","MA","25","100"),
("3833","TWD","MY","70","265"),
("3834","TWD","KZ","30","115"),
("3835","TWD","DZ","25","55"),
("3836","TWD","ID","65","240"),
("3837","TWD","NG","35","230"),
("3838","TWD","GT","25","180"),
("3839","TWD","VN","55","200"),
("3840","TWD","BY","25","95"),
("3841","TWD","EG","35","205"),
("3842","TWD","UY","25","120"),
("3843","TWD","BD","20","50"),
("3844","TWD","PK","25","135"),
("3845","TWD","PH","40","150"),
("3846","TWD","ET","5","50"),
("3847","TWD","TN","25","45"),
("3848","TWD","LB","25","75"),
("3849","TWD","IN","25","105"),
("3850","TWD","PY","25","80"),
("3851","TWD","UZ","25","50"),
("3852","TWD","EC","25","85"),
("3853","TWD","MM","25","30"),
("3854","TWD","GE","25","30"),
("3855","UAH","US","610","1720"),
("3856","UAH","CH","570","1495"),
("3857","UAH","AU","515","1330"),
("3858","UAH","GB","450","1155"),
("3859","UAH","DE","450","1145"),
("3860","UAH","DK","410","1020"),
("3861","UAH","AT","300","935"),
("3862","UAH","NO","340","950"),
("3863","UAH","CA","375","1155"),
("3864","UAH","NL","405","1020"),
("3865","UAH","SE","320","870"),
("3866","UAH","IE","320","840"),
("3867","UAH","BE","295","860"),
("3868","UAH","FI","220","665"),
("3869","UAH","FR","270","725"),
("3870","UAH","NZ","275","815"),
("3871","UAH","HK","250","710"),
("3872","UAH","CZ","240","575"),
("3873","UAH","SK","225","490"),
("3874","UAH","AE","215","670"),
("3875","UAH","SG","280","825"),
("3876","UAH","IL","245","595"),
("3877","UAH","KW","110","535"),
("3878","UAH","IT","165","435"),
("3879","UAH","JP","205","590"),
("3880","UAH","ES","170","450"),
("3881","UAH","VE","20","345"),
("3882","UAH","HU","145","335"),
("3883","UAH","PT","145","375"),
("3884","UAH","GR","175","360"),
("3885","UAH","KR","215","575"),
("3886","UAH","TW","175","475"),
("3887","UAH","PL","150","375"),
("3888","UAH","ZM","20","125"),
("3889","UAH","PR","55","500"),
("3890","UAH","CI","30","120"),
("3891","UAH","RO","140","335"),
("3892","UAH","BH","65","350"),
("3893","UAH","PA","40","480"),
("3894","UAH","GH","50","140"),
("3895","UAH","KH","30","140"),
("3896","UAH","SN","20","150"),
("3897","UAH","SA","90","345"),
("3898","UAH","RU","90","290"),
("3899","UAH","UG","20","110"),
("3900","UAH","BR","95","235"),
("3901","UAH","NI","20","150"),
("3902","UAH","MG","20","110"),
("3903","UAH","DO","25","180"),
("3904","UAH","MX","70","260"),
("3905","UAH","OM","45","260"),
("3906","UAH","CM","20","195"),
("3907","UAH","ZA","85","280"),
("3908","UAH","CL","90","270"),
("3909","UAH","KE","25","110"),
("3910","UAH","NP","20","100"),
("3911","UAH","PE","55","225"),
("3912","UAH","UA","50","160"),
("3913","UAH","MZ","20","210"),
("3914","UAH","TZ","5","50"),
("3915","UAH","AO","45","120"),
("3916","UAH","JO","35","165"),
("3917","UAH","ZW","20","115"),
("3918","UAH","TR","55","150"),
("3919","UAH","MU","30","95"),
("3920","UAH","SV","20","115"),
("3921","UAH","TH","80","260"),
("3922","UAH","CO","40","160"),
("3923","UAH","LK","20","30"),
("3924","UAH","CR","25","170"),
("3925","UAH","AR","55","155"),
("3926","UAH","MA","25","100"),
("3927","UAH","MY","70","265"),
("3928","UAH","KZ","30","115"),
("3929","UAH","DZ","25","55"),
("3930","UAH","ID","65","240"),
("3931","UAH","NG","35","230"),
("3932","UAH","GT","25","180"),
("3933","UAH","VN","55","200"),
("3934","UAH","BY","25","95"),
("3935","UAH","EG","35","205"),
("3936","UAH","UY","25","120"),
("3937","UAH","BD","20","50"),
("3938","UAH","PK","25","135"),
("3939","UAH","PH","40","150"),
("3940","UAH","ET","5","50"),
("3941","UAH","TN","25","45"),
("3942","UAH","LB","25","75"),
("3943","UAH","IN","25","105"),
("3944","UAH","PY","25","80"),
("3945","UAH","UZ","25","50"),
("3946","UAH","EC","25","85"),
("3947","UAH","MM","25","30"),
("3948","UAH","GE","25","30"),
("3949","USD","US","20","60"),
("3950","USD","CH","20","55"),
("3951","USD","AU","20","45"),
("3952","USD","GB","15","40"),
("3953","USD","DE","15","40"),
("3954","USD","DK","15","35"),
("3955","USD","AT","10","35"),
("3956","USD","NO","10","35"),
("3957","USD","CA","15","40"),
("3958","USD","NL","15","35"),
("3959","USD","SE","10","30"),
("3960","USD","IE","10","30"),
("3961","USD","BE","10","30"),
("3962","USD","FI","10","25"),
("3963","USD","FR","10","25"),
("3964","USD","NZ","10","30"),
("3965","USD","HK","10","25"),
("3966","USD","CZ","10","20"),
("3967","USD","SK","10","15"),
("3968","USD","AE","10","25"),
("3969","USD","SG","10","30"),
("3970","USD","IL","10","20"),
("3971","USD","KW","5","20"),
("3972","USD","IT","5","15"),
("3973","USD","JP","5","20"),
("3974","USD","ES","5","15"),
("3975","USD","VE","5","10"),
("3976","USD","HU","5","10"),
("3977","USD","PT","5","15"),
("3978","USD","GR","5","15"),
("3979","USD","KR","10","20"),
("3980","USD","TW","5","15"),
("3981","USD","PL","5","15"),
("3982","USD","ZM","5","10"),
("3983","USD","PR","5","20"),
("3984","USD","CI","5","10"),
("3985","USD","RO","5","10"),
("3986","USD","BH","5","10"),
("3987","USD","PA","5","15"),
("3988","USD","GH","5","10"),
("3989","USD","KH","5","10"),
("3990","USD","SN","5","10"),
("3991","USD","SA","5","10"),
("3992","USD","RU","5","10"),
("3993","USD","UG","5","10"),
("3994","USD","BR","5","10"),
("3995","USD","NI","5","10"),
("3996","USD","MG","5","10"),
("3997","USD","DO","5","10"),
("3998","USD","MX","5","10"),
("3999","USD","OM","5","10"),
("4000","USD","CM","5","10"),
("4001","USD","ZA","5","10"),
("4002","USD","CL","5","10"),
("4003","USD","KE","5","10"),
("4004","USD","NP","5","10"),
("4005","USD","PE","5","10"),
("4006","USD","UA","5","10"),
("4007","USD","MZ","5","10"),
("4008","USD","TZ","5","10"),
("4009","USD","AO","5","10"),
("4010","USD","JO","5","10"),
("4011","USD","ZW","5","10"),
("4012","USD","TR","5","10"),
("4013","USD","MU","5","10"),
("4014","USD","SV","5","10"),
("4015","USD","TH","5","10"),
("4016","USD","CO","5","10"),
("4017","USD","LK","5","10"),
("4018","USD","CR","5","10"),
("4019","USD","AR","5","10"),
("4020","USD","MA","5","10"),
("4021","USD","MY","5","10"),
("4022","USD","KZ","5","10"),
("4023","USD","DZ","5","10"),
("4024","USD","ID","5","10"),
("4025","USD","NG","5","10"),
("4026","USD","GT","5","10"),
("4027","USD","VN","5","10"),
("4028","USD","BY","5","10"),
("4029","USD","EG","5","10"),
("4030","USD","UY","5","10"),
("4031","USD","BD","5","10"),
("4032","USD","PK","5","10"),
("4033","USD","PH","5","10"),
("4034","USD","ET","5","10"),
("4035","USD","TN","5","10"),
("4036","USD","LB","5","10"),
("4037","USD","IN","5","10"),
("4038","USD","PY","5","10"),
("4039","USD","UZ","5","10"),
("4040","USD","EC","5","10"),
("4041","USD","MM","5","10"),
("4042","USD","GE","5","10"),
("4043","VND","US","501260","1414340"),
("4044","VND","CH","467440","1230050"),
("4045","VND","AU","425330","1092035"),
("4046","VND","GB","370825","948980"),
("4047","VND","DE","368005","941305"),
("4048","VND","DK","338590","840285"),
("4049","VND","AT","247060","767770"),
("4050","VND","NO","280035","781870"),
("4051","VND","CA","309560","949275"),
("4052","VND","NL","331205","840625"),
("4053","VND","SE","265110","716900"),
("4054","VND","IE","262340","691545"),
("4055","VND","BE","241250","707035"),
("4056","VND","FI","180355","547725"),
("4057","VND","FR","223325","597765"),
("4058","VND","NZ","227285","669110"),
("4059","VND","HK","206690","584525"),
("4060","VND","CZ","197060","473095"),
("4061","VND","SK","185915","402915"),
("4062","VND","AE","175445","550600"),
("4063","VND","SG","228920","676560"),
("4064","VND","IL","199775","488665"),
("4065","VND","KW","90110","439220"),
("4066","VND","IT","135985","358995"),
("4067","VND","JP","170500","484575"),
("4068","VND","ES","139790","369670"),
("4069","VND","VE","18325","283150"),
("4070","VND","HU","117795","274075"),
("4071","VND","PT","117590","306530"),
("4072","VND","GR","144990","296945"),
("4073","VND","KR","178765","473390"),
("4074","VND","TW","145295","388965"),
("4075","VND","PL","124320","307750"),
("4076","VND","ZM","17955","102445"),
("4077","VND","PR","43915","412820"),
("4078","VND","CI","23965","99035"),
("4079","VND","RO","114205","276330"),
("4080","VND","BH","51860","287490"),
("4081","VND","PA","34735","394605"),
("4082","VND","GH","41630","116170"),
("4083","VND","KH","24000","115255"),
("4084","VND","SN","17475","125220"),
("4085","VND","SA","74540","285405"),
("4086","VND","RU","74075","236380"),
("4087","VND","UG","17405","91510"),
("4088","VND","BR","78980","194735"),
("4089","VND","NI","17370","124690"),
("4090","VND","MG","17575","88390"),
("4091","VND","DO","21075","146550"),
("4092","VND","MX","59560","215530"),
("4093","VND","OM","37440","215540"),
("4094","VND","CM","17345","160620"),
("4095","VND","ZA","70970","228425"),
("4096","VND","CL","73940","220970"),
("4097","VND","KE","21345","92235"),
("4098","VND","NP","17345","83780"),
("4099","VND","PE","44165","185900"),
("4100","VND","UA","42105","131500"),
("4101","VND","MZ","17345","174435"),
("4102","VND","TZ","2190","40030"),
("4103","VND","AO","38465","100290"),
("4104","VND","JO","28365","134700"),
("4105","VND","ZW","17435","95590"),
("4106","VND","TR","45180","123620"),
("4107","VND","MU","23140","79070"),
("4108","VND","SV","17345","95775"),
("4109","VND","TH","67775","213265"),
("4110","VND","CO","34375","133035"),
("4111","VND","LK","16690","23055"),
("4112","VND","CR","20955","139205"),
("4113","VND","AR","46810","126790"),
("4114","VND","MA","20905","82055"),
("4115","VND","MY","59320","218145"),
("4116","VND","KZ","25370","92865"),
("4117","VND","DZ","20800","44030"),
("4118","VND","ID","52930","196355"),
("4119","VND","NG","29750","188200");

INSERT IGNORE INTO `wp_gla_budget_recommendations` VALUES 
("4120","VND","GT","20845","147390"),
("4121","VND","VN","43305","164120"),
("4122","VND","BY","20335","79160"),
("4123","VND","EG","27425","167505"),
("4124","VND","UY","21620","99635"),
("4125","VND","BD","17800","39405"),
("4126","VND","PK","19515","112330"),
("4127","VND","PH","33795","124710"),
("4128","VND","ET","5420","41305"),
("4129","VND","TN","20820","37725"),
("4130","VND","LB","21020","62835"),
("4131","VND","IN","19380","87540"),
("4132","VND","PY","20830","66985"),
("4133","VND","UZ","20845","40665"),
("4134","VND","EC","20250","69470"),
("4135","VND","MM","20850","22770"),
("4136","VND","GE","20915","26650"),
("4137","ZAR","US","330","935"),
("4138","ZAR","CH","310","815"),
("4139","ZAR","AU","280","720"),
("4140","ZAR","GB","245","630"),
("4141","ZAR","DE","245","620"),
("4142","ZAR","DK","225","555"),
("4143","ZAR","AT","165","510"),
("4144","ZAR","NO","185","515"),
("4145","ZAR","CA","205","630"),
("4146","ZAR","NL","220","555"),
("4147","ZAR","SE","175","475"),
("4148","ZAR","IE","175","455"),
("4149","ZAR","BE","160","470"),
("4150","ZAR","FI","120","360"),
("4151","ZAR","FR","150","395"),
("4152","ZAR","NZ","150","440"),
("4153","ZAR","HK","135","385"),
("4154","ZAR","CZ","130","315"),
("4155","ZAR","SK","125","265"),
("4156","ZAR","AE","115","365"),
("4157","ZAR","SG","150","445"),
("4158","ZAR","IL","130","325"),
("4159","ZAR","KW","60","290"),
("4160","ZAR","IT","90","235"),
("4161","ZAR","JP","115","320"),
("4162","ZAR","ES","90","245"),
("4163","ZAR","VE","10","185"),
("4164","ZAR","HU","80","180"),
("4165","ZAR","PT","80","205"),
("4166","ZAR","GR","95","195"),
("4167","ZAR","KR","120","315"),
("4168","ZAR","TW","95","255"),
("4169","ZAR","PL","80","205"),
("4170","ZAR","ZM","10","70"),
("4171","ZAR","PR","30","275"),
("4172","ZAR","CI","15","65"),
("4173","ZAR","RO","75","185"),
("4174","ZAR","BH","35","190"),
("4175","ZAR","PA","25","260"),
("4176","ZAR","GH","30","75"),
("4177","ZAR","KH","15","75"),
("4178","ZAR","SN","10","85"),
("4179","ZAR","SA","50","190"),
("4180","ZAR","RU","50","155"),
("4181","ZAR","UG","10","60"),
("4182","ZAR","BR","50","130"),
("4183","ZAR","NI","10","80"),
("4184","ZAR","MG","10","60"),
("4185","ZAR","DO","15","95"),
("4186","ZAR","MX","40","145"),
("4187","ZAR","OM","25","145"),
("4188","ZAR","CM","10","105"),
("4189","ZAR","ZA","45","150"),
("4190","ZAR","CL","50","145"),
("4191","ZAR","KE","15","60"),
("4192","ZAR","NP","10","55"),
("4193","ZAR","PE","30","125"),
("4194","ZAR","UA","30","85"),
("4195","ZAR","MZ","10","115"),
("4196","ZAR","TZ","5","25"),
("4197","ZAR","AO","25","65"),
("4198","ZAR","JO","20","90"),
("4199","ZAR","ZW","10","65"),
("4200","ZAR","TR","30","80"),
("4201","ZAR","MU","15","50"),
("4202","ZAR","SV","10","65"),
("4203","ZAR","TH","45","140"),
("4204","ZAR","CO","25","90"),
("4205","ZAR","LK","10","15"),
("4206","ZAR","CR","15","90"),
("4207","ZAR","AR","30","85"),
("4208","ZAR","MA","15","55"),
("4209","ZAR","MY","40","145"),
("4210","ZAR","KZ","15","60"),
("4211","ZAR","DZ","15","30"),
("4212","ZAR","ID","35","130"),
("4213","ZAR","NG","20","125"),
("4214","ZAR","GT","15","95"),
("4215","ZAR","VN","30","110"),
("4216","ZAR","BY","15","50"),
("4217","ZAR","EG","20","110"),
("4218","ZAR","UY","15","65"),
("4219","ZAR","BD","10","25"),
("4220","ZAR","PK","15","75"),
("4221","ZAR","PH","20","80"),
("4222","ZAR","ET","5","25"),
("4223","ZAR","TN","15","25"),
("4224","ZAR","LB","15","40"),
("4225","ZAR","IN","15","60"),
("4226","ZAR","PY","15","45"),
("4227","ZAR","UZ","15","25"),
("4228","ZAR","EC","15","45"),
("4229","ZAR","MM","15","20"),
("4230","ZAR","GE","15","20");

INSERT IGNORE INTO `wp_mailpoet_migrations` VALUES 
("1","Migration_20221028_105818","2023-03-13 22:26:40","2023-03-13 22:26:40","0",NULL),
("2","Migration_20221110_151621","2023-03-13 22:26:40","2023-03-13 22:26:40","0",NULL),
("3","Migration_20230109_144830","2023-03-13 22:26:40","2023-03-13 22:26:40","0",NULL),
("4","Migration_20230111_120000","2023-03-13 22:26:40","2023-03-13 22:26:40","0",NULL),
("5","Migration_20230111_130000","2023-03-13 22:26:40","2023-03-13 22:26:40","0",NULL),
("6","Migration_20230215_050813","2023-03-13 22:26:41","2023-03-13 22:26:41","0",NULL),
("7","Migration_20230221_200520","2023-03-13 22:26:41","2023-03-13 22:26:41","0",NULL);

INSERT IGNORE INTO `wp_mailpoet_newsletter_option_fields` VALUES 
("1","isScheduled","standard",NULL,"2023-03-13 22:26:41"),
("2","scheduledAt","standard",NULL,"2023-03-13 22:26:41"),
("3","event","welcome",NULL,"2023-03-13 22:26:41"),
("4","segment","welcome",NULL,"2023-03-13 22:26:41"),
("5","role","welcome",NULL,"2023-03-13 22:26:41"),
("6","afterTimeNumber","welcome",NULL,"2023-03-13 22:26:41"),
("7","afterTimeType","welcome",NULL,"2023-03-13 22:26:41"),
("8","intervalType","notification",NULL,"2023-03-13 22:26:41"),
("9","timeOfDay","notification",NULL,"2023-03-13 22:26:41"),
("10","weekDay","notification",NULL,"2023-03-13 22:26:41"),
("11","monthDay","notification",NULL,"2023-03-13 22:26:41"),
("12","nthWeekDay","notification",NULL,"2023-03-13 22:26:41"),
("13","schedule","notification",NULL,"2023-03-13 22:26:41"),
("14","group","automatic",NULL,"2023-03-13 22:26:41"),
("15","event","automatic",NULL,"2023-03-13 22:26:41"),
("16","sendTo","automatic",NULL,"2023-03-13 22:26:41"),
("17","segment","automatic",NULL,"2023-03-13 22:26:41"),
("18","afterTimeNumber","automatic",NULL,"2023-03-13 22:26:41"),
("19","afterTimeType","automatic",NULL,"2023-03-13 22:26:41"),
("20","meta","automatic",NULL,"2023-03-13 22:26:41"),
("21","afterTimeNumber","re_engagement",NULL,"2023-03-13 22:26:41"),
("22","afterTimeType","re_engagement",NULL,"2023-03-13 22:26:41"),
("23","automationId","automation",NULL,"2023-03-13 22:26:41"),
("24","automationStepId","automation",NULL,"2023-03-13 22:26:41");

INSERT IGNORE INTO `wp_mailpoet_newsletter_templates` VALUES 
("1","0","Welcome Email: Blank 1 Column","[\"welcome\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Hi, new subscriber!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>You recently joined our list and we\'d like to give you a warm welcome!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>Want to get to know us better? Check out some of our most popular articles: <\\/p>\\n<ol>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/the-importance-of-focus-when-writing\\/\\\">The Importance of Focus When Writing<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/writing-next-great-email-subject-line\\/\\\">How to Write a Great Subject Line<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/write-advice-motivation\\/\\\">Just Sit Down and Write &ndash; Advice on Motivation from Ernest Hemingway<\\/a><\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"https:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"https:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-column/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("2","0","Welcome Email: Blank 1:2 Column","[\"welcome\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Hi, new subscriber!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>You recently joined our list and we\'d like to give you a warm welcome!<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Our Most Popular Posts<\\/h3>\"},{\"type\":\"text\",\"text\":\"<ul>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/the-importance-of-focus-when-writing\\/\\\">The Importance of Focus When Writing<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/writing-next-great-email-subject-line\\/\\\">How to Write a Great Subject Line<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.mailpoet.com\\/blog\\/write-advice-motivation\\/\\\">Just Sit Down and Write &ndash; Advice on Motivation from Ernest Hemingway<\\/a><\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>What\'s Next?<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>Add a single button to your newsletter in order to have one clear call-to-action, which will increase your click rates.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read up!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"https:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"https:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-2-column/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("3","0","Gift Welcome","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Header-1.jpg\",\"alt\":\"Gift-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7e7e7\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #dd2d2d;\\\">We\'re so happy you\'re onboard!<\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dd2d2d\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Footer.jpg\",\"alt\":\"Gift-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 1<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 2<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>City<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Country<\\/strong><\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#dd2d2d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/gift/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("4","0","Minimal","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#303c54\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo1.png\",\"alt\":\"Minimal-Logo1\",\"fullWidth\":false,\"width\":\"590px\",\"height\":\"93px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #8b9cbc;\\\">EST.2009<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"41px\"}}},{\"type\":\"text\",\"text\":\"<h2>Welcome to Minimal, Kim.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula. Cras sollicitudin nunc facilisis neque tristique sagittis.<\\/p>\\n<p><\\/p>\\n<p>Maecenas iaculis, lacus malesuada dictum dapibus, justo justo molestie lorem, ac dapibus magna urna vel arcu. Aliquam erat volutpat. Sed bibendum, ipsum sed ullamcorper blandit, eros odio interdum nibh, non venenatis metus lacus vitae lectus.<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}}},{\"type\":\"text\",\"text\":\"<h2>Some of our recent stories<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/plasma-stingray111-800x533.jpg\",\"alt\":\"plasma-stingray111-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"gettyimages-578313682-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"5_what_to_do_p352m1141746-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"47px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo-Small.png\",\"alt\":\"Minimal-Logo-Small\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">Unsubscribe<\\/a><\\/span><\\/p>\\n<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #999999;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Georgia\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Georgia\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Georgia\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#303c54\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/minimal/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("5","0","New Phone Purchase","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":true,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Title.png\",\"alt\":\"Phone-Title\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"215px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Header.jpg\",\"alt\":\"Phone-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Welcome to your brand new Casia 7200.<\\/strong><\\/span><\\/h3>\\n<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #8748d5;\\\">Let\'s get you all set up.<\\/span><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8748d5\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"159px\",\"lineHeight\":\"45px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#2c2c2c\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 1<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 2<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">City<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Country<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":false,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Pinterest.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><\\/p>\\n<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#8748d5\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#1b1821\"},\"body\":{\"backgroundColor\":\"#1b1821\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/phone/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("6","0","Sunglasses","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Logo.jpg\",\"alt\":\"Glasses-Logo\",\"fullWidth\":false,\"width\":\"250px\",\"height\":\"66px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header-2.jpg\",\"alt\":\"Glasses-Header-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"116px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Here\'s what we sent you<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-1.jpg\",\"alt\":\"Glasses-Images-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-2.jpg\",\"alt\":\"Glasses-Images-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-3.jpg\",\"alt\":\"Glasses-Images-3\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header.jpg\",\"alt\":\"Glasses-Header\",\"fullWidth\":true,\"width\":\"640px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Our Summer Range Is Here<\\/strong><\\/h3>\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit.<\\/p>\\n<p><\\/p>\\n<p>Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue.&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"137px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Got any questions or need some help?<\\/strong><\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'re just a click or a phone call away.<\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Call Us:<\\/strong> 08856877854<\\/span><\\/h3>\\n<h3 style=\\\"text-align: center;\\\"><\\/h3>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"23.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><strong><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">Unsubscribe<\\/a>&nbsp;|&nbsp;<a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #808080;\\\">Add your postal address here!<\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/sunglasses/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("7","0","Real Estate","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Logo-1-150x84.jpg\",\"alt\":\"Property-Logo-1\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"84px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">TAKING&nbsp;THE WORRY OUT OF REAL ESTATE<\\/span><\\/strong><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Welcome Home<\\/span><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Header.jpg\",\"alt\":\"Property-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"782px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">We\'re here to help you move<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-1.png\",\"alt\":\"Property-Icon-1\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-2.png\",\"alt\":\"Property-Icon-2\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-3.png\",\"alt\":\"Property-Icon-3\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"22.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#8691be\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'d love to keep you updated with our latest news. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Sign up to our newsletter now and you\'ll never miss a thing.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Sign Up Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#6a7087\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#6a7087\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/real-estate/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("8","0","App Welcome","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-1.png\",\"alt\":\"App-Signup-Logo\",\"fullWidth\":false,\"width\":\"80px\",\"height\":\"80px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center; margin: 0;\\\"><strong>Welcome to Appy<\\/strong><\\/h1><p style=\\\"text-align: center; margin: 0;\\\"><span style=\\\"color: #ffffff;\\\">Let\'s get started!<\\/span><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Header.png\",\"alt\":\"App-Signup-Header\",\"fullWidth\":false,\"width\":\"1280px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Hi [subscriber:firstname | default:subscriber],<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">In MailPoet, you can write emails in plain text, just like in a regular email. This can make your email newsletters more personal and attention-grabbing.<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Is this too simple? You can still style your text with basic formatting, like <strong>bold<\\/strong> or <em>italics.<\\/em><\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Finally, you can also add a call-to-action button between 2 blocks of text, like this:<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"button\",\"text\":\"Get Started Here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\",\"borderColor\":\"#32b6c6\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"188px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Team.jpg\",\"alt\":\"App-Signup-Team\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-Footer.png\",\"alt\":\"App-Signup-Logo-Footer\",\"fullWidth\":false,\"width\":\"50px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><strong>Appy<\\/strong><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 1<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 2<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>City<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span> | <\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#32b6c6\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#32b6c6\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/app_welcome/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("9","0","Welcome to FoodBox","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Logo.png\",\"alt\":\"Food-Delivery-Logo\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-App.png\",\"alt\":\"Food-Delivery-App\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Welcome to FoodBox<\\/strong><\\/h1>\\n                                  <h2><strong>Lorem ipsum dolor sit amet<\\/strong><\\/h2>\\n                                  <p>Curabitur sollicitudin eros eu cursus sollicitudin. Suspendisse laoreet sollicitudin urna, ut lacinia risus dictum a. Integer a neque eu magna commodo sodales eu eget ante.<\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Focus.jpg\",\"alt\":\"Food-Delivery-Focus\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"800px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"31.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#e5e5e5\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">Get started in 3 simple steps<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-1-1.png\",\"alt\":\"Food-Delivery-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-2-1.png\",\"alt\":\"Food-Delivery-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-3-1.png\",\"alt\":\"Food-Delivery-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 14px;\\\"><strong><span style=\\\"color: #ffffff;\\\">Link 1 - Link 2 - Link 3 - Link 4<\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\"},\"h1\":{\"fontColor\":\"#4599da\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#878787\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"link\":{\"fontColor\":\"#4599da\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/food_box/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("10","0","Poet","[\"welcome\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"144px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1>Thanks for signing up!<\\/h1>\\n    <p><span style=\\\"color: #000000;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"66px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 12px;\\\"><span style=\\\"color: #999999;\\\"><strong>Latest p<\\/strong><\\/span><\\/p>\\n    <h2><strong>The 26th of December<\\/strong><\\/h2>\\n    <h3><span>A Tuesday, day of Tiw,<\\/span><br \\/><span>god of war, dawns in darkness.<\\/span><br \\/><span>The short holiday day of talking by the fire,<\\/span><br \\/><span>floating on snowshoes among<\\/span><br \\/><span>ancient self-pollarded maples,<\\/span><br \\/><span>visiting, being visited, giving<\\/span><br \\/><span>a rain gauge, receiving red socks,<\\/span><br \\/><span>watching snow buntings nearly over<\\/span><br \\/><span>their heads in snow stab at spirtled bits<\\/span><br \\/><span>of sunflower seeds the chickadees<\\/span><br \\/><span>hold with their feet to a bough<\\/span><br \\/><span>and hack apart, scattering debris<\\/span><br \\/><span>like sloppy butchers, is over.<\\/span><br \\/><span>Irregular life begins. Telephone calls,<\\/span><br \\/><span>Google searches, evasive letters,<\\/span><br \\/><span>complicated arrangements, faxes,<\\/span><br \\/><span>second thoughts, consultations,<\\/span><br \\/><span>e-mails, solemnly given kisses.<\\/span><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Images-1.jpg\",\"alt\":\"Poet-Images\",\"fullWidth\":true,\"width\":\"400px\",\"height\":\"1200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#393939\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">What did you think of this poem? Let me know on one of my social media channels.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"right\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Poetry books<\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-1.png\",\"alt\":\"Poet-Books-1\",\"fullWidth\":false,\"width\":\"220px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-3.png\",\"alt\":\"Poet-Books-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-2.png\",\"alt\":\"Poet-Books-2\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h2\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h3\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#393939\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ebebeb\"},\"body\":{\"backgroundColor\":\"#ebebeb\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\",\"styles\":{\"block\":{\"textAlign\":\"right\"}}},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/poet/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("11","0","Post Notifications: Blank 1 Column","[\"notification\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"fake-logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Check Out Our New Blog Posts! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>MailPoet can <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>automatically<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">send your new blog posts to your subscribers.<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">Below, you\'ll find three recent posts, which are displayed automatically, thanks to the <em>Automatic Latest Content<\\/em> widget, which can be found in the right sidebar, under <em>Content<\\/em>.<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">To edit the settings and styles of your post, simply click on a post below.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/post-notifications-blank-1-column/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("12","0","Modular Style Stories","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/Modular-Logo.png\",\"alt\":\"Modular-Logo\",\"fullWidth\":false,\"width\":\"271px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"26px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Pinterest.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">They certainly know how to fold. A see-through artificial wing case has been used to watch for the first time as ladybirds put away their wings after flight.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Plasma jet engines that could take you from ground to space<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">FORGET fuel-powered jet engines. We&rsquo;re on the verge of having aircraft that can fly from the ground up to the edge of space using air and electricity alone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"Cutting through the smog: What to do to fight air pollution\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Cutting through the smog: What to do to fight air pollution<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Plasma jet engines that could take you from the ground to space<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#b956c5\"},\"body\":{\"backgroundColor\":\"#efe7f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"2\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"116px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#ffffff\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/modular-style-stories/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41");

INSERT IGNORE INTO `wp_mailpoet_newsletter_templates` VALUES 
("13","0","Stripped RSS Style Layout","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rss-simple-news\\/RSS-Logo-2.png\",\"alt\":\"RSS-Logo-2\",\"fullWidth\":true,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong><span style=\\\"color: #333333;\\\">Latest RSS Simple&nbsp;Posts<\\/span><\\/strong><\\/h3>\\n<p><span style=\\\"color: #999999;\\\">Week 23: 23\\/19\\/19<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"5\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><strong>RSS Simple<\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><span>Add your postal address here!<\\/span><\\/strong><\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#3478f5\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#3478f5\",\"textDecoration\":\"none\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"3\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/rss-simple-news/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("14","0","One Full Post In An Email","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/not-so-medium\\/Not-So-Medium-Logo.png\",\"alt\":\"Not-So-Medium-Logo\",\"fullWidth\":false,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong><em>Welcome to this week\'s post. <\\/em><\\/strong><\\/p>\\n<p><em>Every Friday, we send you the most interesting story&nbsp;of the week in full.<\\/em><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"1\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><em>Share this with your friends<\\/em><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><em>We promise not to spam anyone, and we only send our great articles to any email addresses in our list. Promise!<\\/em><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/LinkedIn.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Email.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#2c2c2c\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"18px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"1\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/not-so-medium/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("15","0","Wide Story Layout","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Logo.png\",\"alt\":\"Wide-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #808080;\\\">Our Latest Posts<\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Footer.jpg\",\"alt\":\"Wide-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"721px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Lucida\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Lucida\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Lucida\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#5ecd39\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f0f0f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/wide-story-layout/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("16","0","Industry Conference","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Logo.png\",\"alt\":\"Conf-Logo\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"150px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff; font-size: 11px; text-transform: uppercase; opacity: 0.5; letter-spacing: 3px;\\\">Get ready for the biggest email conference of the year<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"56px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Ticket.png\",\"alt\":\"Conf-Ticket\",\"fullWidth\":false,\"width\":\"339px\",\"height\":\"177px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"font-size: 42px;\\\"><strong><span style=\\\"color: #ffffff; line-height: 1.2; position: relative; top: -5px;\\\">Email Boston 2018<\\/span><\\/strong><\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"133px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"34px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Industry-Coupon.png\",\"display\":\"fit\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">---<\\/span><\\/h3>\\n    <h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Grab 20% off your tickets right now<\\/span><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">We\'re offering an exclusive 20% off tickets with this coupon code!<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"CouPon_Code\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Top.png\",\"alt\":\"Conf-Top\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"12px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"14px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Holding.jpg\",\"alt\":\"Conf-Holding\",\"fullWidth\":false,\"width\":\"1000px\",\"height\":\"667px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"46px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Check out&nbsp;this year\'s event<\\/strong><\\/h3>\\n    <p>We\'ve ramped up everything this year for our conference, including amazing new speakers and guests, and a few surprises for everyone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy a ticket here\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"30px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"header\",\"text\":\"<p>&nbsp;<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b8291e;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b8291e;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b8291e;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arvo\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arvo\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arvo\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#b8291e\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#515151\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/industry-conference/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("17","0","Science Weekly","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Science-Logo.png\",\"alt\":\"Science-Logo\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"300px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Title-22.png\",\"alt\":\"Health-Mag-Title-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"214px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>The latest news from the world of science<\\/strong><\\/span><\\/h1>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-End-1.png\",\"alt\":\"Health-Mag-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Download our app!<\\/strong><\\/h2>\\n                      <p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed in odio dui. Duis et dolor nec erat dictum laoreet. Morbi dapibus turpis id eros viverra tempor. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\\n                      <p><span>Fusce et diam ac sapien posuere luctus. Etiam in vehicula metus, ac viverra elit. Duis diam lacus, molestie vel enim non, rutrum placerat massa. Suspendisse a elit tincidunt, egestas lacus at, maximus diam. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Download Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"144px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Phone.png\",\"alt\":\"Health-Mag-Phone\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"573px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">Keep In Touch With Us<\\/h3>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"26px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b1b6d1;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b1b6d1;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b1b6d1;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\"},\"text\":{\"fontColor\":\"#d6d6d6\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2b2d37\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/science_weekly/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("18","0","Newspaper Traditional","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"28px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"font-size: 15px;\\\"><em><strong>[date:mtext][date:dordinal],[date:y]<\\/strong><\\/em><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #008080;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #008080;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Local News<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong>Sports&nbsp;Updates &amp; Scores<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><strong>Business News<\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><strong>Check Out Our New Blog Posts! <\\/strong><\\/h1>\\n    <p style=\\\"text-align: left;\\\">&nbsp;<\\/p>\\n    <p style=\\\"text-align: left;\\\">MailPoet can <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>automatically<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">send your new blog posts to your subscribers.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">Below, you\'ll find three recent posts, which are displayed automatically, thanks to the <em>Automatic Latest Content<\\/em> widget, which can be found in the right sidebar, under <em>Content<\\/em>.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">To edit the settings and styles of your post, simply click on a post below.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"28px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #458687;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #458687;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #458687;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"21px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#3d8076\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f2f9f8\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/newspaper-traditional/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("19","0","Clear News","[\"notification\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"27px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: right;\\\"><span style=\\\"color: #808080;\\\"><strong>October 2018<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left; line-height: 1.3;\\\"><strong>Good Morning!<\\/strong><\\/h1>\\n    <h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce egestas nisl vel ante finibus fringilla ullamcorper non lectus. Aenean leo neque, egestas et lacus eu, viverra luctus nisi. Donec dapibus mauris at fringilla consequat. Cras sed porta nunc. Ut tincidunt luctus felis sed suscipit. Sed tristique faucibus fermentum.<\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"24px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/UEl2.gif\",\"alt\":\"UEl2\",\"fullWidth\":false,\"width\":\"360px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Today\'s Top Stories<\\/strong><\\/h2>\"}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>We cover all types of news<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"World\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e23f3f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Business\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#50b6ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Politics\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#506dce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Sports\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e1bc2d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Science\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#a650ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Health\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#64b03c\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Family\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#278f6e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Arts\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#7c5e5e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Local\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Crossword.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">The Friday Crossword<\\/span><\\/h2>\\n    <p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum vitae ornare elit. Duis laoreet justo sed fringilla maximus. Aenean pharetra nec risus a vestibulum.<\\/span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get started\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"22px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><\\/strong><\\/p>\\n    <p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/strong><\\/p>\"},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Add your postal address!<\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"social\",\"iconSet\":\"default\",\"icons\":[]}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Source Sans Pro\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"titleOnly\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"centered\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/clear-news/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("20","0","Dog Food","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Logo.png\",\"alt\":\"Dog-Logo\",\"fullWidth\":false,\"width\":\"42px\",\"height\":\"91px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"31px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"line-height: 1.2em;\\\"><strong>Thanks for buying your dog food from us<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Header-1024x409.jpg\",\"alt\":\"Dog-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"511px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Here\'s some other pawsome things to try...&nbsp;<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-1.jpg\",\"alt\":\"Dog-Product-1\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Dog Jumper<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><span><strong><\\/strong><\\/span><\\/p>\\n<p><em><strong>$19.99<\\/strong><\\/em><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-2.jpg\",\"alt\":\"Dog-Product-2\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Dog&nbsp;Socks<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><span><em><strong>$19.99<\\/strong><\\/em><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-3.jpg\",\"alt\":\"Dog-Product-3\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Glow Collar<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><em><\\/em><\\/p>\\n<p><em><strong>$19.99<\\/strong><\\/em><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#000000\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"45px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong><\\/strong><span style=\\\"color: #ffffff;\\\">Our Guarantee<\\/span><\\/h3>\\n<p><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque. Vivamus ante sapien, consequat vitae ante quis, facilisis pellentesque mi. Praesent at scelerisque leo. Donec elementum mi consequat, ultrices lorem nec, vestibulum arcu. Aenean id libero vitae felis consequat maximus<\\/span><\\/p>\\n<p><span style=\\\"color: #ffffff;\\\"><em><\\/em><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><em><span style=\\\"color: #000000;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #000000;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #000000;\\\">Manage your subscription<\\/a><\\/span><\\/em><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#d4d4d4\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/dog-food/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41");

INSERT IGNORE INTO `wp_mailpoet_newsletter_templates` VALUES 
("21","0","Abandoned Cart – Kids","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Logo.png\",\"alt\":\"Kids-Clothing-Logo\",\"fullWidth\":true,\"width\":\"250px\",\"height\":\"121px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Boys Clothes<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Girls Clothes<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Toys & Games<\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#9cd1e1\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Wait!<\\/strong><\\/h1><h3>You\\u2019ve left something in your cart!<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Don\\u2019t worry, we saved it for you\\u2026<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"abandonedCartContent\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"titlePosition\":\"aboveExcerpt\",\"featuredImagePosition\":\"left\",\"pricePosition\":\"below\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}},\"context\":\"abandonedCartContent.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Go To Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"154px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#fceba5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>YOU MIGHT ALSO LIKE\\u2026<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-3.jpg\",\"alt\":\"Kids-Clothing-Image-3\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Cherry Dress<\\/strong><\\/p><p><span>$10.99<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-2.jpg\",\"alt\":\"Kids-Clothing-Image-2\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Red T-Shirt<\\/strong><\\/p><p><span>$9.49<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-4.jpg\",\"alt\":\"Kids-Clothing-Image-4\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Pink Dance Dress<\\/strong><\\/p><p><span>$11.99<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Footer.jpg\",\"alt\":\"Kids-Clothing-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"107px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Logo-Footer-150x61.png\",\"alt\":\"Kids-Clothing-Logo-Footer\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"61px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #333333;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #333333;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #333333;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"lineHeight\":\"1.6\"},\"h1\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\",\"lineHeight\":\"1.6\"},\"h2\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\",\"lineHeight\":\"1.6\"},\"h3\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\",\"lineHeight\":\"1.6\"},\"link\":{\"fontColor\":\"#9bd2e0\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#c3e1e8\"}},\"blockDefaults\":{\"abandonedCartContent\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"pricePosition\":\"below\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"abandonedCartContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"abandonedCartContent\",\"titlePosition\":\"aboveExcerpt\"},\"automatedLatestContent\":{\"amount\":\"5\",\"authorPrecededBy\":\"Author:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"belowTitle\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"readMoreButton\":{\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"Read more\",\"url\":\"[postLink]\"},\"readMoreText\":\"Read more\",\"readMoreType\":\"button\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"authorPrecededBy\":\"Author:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"alternate\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"readMoreButton\":{\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"Read more\",\"url\":\"[postLink]\"},\"readMoreText\":\"Read more\",\"readMoreType\":\"button\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false,\"withLayout\":true},\"button\":{\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"154px\"}},\"text\":\"Go To Cart\",\"url\":\"\",\"type\":\"button\"},\"container\":[],\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"footer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}},\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\"},\"posts\":{\"amount\":\"10\",\"authorPrecededBy\":\"Author:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"belowTitle\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"postStatus\":\"publish\",\"readMoreButton\":{\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"Read more\",\"url\":\"[postLink]\"},\"readMoreText\":\"Read more\",\"readMoreType\":\"link\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false},\"products\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"pricePosition\":\"below\",\"readMoreType\":\"link\",\"readMoreText\":\"Buy now\",\"readMoreButton\":{\"text\":\"Buy now\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"height\":\"32px\",\"iconType\":\"facebook\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"link\":\"http:\\/\\/www.facebook.com\",\"text\":\"Facebook\",\"type\":\"socialIcon\",\"width\":\"32px\"},{\"height\":\"32px\",\"iconType\":\"twitter\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"link\":\"http:\\/\\/www.twitter.com\",\"text\":\"Twitter\",\"type\":\"socialIcon\",\"width\":\"32px\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}},\"type\":\"spacer\"},\"header\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}},\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\"},\"woocommerceHeading\":{\"contents\":{\"new_account\":\"New Order: #0001\",\"processing_order\":\"Thank you for your order\",\"completed_order\":\"Thanks for shopping with us\",\"customer_note\":\"A note has been added to your order\"}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/kids-clothing/thumbnail.20201028.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("22","0","Rock Band","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#060d13\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#060d13\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"315px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"48px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #7acff0;\\\">Free track download<\\/span><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #d4d4d4;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam. Nunc diam leo, bibendum eget aliquam eget, commodo vitae lectus<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Download now for free\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#152533\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"2px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#1c2f40\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">We\'ve been busy in the studio<\\/span><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #d4d4d4;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-2.jpg\",\"alt\":\"RockBand-Albums-2\",\"fullWidth\":false,\"width\":\"250px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Magnus Opium<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-1.jpg\",\"alt\":\"RockBand-Albums-1\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Skeletal Bones<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-3.jpg\",\"alt\":\"RockBand-Albums-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Blinded by Vision<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Tours.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1c2f40\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"37px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: right;\\\">New Tour Dates<\\/h1>\\n    <p style=\\\"text-align: right;\\\">14th March - London, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">15th March - Leeds, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">16th March - Birmingham, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">19th March - Manchester, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">21st March - Glasgow, UK<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"144px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">Bounce Rate<\\/h3>\"},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#aaaaaa\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#060d13\"},\"body\":{\"backgroundColor\":\"#060d13\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#1c2f40\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#aaaaaa\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/rock-band/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("23","0","Wine City (with coupon)","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"37px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wine-city\\/Wine-Logo.png\",\"alt\":\"Wine-Logo\",\"fullWidth\":false,\"width\":\"136px\",\"height\":\"67px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"31px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>Red Wine<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>White&nbsp;Wine<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>Rose&nbsp;Wine<\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wine-city\\/Wine-Header-1.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Have a drink on us<\\/strong><\\/span><\\/h1>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"231px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"34px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>You\'re our VIP - now it\'s time to celebrate!&nbsp;<\\/strong><\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #6d6d6d;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue.<\\/span><\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#6d6d6d\",\"borderWidth\":\"2px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"50px\",\"fontColor\":\"#6d6d6d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #6d6d6d;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #6d6d6d;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #6d6d6d;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #6d6d6d;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"231px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/wine-city/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("24","0","Abandoned Cart – Fitness","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Logo-1.jpg\",\"alt\":\"Fitness-Logo-1\",\"fullWidth\":true,\"width\":\"180px\",\"height\":\"96px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Get back in the game<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Header.jpg\",\"alt\":\"Fitness-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"696px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>You\'ve left something in your cart...<\\/strong><\\/h3>\"}]}]},{\"type\":\"abandonedCartContent\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"titlePosition\":\"aboveExcerpt\",\"featuredImagePosition\":\"left\",\"pricePosition\":\"hidden\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"abandonedCartContent.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Recover Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#343434\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"146px\",\"lineHeight\":\"37px\",\"fontColor\":\"#343434\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#afd147\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Still interested?<\\/strong><\\/h3>\\n<p style=\\\"text-align: center;\\\"><strong>Here\'s 20% off your order if you complete it right now. We\'re nice like that.<\\/strong><\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#afd147\",\"borderColor\":\"#56741d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"50px\",\"fontColor\":\"#56741d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Logo-Footer-1.png\",\"alt\":\"Fitness-Logo-Footer-1\",\"fullWidth\":false,\"width\":\"180px\",\"height\":\"52px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\">Address Line 1, Address Line 2, City, Country<\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #999999;\\\">Unsubscribe<\\/a><span>&nbsp;<\\/span>|<span>&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #999999;\\\">Manage your subscription<\\/a><\\/strong><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"lineHeight\":\"1.6\"},\"h1\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\",\"lineHeight\":\"1.6\"},\"h2\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\",\"lineHeight\":\"1.6\"},\"h3\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"lineHeight\":\"1.6\"},\"link\":{\"fontColor\":\"#3c3c3c\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}},\"blockDefaults\":{\"abandonedCartContent\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"pricePosition\":\"hidden\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"abandonedCartContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"abandonedCartContent\",\"titlePosition\":\"aboveExcerpt\"},\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Recover Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#343434\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"146px\",\"lineHeight\":\"37px\",\"fontColor\":\"#343434\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":[],\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"products\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"pricePosition\":\"below\",\"readMoreType\":\"link\",\"readMoreText\":\"Buy now\",\"readMoreButton\":{\"text\":\"Buy now\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}},\"woocommerceHeading\":{\"contents\":{\"new_account\":\"New Order: #0001\",\"processing_order\":\"Thank you for your order\",\"completed_order\":\"Thanks for shopping with us\",\"customer_note\":\"A note has been added to your order\"}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/fitness/thumbnail.20201028.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("25","0","Motor","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #d52a2a;\\\"><strong>Welcome to Vector Motors<\\/strong><\\/span><\\/p>\\n    <p style=\\\"text-align: center; font-size: 11px;\\\"><span style=\\\"color: #d52a2a;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Header-logo-1.png\",\"alt\":\"Car-Header-logo-1\",\"fullWidth\":false,\"width\":\"167.5px\",\"height\":\"349px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"118px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"font-size: 35px; line-height: 40px; text-align: left; border-left: 10px solid #d52a2a; margin-left: 20px; padding-left: 20px;\\\"><strong><span style=\\\"color: #ffffff;\\\">Welcome to the club<\\/span><\\/strong><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"72px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #d52a2a;\\\">You\'ve bought the car,&nbsp;here\'s&nbsp;what happens next.<\\/span><\\/strong><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque. <\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span><\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>Vivamus ante sapien, consequat vitae ante quis, facilisis pellentesque mi. Praesent at scelerisque leo. Donec elementum mi consequat, ultrices lorem nec, vestibulum arcu. Aenean id libero vitae felis consequat maximus.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1><strong>We\'re here to help<\\/strong><\\/h1>\\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque.<\\/p>\\n    <p><\\/p>\\n    <p><strong><a href=\\\"\\\">Get in touch with us here<\\/a><\\/strong><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"113px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"42px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Servicing Plans\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"176px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Wheel.jpg\",\"alt\":\"Car-Wheel\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"560px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>We\'ll be in touch soon with updates<\\/strong><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #d52a2a;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #d52a2a;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #d52a2a;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Footer.jpg\",\"alt\":\"Car-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"275px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Roboto\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#d52a2a\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#e3e3e3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Servicing Plans\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"176px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"5px\",\"borderColor\":\"#d52a2a\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"118px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#d52a2a\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/motor/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("26","0","Avocado","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f8f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Logo-2.png\",\"alt\":\"Avocado-Logo-2\",\"fullWidth\":false,\"width\":\"212px\",\"height\":\"89px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><strong>Has to be fresh<\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ddeeba\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"58px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Holy Guacamole!<\\/strong><\\/h1>\\n<h2 style=\\\"text-align: center;\\\">Your monthly avocado<\\/h2>\\n<h2 style=\\\"text-align: center;\\\">delivery starts right now.<\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Header-1.jpg\",\"alt\":\"Avocado-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"644px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Recipe.jpg\",\"alt\":\"Avocado-Recipe\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"890px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"135px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>A quick and easy recipe to get you started...<\\/strong><\\/h3>\\n<p style=\\\"text-align: left;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer blandit tortor nec eleifend maximus. Nulla est lectus, tincidunt quis molestie vitae, suscipit non orci.<\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9ecd2e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"28px\",\"borderStyle\":\"solid\",\"width\":\"111px\",\"lineHeight\":\"36px\",\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#9ecd2e\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #333333;\\\"><\\/span><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #333333;\\\"><\\/span><\\/strong><strong><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\/span><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ddeeba\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"58px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Got a friend that hass to have this too ?<\\/strong><\\/h2>\\n<h2 style=\\\"text-align: center;\\\"><\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Coupon.jpg\",\"alt\":\"Avocado-Coupon\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"382px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Send them your exclusive coupon code now and they\'ll receive 50% off their next order, and you\'ll get your next box for free!&nbsp;<\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\",\"borderColor\":\"#3d3d3d\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"254px\",\"lineHeight\":\"50px\",\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f3f8f3\",\"height\":\"44px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #9ecd2e;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #9ecd2e;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #9ecd2e;\\\">Manage your subscription<\\/a><\\/span><\\/strong><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#9ecd2e\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f3f8f3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#9ecd2e\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/avocado/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("27","0","Book store (with coupon)","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Logo.png\",\"alt\":\"Book-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">Turn more pages this weekend...<\\/span><\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Just to say thanks, here\'s a small gift from us to you.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"71px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #5094ad;\\\"><strong>Read more every week<\\/strong><\\/span><\\/p>\\n    <h2 style=\\\"text-align: center;\\\"><strong>Your free gift!<\\/strong><\\/h2>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"2px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#125674\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, adipiscing elit. Fusce mollis orci justo,<\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>commodo mattis nisi vitae. Sed aliquam, ex ac lacinia tempus,<\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>enim urna luctus odio, at leo ante non.<\\/span><\\/p>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>20% off all books<\\/strong><\\/h2>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#125674\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#125674\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Image-Wide-2.png\",\"alt\":\"Book-Image-Wide\",\"fullWidth\":true,\"width\":\"1200px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cdc391\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cdc391\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Logo.png\",\"alt\":\"Book-Logo\",\"fullWidth\":false,\"width\":\"96px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #cdc391;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #cdc391;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #cdc391;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #ffffff;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Noticia Text\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#125674\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"2px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#125674\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/book-store-with-coupon/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("28","0","Flowers (with coupon)","[\"woocommerce\",\"all\"]","","{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eae5e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #000000;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #000000;\\\">View this email in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flowers-Logo.png\",\"alt\":\"Flowers-Logo\",\"fullWidth\":false,\"width\":\"110px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"44px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flowers-Header.jpg\",\"alt\":\"Flowers-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"850px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Just for you.<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Welcome to our flower store - as a token of our appreciation for you signing up,<\\/strong><\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>here\'s a little gift from us for your next order.<\\/strong><\\/span><\\/p>\"},{\"productIds\":[],\"excludedProductIds\":[],\"productCategoryIds\":[],\"excludedProductCategoryIds\":[],\"type\":\"coupon\",\"amount\":10,\"amountMax\":100,\"discountType\":\"percent\",\"expiryDay\":10,\"usageLimit\":\"\",\"usageLimitPerUser\":\"\",\"minimumAmount\":\"\",\"maximumAmount\":\"\",\"emailRestrictions\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#292929\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"source\":\"createNew\",\"code\":\"XXXX-XXXXXXX-XXXX\"},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333; font-size: 11px;\\\"><strong><\\/strong><strong>10% off your next order with us. Terms and Conditions apply.<\\/strong><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>A little inspiration to get you started...<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>New flowers delivered<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-1.jpg\",\"alt\":\"Flower-1\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-2.jpg\",\"alt\":\"Flower-2\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>Save with a subscription<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>Collect from our store<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-3.jpg\",\"alt\":\"Flower-3\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eae5e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b3748a;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b3748a;\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b3748a;\\\">Manage your subscription<\\/a><\\/span><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#e0a9bc\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eae5e5\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"392px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/flowers-with-coupon/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41");

INSERT IGNORE INTO `wp_mailpoet_newsletter_templates` VALUES 
("29","0","Newsletter: Blank 1 Column","[\"standard\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find 4 menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-column/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("30","0","Newsletter: Blank 1:2 Column","[\"standard\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find 4 menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>This template has...<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>In the right sidebar, you can add these layout blocks to your email:<\\/p>\\n<ul>\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>... a 2-column layout.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p><span style=\\\"line-height: 25.6px;\\\">You can change a layout\'s background color by clicking on the settings icon on the right edge of the Designer. Simply hover over this area to see the Settings (gear) icon.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-2-column/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("31","0","Newsletter: Blank 1:2:1 Column","[\"standard\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started!<\\/strong><\\/h1>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find four menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>This template has...<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>In the right sidebar, you can add layout blocks to your email:<\\/p>\\n<ul>\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>... a 2-column layout.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>You can change a layout\'s background color by clicking on the settings icon on the right edge of the Designer. Simply hover over this area to see the Settings (gear) icon.<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"font-weight: 600;\\\">Let\'s end with a single column. <\\/span><\\/h3>\\n<p style=\\\"line-height: 25.6px;\\\">In the right sidebar, you can add these layout blocks to your email:<\\/p>\\n<p style=\\\"line-height: 25.6px;\\\"><\\/p>\\n<ul style=\\\"line-height: 25.6px;\\\">\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-2-1-column/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("32","0","Newsletter: Blank 1:3 Column","[\"standard\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Let\'s Get Started! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>It\'s time to design your newsletter! In the right sidebar, you\'ll find four menu items that will help you customize your newsletter:<\\/p>\\n<ol>\\n<li>Content<\\/li>\\n<li>Columns<\\/li>\\n<li>Styles<\\/li>\\n<li>Preview<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>This template...<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>In the right sidebar, you can add layout blocks to your newsletter.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>... has a...<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>You have the choice of:<\\/p>\\n<ul>\\n<li>1 column<\\/li>\\n<li>2 columns<\\/li>\\n<li>3 columns<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>3-column layout.<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>You can add as many layout blocks as you want!<\\/p>\"},{\"type\":\"text\",\"text\":\"\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-3-column/thumbnail.20190930.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("33","0","Simple Text","[\"standard\",\"blank\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"Fake logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\">Hi [subscriber:firstname | default:subscriber],<\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">In MailPoet, you can write emails in plain text, just like in a regular email. This can make your email newsletters more personal and attention-grabbing.<\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">Is this too simple? You can still style your text with basic formatting, like <strong>bold<\\/strong> or <em>italics.<\\/em><\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">Finally, you can also add a call-to-action button between 2 blocks of text, like this:<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"button\",\"text\":\"It\'s time to take action!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<p>Thanks for reading. See you soon!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p><strong><em>The MailPoet Team<\\/em><\\/strong><\\/p>\"},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/simple-text/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("34","0","Take a Hike","[\"standard\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/header.jpg\",\"alt\":\"header\",\"fullWidth\":true,\"width\":\"1320px\",\"height\":\"483px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p>Hi&nbsp;[subscriber:firstname | default:explorer]<\\/p>\\n                      <p><\\/p>\\n                      <p>Aliquam feugiat nisl eget eleifend congue. Nullam neque tellus, elementum vel elit dictum, tempus sagittis nunc. Phasellus quis commodo odio. Vestibulum vitae mi vel quam rhoncus egestas eget vitae eros.&nbsp;<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1><strong>How to plan your hiking route<\\/strong><\\/h1>\\n                      <p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam dictum urna ac lacus dapibus rhoncus.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"https:\\/\\/www.google.co.uk\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"150px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/map.jpg\",\"alt\":\"map\",\"fullWidth\":false,\"width\":\"330px\",\"height\":\"227px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/boots.jpg\",\"alt\":\"boots\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2><strong>Tried &amp; tested: Our favourite walking boots<\\/strong><\\/h2>\\n                        <p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"See Reviews\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"150px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Hikers Gallery<\\/strong><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery3.jpg\",\"alt\":\"gallery3\",\"fullWidth\":true,\"width\":\"1000px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery1-300x225.jpg\",\"alt\":\"gallery1\",\"fullWidth\":true,\"width\":\"300px\",\"height\":\"225px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery2-1.jpg\",\"alt\":\"gallery2\",\"fullWidth\":true,\"width\":\"1000px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Edit this to insert text<\\/p>\"},{\"type\":\"button\",\"text\":\"View More Photos\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"214px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Hiking goes social...<\\/strong><\\/h3>\"},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4f230c\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#423c39\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h2\":{\"fontColor\":\"#265f6d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#423c39\",\"fontFamily\":\"Courier New\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#843c15\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#843c15\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/take_a_hike/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("35","0","News Day","[\"standard\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/news_day\\/News-Outlet-Title-2.jpg\",\"alt\":\"News-Outlet-Title-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #2ca5d2;\\\"><strong>Top Story<\\/strong><\\/span><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Plasma jet engines that could take you from the ground to space<\\/strong><\\/h2>\"},{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/news_day\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":\"413.28125px\",\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\">FORGET fuel-powered jet engines. We\\u2019re on the verge of having aircraft that can fly from the ground up to the edge of space using air and electricity alone. Traditional jet engines create thrust by mixing compressed air with fuel and igniting it. The burning mixture expands rapidly and is blasted out of the back of the engine, pushing it forwards. &hellip;<\\/p><p><a href=\\\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #2ca5d2;\\\"><strong>Popular Posts Today<\\/strong><\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Cutting through the smog: What to do to fight air pollution<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Tackling our air problems starts with traffic control, but individual action to reduce energy use and intensive farming would also help clean our air.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it&nbsp;moves<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">They certainly know how to fold. A see-through artificial wing case has been used to watch for the first time as ladybirds put away their wings after flight.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Brazil&rsquo;s history-making Hurricane<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Jairzinho has just made history. In claiming the fourth goal of an unforgettable 1970 FIFA World Cup Mexico&trade; Final against Italy, he has maintained his record of scoring in every one of Brazil&rsquo;s matches en route to the Trophy.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Iceland&rsquo;s dentist-coach defying convention and expectations<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">As Iceland&rsquo;s key matches loom, with kick-off just a couple of hours away, you will find their national coach in the pub. This may seem unusual...<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Impact and legacy of 2018 FIFA World Cup Russia<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Organising a FIFA World Cup&trade; in a sustainable manner is a major challenge. The scale of the event inevitably has an impact on the Host Country.&nbsp;<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Lineker&rsquo;s life-changing treble<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Given that he won the Golden Boot in his first and came within a whisker of the Final in his second, one might expect Gary Lineker to have a tough time picking his FIFA World Cup&trade; highlight. Yet the man who scored ten times...<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\\\">Read More<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><strong>NewsDay<\\/strong><\\/p>\\n                      <p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/><br \\/><\\/p>\\n                      <p><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#2ca5d2\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f2f2f2\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/news_day/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("36","0","World Cup","[\"standard\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Header.png\",\"alt\":\"Sports-Football-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"220px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-1.png\",\"alt\":\"Sports-Football-Divider-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong><span style=\\\"color: #ffffff; font-size: 14px;\\\">Issue #1<\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" target=\\\"_blank\\\" style=\\\"color: #ffffff; font-size: 14px; text-align: center;\\\">View In Browser<\\/a><\\/p>\\n                                        <p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff; text-align: start;\\\">Monday 1st January 2017<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Header-1.png\",\"alt\":\"Sports-Football-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"580px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Welcome Back!<\\/strong><\\/h2>\\n                                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit, vel ultrices nibh bibendum quis. Donec eget fermentum magna.<\\/p>\\n                                      <p><\\/p>\\n                                      <p>Nullam congue dui lectus, quis pellentesque orci placerat eu. Fusce semper neque a mi aliquet vulputate sed sit amet nisi. Etiam sed nisl nec orci pretium lacinia eget in turpis. Maecenas in posuere justo. Vestibulum et sapien vestibulum, imperdiet neque in, maximus velit.<\\/p>\\n                                      <p><\\/p>\\n                                      <p>Proin dignissim elit magna, viverra scelerisque libero vehicula sed<\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-3.png\",\"alt\":\"Sports-Football-Divider-3\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"padding-bottom: 0;\\\"><span style=\\\"font-weight: 600;\\\">Latest News<\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"View All News\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d35400\",\"borderColor\":\"#d35400\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"right\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2865897_full-lnd.jpg\",\"alt\":\"Brazil\\u2019s history-making Hurricane\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Brazil&rsquo;s history-making Hurricane<\\/strong><\\/h3>\\n                                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit, vel ultrices nibh bibendum quis. Donec eget fermentum magna. Nullam congue dui lectus, quis pellentesque orci placerat eu. Fusce semper neque a mi aliquet vulputate sed sit amet nisi...<\\/p>\\n                                            <p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2866107_full-lnd.jpg\",\"alt\":\"Iceland\\u2019s dentist-coach defying convention and expectations\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Iceland&rsquo;s dentist-coach defying convention and expectations<\\/strong><\\/h3>\\n                                          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit...<\\/p>\\n                                          <p><a href=\\\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2709222_full-lnd.jpg\",\"alt\":\"Impact and legacy of 2018 FIFA World Cup Russia: facts and figures\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Impact and legacy of 2018 FIFA World Cup Russia: facts and figures<\\/strong><\\/h3>\\n                                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod...<\\/p>\\n                                        <p><a href=\\\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2867790_full-lnd.jpg\",\"alt\":\"Lineker\\u2019s life-changing treble\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Lineker&rsquo;s life-changing treble<\\/strong><\\/h3>\\n                                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit&nbsp;<span style=\\\"background-color: inherit;\\\">consequat lorem at est congue...<\\/span><\\/p>\\n                                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\\\">Read More<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-2.png\",\"alt\":\"Sports-Football-Divider-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Footer-1.png\",\"alt\":\"Sports-Football-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#b55311\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Logo-Small.png\",\"alt\":\"Sports-Football-Logo-Small\",\"fullWidth\":false,\"width\":\"772px\",\"height\":\"171px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><br \\/>Add your postal address here!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#da6110\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#da6110\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}}}","https://ps.w.org/mailpoet/assets/newsletter-templates/world_cup/thumbnail.20190411-1500.jpg",NULL,"1",NULL,"2023-03-13 22:26:41"),
("37","0","Festival Event","[\"standard\",\"all\"]","","{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#0a5388\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/festival_event\\/festival-header.jpg\",\"alt\":\"festival-header\",\"fullWidth\":true,\"width\":\"1320px\",\"height\":\"879px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"36px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Pack your glowsticks, <br \\/>Boomfest is back!&nbsp;<\\/h1>\\n                        <p><\\/p>\\n                        <p style=\\\"text-align: center;\\\">Duis tempor nisl in risus hendrerit venenatis. <br \\/>Curabitur ornare venenatis nisl non ullamcorper. <\\/p>\"},{\"type\":\"button\",\"text\":\"Duis id tincidunt\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#0a5388\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"260px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Maecenas scelerisque nisi sit amet metus efficitur dapibus!&nbsp;<br \\/>Ut eros risus, facilisis ac aliquet vel, posuere ut urna.<\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/bavance.com\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"28px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">Confirmed Lineup<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">Main Stage<\\/span><\\/em><\\/h3><p>Quisque libero<br \\/>Nulla convallis<br \\/>Vestibulum Ornare<br \\/>Consectetur Odio<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">New Acts Stage<\\/span><\\/em><\\/h3><p>Nulla interdum<br \\/>Massa nec<br \\/>Pharetra<br \\/>Varius<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">Comedy Stage<\\/span><\\/em><\\/h3><p>In pulvinar<br \\/>Risus sed<br \\/>Condimentum<br \\/>Feugiat<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">New to the festival this year<\\/h2>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"9px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link