<?php defined('ABSPATH') || exit ("no access");  ?>
<div id="main-guard-inner">
    <div class="license-input">
        <h1> <?php printf(esc_html__('%s Activation', 'guard-gn-b32eccb37a1a2c1bd50648928f720a'), esc_html__($this->c17e88c93a19228c9c784216076e11b, 'guard-gn-b32eccb37a1a2c1bd50648928f720a')); ?></h1>
        <?php if ($this->c6badf470102f74654d7482403b248d): ?>
            <h3><?php esc_html_e('Your activation key:', 'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?></h3>
            <code id="code-style"><?php echo $this->e37e570e767b8c2fdd2556433e3da() ?></code>
            <div class="text-left">
                    <span id="recheck-license" onclick="recheck_licence(this)"><?php esc_html_e('Recheck license', 'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?></span>
                    <span id="remove-license" onclick="remove_licence(this)"><?php esc_html_e('Remove / Change key', 'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?></span>
            </div>
            <div id="license-message" style="display: flex; <?php echo ($this->d5863d969619abe64a49e04011443a===true)? 'background:red;':''?>">
                <div class="result" style=""><?php echo $this->ca53aae362133cdd66d70a2a('last_message'); ?></div>
            </div>
            <!-- /#license-message -->
        <?php else: ?>
            <h3><?php esc_html_e('Enter your activation key:', 'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?></h3>
            <input id="license-input" type="text" value="">
            <div class="text-left">
                    <span id="install-license" onclick="install_licence(this)"><?php esc_html_e('Activate',
                            'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?></span>
            </div>
            <div id="license-message">
            </div>
        <?php endif; ?>

        <!-- /#license-message -->
        <?php
        $crons=get_option('cron');
        $last_cron_run=false;
        foreach ($crons as $time => $cron){
            if (!is_array($cron)){
                continue;
            }
            if (isset($cron['zhaket_guard_daily_validator'])) {
                $last_cron_run = $time;
            }
        }
        if (empty($last_cron_run)){
            ?>
            <div id="license-message" style="display: flex; background:red;">
                <div class="result" ><?php esc_html_e('No cron jobs found. Your license can not be activated.', 'guard-gn-b32eccb37a1a2c1bd50648928f720a'); ?></div>
            </div>
            <?php
        }elseif($last_cron_run < time()-90000 || $last_cron_run > time()+90000){
            ?>
            <div id="license-message" style="display: flex; background:red;">
                <div class="result" ><?php printf(__('Number of failed Activation checks is reached (%s). your plugin or theme will be disabled soon. Please check cron job settings on your WordPress or host. <a href="%s">cron manual</a>', 'guard-gn-b32eccb37a1a2c1bd50648928f720a'),human_time_diff( $last_cron_run),'https://codekraken.ir/cron-manual'); ?></div>
            </div>
            <?php
        }
        ?>
        <div id="license-help">
            <strong><?php esc_html_e('Manual:', 'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?></strong>
            <ul>
                <?php if ($this->c6badf470102f74654d7482403b248d): ?>
                    <li>
                        <?php esc_html_e('Your key is used on this website, and it is not possible to use on another website.',
                            'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?>
                    </li>
                    <li>
                        <?php esc_html_e('If you want to transfer a license to another domain, click on the "Remove / Change key", after that login to your account of zhaket.com and go to the download section and click on change domain button. Enter your new domain name and use the license key on your desired domain.',
                            'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?>
                    </li>
                <?php else: ?>
                    <li>
                        <?php esc_html_e('To use the product, you should enter the license key, to find your license key, login to your account of zhaket.com and go to downloads section, after than select product and copy your license key or click on create license button and copy your license key.',
                            'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?>
                    </li>
                    <li>
                        <?php esc_html_e('Each license can be activated only for one website', 'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?>
                    </li>
                    <li>
                        <?php esc_html_e('If your license is activated on another domain, first click on the "Remove / Change key" on the old website, then login to your account of zhaket.com and go to the download section and click on the change domain button, enter your website domain name and use the license key to activate.',
                            'guard-gn-b32eccb37a1a2c1bd50648928f720a') ?>
                    </li>
                <?php endif; ?>
            </ul>
            <?php
            if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) {
                echo '<hr>';
                echo sprintf( esc_html__( 'The %s constant is set to true. WP-Cron spawning is disabled.', 'guard-gn-b32eccb37a1a2c1bd50648928f720a' ), 'DISABLE_WP_CRON' );
            }
            if ( defined( 'ALTERNATE_WP_CRON' ) && ALTERNATE_WP_CRON ) {
                echo '<hr>';
                echo sprintf( esc_html__( 'The %s constant is set to true.', 'guard-gn-b32eccb37a1a2c1bd50648928f720a' ), 'ALTERNATE_WP_CRON'
                );
            }

            ?>
            <hr>
            <span style="display: block;direction: ltr;text-align:left;font-size: 10px">version:1.1.0</span>
        </div>


    </div>
    <!-- /.license-input -->
    <div class="background-status">
        <?php if ($this->c6badf470102f74654d7482403b248d): ?>
            <img src="<?php echo $this->ab57b6b1b7f6fcdb2b10d8be2a ?>assets/unlocked.png" alt="">
        <?php else: ?>
            <img src="<?php echo $this->ab57b6b1b7f6fcdb2b10d8be2a ?>assets/locked.png" alt="">
        <?php endif; ?>
    </div>
    <!-- /.background-status -->
</div>
<!-- /#main-guard-inner -->