<?php
namespace WPSURL\App;
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

class Alert
{
    /**
     * Message
     * @var
     */
    protected $_messages;

    /**
     * Alert types
     */
    const ERROR = 1;
    const SUCCESS = 2;
    const WARNING = 3;
    const INFO = 4;

    /**
     * Save error
     * @var
     */
    public static $has_error;

    use \WPSURL\App\Traits\Singleton;

    /**
     * Add message to session array
     *
     * @param string $message
     * @param int $type
     */
    public static function addMessage($message = "", $type = self::SUCCESS)
    {
        if (!isset($_SESSION['wpsurl']['messages'])) {
            $_SESSION['wpsurl']['messages'] = array();
        }
        if ($type == self::ERROR) {
            self::$has_error = true;
        }
        $_SESSION['wpsurl']['messages'][] = array(
            'body' => $message,
            'type' => $type
        );
    }

    /**
     * Show message
     */
    public static function showMessage()
    {
        if (isset($_SESSION['wpsurl']['messages']) && !empty($_SESSION['wpsurl']['messages'])) {
            foreach ($_SESSION['wpsurl']['messages'] as $message) {
                $alert_class = self::getAlertType($message['type'])
                ?>
                <div class="<?php echo is_admin() ? 'notice is-dismissible' : 'wpsurl-alert'; ?> <?php echo $alert_class; ?>">
                    <p><?php echo $message['body']; ?></p>
                </div>
                <?php
            }
            self::emptyBag();
        }
    }

    /**
     * Get alert type
     *
     * @param $type
     *
     * @return string
     */
    public static function getAlertType($type)
    {
        switch ($type) {
            case self::SUCCESS:
                if (is_admin()) {
                    return 'notice-success';
                } else {
                    return 'wpsurl-alert success';
                }
                break;
            case self::ERROR:
                if (is_admin()) {
                    return 'notice-error';
                } else {
                    return 'wpsurl-alert danger';
                }
                break;
            case self::WARNING;
                if (is_admin()) {
                    return 'notice-warning';
                } else {
                    return 'wpsurl-alert warning';
                }
                break;
            case self::INFO:
                if (is_admin()) {
                    return 'notice-info';
                } else {
                    return 'wpsurl-alert info';
                }
                break;

        }
    }

    /**
     * Make session and $has_error variable empty for next use
     */
    public static function emptyBag()
    {
        $_SESSION['wpsurl']['messages'] = array();

        self::$has_error = false;
    }
}
