<?php
namespace WPSURL\App;

final class Callbacks {
    /**
     * show view page index
     */
    public static function getViewContentHtmlCallback()
    {
        $file = WPSURL_VIEW_PAGES . 'index.content.php';
        if (file_exists($file)) {
            require_once $file;
        }
    }

    /**
     *
     * Fired after link insert/update
     *
     * @param $insert_id
     * @param $params
     * @return void
     */
    public static function afterLinkInsertCallback($insert_id, $params){
        $link_id = !empty($insert_id) ? $insert_id : (isset($params['id']) ? $params['id'] : 0);

        if (!$link_id)
            return false;

        if(isset($params['type']))
            Links::changeType($link_id, $params['type']);
        LinkOptions::updateOption($link_id, 'iframe_preview', ($params['iframe_preview'] ?? false));
        LinkOptions::updateOption($link_id, 'restriction_woo', ($params['restriction_woo'] ?? false));
        if (isset($params['restriction_woo']) && isset($params['woo_products'])){
            LinkOptions::updateOption($link_id, 'woo_products', $params['woo_products']);
        }
        LinkOptions::updateOption($link_id, 'restriction_edd', ($params['restriction_edd'] ?? false));
        if (isset($params['restriction_edd']) && isset($params['edd_products'])){
            LinkOptions::updateOption($link_id, 'edd_products', $params['edd_products']);
        }
        LinkOptions::updateOption($link_id, 'view_restrictions_status', ($params['view_restrictions'] ?? false));
        if (isset($params['view_restrictions'])){
            LinkOptions::updateOption($link_id, 'view_limited_num', ($params['view_limited_num'] ?? 0));
            LinkOptions::updateOption($link_id, 'click_limited_num', ($params['click_limited_num'] ?? 0));
        }
        LinkOptions::updateOption($link_id, 'only_user_logged', ($params['only_user_logged'] ?? false));
        LinkOptions::updateOption($link_id,'views_count', 0);
        LinkOptions::updateOption($link_id,'clicks_count', 0);
    }

    public static function applyStatisticsCallback()
    {
        $token = Utility::getQueryVarsValue();
        if(!empty($token)){
            $link = Links::get($token);
            if ($link)
                Statistics::incrementView($link->link_id);
        }
    }

    public static function loadedLinkDataCallback($link_id)
    {
        if(empty($link_id))
            return;

        $link_data = Links::get($link_id);

        if (!$link_data)
            return;

        # START REGISTER LINK DATA #

        $link_id = $link_data->link_id;
        $pwd = $link_data->password;
        $is_locked = !empty($link_data->password);
        $restrictions_status = LinkOptions::isRestrictByView($link_id);
        $access_products = LinkOptions::isAccessForProducts($link_id);
        $access_products_arr = explode(",", $access_products);
        $access_downloads = LinkOptions::isAccessForEddProducts($link_id);
        $access_downloads_arr = explode(",", $access_downloads);
        $clicks = LinkOptions::getClickLimitNumber($link_id);
        $views = LinkOptions::getViewLimitNumber($link_id);
        $all_clicks = LinkOptions::getClicksCount($link_id);
        $all_views = LinkOptions::getViewsCount($link_id);
        $only_logged_user = LinkOptions::isOnlyLoggedUser($link_id);
        $type = Links::getType($link_id);

        # / END LINK DATA #

        if(get_defined_vars()){
            foreach (get_defined_vars() as $key => $value){
                $GLOBALS['link_data'][$key] = $value;
            }
        }
    }
}