<?php
namespace WPSURL\App;
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

use Curl\Client;
use CurlDownloader\CurlDownloader;

class Downloader
{
    private $url;
    private $browser;
    private $downloader;

    use \WPSURL\App\Traits\Singleton;

    public function __construct($url)
    {
        $this->url = $url;
        $this->browser = new Client();
        $this->downloader = new CurlDownloader($this->browser);
    }

    public function downloadFileFromUrl()
    {
        if(empty($this->url))
            return false;

        $response = $this->downloader->download($this->url, function ($filename) {
            $fname = date('Y-m-d');
            return './' . $fname . '-' . $filename;
        });
        
        if(is_object($response)){
            if (isset($response->status) && $response->status == 200) {
                return wp_send_json_success();
            } elseif(isset($response->error) && !empty($response->error)){
                return wp_send_json_error(['message' => $response->error]);
            }
        }
    }
}

