<?php
namespace WPSURL\App;

use WPSURL\App\Traits\Singleton;

class Hooks {
    
    use Singleton;

    public function __construct(){
        add_action( 'wpsurl_view_html_content', ['\WPSURL\App\Callbacks', 'getViewContentHtmlCallback'] );
        add_action( 'wpsurl_action_insert_report', ['\WPSURL\App\Callbacks', 'applyStatisticsCallback'] );
        add_action( 'wpsurl_loaded_link_data', ['\WPSURL\App\Callbacks', 'loadedLinkDataCallback'], 10, 1);
        add_shortcode( 'wpsurl', ['\WPSURL\App\Shortcode', 'buttonShortcodeCallback'] );

        add_action('admin_menu', ['\WPSURL\App\Admin\Menu','registerMenuItems']);
        add_action('init', ['\WPSURL\App\Admin\Menu','registerMenuNavigation']);
        add_action('wpsurl_save_settings', ['\WPSURL\App\Settings', 'saveSettingsCallback']);
        add_action('wpsurl_action_admin_backup', ['\WPSURL\App\Settings', 'importLinksWithCsvCallback']);
        add_action('wpsurl_export_links_action', ['\WPSURL\App\Settings', 'exportLinksCallback']);
        add_action('wpsurl_bulk_actions', ['\WPSURL\App\Settings', 'linkBulkActionsCallback']);
        add_action('wpsurl_after_insert_link_action', ['\WPSURL\App\Callbacks', 'afterLinkInsertCallback'], 10, 2);
        add_action('wpsurl_after_edit_link_action', ['\WPSURL\App\Callbacks', 'afterLinkInsertCallback'], 10, 2);

        /**
         * 
         * 
         * Ajax Hooks
         * 
         */
        add_action( 'wp_ajax_wpsurl_action_view_redirect_button', ['\WPSURL\App\Ajax', 'viewRedirectButton'] );
        add_action( 'wp_ajax_nopriv_wpsurl_action_view_redirect_button', ['\WPSURL\App\Ajax', 'viewRedirectButton' ]);
        add_action( 'wp_ajax_wpsurl_action_open_link_by_pwd', ['\WPSURL\App\Ajax', 'openLinkByPassword'] );
        add_action( 'wp_ajax_nopriv_wpsurl_action_open_link_by_pwd', ['\WPSURL\App\Ajax', 'openLinkByPassword'] );
        add_action( 'wp_ajax_wpsurl_action_report_link_problem', ['\WPSURL\App\Ajax', 'reportLinkProblem'] );
        add_action( 'wp_ajax_nopriv_wpsurl_action_report_link_problem', ['\WPSURL\App\Ajax', 'reportLinkProblem'] );
        
        /**
         * 
         *
         * Admin Ajax
         * 
         * 
         */
        add_action('wp_ajax_wpsurl_action_change_link_status', ['\WPSURL\App\Admin\Ajax', 'changeLinkStatus']);
        add_action('wp_ajax_wpsurl_action_active_link_lock', ['\WPSURL\App\Admin\Ajax', 'activeLinkLock']);
        add_action('wp_ajax_wpsurl_action_delete_link', ['\WPSURL\App\Admin\Ajax', 'deleteLink']);
        add_action('wp_ajax_wpsurl_action_insert_link', ['\WPSURL\App\Admin\Ajax', 'insertLink']);
        add_action('wp_ajax_wpsurl_action_edit_link', ['\WPSURL\App\Admin\Ajax', 'editLink']);
        add_action('wp_ajax_wpsurl_action_rewrite_exists', ['\WPSURL\App\Admin\Ajax', 'checkIsExistsSlug']);
        add_action('wp_ajax_wpsurl_action_edit_html', ['\WPSURL\App\Admin\Ajax', 'linkEditorHtmlTemplate']);
        add_action('wp_ajax_wpsurl_action_clear_link_data', ['\WPSURL\App\Admin\Ajax', 'clearLinkData']);
        add_action('wp_ajax_wpsurl_action_empty_table', ['\WPSURL\App\Admin\Ajax', 'truncateTable']);
        add_action('wp_ajax_wpsurl_report_item_action', ['\WPSURL\App\Admin\Ajax', 'reportItemAction']);

        /**
         * 
         * Rewrite Hooks
         * 
         */
        add_action('init', ['\WPSURL\App\Rewrite', 'registerRewrite']);
        add_filter('query_vars', ['\WPSURL\App\Rewrite', 'rewriteQueryVars']);
        add_action('parse_request', ['\WPSURL\App\Rewrite', 'handleRewriteQueryVarsRequest']);

        /**
         *
         * Elementor Hooks
         *
         */
        /*if(Options::isActiveElementor()){
            add_action('admin_notices', ['\WPSURL\App\Elementor\Widgets', 'checkRequirementsMinimumVersion']);
            add_action('elementor/elements/categories_registered', ['\WPSURL\App\Elementor\Widgets', 'registerWidgetsCategory']);
            add_action('elementor/widgets/register', ['\WPSURL\App\Elementor\Widgets', 'widgetsRegistered']);
            add_action( 'elementor/editor/after_enqueue_styles', ['\WPSURL\App\Elementor\Widgets', 'enqueueEditorStyles']);
            add_action( 'elementor/preview/enqueue_styles', ['\WPSURL\App\Elementor\Widgets', 'enqueueEditorStyles']);
            add_action( 'elementor/fonts/groups', ['\WPSURL\App\Elementor\Widgets', 'registerFontsGroup']);
            add_action( 'elementor/fonts/additional_fonts', ['\WPSURL\App\Elementor\Widgets', 'registerAdditionalFonts']);
        }*/
    }
}