<?php
namespace WPSURL\App;

class Links {
    use \WPSURL\App\Traits\Singleton;

    use \WPSURL\App\Traits\Database\Connection;

    public static function getResults($params){
        return self::getDb()->links()->getResults($params);
    }

    public static function insert($params){
        return self::getDb()->links()->insert($params);
    }

    public static function get($id_or_key){
        $item = self::getByID($id_or_key);
        if(!$item){
            $item = self::getByKey($id_or_key);
        }
        return $item ? $item : false;
    }

    public static function update($link_id, $fields){
        return self::getDb()->links()->update($fields, ['link_id' => $link_id]);
    }

    public static function updateItem($link_id, $item, $value){
        return self::update($link_id, [$item => $value]);
    }

    public static function delete($link_id){
        return self::getDb()->links()->delete(['link_id' => $link_id]);
    }

    public static function changeStatus($link_id, $status){
        return self::updateItem($link_id, 'status' ,$status);
    }

    public static function changeType($link_id, $type){
        return self::updateItem($link_id, 'type', $type);
    }

    public static function getStatus($id)
    {
        return self::getItem($id, 'status');
    }

    public static function getType($id)
    {
        return self::getItem($id, 'type');
    }

    public static function getByID($id, $status = '')
    {
        $params = ['link_id' => $id];
        if(!empty($status)){
            $params['status'] = $status;
        }
        return self::getDb()->links()->get($params);
    }

    public static function getByKey($key, $status = 'active')
    {
        $params = ['link_key' => $key];
        if(!empty($status)){
            $params['status'] = $status;
        }
        return self::getDb()->links()->get($params);
    }

    public static function getItem($id, $item = null)
    {
        $data = self::get($id);
        return $item && is_object($data) && isset($data->{$item}) ? $data->{$item} : false;
    }

    public static function count(){
        return self::getDb()->links()->count();
    }

    public static function getPreviewsItems(){
        global $wpdb;
        $links_table = Database::$table_links;
        $links_options_table = Database::$table_options;

        $sql = "SELECT * FROM {$links_table} JOIN {$links_options_table} ON {$links_table}.link_id = {$links_options_table}.link_id WHERE {$links_table}.status = 'active' AND {$links_options_table}.link_option = 'iframe_preview' AND {$links_options_table}.link_option_value = 'true'";
        $stmt = $wpdb->get_results($sql);
        return $stmt;
    }
}