<?php
namespace WPSURL\App;

class Mailer {
    private $content;
    private $title;
    private $to;

    /**
     * Generate html email template
     *
     * @param $title
     * @param $content
     *
     * @return string
     */
    public function setEmailTemplate($title, $content)
    {
        $this->title = $title;
        $site_title = get_bloginfo('name');
        $site_url = get_site_url();
        $html = "<h1>{$this->title}</h1><br>";
        $html .= '<div class="wpsurl-mail-content">' . $content . '</div>';
        $html .= '<footer class="wpsurl-mail-footer"><a href="' . $site_url . '">' . $site_title . '</a></footer>';

        $this->content = $html;
        return $this;
    }

    public function setTo($email){
        $this->to = $email;
        return $this;
    }

    public function setToAdmin(){
        $this->to = get_bloginfo( 'admin_email' );
        return $this;
    }

    public function send(){
        $headers       = array( 'Content-Type: text/html; charset=UTF-8' );
        $send_email    = wp_mail( $this->to, $this->title, $this->content, $headers );
        return $send_email;
    }
}