<?php
namespace WPSURL\App;

class Rewrite {

    use \WPSURL\App\Traits\Singleton;

    protected static function getSlug(){
        return \WPSURL\App\Utility::getPagesSlug();
    }

    protected static function getShortSlug(){
        return \WPSURL\App\Utility::getPagesSlug(2);
    }

    public static function registerRewrite()
    {
        add_rewrite_rule(static::getShortSlug() . '-download/?([a-zA-Z0-9].*)?', 'index.php?' . static::getShortSlug() . '-download=$matches[1]', 'top');
        add_rewrite_rule(static::getSlug() . '/?([a-zA-Z0-9].*)?', 'index.php?' . static::getSlug() . '=$matches[1]', 'top');
        add_rewrite_rule(static::getShortSlug() . '/?([0-9].*)?', 'index.php?' . static::getShortSlug() . '=$matches[1]', 'top');
        flush_rewrite_rules();
    }

    public static function rewriteQueryVars($vars)
    {
        $vars[] = static::getSlug();
        $vars[] = static::getShortSlug();
        $vars[] = static::getShortSlug() . '-download';

        return $vars;
    }

    public static function handleRewriteQueryVarsRequest($query)
    {
        if (isset($query->query_vars[static::getShortSlug() . '-download'])) {
            include_once(WPSURL_VIEW_PAGES . 'download.php');
            exit();
        }
        if (isset($query->query_vars[static::getSlug()]) || isset($query->query_vars[static::getShortSlug()])) {
            include_once(WPSURL_VIEW_PAGES . 'redirect.php');
            exit();
        }
    }
}