<?php
namespace WPSURL\App;

use WPSURL\App\Options;

class Settings {
    private static $option_name_prefix = 'wpsurl_';

    /**
     * Save general settings callback
     */
    public static function saveSettingsCallback()
    {
        if (isset($_POST['wpsurl-save-setting-options'])) {
            if (!isset($_POST['settings_nonce']) || !wp_verify_nonce($_POST['settings_nonce'], 'save_settings')) {
                exit('Sorry, your nonce did not verify!');
            } else {
                $options = [
                    'use_elementor' => ['type' => 'checkbox'],
                    'elementor_page' => [],
                    'view_page_logo_url' => [],
                    'view_redirect_page_status' => ['type' => 'checkbox'],
                    'view_only_logged_users' => ['type' => 'checkbox'],
                    'links_title_status' => ['type' => 'checkbox'],
                    'view_timer_status' => ['type' => 'checkbox'],
                    'transfer_end_timer_status' => ['type' => 'checkbox'],
                    'view_add_html_code' => [],
                    'redirect_page_slug' => [],
                    'redirect_page_short_slug' => [],
					'alert_status' => [],
                    'view_timer_second_value' => [],
                    'view_alert_text' => [],
                    'view_alert_type' => [],
                    'show_other_previews' => ['type' => 'checkbox'],
                ];

                if($options){
                    foreach ($options as $key => $value){
                        if(isset($_POST[$key])){
                            $is_slug = strpos($key, 'slug') !== false;
                            $option = $_POST[$key];
                            if($is_slug){
                                if (!empty($option)) {
                                    self::updateOption($key, \WPSURL\App\Utility::slugRegexMatch($option));
                                    flush_rewrite_rules();
                                }
                            } else {
                                self::updateOption($key, $option);
                            }
                        } else {
							self::deleteOption($key);
						}
                    }
                }

                \WPSURL\App\Alert::addMessage(__('Settings saved successfully.', WPSURL_TEXT_DOMAIN));
            }
        }
    }

    /**
     * import links action callback
     */
    public static function importLinksWithCsvCallback()
    {
        global $alert;
        if (isset($_POST['wpsurl_import_nonce']) && !wp_verify_nonce($_POST['wpsurl_import_nonce'], 'wpsurl_import_nonce_action')) {
            return;
        }
        if (isset($_GET['page']) && $_GET['page'] == 'wp-safe-url') {
            if (isset($_POST['wpsurl-import-submit'])) {
                $file = (!empty($_FILES['wpsurl_import_links_file']['name'])) ? $_FILES['wpsurl_import_links_file'] : null;
                $file_name = $file['name'];
                if (!empty($file_name)) {
                    if (strtolower(pathinfo($file_name, PATHINFO_EXTENSION)) == 'csv') {
                        $import = wpsurl_import_links_by_csv($file);
                        if ($import !== false) {
                            $alert->addMessage(__('Import successfully.', WPSURL_TEXT_DOMAIN));
                        } else {
                            $alert->addMessage(__('An error occurred, please try again', WPSURL_TEXT_DOMAIN), 1);
                        }
                    } else {
                        $alert->addMessage(__('File format invalid', WPSURL_TEXT_DOMAIN), 1);
                    }
                }
            }
        }
    }

    /**
     *  Links export action callback
     */
    public static function exportLinksCallback()
    {
        global $loops;
        if (isset($_POST['wpsurl_export_nonce']) && !wp_verify_nonce($_POST['wpsurl_export_nonce'], 'wpsurl_export_nonce_action')) {
            return;
        }
        if (isset($_GET['page']) && $_GET['page'] == 'wp-safe-url') {
            if (isset($_POST['wpsurl-export-submit'])) {
                extract($_POST);
                date_default_timezone_set('Asia/Tehran');
                $file_name = 'wp-safe-url-' . date('Y/d/m H:i:s') . '-export';
                $file_name = \WPSURL\App\Utility::cleanSpecialChar($file_name, '-');
                $file_type = 'csv';
                $file = $file_name . '.' . $file_type;
                $options = isset($wpsurl_links_export_options) ? $wpsurl_links_export_options : array();
                header("Pragma: public");
                header("Expires: 0");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Cache-Control: private", false);
                header('Content-Encoding: UTF-8');
                header('Content-Type: text/csv; charset=UTF-8');
                header("Content-Disposition: attachment; filename={$file};");
                ob_end_clean();
                echo "\xEF\xBB\xBF";
                $output = fopen('php://output', 'w');
                /*$columns = array(
                    'title',
                    'link',
                    'type',
                    'products_id',
                    'limit_views',
                    'limit_clicks',
                    'only_users'
                );
                fputcsv( $output, $columns );*/
                $links = $loops->links();
                if ($links) {
                    foreach ($links as $link) {
                        $modified_values = array(
                            $link->title,
                            $link->link,
                            $link->type,
                            3 => '',
                            4 => ''
                        );
                        if (in_array(1, $options)) {
                            $lv = wpsurl_get_link_option('view_limited_num', $link->link_id, $link->link_key);
                            $modified_values[3] = ($lv) ? $lv : 10;
                        }
                        if (in_array(2, $options)) {
                            $lc = wpsurl_get_link_option('click_limited_num', $link->link_id, $link->link_key);
                            $modified_values[4] = ($lc) ? $lc : '';
                        }
                        fputcsv($output, $modified_values);
                    }
                    fclose($output);
                    exit();
                }
            }
        }
    }

    /**
     *
     * Links bulk actions
     *
     */
    public static function linkBulkActionsCallback()
    {
        global $loops, $alert;
        if (isset($_GET['page']) && $_GET['page'] == 'wpsurl-links') {
            if (isset($_GET['wpsurl_search']) && $_GET['action']) {
                $get_links_check = (isset($_GET['link_check']) && !empty($_GET['link_check'])) ? $_GET['link_check'] : null;
                if ($get_links_check && is_array($get_links_check)) {
                    if ($_GET['action'] == 1) {
                        if (wpsurl_change_links_status($get_links_check, 'active')) {
                            $alert->addMessage(__('Links have been successfully changes status', WPSURL_TEXT_DOMAIN));
                            $alert->showMessage();
                        }
                    } elseif ($_GET['action'] == 2) {
                        if (wpsurl_change_links_status($get_links_check, 'inactive')) {
                            $alert->addMessage(__('Links have been successfully changes status', WPSURL_TEXT_DOMAIN));
                            $alert->showMessage();
                        }
                    } elseif ($_GET['action'] == 3) {
                        if (wpsurl_delete_link($get_links_check)) {
                            $alert->addMessage(__('Links have been successfully deleted', WPSURL_TEXT_DOMAIN));
                            $alert->showMessage();
                        }
                    }
                }
            }
        }
    }

    public static function getOption($key){
        return Options::getOption(self::$option_name_prefix . $key);
    }

    public static function updateOption($key, $value){
        return Options::updateOption(self::$option_name_prefix . $key, $value);
    }

    public static function deleteOption($key){
        return Options::deleteOption(self::$option_name_prefix . $key);
    }

    public static function getTabs(){
        $tabs = [
            'global' => [
              'icon' => 'wpsurl-icon-cog',
              'title' => __( 'Settings', WPSURL_TEXT_DOMAIN ),
              'description' => __('Element control and configuration', WPSURL_TEXT_DOMAIN),
            ],
            'alert' => [
              'icon' => 'wpsurl-icon-comment',
              'title' => __( 'Alert', WPSURL_TEXT_DOMAIN ),
              'description' => __('Notification bar', WPSURL_TEXT_DOMAIN)
            ],
            'backup' => [
                'icon' => 'wpsurl-icon-comment',
                'title' => __( 'Backup', WPSURL_TEXT_DOMAIN ),
                'description' => __('Import and Export data', WPSURL_TEXT_DOMAIN),
                'show' => false
            ],
        ];

        $tabs = apply_filters('wpsurl_get_setting_tabs', $tabs);

        return $tabs;
    }

    public static function getLogoUrl(){
        $logo_option = Settings::getOption( 'view_page_logo_url' );
        if ( empty( $logo_option ) ) {
            $logo_url = WPSURL_IMG_URL . 'default-logo.png';
        } else {
            $logo_url = $logo_option;
        }
        return $logo_url;
    }
}