<?php
namespace WPSURL\App;

class Woocommerce {
    /**
     *
     * check user is woocommerce customer
     *
     * @return bool
     */
    public static function isUserCustomer()
    {
        if (is_user_logged_in()) {
            if (\WPSURL\App\Options::isActiveWoo()) {
                global $wpdb;
                $table = $wpdb->prefix . 'posts';
                $id = get_current_user_id();
                $result = $wpdb->get_var("SELECT COUNT(*) FROM $table WHERE post_type='shop_order' AND post_author=$id AND post_status='wc-completed'");
                if ($result > 0) {
                    return true;
                }
            } else {
                return true;
            }
        }

        return false;
    }

    public static function hasBoughtItems($products_id = array(), $user_id = 0)
    {
        $bought = false;
        // Get all customer orders
        $customer_orders = get_posts(array(
            'numberposts' => -1,
            'meta_key' => '_customer_user',
            'meta_value' => $user_id,
            'post_type' => 'shop_order', // WC orders post type
            'post_status' => 'wc-completed' // Only orders with status "completed"
        ));
        foreach ($customer_orders as $customer_order) {
            // Updated compatibility with WooCommerce 3+
            $order_id = method_exists($order, 'get_id') ? $order->get_id() : $order->id;
            $order = wc_get_order($customer_order);
            // Iterating through each current customer products bought in the order
            foreach ($order->get_items() as $item) {
                // WC 3+ compatibility
                if (version_compare(WC_VERSION, '3.0', '<')) {
                    $product_id = $item['product_id'];
                } else {
                    $product_id = $item->get_product_id();
                }
                // Your condition related to your 2 specific products Ids
                if (in_array($product_id, $products_id)) {
                    $bought = true;
                }
            }
        }

        // return "true" if one the specifics products have been bought before by customer
        return $bought;
    }

    public static function isUserCustomerProducts($products_id = array(), $user_id = 0)
    {
        if (is_array($products_id)) {
            if (\WPSURL\App\Options::isActiveWoo()) {
                if (is_user_logged_in()) {
                    if (!$user_id) {
                        $user_id = get_current_user_id();
                    }
                    if (\WPSURL\App\Woocommerce::hasBoughtItems($products_id, $user_id)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }

        return false;
    }
}