<?php
namespace WPSURL\App\Admin;

use WPSURL\App\Links;
use WPSURL\App\Options;
use WPSURL\App\LinkOptions;
use WPSURL\App\Reports;
use WPSURL\App\Statistics;
use WPSURL\App\Utility;

class Ajax {
    /**
     * Ajax action change link status
     */
    public static function changeLinkStatus()
    {
        $id = $_POST['link_id'];

        if (Links::getByID($id)) {
            $link_status = Links::getStatus($id);
            $status = $link_status == 'active' ? 'inactive' : 'active';

            $change = Links::changeStatus($id, $status);

            if ($change) {
                $result = array(
                    'msg' => __('Link status changed successfully', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                    'status' => Links::getStatus($id)
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                    'status' => $link_status
                );
            }
        } else {
            $result = array(
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
                'status' => false
            );
        }
        wp_send_json($result);
    }

    /**
     * Ajax action link lock
     */
    public static function activeLinkLock()
    {
        $id = $_POST['link_id'];
        $password = $_POST['password'];
        $unlocked = isset($_POST['unlock']) && $_POST['unlock'] == true;
        if (Links::getByID($id)) {
            if ($unlocked && empty($password)) {
                $lock = Links::updateItem($id, 'password', null);
                $msg = __('Link lock inactivated', WPSURL_TEXT_DOMAIN);
            } else {
                $lock = Links::updateItem($id, 'password', md5($password));
                $msg = __('Link successfully locked', WPSURL_TEXT_DOMAIN);
            }
            if ($lock) {
                $result = array(
                    'msg' => $msg,
                    'type' => 'success',
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                );
            }
        } else {
            $result = array(
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
            );
        }
        if(!empty($password)){
            $result['lock'] = Links::getItem($id, 'password');
        }
        wp_send_json($result);
    }

    /**
     * Ajax action delete link
     */
    public static function deleteLink()
    {
        $id = $_POST['link_id'];
        $count = Links::count();
        if (Links::getByID($id)) {
            $delete = Links::delete($id);
            if ($delete) {
                $result = array(
                    'msg' => __('Successfully deleted', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                    'links_count' => $count
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                    'links_count' => $count
                );
            }
        } else {
            $result = array(
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
                'links_count' => $count
            );
        }
        wp_send_json($result);
    }

    /**
     * Ajax action insert new link
     */
    public static function insertLink()
    {
        global $loops;
        $title = $_POST['title'];
        $link = $_POST['link'];
        $type = $_POST['type'];
        $password = $_POST['password'];
        if (!empty($title) && !empty($link)) {
            $params = [
                'title' => $title,
                'link' => $link,
                'type' => $type,
                'link_id' => Utility::generateUniqueLinkID(),
                'link_key' => md5($link)
            ];
            if (!empty($password) || $password != '' || $password != null) {
                $params['password'] = $password;
            }
            $insert_id = Links::insert($params);
            if ($insert_id) {
                do_action('wpsurl_after_insert_link_action', $insert_id, array_merge($_POST, $params));
                $result = array(
                    'msg' => __('Link created successfully', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                    'links_count' => Links::count(),
                    'safe' => Utility::getHashLink($link),
                    'short' => Utility::getShortHashLink($insert_id)
                );
            } else {
                $result = array(
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN),
                    'type' => 'error',
                    'links_count' => Links::count()
                );
            }
        } else {
            $result = array(
                'msg' => __('Invalid values entered', WPSURL_TEXT_DOMAIN),
                'type' => 'error',
                'links_count' => Links::count()
            );
        }
        wp_send_json($result);
    }

    /**
     * Ajax action edit link
     */
    public static function editLink()
    {
        ob_clean();
        $data = $_POST;
        $title = $data['title'];
        $link = $data['link'];
        $type = $data['type'];
        $id = $data['id'];
        if (!empty($title) || !empty($link) || !empty($type) && !empty($id)) {
            if (Links::getByID($id)) {
                $update = Links::update($id, [
                    'title' => $title,
                    'link' => $link,
                    'type' => $type
                ]);
                do_action('wpsurl_after_edit_link_action', $id, $data);
                $result = array(
                    'msg' => __('Updated successfully', WPSURL_TEXT_DOMAIN),
                    'type' => 'success',
                );
            } else {
                $result = array(
                    'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN),
                    'type' => 'error'
                );
            }
        } else {
            $result = array(
                'msg' => __('Invalid values entered', WPSURL_TEXT_DOMAIN),
                'type' => 'error'
            );
        }
        wp_send_json($result);
    }

    /**
     *
     * Get edit modal html element by ajax
     *
     */
    public static function linkEditorHtmlTemplate()
    {
        $show = false;
        $link_id = $_POST['link_id'];
        $link_data = Links::getByID($link_id);
        if ($link_data) {
            $link_title = $link_data->title;
            $link = $link_data->link;
            $link_type = $link_data->type;
            $only_logged = LinkOptions::isOnlyLoggedUser($link_id);
            $is_preview = LinkOptions::isIframePreview($link_id);
            $restrictions_status = LinkOptions::isRestrictByView($link_id);
            $restriction_woo = Options::isActiveWoo() && LinkOptions::isRestrictByWoo($link_id);
            $restriction_edd = Options::isActiveEdd() && LinkOptions::isRestrictByEdd($link_id);
            include_once(WPSURL_VIEW_ADMIN_PATH . 'edit-link.php');
        }
        wp_die();
    }

    /**
     * Ajax action settings check is exists url slug(s)
     */
    public static function checkIsExistsSlug()
    {
        $rewrite = $_POST['rewrite'];
        if (!empty($rewrite)) {
            if (\WPSURL\App\Utility::isExistsRewrite($rewrite . '/?([a-zA-Z0-9].*)?') || \WPSURL\App\Utility::isExistsRewrite($rewrite . '/?([0-9].*)?')) {
                $result = array('type' => 'error');
            } else {
                $result = array('type' => 'success');
            }
        } else {
            $result = array('type' => 'error');
        }
        wp_send_json($result);
    }

    public static function clearLinkData()
    {
        extract($_POST);
        if (Links::getByID($link_id)) {
            if ($clear_type == 'views') {
                LinkOptions::updateOption($link_id, 'views_count', 0);
                $clear_data = Statistics::update($link_id, ['visit' => 0]);
                if ($clear_data) {
                    $result = array(
                        'type' => 'success',
                        'msg' => __('Number of visits was successfully cleared', WPSURL_TEXT_DOMAIN),
                        'count' => Statistics::getViews($link_id)
                    );
                    Statistics::truncate( $link_id );
                } else {
                    $result = array(
                        'type' => 'error',
                        'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                    );
                }
            } elseif ($clear_type == 'clicks') {
                LinkOptions::updateOption($link_id, 'clicks_count', 0);
                $clear_data = Statistics::update($link_id, ['click' => 0]);
                if ($clear_data) {
                    $result = array(
                        'type' => 'success',
                        'msg' => __('Number of clicks was successfully cleared', WPSURL_TEXT_DOMAIN),
                        'count' => Statistics::getClicks($link_id)
                    );
                    Statistics::truncate( $link_id );
                } else {
                    $result = array(
                        'type' => 'error',
                        'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                    );
                }
            }
        } else {
            $result = array(
                'status' => 'error',
                'msg' => __('Link Not Found', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }

    public static function truncateTable()
    {
        global $wpdb;
        $table = $_POST['table'];
        if(!empty($table)){
            $table_name = $wpdb->prefix . WPSURL_PREFIX . 'links_' . $table;
            $query = $wpdb->query("DELETE FROM {$table_name}");
            if ($query) {
                $result = array(
                    'type' => 'success',
                    'msg' => __('Empty was successfully', WPSURL_TEXT_DOMAIN)
                );
            } else {
                $result = array(
                    'type' => 'error',
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                );
            }
        } else {
            $result = array(
                'type' => 'error',
                'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }

    public static function reportItemAction()
    {
        extract($_POST);
        if($item_action === 'reviewed'){
            if (Reports::update($id, ['status' => 2])){
                $result = array(
                    'type' => 'success',
                    'msg' => __('The request was successful.', WPSURL_TEXT_DOMAIN)
                );
            } else {
                $result = array(
                    'type' => 'error',
                    'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
                );
            }
        } else {
            $result = array(
                'type' => 'error',
                'msg' => __('An error occurred, please try again', WPSURL_TEXT_DOMAIN)
            );
        }
        wp_send_json($result);
    }
}