<?php
namespace WPSURL\App\Admin;
use WPSURL\App\Traits\Singleton;

class Menu {

    use Singleton;

    public static function registerMenuItems(){
        add_menu_page(
            __('Links', WPSURL_TEXT_DOMAIN),
            __('Safe Url', WPSURL_TEXT_DOMAIN),
            'manage_options',
            'wp-safe-url',
            [__CLASS__, 'handleMenuItemsContent'],
            WPSURL_IMG_URL . 'logo.png',
            40
        );
        add_submenu_page(
            'wp-safe-url',
            __('Statistics', WPSURL_TEXT_DOMAIN),
            __('Statistics', WPSURL_TEXT_DOMAIN),
            'manage_options',
            'wpsurl-statistics',
            [__CLASS__, 'handleMenuItemsContent']
        );
        add_submenu_page(
            'wp-safe-url',
            __('Reports', WPSURL_TEXT_DOMAIN),
            __('Reports', WPSURL_TEXT_DOMAIN),
            'manage_options',
            'wpsurl-reports',
            [__CLASS__, 'handleMenuItemsContent']
        );
        add_submenu_page(
            'wp-safe-url',
            __('Configuration', WPSURL_TEXT_DOMAIN),
            __('Configuration', WPSURL_TEXT_DOMAIN),
            'manage_options',
            'wpsurl-settings',
            [__CLASS__, 'handleMenuItemsContent']
        );
    }

    public static function handleMenuItemsContent(){
        $page = $_GET['page'];
        $page = str_replace('wpsurl-', '', $page);
        $path = WPSURL_ADMIN_PATH . "pages/";
        $file_path = $path . "settings/{$page}.php";
        if(!file_exists($file_path)){
            $file_path = $path . "{$page}.php";
        }
        if(file_exists($file_path)){
            include_once $file_path;
        } else{
            include_once $path . "/links.php";
        }
    }

    public static function registerMenuNavigation(){
        register_nav_menus(array(
            'wpsurl_view_menu' => __('WP Safe Url Primary Menu', WPSURL_TEXT_DOMAIN),
        ));
    }
}