<?php
namespace WPSURL\App\Elementor\Widgets;

use Elementor\Controls_Manager;
use WPSURL\App\Assets;
use WPSURL\App\Utility;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class PageTitle extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'wpsurl_page_title';
    }

    public function get_title()
    {
        return esc_html__('Page Title', WPSURL_TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['wpsurl_elements'];
    }

    public function get_keywords()
    {
        return ['page_title', 'pagetitle', esc_html__('Page Title' , WPSURL_TEXT_DOMAIN)];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_styles',
            [
                'label' => esc_html__('Content', WPSURL_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', WPSURL_TEXT_DOMAIN),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_text_alignment',
            [
                'label' => esc_html__('Alignment', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('Text color', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element a' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_content_typo',
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18'
                        ]
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'label' => esc_html__('Background', WPSURL_TEXT_DOMAIN),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('Padding', WPSURL_TEXT_DOMAIN),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .wpsurl-page-title-element' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => esc_html__('Border', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_wrap_shadow',
                'label' => esc_html__('Box Shadow', WPSURL_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .wpsurl-page-title-element',
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $title = Utility::getCurrentViewPageTitle();
        ?>
        <div class="wpsurl-page-title-element wpsurl-page-title-element-<?php echo $wid; ?>">
            <h1>
                <a href="<?php echo Utility::getCurrentViewPageUrl() ?>">
                    <?php echo $title ? $title : esc_html('Page Title', WPSURL_TEXT_DOMAIN); ?>
                </a>
            </h1>
        </div>
    <?php
    }
}