<?php
namespace WPSURL\App\User;
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

class UserData
{
    /**
     *
     * Get user data by id
     *
     * @param int $user_id
     * @return false|WP_User
     */
    public static function getData($user_id = 0)
    {
        if (!intval($user_id))
            $user_id = self::getCurrentUserID();

        return get_userdata($user_id);
    }

    /**
     *
     * Get current user id
     *
     * @return int
     */
    public static function getCurrentUserID()
    {
        return get_current_user_id();
    }

    /**
     *
     * Get user meta data
     *
     * @param $key
     * @param int $user_id
     * @return mixed
     */
    public static function getMeta($key, $user_id = 0)
    {
        if (!intval($user_id))
            $user_id = self::getCurrentUserID();

        return get_user_meta($user_id, $key, true);
    }

    /**
     *
     * Get user avatar (gravatar)
     *
     * @param int $user_id
     * @return false|mixed|string
     */
    public static function getAvatarUrl($user_id = 0)
    {
        if (!intval($user_id))
            $user_id = self::getCurrentUserID();

        return get_avatar_url($user_id);
    }

    /**
     *
     * Get user display name
     *
     * @param int $user_id
     * @return mixed
     */
    public static function getDisplayName($user_id = 0)
    {
        if (!intval($user_id))
            $user_id = self::getCurrentUserID();

        $data = static::getData($user_id);
        return !empty($data->display_name) ? $data->display_name : $data->nikname;
    }

    /**
     * Get user mobile number
     *
     * @return string
     */
    public static function getMobile($user_id = 0){
        if (!intval($user_id))
            $user_id = self::getCurrentUserID();

        $mobile = self::getMeta('digits_phone_no', $user_id);

        if(intval($mobile)){
            return $mobile;
        }

        return false;
    }
}