<?php
/**
 * If uninstall.php is not called by WordPress, die
 */
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}
/**
 * Delete plugin data from database on plugin uninstall
 */
if (is_multisite()) {
    delete_site_option('wpsurl_redirect_page_slug');
    delete_site_option('wpsurl_redirect_page_short_slug');
    delete_site_option('wpsurl_view_redirect_page_status');
    delete_site_option('wpsurl_view_only_logged_users');
    delete_site_option('wpsurl_links_title_status');
    delete_site_option('wpsurl_view_timer_status');
    delete_site_option('wpsurl_view_timer_second_value');
    delete_site_option('wpsurl_view_add_html_code');
    delete_site_option('wpsurl_view_alert_text');
    delete_site_option('wpsurl_view_alert_type');
} else {
    delete_option('wpsurl_redirect_page_slug');
    delete_option('wpsurl_redirect_page_short_slug');
    delete_option('wpsurl_view_redirect_page_status');
    delete_option('wpsurl_view_only_logged_users');
    delete_option('wpsurl_links_title_status');
    delete_option('wpsurl_view_timer_status');
    delete_option('wpsurl_view_timer_second_value');
    delete_option('wpsurl_view_add_html_code');
    delete_option('wpsurl_view_alert_text');
    delete_option('wpsurl_view_alert_type');
}
/*
 *  Delete database tables
 */
global $wpdb;
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}wpsurl_links");
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}wpsurl_links_statistics");
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}wpsurl_links_reports");
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}wpsurl_links_options");
