<?php
$is_active_woo = \WPSURL\App\Options::isActiveWoo();
$is_active_edd = \WPSURL\App\Options::isActiveEdd();
?>
<form action="<?php add_query_arg(['']) ?>" method="post" data-wpsurl-link-id="<?php echo $link_id ?>" id="wpsurl-link-edit-form" novalidate>
    <div class="form-fields-group">
        <div class="form-field-group">
            <label><?php _e('Title', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="text" id="link-title-<?php echo $link_id ?>" value="<?php echo $link_title ?>" name="title" required>
            </div>
        </div>
        <div class="form-field-group">
            <label><?php _e('Link', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="text" dir="ltr" id="link-<?php echo $link_id ?>" value="<?php echo $link ?>" name="link" required>
            </div>
        </div>
        <div class="form-field-group w-100">
            <label><?php _e('Type', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <select id="link-type-<?php echo $link_id ?>" class="select-affected-toggle-elements" name="type" data-option-targets=".edit-link-type-option-targets" data-option-target-1=".edit-preview-iframe-field" required>
                    <option value="0"><?php _e('Select Type...', WPSURL_TEXT_DOMAIN); ?></option>
                    <option<?php echo $link_type == '1' ? ' selected ' : '' ?> value="1"><?php _e('Website url', WPSURL_TEXT_DOMAIN); ?></option>
                    <option<?php echo $link_type == '2' ? ' selected ' : '' ?> value="2"><?php _e('Download url', WPSURL_TEXT_DOMAIN); ?></option>
                </select>
            </div>
        </div>
        <div class="form-field-group edit-link-type-option-targets edit-preview-iframe-field w-100" style="display:<?php echo $link_type == '1' ? 'block' : 'none' ?>">
            <div class="form-field-box">
                <div class="wpsurl-link-checkbox">
                    <input type="checkbox" id="iframe-preview-<?php echo $link_id ?>" name="iframe_preview" <?php echo $is_preview ? ' checked' : '' ?>>
                    <label for="iframe-preview-<?php echo $link_id ?>">
                        <i class="wpsurl-icon-check"></i>
                    </label>
                </div>
                <label for="iframe-preview-<?php echo $link_id ?>"><?php _e('Preview in Iframe', WPSURL_TEXT_DOMAIN) ?></label>
            </div>
        </div>

        <div class="form-field-group">
            <div class="wpsurl-link-checkbox">
                <input type="checkbox" value="<?php echo $restriction_woo ?>" id="restriction-woo-<?php echo $link_id ?>" name="restriction_woo" class="checkbox-affected-toggle-elements" data-elements=".edit-woo-products-list" <?php echo $is_active_woo && $restriction_woo ? ' checked' : '' ?>  <?php echo !$is_active_woo ? ' disabled' : '' ?>>
                <label for="restriction-woo-<?php echo $link_id ?>">
                    <i class="wpsurl-icon-check"></i>
                </label>
            </div>
            <label for="restriction-woo-<?php echo $link_id ?>">
                <?php _e('Restriction woocommerce customers', WPSURL_TEXT_DOMAIN) ?>
                <?php if (!$is_active_woo): ?>
                    <span class="is-not-active"><?php _e('Woo is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                <?php endif; ?>
            </label>
            <div class="form-field-box-wrap edit-woo-products-list" style="display:<?php echo $is_active_woo && $restriction_woo ? 'block' : 'none' ?>">
                <label><?php _e('WooCommerce products', WPSURL_TEXT_DOMAIN) ?></label>
                <div class="form-field-box">
                    <?php
                    $products_count = wp_count_posts('product');
                    if (isset($products_count->publish) && $products_count->publish > 0) {
                        \WPSURL\App\Utility::dropDownPosts(array(
                            'post_type' => 'product',
                            'multi' => true,
                            'class' => 'editor-wpsurl-js-select',
                            'id' => 'woo-products-' . $link_id,
                            'select_name' => 'woo_products',
                            'selected' => explode(',', \WPSURL\App\LinkOptions::getOption($link_id, 'woo_products'))
                        ));
                    } else { ?>
                        <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="form-field-group">
            <div class="wpsurl-link-checkbox">
                <input type="checkbox" value="<?php echo $restriction_edd ?>" id="restriction-edd-<?php echo $link_id ?>" name="restriction_edd" class="checkbox-affected-toggle-elements" data-elements=".edit-edd-products" <?php echo $is_active_edd && $restriction_edd ? ' checked' : '' ?>  <?php echo !$is_active_edd ? ' disabled' : '' ?>>
                <label for="restriction-edd-<?php echo $link_id ?>">
                    <i class="wpsurl-icon-check"></i>
                </label>
            </div>
            <label for="restriction-edd-<?php echo $link_id ?>">
                <?php _e('Restriction edd customers', WPSURL_TEXT_DOMAIN) ?>
                <?php if (!$is_active_edd): ?>
                    <span class="is-not-active"><?php _e('Edd is not active.', WPSURL_TEXT_DOMAIN) ?></span>
                <?php endif; ?>
            </label>
            <div class="form-field-box-wrap edit-edd-products" style="display:<?php echo $is_active_edd && $restriction_edd ? 'block' : 'none' ?>">
                <label><?php _e('Edd products', WPSURL_TEXT_DOMAIN) ?></label>
                <div class="form-field-box">
                    <?php
                    $products_count = wp_count_posts('download');
                    if (isset($products_count->publish) && $products_count->publish > 0) {
                        \WPSURL\App\Utility::dropDownPosts(array(
                            'post_type' => 'download',
                            'multi' => true,
                            'class' => 'editor-wpsurl-js-select',
                            'id' => 'edd-products-' . $link_id,
                            'select_name' => 'edd_products',
                            'selected' => explode(',', \WPSURL\App\LinkOptions::getOption($link_id, 'edd_products'))
                        ));
                    } else { ?>
                        <div class="not-found"><?php echo __('Product Not Found.', WPSURL_TEXT_DOMAIN); ?></div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="form-field-group w-100">
            <div class="form-field-box">
                <div class="wpsurl-link-checkbox">
                    <input type="checkbox" id="view-restrictions-<?php echo $link_id ?>" name="view_restrictions" value="<?php echo $restrictions_status ?>" class="checkbox-affected-toggle-elements" data-elements=".edit-views-limit-box,.edit-click-limit-box" <?php echo ($restrictions_status) ? ' checked' : ''; ?>>
                    <label for="view-restrictions-<?php echo $link_id ?>">
                        <i class="wpsurl-icon-check"></i>
                    </label>
                </div>
                <label for="view-restrictions-<?php echo $link_id ?>"><?php _e('Visit restrictions', WPSURL_TEXT_DOMAIN) ?></label>
            </div>
        </div>
        <div class="form-field-group edit-views-limit-box" style="display:<?php echo ($restrictions_status) ? 'inline-block' : 'none'; ?>">
            <label><?php _e('View limit', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="number" id="link-views-limit-<?php echo $link_id ?>" value="<?php echo \WPSURL\App\LinkOptions::getOption($link_id, 'view_limited_num') ?>" name="view_limited_num" min="1">
            </div>
        </div>
        <div class="form-field-group edit-click-limit-box" style="display:<?php echo ($restrictions_status) ? 'inline-block' : 'none'; ?>">
            <label><?php _e('Click limit', WPSURL_TEXT_DOMAIN) ?></label>
            <div class="form-field-box">
                <input type="number" id="link-clicks-limit-<?php echo $link_id ?>" value="<?php echo \WPSURL\App\LinkOptions::getOption($link_id, 'click_limited_num') ?>" name="click_limited_num" min="1">
            </div>
        </div>
        <div class="form-field-group">
            <div class="form-field-box">
                <div class="wpsurl-link-checkbox">
                    <input type="checkbox" value="<?php echo $only_logged ?>" name="only_user_logged" id="only-user-logged-<?php echo $link_id ?>" <?php echo ($only_logged) ? ' checked' : ''; ?>>
                    <label for="only-user-logged-<?php echo $link_id ?>">
                        <i class="wpsurl-icon-check"></i>
                    </label>
                </div>
                <label for="only-user-logged-<?php echo $link_id ?>"><?php _e('Only the logged in user', WPSURL_TEXT_DOMAIN) ?></label>
            </div>
        </div>
    </div>
    <button type="submit" class="wpsurl-button save">
        <img src="<?php echo WPSURL_IMG_URL . 'loader.svg' ?>" alt="loader" style="display: none">
        <?php _e('Save Changes', WPSURL_TEXT_DOMAIN) ?>
    </button>
</form>
<script type="text/javascript">
    jQuery(document).ready(function ($) {
        let body = $('body');
        let edit_form = $("#wpsurl-link-edit-form");
        let form_id = edit_form.data('wpsurl-link-id');
        let checkbox = $("#only-user-logged-" + form_id);
        checkbox.change(function (e) {
            e.preventDefault();
            let $this = $(this);
            if ($this.prop('checked')) {
                $this.prop('value', true);
                $this.attr('checked', 'checked');
            } else {
                $this.prop('value', false);
                $this.removeAttr('checked');
            }
        });

        $('.link-type').change(function () {
            let select = $(this);
            let selected = select.val();
            let parent = select.parent();
            if (selected === '3') {
                if (!parent.hasClass('wpsurl-selected')) {
                    parent.addClass('wpsurl-selected');
                }
            } else {
                if (parent.hasClass('wpsurl-selected')) {
                    parent.removeClass('wpsurl-selected');
                }
            }
        });

        edit_form.submit(function (e) {
            e.preventDefault();
            let $this = $(this);
            let link_id = $this.data('wpsurl-link-id');
            let formData = wpsurlGetFormData(this);
            formData['id'] = link_id;
            formData['action'] = 'wpsurl_action_edit_link';

            $.ajax({
                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                data: formData,
                type: 'POST',
                dataType: 'json',
                beforeSend: function () {
                    $('.wpsurl-modal.edit-link .wpsurl-button.save').addClass('loading');
                },
                success: function (response) {
                    Messager.fire(response.msg, response.type);
                    if (response.type === 'success') {
                        setTimeout(function () {
                            location.reload();
                        }, 1000)
                    } else {
                        $('.wpsurl-modal.edit-link .wpsurl-button.save').removeClass('loading');
                    }
                },
            });
        });
        $('.editor-wpsurl-js-select').selectize({
            searchField: ['text'],
            plugins: ['remove_button']
        });
    });
</script>