<?php
use WPSURL\App\{Links, Options, LinkOptions, Settings, Statistics};

$message      = Settings::getOption( 'view_alert_text' );
$message_type = Settings::getOption( 'view_alert_type' );
$col          = ( \WPSURL\App\Utility::hasNavMenu( 'wpsurl_view_menu' ) ) ? 6 : 12;
$val = \WPSURL\App\Utility::getQueryVarsValue();

$link_data = Links::get($val);

$extra = \WPSURL\App\GlobalData::loadedExtraLinkData($link_data->link_id);

$btn_cls = (empty($extra->pwd) || $extra->pwd == null || $extra->pwd == '') ? 'button' : 'by-pass';
$time = Settings::getOption( 'view_timer_second_value' );
$timer_status = Settings::getOption( 'view_timer_status' );
$transfer_status = Settings::getOption('transfer_end_timer_status');
if ( ! empty( $message ) ):?>
 <div class="wpsurl-view-alert <?php echo $message_type ?>">
     <?php echo $message; ?>
  <span class="wpsurl-toggle wpsurl-alert-close" data-wpsurl-toggle="wpsurl-view-alert"><i class="wpsurl-icon-close"></i></span>
 </div>
<?php endif; ?>
<?php
if(LinkOptions::isIframePreview($extra->link_id)):
    require_once WPSURL_VIEW_PAGES . 'iframe.php';
else: ?>
<header id="wpsurl-header">
 <div class="wpsurl-container">
  <div class="wpsurl-row">
   <div class="wpsurl-col-lg-<?php echo $col; ?> wpsurl-col-md-<?php echo $col; ?> wpsurl-col-sm-12 wpsurl-col-xs-12">
    <div class="wpsurl-view-page-logo">
       <div class="wpsurl-logo">
           <a href="<?php echo site_url() ?>" target="_blank">
            <img src="<?php echo Settings::getLogoUrl(); ?>" alt="<?php bloginfo( 'name' ) ?>">
           </a>
       </div>
   </div>
   </div>
	  <?php if ( \WPSURL\App\Utility::hasNavMenu( 'wpsurl_view_menu' ) ): ?>
       <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
       <?php wp_nav_menu( array( 'theme_location' => 'wpsurl_view_menu', 'container_class' => 'wpsurl-view-nav' ) ); ?>
   </div>
	  <?php endif; ?>
  </div>
 </div>
</header>
<div class="title">
 <div class="wpsurl-container">
  <div class="wpsurl-row">
   <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
        <?php
        $title = '';
        if ( ! Settings::getOption( 'links_title_status' ) ) {
	        $title .= '<h1><a class="wpsurl-redirect-by-pass" href="' . \WPSURL\App\Utility::getCurrentViewPageUrl() . '">';
	        $title .= \WPSURL\App\Utility::getCurrentViewPageTitle();
	        $title .= '</a></h1>';
        } else {
	        $title .= '<p>';
	        $title .= __( 'Share Link', WPSURL_TEXT_DOMAIN );
	        $title .= '</p>';
        }
        echo $title;
        ?>
   </div>
   <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
    <div class="share">
    <a href="https://twitter.com/share?text=<?php echo \WPSURL\App\Utility::getCurrentViewPageTitle() ?>&url=<?php echo \WPSURL\App\Utility::getCurrentViewPageUrl() ?>" target="_blank" class="twitter" title="<?php _e( 'Twitter', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-twitter"></i></a>
    <a href="https://wa.me/?text=<?php echo \WPSURL\App\Utility::getCurrentViewPageUrl() ?>" target="_blank" class="whatsapp" title="<?php _e( 'Whatsapp', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-whatsapp"></i></a>
    <a href="https://telegram.me/share/url?url=<?php echo \WPSURL\App\Utility::getCurrentViewPageUrl() ?>" target="_blank" class="telegram" title="<?php _e( 'Telegram', WPSURL_TEXT_DOMAIN ); ?>"><i class="wpsurl-icon-telegram"></i></a>
    </div>
   </div>
  </div>
 </div>
</div>
 <div class="wpsurl-container">
  <div class="wpsurl-downloader-wrapper">
     <div class="wpsurl-row">
      <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
       <div class="wpsurl-downloader-content">
        <div class="wpsurl-report-problem-form">
         <div class="wpsurl-toggle" data-wpsurl-toggle="wpsurl-report-problem-form"><i class="wpsurl-icon-close"></i></div>
            <label for="wpsurl-report-link-problem-email"><?php _e( 'Email', WPSURL_TEXT_DOMAIN ) ?></label>
            <input type="email" dir="ltr" name="wpsurl_report_link_problem_email" id="wpsurl-report-link-problem-email">
            <label for="wpsurl-report-link-problem-des"><?php _e( 'Problem description', WPSURL_TEXT_DOMAIN ) ?></label>
            <textarea name="wpsurl_report_link_problem_des" id="wpsurl-report-link-problem-des"></textarea>
            <button class="wpsurl-button wpsurl-report-problem" data-wpsurl-link-token="<?php echo \WPSURL\App\Utility::getQueryVarsValue(); ?>"><i class="wpsurl-icon-paper-plane-empty"></i><?php _e( 'Report submit', WPSURL_TEXT_DOMAIN ) ?></button>
        </div>
	       <?php if ( ! $timer_status ): ?>
            <div class="wpsurl-timer-container">
                <div id="timer-app" data-time="<?php echo ($time >= 5) ? $time : '5'; ?>"></div>
             </div>
	       <?php endif; ?>
        <div class="wpsurl-view-buttons wpsurl-buttons" style="display:<?php echo ( ! $timer_status ) ? 'none' : 'block' ?>">
            <?php if ($transfer_status): ?>
                <p><?php echo sprintf(__('If the transfer does not take place after %d seconds, click on this button', WPSURL_TEXT_DOMAIN), $time) ?></p>
            <?php endif; ?>
            <a href="javascript:void(0)" data-wpsurl-link-type="<?php echo Links::getType($val) ?>" data-wpsurl-link-token="<?php echo \WPSURL\App\Utility::getQueryVarsValue() ?>" class="wpsurl-button wpsurl-transfer-button wpsurl-redirect-<?php echo $btn_cls ?><?php echo (!Settings::getOption('view_timer_status')) ? ' wpsurl-button-disable' : ''; ?>">
                <?php if (in_array(Links::getType($val), array(
                    '1',
                    '3'
                ))) { ?>
                    <i class="wpsurl-icon-external-link-square"></i>
                    <?php _e('Click to transfer', WPSURL_TEXT_DOMAIN) ?>
                <?php } else { ?>
                    <i class="wpsurl-icon-download"></i>
                    <?php _e('Download file', WPSURL_TEXT_DOMAIN) ?>
                <?php } ?>
            </a>
        </div>
        <div class="footer">
         <?php
         $page  = \WPSURL\App\Utility::getCurrentViewPageUrl();
         $token = \WPSURL\App\Utility::getQueryVarsValue();
         $link  = '<a href="#" class="iemaker-btn export-options" data-hystmodal="#link-report-modal">' . esc_html__( 'report it to us', WPSURL_TEXT_DOMAIN ) . '</a>';
         printf( __( 'Please if you have any problem link to %s', WPSURL_TEXT_DOMAIN ), $link );
         ?>
        </div>
            </div>
      </div>
      <div class="wpsurl-col-lg-6 wpsurl-col-md-6 wpsurl-col-sm-12 wpsurl-col-xs-12">
          <?php
          $ads = Settings::getOption( 'view_add_html_code' );
          if ( ! empty( $ads ) ): ?>
           <div class="wpsurl-view-ads" style="width: 100%;margin-top: 25px;color: #000000;">
          	 <?php echo \WPSURL\App\Utility::unslashHtml( $ads ); ?>
           </div>
          <?php else: ?>
           <div class="wpsurl-helper-content">
            <div class="wpsurl-ads-position">
             <p><?php _e( 'Your ad location', WPSURL_TEXT_DOMAIN ); ?></p>
             <P><?php echo \WPSURL\App\Number::numByLang( '333 * 515' ) ?></P>
            </div>
           </div>
          <?php endif; ?>
      </div>
     </div>
 </div>
</div>
<?php endif; ?>
<!------------------- [Link Report Modal] ------------------->
<div class="hystmodal" id="link-report-modal" aria-hidden="true">
    <div class="hystmodal__wrap">
        <div class="hystmodal__window hystmodal__window--form" role="dialog" aria-modal="true">
            <button data-hystclose class="hystmodal__close">Закрыть</button>
            <div class="hystmodal__styled">
                <form action="<?php echo add_query_arg(['']) ?>" method="post" id="link-report-form" data-token="<?php echo \WPSURL\App\Utility::getQueryVarsValue(); ?>">
                    <div class="field">
                        <label class="label text-right"><?php _e( 'Name', WPSURL_TEXT_DOMAIN ) ?></label>
                        <div class="control">
                            <input class="input" type="text" name="fullname">
                        </div>
                    </div>
                    <div class="field">
                        <label class="label text-right"><?php _e( 'Email', WPSURL_TEXT_DOMAIN ) ?></label>
                        <div class="control">
                            <input class="input" type="email" name="email">
                        </div>
                    </div>
                    <div class="field">
                        <label class="label text-right"><?php _e( 'Problem description', WPSURL_TEXT_DOMAIN ) ?></label>
                        <div class="control">
                            <textarea class="textarea" name="description" required></textarea>
                        </div>
                    </div>
                    <div class="field captcha-wrap">
                        <p class="control has-icons-left">
                            <input class="input" type="text" name="security_code" placeholder="<?php _e( 'Security Code', WPSURL_TEXT_DOMAIN ) ?>">
                            <span class="icon is-small is-left">
                                <em class="captcha-code reload-captcha" id="report-problem-captcha"></em>
                            </span>
                        </p>
                    </div>
                    <div class="field">
                        <div class="control">
                            <button class="button is-link"><?php _e( 'Report submit', WPSURL_TEXT_DOMAIN ) ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>