<?php
/**
 * Exit if accessed directly
 */
if (!defined('ABSPATH')) {
    exit;
}

use WPSURL\App\{Links, Options, LinkOptions, Settings, Statistics};
$elementor_page_id = Settings::getOption('elementor_page');
$is_active_elementor_page = Options::isActiveElementor() && Settings::getOption('use_elementor') && intval($elementor_page_id);
?>
<!doctype html>
<html <?php language_attributes() ?>>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo \WPSURL\App\Utility::getCurrentViewPageTitle() ?></title>
    <?php wp_head(); ?>
</head>
<body <?php body_class('wp-safe-url wpsurl-view-page') ?>>
<div class="wpsurl-view-content">
    <?php
    require_once WPSURL_VIEW_INC . 'actions.php';
    if($is_active_elementor_page && !LinkOptions::isIframePreview($extra->link_id)):
        echo do_shortcode("[elementor-template id='{$elementor_page_id}']");
    else:
        if (Settings::getOption('view_only_logged_users')):
            if (is_user_logged_in()):
                do_action('wpsurl_view_html_content');
            else:
                if (\WPSURL\App\Options::isActiveWoo()) {
                    $login_url = get_permalink(get_option('woocommerce_myaccount_page_id'));
                    $register_url = $login_url;
                } else {
                    $login_url = wp_login_url(\WPSURL\App\Utility::getCurrentViewPageUrl());
                    $register_url = wp_registration_url();
                }
                ?>
                <script type="text/javascript">
                    jQuery(document).ready(function () {
                        Swal.fire({
                            icon: 'error',
                            text: '<?php _e('You must be logged in to use this section', WPSURL_TEXT_DOMAIN) ?>',
                            showConfirmButton: false,
                            footer: '<a href="<?php echo $login_url ?>"><?php _e('Login', WPSURL_TEXT_DOMAIN) ?></a><span style="margin:0 25px"></span><a href="<?php echo $register_url ?>"><?php _e('Register', WPSURL_TEXT_DOMAIN) ?></a>',
                            onClose: () => {
                                window.location.href = '<?php echo site_url(); ?>'
                            }
                        })
                    });
                </script>
            <?php endif;
        else:
            do_action('wpsurl_view_html_content');
        endif;
    endif;
    ?>
</div>
<?php wp_footer(); ?>
</body>
</html>