<?php
/**
 * Exit if accessed directly
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $val;
$val = \WPSURL\App\Utility::getQueryVarsValue();

if ( ! empty( $val ) || $val != null || $val != '' ) {
	if (\WPSURL\App\Utility::isExistsQueryVarValue()) {
		do_action( 'wpsurl_action_insert_report' );
		$file = WPSURL_VIEW_PAGES . 'index.view.php';
		if ( file_exists( $file ) ) {
			if ( \WPSURL\App\Utility::issetQueryVars( \WPSURL\App\Utility::getPagesSlug() ) || \WPSURL\App\Utility::issetQueryVars( \WPSURL\App\Utility::getPagesSlug( 2 ) ) ) {
				$link   = \WPSURL\App\Links::getItem($val, 'link');
				$status = \WPSURL\App\Links::getStatus($val);
				$logged = (bool) \WPSURL\App\Options::isViewOnlyLoggedUser();
				if ( $logged ) {
					wp_redirect( site_url(), 301 );
					exit;
				}
				if ( $link && $status == 'active' ) {
					if ( \WPSURL\App\Options::getOption( 'view_redirect_page_status' ) ) {
						wp_redirect( $link );
						exit();
					} else {
						if (
							\WPSURL\App\Utility::issetQueryVars( \WPSURL\App\Utility::getPagesSlug() )
							&&
							! preg_match( '/^[a-zA-Z0-9]*$/', (string) $val )
							||
							\WPSURL\App\Utility::issetQueryVars( \WPSURL\App\Utility::getPagesSlug( 2 ) )
							&&
							! preg_match( '/^[1-9][0-9]*$/', (string) $val ) ) {
							wp_redirect( site_url() );
							exit();
						}
						require_once $file;
					}
				} else {
					wp_redirect( site_url() );
				}
			}
		}
	} else {
		wp_redirect( site_url() );
	}
} else {
	wp_redirect( site_url() );
}