<?php
namespace ahura\inc\widgets;

use ahura\app\mw_assets;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );


class post_archive2 extends \Elementor\Widget_Base {

	public function get_name() {
		return 'postarchive2';
	}

	public function get_title() {
		return __( 'Post Archive 2', 'ahura' );
	}

    public function get_icon() {
		return 'aicon-svg-post-archive-2';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['post_archive2', 'postarchive2', esc_html__( 'Post Archive 2' , 'ahura')];
	}
	function __construct($data=[], $args=null)
	{
		parent::__construct($data, $args);
		$post_archive2_css = mw_assets::get_css('elementor.post_archive2');
		mw_assets::register_style('post_archive2', $post_archive2_css);
	}
	function get_style_depends()
	{
		return [mw_assets::get_handle_name('post_archive2')];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$categories = get_categories();
		$cats       = array();
		foreach ( $categories as $category ) {
			$cats[ $category->term_id ] = $category->name;
		}
		$default = key($cats);
		$this->add_control(
			'catsid',
			[
				'label'    => __( 'Categories', 'ahura' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $cats,
				'label_block' => true,
				'multiple' => false,
				'default' => $default
			]
		);

		$this->add_control(
			'target_link',
			[
				'label' => __('Open Link in New tab', 'ahura'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => '_self',
				'options' => [
					'_blank' => [
						'title' => __('Yes', 'ahura'),
						'icon' => 'eicon-check'
					],
					'_self' => [
						'title' => __('No', 'ahura'),
						'icon' => 'eicon-close-circle'
					],
				],
				'toggle' => true
			]
		);

		$this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'item_cover',
                'default' => 'stthumb',
            ]
        );

		$this->end_controls_section();
		/**
		 * 
		 * 
		 * Styles
		 * 
		 *
		 */
		$this->start_controls_section(
			'content_styles',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
            'box_img_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .post-archive1-thumbnail img' => 'width: {{SIZE}}{{UNIT}}',
                ]
            ]
        );

		$this->add_responsive_control(
            'box_img_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .post-archive1-thumbnail img' => 'height: {{SIZE}}{{UNIT}}',
                ]
            ]
        );

		$this->add_control(
			'catcolor',
			[
				'label'   => __( 'Category Color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-archive1-details h2' => 'color: {{VALUE}}'
				]
			]
		);
		$this->add_control(
			'titlecolor',
			[
				'label'   => __( 'Post Title Color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-archive1-details h3' => 'color: {{VALUE}}'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'bntbackground',
				'label' => __( 'Link Background', 'ahura' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .post-archive1-details a',
			]
		);
		$this->add_control(
			'btx_text_color',
			[
				'label'   => __( 'Link Color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-archive1-details a' => 'color: {{VALUE}}'
				]
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        <?php $the_query = new \WP_Query(array(
            'posts_per_page' => 1,
            'cat' =>$settings['catsid'],
        ));
         if ( $the_query->have_posts() ):
         while ( $the_query->have_posts() ) : $the_query->the_post();
        ?>
        <div class="post-archive1">
            <div class="post-archive1-thumbnail">
                <?php the_post_thumbnail($settings['item_cover_size'])?>
            </div>
            <div class="post-archive1-details">
				<h2><?php echo get_cat_name($settings['catsid']); ?></h2>
                <h3><?php the_title();?></h3>
                <a href="<?php the_permalink()?>" target="<?php echo $settings['target_link']; ?>">نمایش نوشته</a>
            </div>
        </div>
        <?php 
            endwhile;
            endif;
        ?>
		<?php
	}

}
