<?php
// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class Ahura_Mini_Cart2 extends \Elementor\Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_style('mini_cart2_css', mw_assets::get_css('elementor.mini_cart2'));
    }

    public function get_style_depends()
    {
        return [mw_assets::get_handle_name('mini_cart2_css')];
    }

    public function get_name()
    {
        return 'ahura_mini_cart2';
    }

    public function get_title()
    {
        return esc_html__('Mini Cart 2', 'ahura');
    }

    public function get_icon()
    {
        return 'eicon-cart';
    }

    public function get_categories()
    {
        return ['ahurabuilder'];
    }

    function get_keywords()
    {
        return ['mini_cart2', 'minicart2', esc_html__('Mini Cart 2', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => ['url' => get_template_directory_uri() . '/img/basket-icon.svg'],
                    'library' => 'svg',
                ],
            ]
        );

        $this->add_control(
            'hide_in_scroll',
            [
                'label' => esc_html__('Hide in scroll', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();
        /**
         *
         * Styles
         *
         */

    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $hide_in_scroll = $settings['hide_in_scroll'] == 'yes' ? ' hide_in_scroll' : '';
        $icon = $settings['icon'];

        if(!\ahura\app\woocommerce::is_active()){
            return false;
        }

        $cart = \WC()->cart;
        $cart_items = $cart->get_cart();
        ?>
        <div class="mini-cart2-element <?php echo $hide_in_scroll ?>">
            <div class="mc2-button">
                <?php
                if($icon['library'] === 'svg' && !empty($icon['value']['url'])){
                    $alt = __('Cart', 'ahura');
                    echo "<img src='{$icon['value']['url']}' alt='{$alt}'>";
                } else {
                    \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
                }
                ?>
            </div>
            <div class="mc2-container">
                <div class="mc2-content">
                    <div class="mc2-head">
                        <div class="mc2-counter">1 کالا</div>
                        <div class="mc2-btns1">
                            <a href="#">مشاهده ی سبد خرید <i class="fas fa-angle-left"></i></a>
                        </div>
                    </div>
                    <div class="mc2-main">
                        <?php
                        if ($cart_items):
                            foreach ($cart_items as $item):
                                $product_id = $item['product_id'];
                                $item_data = $item['data'];
                            ?>
                            <div class="cart-item">
                                <div class="cart-item-image">
                                    <?php echo wp_get_attachment_image(get_post_thumbnail_id($product_id)) ?>
                                    <div class="cart-item-action">
                                        <div class="cart-item-action-btn">
                                            <span><i class="fas fa-trash"></i></span>
                                            <span><?php echo $item['quantity']; ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php
                            endforeach;
                        else: ?>
                        <?php endif; ?>
                    </div>
                    <div class="mc2-foot">
                        <div class="mc2-total-prices">
                            <div>مبلغ قابل پرداخت</div>
                            <div class="total-cart-price">
                                <span>تومان</span>
                                <span>1.500.000</span>
                            </div>
                        </div>
                        <div class="mc2-btns2">
                            <a href="#">ثبت سفارش</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
