<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\woocommerce;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;

class shop_carousel extends \Elementor\Widget_Base {
    /**
     * shop_carousel constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
		mw_assets::register_style('owl_carousel_css', mw_assets::get_css('owl-carousel'));
        mw_assets::register_script('owl_carousel_js', mw_assets::get_js('owl-carousel-min'));
        mw_assets::register_style('shop_carousel_css', mw_assets::get_css('elementor.shop_carousel'));
        mw_assets::register_script('shop_carousel_js', mw_assets::get_js('elementor.shop_carousel'));
    }

    public function get_style_depends()
    {
        return [mw_assets::get_handle_name('owl_carousel_css'), mw_assets::get_handle_name('shop_carousel_css')];
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('owl_carousel_js'), mw_assets::get_handle_name('shop_carousel_js')];
    }

	public function get_name() {
		return 'shopcarousel';
	}

	public function get_title() {
		return __( 'Products Carousel', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-shop-carousel';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['shopcarousel', 'productscarousel', 'products_carousel', 'shop_carousel', esc_html__( 'Products Carousel' , 'ahura')];
	}

	protected function register_controls() {
		if(!woocommerce::is_active())
		{
			return false;
		}
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$categories = get_terms( array(
			'taxonomy' => 'product_cat',
			'hide_empty' => false,
		));
		$cats       = array();
		foreach ( $categories as $category ) {
			$cats[ $category->slug ] = $category->name;
		}
		$default = key($cats);
		$this->add_control(
			'catsid',
			[
				'label'    => __( 'Categories', 'ahura' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => array_merge(
					[ 'allproducts'  => esc_html__( 'All Products', 'ahura' ) ],
					[ 'discountedproducts'  => esc_html__( 'Discounted Products', 'ahura' ) ],
					[ 'randomproducts'  => esc_html__( 'Random Products', 'ahura' ) ],
					$cats ),
				'label_block' => true,
				'multiple' => true,
				'default' => $default
			]
		);

		$stock_options = (function_exists('wc_get_product_stock_status_options')) ? wc_get_product_stock_status_options() : [];

        $this->add_control(
            'products_stock_status',
            [
                'label'   => esc_html__('Stock status of products', 'ahura'),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => array_merge(['none'  => esc_html__('None', 'ahura')], $stock_options),
                'default' => 'instock'
            ]
        );

        $this->add_control(
            'fully_show_title',
            [
                'label'   => __( 'Fully Show Title', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
                    'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
                ],
                'default' => 'no'
            ]
        );

		$this->add_control(
			'price',
			[
				'label'   => __( 'Show Price', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'count',
			[
				'label'      => __( 'Number of posts', 'ahura' ),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'product_order',
			[
				'label' => __('Sort', 'ahura'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'DESC',
				'options' => [
					'ASC' => [
						'title' => __('Ascending', 'ahura'),
						'icon' => 'eicon-sort-up'
					],
					'DESC' => [
						'title' => __('Descending', 'ahura'),
						'icon' => 'eicon-sort-down'
					],
				],
				'toggle' => true
			]
		);

		$this->add_control(
			'outofstock_text',
			[
				'label' => __( 'Out of stock text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'out of stock', 'ahura' ),
			]
		);

		$this->add_control(
			'stock_status',
			[
				'label'   => __( 'Show product stock status', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'sale_price_product',
			[
				'label'   => __( 'Show only discounted products', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					null  => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no' => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
				],
				'default' => 'no',
				'condition' => [
					'catsid!' => 'discountedproducts',
				],				
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'color',
			[
				'label'   => __( 'Color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#66bb6a'
			]
		);

		$this->add_control(
			'outofstock_color',
			[
				'label' => esc_html__( 'Of of stock color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'white',
				'selectors' => [
					'{{WRAPPER}} .out-of-stock' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'outofstock_background_color',
			[
				'label' => esc_html__( 'Of of stock background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'red',
				'selectors' => [
					'{{WRAPPER}} .out-of-stock' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( class_exists( 'WooCommerce' ) ) {
			$field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);

			if( ( $settings[ 'catsid' ][ 0 ] == 'allproducts' ) || $settings[ 'catsid' ][ 0 ] == 'randomproducts' ) {
				$args = [
					'post_type'		 => 'product',
					'post_status'	 => 'publish',
					'posts_per_page' => $settings[ 'count' ],
					'order' 		 => $settings[ 'product_order' ],
					'orderby' 		 => $settings[ 'catsid' ][ 0 ] == 'randomproducts' ? 'rand' : $settings[ 'product_order' ]
				];
			} elseif( $settings[ 'catsid' ][ 0 ] == 'discountedproducts' ) {
				$args = [
					'post_type'		 => 'product',
					'post_status'	 => 'publish',
					'posts_per_page' => $settings[ 'count' ],
					'order' 		 => $settings[ 'product_order' ],
					'meta_key' 		 => '_sale_price',
					'meta_value' 	 => '0',
					'meta_compare'   => '>='
				];
			} else {
				$args = [
					'post_type'		 => 'product',
					'post_status'	 => 'publish',
					'posts_per_page' => $settings[ 'count' ],
					'tax_query'		 => [ [
						'taxonomy'   => 'product_cat',
						'field'		 => $field_is_term ? 'term_id' : 'slug',
						'terms'		 => $settings[ 'catsid' ],
					] ],
					'order' 		 => $settings[ 'product_order' ]
				];
			}
			
            $products_stock_status = $settings['products_stock_status'];

            if ($products_stock_status && $products_stock_status !== 'none') {
                $args['meta_query'] = array(array(
                    'key' => '_stock_status',
                    'value' => $products_stock_status,
                    'compare' => '==',
                ));
            }

			$wc_query = new \WP_Query($args);
			if ( $wc_query->have_posts() ) : ?>
                <div>
					<?php if(is_admin()): ?>
						<div class="preload_widget_section">
							<h3><?php _e('Slider is here!', 'ahura'); ?></h3>
							<small><?php _e('To see slider please view page.', 'ahura'); ?></small>
						</div>
					<?php else: ?>
                    <div class="owl-carousel owl-theme owl-shop-carousel">
						<?php while ( $wc_query->have_posts() ) : $wc_query->the_post(); ?>
						<?php if (get_post_meta(get_the_ID(), '_sale_price', true) != $settings['sale_price_product'] ): ?>
                            <div class="sc-item-content">
                                <div class="sc-items-top">
								<a class="fimage"
                                   href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'woocommerce_thumbnail' ); ?></a>
                                <a href="<?php the_permalink(); ?>">
                                    <h3><?php echo $settings['fully_show_title'] == 'yes' ? get_the_title() : wp_trim_words( get_the_title(), 6, '...' ); ?></h3></a>
								</div>
								<div class="sc-items-bottom">
								<?php if ( $settings['price'] == 'yes' ) : ?>
                                    <div class="mwprprice">
										<?php
											$price = woocommerce_template_single_price();
											echo $price;
										?>
                                    </div>
								<?php endif; ?>
								<?php
								 if ( ( $settings['stock_status'] == 'yes' && wc_get_product( get_the_ID() )->get_stock_status() == "outofstock" ) ) {
									echo '<p class="out-of-stock">'.$settings['outofstock_text'].'</p>';
								 }
								?>
								</div>
                            </div>
						<?php endif; ?>
						<?php endwhile; ?>
					</div>
					<?php endif; ?>
                </div>
				<?php wp_reset_postdata(); ?>
			<?php else: ?>
					<div class="mw_element_error">
						<?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
					</div>
			<?php endif; ?>
            <div class="clear"></div>
			<?php
		}elseif(is_admin()){
			?>
			<div class="productcategorybox mw_elem_empty_box"><h3><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></h3></div>
			<?php
		}
	}

}
