<?php

namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use ahura\app\woocommerce;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class shop_carousel2 extends \Elementor\Widget_Base {

	public function get_name() {
		return 'shop_carousel2';
	}

	public function get_title() {
		return __( 'Products Carousel 2', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-shop-carousel-2';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}

	function get_keywords()
	{
		return ['shop_carousel2', 'shopcarousel2', 'productscarousel2', 'products_carousel_2', esc_html__( 'Products Carousel 2' , 'ahura')];
	}
	
	public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
		mw_assets::register_style('owl_carousel_css', mw_assets::get_css('owl-carousel'));
        mw_assets::register_script('owl_carousel_js', mw_assets::get_js('owl-carousel-min'));
		mw_assets::register_style('shop_carousel2_widget_style', mw_assets::get_css('elementor.shop_carousel2'));
		mw_assets::register_script('shop_carousel2_widget_script', mw_assets::get_js('elementor.shop_carousel2'), [ 'elementor-frontend' ]);
		mw_assets::register_script('woocommerce_script', mw_assets::get_js('woocommerce'));
    }
  
    public function get_style_depends() {
        return [ mw_assets::get_handle_name('shop_carousel2_widget_style'), mw_assets::get_handle_name('owl_carousel_css') ];
    }
  
    public function get_script_depends() {
        return [mw_assets::get_handle_name('owl_carousel_js'), mw_assets::get_handle_name('shop_carousel2_widget_script'), mw_assets::get_handle_name('woocommerce_script')];
    }

	protected function register_controls() {
		if(!woocommerce::is_active())
		{
			return false;
		}
		$this->start_controls_section(
			'content_section', [
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Fruits', 'ahura' ),
			]
		);

		$this->add_control(
			'btn_text',
			[
				'label' => __( 'Button text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'All products', 'ahura' ),
			]
		);

		$this->add_control(
            'btn_url',
            [
                'label'      => __('Url', 'ahura'),
                'type'       => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		
		$categories = get_terms( [
			'taxonomy' => 'product_cat',
			'hide_empty' => false,
		] );
		$cats = [];
		foreach ( $categories as $category ) {
			$cats[ $category->slug ] = $category->name;
		}
		$default = key($cats);
		$this->add_control(
			'catsid', [
				'label'    => __( 'Categories', 'ahura' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $cats,
				'label_block' => true,
				'multiple' => true,
				'default' => $default
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_title_typography',
				'label'    => __( 'Product title and price typography', 'ahura' ),
				'selector' => '{{WRAPPER}} .owl-carousel .owl-item h3',
			]
		);

		$this->add_control(
			'color', [
				'label'   => __( 'Color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#66bb6a',
				'selectors' => [
					'{{WRAPPER}} .shop_carousel2_header a.link' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .carousel-box form button' => 'background-color: {{VALUE}}!important',
					'{{WRAPPER}} .owl-carousel .owl-item .price' => 'color: {{VALUE}}',
					'{{WRAPPER}} .carousel-box .quantity input[type="number"]' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .carousel-box .mw_qty_btn i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .shop_carousel2_header .title' => 'color: {{VALUE}}',
					'{{WRAPPER}} #shop_carousel2 .shop_carousel2_header .title:before' => 'border-right-color: {{VALUE}};',
					
				],
			]
		);

        $stock_options = (function_exists('wc_get_product_stock_status_options')) ? wc_get_product_stock_status_options() : [];

        $this->add_control(
            'products_stock_status',
            [
                'label'   => esc_html__('Stock status of products', 'ahura'),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => array_merge(['none'  => esc_html__('None', 'ahura')], $stock_options),
                'default' => 'instock'
            ]
        );

		$this->add_control(
			'price', [
				'label'   => __( 'Show Price', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'fa fa-check-circle' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'fa fa-times-circle' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'sale_price_product',
			[
				'label'   => __( 'Show only discounted products', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					null  => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'fa fa-check-circle' ],
					'no' => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'fa fa-times-circle' ]
				],
				'default' => 'no'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}} .owl-carousel .owl-item .price'
			]
		);

		$this->add_control(
			'subtitle_text',
			[
				'label' => __( 'Subtitle text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Price for 1 kg', 'ahura' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .owl-carousel .owl-item h5'
			]
		);

		$this->add_control(
			'count', [
				'label'      => __( 'Number of posts', 'ahura' ),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'product_order', [
				'label' => __('Sort', 'ahura'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'DESC',
				'options' => [
					'ASC' => [
						'title' => __('Ascending', 'ahura'),
						'icon' => 'fa fa-arrow-up'
					],
					'DESC' => [
						'title' => __('Descending', 'ahura'),
						'icon' => 'fa fa-arrow-down'
					],
				],
				'toggle' => true
			]
		);

		$this->add_control(
			'stock_status',
			[
				'label'   => __( 'Show product stock status', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'fa fa-check-circle' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'fa fa-times-circle' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'outofstock_text',
			[
				'label' => __( 'Out of stock text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'out of stock', 'ahura' ),
			]
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		?><script>const productMaxValueCar2 = [];</script><?php
		if ( class_exists( 'WooCommerce' ) ) {
			$field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);
            $args = [
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $settings['count'],
                'tax_query' => [
                    [
                        'taxonomy' => 'product_cat',
                        'field' => $field_is_term ? 'term_id' : 'slug',
                        'terms' => $settings['catsid'],
                    ]
                ],
                'order' => $settings['product_order']
            ];

            $products_stock_status = $settings['products_stock_status'];

            if ($products_stock_status && $products_stock_status !== 'none') {
                $args['meta_query'] = array(array(
                    'key' => '_stock_status',
                    'value' => $products_stock_status,
                    'compare' => '==',
                ));
            }

            $wc_query = new \WP_Query($args);
			
			if ( $wc_query->have_posts() ) : ?>
                <div class="shop_carousel2 shop_quantity_selector productcategorybox p-4">
					<?php if(is_admin()): ?>
						<div class="preload_widget_section">
							<h3><?php _e('Slider is here!', 'ahura'); ?></h3>
							<small><?php _e('To see slider please view page.', 'ahura'); ?></small>
						</div>
					<?php else: ?>
					<div class="shop_carousel2_header">
						<div class="title"><?php echo $settings['title_text'] ?></div>
						<a href="<?php echo $settings['btn_url']['url']; ?>" class="link"><?php echo $settings['btn_text'] ?></a>
					</div>
                    <div class="owl-carousel owl-shop-carousel2">
						<?php while ( $wc_query->have_posts() ) : $wc_query->the_post(); ?>
						<?php if (get_post_meta(get_the_ID(), '_sale_price', true) != $settings['sale_price_product'] ): ?>
                            <div class="carousel-box">
                                <div class="top-content">
                                    <a href="<?php the_permalink(); ?>" class="fimage">
                                        <?php the_post_thumbnail( 'woocommerce_thumbnail' ); ?>
                                    </a>
                                    <a href="<?php the_permalink(); ?>">
                                        <h3><?php echo wp_trim_words( get_the_title(), 8, '...' ); ?></h3>
                                    </a>
                                    <?php if ( $settings['price'] == 'yes' ) : ?>
                                        <h5><?php echo $settings['subtitle_text']; ?></h5>
                                        <div class="mwprprice">
                                            <?php echo woocommerce_template_single_price();	?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="bottom-content">
                                    <?php
                                    $current_product = wc_get_product( get_the_ID() );
                                    echo '<form action="' . esc_url( $current_product->add_to_cart_url() ) . '" class="cart" class="crousel_addtobtn" method="post" enctype="multipart/form-data">';
                                    echo woocommerce_quantity_input(['min_value' => 1, 'max_value' => $current_product->backorders_allowed() ? '' : $current_product->get_stock_quantity()]);
                                    echo '<button type="submit" class="button alt">'.__("Order", "ahura").' <i class="fa fa-shopping-cart"></i></button>';
                                    echo '</form>';
                                    ?>
                                </div>
								<script>
								productMaxValueCar2.push("<?php echo $current_product->get_stock_quantity(); ?>");
								</script>
								<?php if ( ( $settings['stock_status'] == 'yes' && $current_product -> get_stock_status() == "outofstock" ) ) {
									echo '<p class="out-of-stock">'.$settings['outofstock_text'].'</p>';
								 }
								?>
                            </div>
						<?php endif; ?>
						<?php endwhile; ?>
					</div>
					<?php endif; ?>
                </div>
				<?php wp_reset_postdata(); ?>
			<?php else: ?>
					<div class="mw_element_error">
						<?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
					</div>
			<?php endif; ?>
            <div class="clear"></div>
			<?php
		}elseif(is_admin()){
			?>
			<div class="mw_element_error"><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></div>
			<?php
		}
	}

}
