<?php

namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use ahura\app\woocommerce;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class shop_category2 extends \Elementor\Widget_Base {

	public function get_name() {
		return 'shop_category2';
	}

	public function get_title() {
		return __( 'Shop Category 2', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-shop-category-2';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['shop_category2', 'shopcategory2', esc_html__( 'Shop Category 2' , 'ahura')];
	}

	public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

		mw_assets::register_style('shop_category3_widget_style', mw_assets::get_css('elementor.shop_category3'));
		mw_assets::register_script('shop_category3_widget_script', mw_assets::get_js('elementor.shop_category3'), ['elementor-frontend']);
    }
  
    public function get_style_depends() {
        return [ mw_assets::get_handle_name('shop_category3_widget_style') ];
    }
  
    public function get_script_depends() {
        return [ mw_assets::get_handle_name('shop_category3_widget_script') ];
    }

	protected function register_controls() {
		if(!woocommerce::is_active()) return false;

		$this->start_controls_section(
			'content_section', [
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$categories = get_terms( [
			'taxonomy' => 'product_cat',
			'hide_empty' => false,
		] );
		$cats = [];
		foreach ( $categories as $category ) {
			$cats[ $category->slug ] = $category->name;
		}
		$default = key($cats);
		$this->add_control(
			'catsid', [
				'label'    => __( 'Categories', 'ahura' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $cats,
				'label_block' => true,
				'multiple' => true,
				'default' => $default
			]
		);

		$this->add_control(
			'count', [
				'label'      => __( 'Number of posts', 'ahura' ),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'stock_status',
			[
				'label'   => __( 'Show product stock status', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'fa fa-check-circle' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'fa fa-times-circle' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'outofstock_text',
			[
				'label' => __( 'Out of stock text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'out of stock', 'ahura' ),
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'style_section', [
				'label' => __( 'Style', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'el_style',
			[
				'label' => esc_html__( 'Element Style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style-1 mb-2',
				'options' => [
					'style-1 mb-2'  => esc_html__( 'Style 1', 'ahura' ),
					'style-2' => esc_html__( 'Style 2', 'ahura' ),
				],
			]
		);

		$this->add_control(
			'el_column',
			[
				'label' => esc_html__( 'Product column', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'col-md-6',
				'options' => [
					'col-md-12'  => esc_html__( 'Full width', 'ahura' ),
					'col-md-6' => esc_html__( '2 Column', 'ahura' ),
					'col-md-4' => esc_html__( '3 Column', 'ahura' ),
				],
			]
		);
		
		$this->add_control(
			'main_color', [
				'label'   => __( 'Main color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#66bb6a',
				'selectors' => [
					'{{WRAPPER}} .cat-box form button' => 'background-color: {{VALUE}}!important;box-shadow: 0px 0px 10px {{VALUE}}',
					'{{WRAPPER}} .cat-box .quantity input[type="number"]' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .cat-box .mw_qty_btn i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label'    => __( 'Product title typography', 'ahura' ),
				'selector' => '{{WRAPPER}} .cat-box .title',
				'fields_options' => [
					'typography' => ['default' => 'yes'],
					'font_size' => ['default' => ['size' => 20]],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label'    => __( 'Product description typography', 'ahura' ),
				'selector' => '{{WRAPPER}} .cat-box .description',
				'fields_options' => [
					'typography' => ['default' => 'yes'],
					'font_size' => ['default' => ['size' => 14]],
				],
			]
		);

		$this->add_control(
			'price_color', [
				'label'   => __( 'Price color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#66bb6a',
				'selectors' => [
					'{{WRAPPER}} .cat-box .price' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'price_typography',
				'label'    => __( 'Price typography', 'ahura' ),
				'selector' => '{{WRAPPER}} .cat-box .price',
				'fields_options' => [
					'typography' => ['default' => 'yes'],
					'font_size' => ['default' => ['size' => 18]],
				],
			]
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		?><script>const productMaxValueCat3 = [];</script><?php
		if ( class_exists( 'WooCommerce' ) ) {
			$field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);
			$wc_query = new \WP_Query( [
				'post_type'      => 'product',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['count'],
				'tax_query' => [ [
					'taxonomy' => 'product_cat',
					'field' => $field_is_term ? 'term_id' : 'slug',
					'terms' => $settings['catsid'],
				] ]
			] );
			if ( $wc_query->have_posts() ) : ?>
				<?php if(is_admin()): ?>
					<div class="preload_widget_section">
						<h3><?php _e('Slider is here!', 'ahura'); ?></h3>
						<small><?php _e('To see slider please view page.', 'ahura'); ?></small>
					</div>
				<?php else: ?>
                <div class="shop_category3 d-flex flex-wrap shop_quantity_selector">
					<?php while ( $wc_query->have_posts() ) : $wc_query->the_post(); ?>
						<div class="outer-box col-sm-12 <?php echo $settings['el_column']; ?> px-0">
							<div class="d-flex cat-box <?php echo $settings['el_style']; ?> mr-2">
								<a class="d-flex flex-column justify-content-center p-1 fimage" href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'thumbnail' ); ?></a>
								<div class="d-flex flex-column justify-content-center w-100 cat_content pl-3">
									<a href="<?php the_permalink(); ?>">
										<p class="title"><?php echo wp_trim_words( get_the_title(), 8, '...' ); ?></p>
									</a>
									<span class="description"><?php echo the_excerpt(); ?></span>
									<?php $price = woocommerce_template_single_price(); echo $price; ?>
									<?php
										$current_product = wc_get_product( get_the_ID() );
										echo '<form action="' . esc_url( $current_product->add_to_cart_url() ) . '" class="d-flex aling-center justify-content-between cart" method="post" enctype="multipart/form-data">';
										echo woocommerce_quantity_input(['min_value' => 1, 'max_value' => $current_product->backorders_allowed() ? '' : $current_product->get_stock_quantity()]);
										echo '<button type="submit" class="button alt">'.__("Order", "ahura").' <i class="fa fa-shopping-cart"></i></button>';
										echo '</form>';
										?>
										<script>
										productMaxValueCat3.push("<?php echo $current_product->get_stock_quantity(); ?>");
										</script>
										<?php if ( ( $settings['stock_status'] == 'yes' && $current_product -> get_stock_status() == "outofstock" ) ) {
											echo '<p class="out-of-stock">'.$settings['outofstock_text'].'</p>';
										}
									?>
								</div>
							</div>
						</div>
					<?php endwhile; ?>
					<?php endif; ?>
                </div>
				<?php wp_reset_postdata(); ?>
			<?php else: ?>
					<div class="mw_element_error">
						<?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
					</div>
			<?php endif; ?>
            <div class="clear"></div>
			<?php
		}elseif(is_admin()){
			?>
			<div class="mw_element_error"><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></div>
			<?php
		}
	}

}
